<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version='1.0'
  xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
  xmlns:fo='http://www.w3.org/1999/XSL/Format'>
  <xsl:output method="html" 
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" 
    doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
    indent="yes"/>
  <xsl:template match='/'>
    <html>
      <head>
        <style>
          body {
            font-family: sans-serif;
          }
          h1 {
            font-size: 150%;
          }
          table {
            border-collapse: collapse;
            border: 1px solid grey;
          }
          th {
            text-align: left;
          }
          th, td {
            padding: 0.1em 0.5em;
          }
          td.right {
            text-align: right;
          }
          td.continue {
            border-top: 2px solid white;
          }
          a {
            text-decoration: none;
          }
        </style>
        <title>
          %Index_Title
        </title>
      </head>
      <body>
        <h1>
          %Index_Title
        </h1>
        <table border='1'>
          <xsl:text>
          </xsl:text>
          <tr>
            <th>%Date</th>
            <th>%Time</th>
            <th>%Entries</th>
            <th>%Errors</th>
            <th>%Warnings</th>
            <th>%Log_File</th>
          </tr>
          <xsl:text>
          </xsl:text>
          <xsl:for-each select='logs/log'>
            <tr>
              <xsl:variable name='pos' select='position() - 1'/>
              <xsl:choose>
                <xsl:when test='$pos = 0'>
                  <td>
                    <xsl:value-of select='@date'/>
                  </td>
                </xsl:when>
                <xsl:when test='/logs/*[$pos]/@date != @date'>
                  <td>
                    <xsl:value-of select='@date'/>
                  </td>
                </xsl:when>
                <xsl:otherwise>
                  <td class='continue'>
                  </td>
                </xsl:otherwise>
              </xsl:choose>
              <td>
                <xsl:value-of select='@time'/>
              </td>
              <td class='right'>
                <xsl:value-of select='@entries'/>
              </td>
              <td class='right'>
                <xsl:value-of select='@errors'/>
              </td>
              <td class='right'>
                <xsl:value-of select='@warnings'/>
              </td>
              <td>
                <a>
                  <xsl:attribute name='href'>
                    <xsl:value-of select='.'/>
                  </xsl:attribute>
                  <xsl:value-of select='.'/>
                </a>
              </td>
            </tr>
            <xsl:text>
            </xsl:text>
          </xsl:for-each>
        </table>

      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>
