------------------------------------------------------------------------------
--
--	Licensed Materials - Property of IBM
--
--	5724O4800
--
--	(C) Copyright IBM Corp. 2017. All Rights Reserved
--
--	US Government Users Restricted Rights - Use, duplication
--	or disclosure restricted by GSA ADP Schedule Contract
--	with IBM Corp.
--
--	Netcool/OMNIbus 8.1.0 - July 2018  Build: 5.50.78
--
--	SCOPE BASED EVENT GROUPING
--
--	This SQL file adds the fields and triggers used by the related event grouping
--
------------------------------------------------------------------------------

------------------------------------------------------------------------------
--
-- UPDATE SCRIPT
--
-- THIS SQL SCRIPT UPDATES SCOPE-BASED EVENT GROUPING RELEASED IN 8.1 FP8 TO FP13
--
-- NOTE: THIS SHOULD ONLY BE APPLIED TO AN AGGREGATION OBJECTSERVER
--
------------------------------------------------------------------------------

------------------------------------------------------------------------------
-- UPDATE CODE VERSION IN OBJECTSERVER

update master.properties set CharValue = 'Netcool/OMNIbus 8.1.0 - July 2018  Build: 5.50.78' where
	Name = 'SEGVersion';
go

------------------------------------------------------------------------------
-- CREATE A PROCEDURE TO PROCESS ScopeIDParent EVENTS

CREATE OR REPLACE PROCEDURE correlation_process_scopeidparents ( )
declare

	propagatettnumber INTEGER;
	propagateacknowledged INTEGER;
	propagateowneruid INTEGER;
	propagateownergid INTEGER;

	usescopeidprefix INTEGER;
	scopeidprefix CHAR(255);
	usescopeidlabel INTEGER;
	usescopeidimpactcause INTEGER;
	usescopeidcustomtext INTEGER;
	propagatetexttoscopeidparentcause INTEGER;
	propagatetexttoscopeidparentimpact INTEGER;
	propagatetexttoscopeidparentfirst INTEGER;
	propagatetexttoscopeidparentlast INTEGER;
	customtext CHAR(255);
	usescopeidsitesaffected INTEGER;
	scopeidsitesaffectedlabel CHAR(255);
	usescopeidnumactivealarms INTEGER;

	highcauseweight INTEGER;
	highcausetext CHAR(255);
	highimpactweight INTEGER;
	highimpacttext CHAR(255);
	highseverity INTEGER;
	lowfirstoccurrence TIME;
	highlastoccurrence TIME;
	alarmcounter INTEGER;
	alarmcounter2 INTEGER;
	alarmcounter3 INTEGER;
	summary CHAR(255);

	journaluid INTEGER;
	journaltoscopeidparent INTEGER;
	journalmaxeventsperentry INTEGER;
	journalservernameserverserial INTEGER;
	journalnode INTEGER;
	journalsummary INTEGER;
	journalalertkey INTEGER;
	journalcustomtext INTEGER;
	maxscopeidjournals INTEGER;
	thisjournalentry CHAR(4080);
	scopeidparentjournalentry CHAR(4080);
	journalcounter INTEGER;

begin

	-- INITIALISE LOCAL VARIABLES
	set propagatettnumber = 1;
	set propagateacknowledged = 1;
	set propagateowneruid = 1;
	set propagateownergid = 1;

	set usescopeidprefix = 1;
	set scopeidprefix = '';
	set usescopeidlabel = 1;
	set usescopeidimpactcause = 0;
	set usescopeidcustomtext = 0;
	set propagatetexttoscopeidparentcause = 0;
	set propagatetexttoscopeidparentimpact = 0;
	set propagatetexttoscopeidparentfirst = 0;
	set propagatetexttoscopeidparentlast = 0;
	set customtext = '';
	set usescopeidsitesaffected = 1;
	set scopeidsitesaffectedlabel = 'site';
	set usescopeidnumactivealarms = 0;

	set highcauseweight = 0;
	set highcausetext = 'UNKNOWN';
	set highimpactweight = 0;
	set highimpacttext  = 'UNKNOWN';
	set highseverity = 0;
	set lowfirstoccurrence = 0;
	set highlastoccurrence = 0;
	set alarmcounter= 0;
	set alarmcounter2 = 0;
	set alarmcounter3 = 0;
	set summary = '';

	set journaluid = 0;
	set journaltoscopeidparent = 0;
	set journalmaxeventsperentry = 20;
	set journalservernameserverserial = 1;
	set journalnode = 1;
	set journalsummary = 1;
	set journalalertkey = 0;
	set journalcustomtext = 0;
	set maxscopeidjournals = 50;
	set thisjournalentry = '';
	set scopeidparentjournalentry = '';
	set journalcounter = 0;

	-- LOAD UP VARIABLES BASED ON PROPERTIES
	for each row property in master.properties where property.Name in (
		'SEGPropagateTTNumber',
		'SEGPropagateAcknowledged',
		'SEGPropagateOwnerUID',
		'SEGPropagateOwnerGID',
		'SEGUseScopeIDPrefix',
		'SEGScopeIDPrefix',
		'SEGUseScopeIDLabel',
		'SEGUseScopeIDImpactCause',
		'SEGUseScopeIDCustomText',
		'SEGPropagateTextToScopeIDParentCause',
		'SEGPropagateTextToScopeIDParentImpact',
		'SEGPropagateTextToScopeIDParentFirst',
		'SEGPropagateTextToScopeIDParentLast',
		'SEGUseScopeIDSitesAffected',
		'SEGScopeIDSitesAffectedLabel',
		'SEGUseScopeIDNumActiveAlarms',
		'SEGJournalUID',
		'SEGJournalToScopeIDParent',
		'SEGJournalMaxEventsPerEntry',
		'SEGJournalServerNameServerSerial',
		'SEGJournalNode',
		'SEGJournalSummary',
		'SEGJournalAlertKey',
		'SEGJournalCustomText',
		'SEGMaxScopeIDJournals')
	begin

		-- SPECIFIES WHETHER OR NOT TO PROPAGATE THE TTNumber TO CHILD EVENTS
		if (property.Name = 'SEGPropagateTTNumber') then

			set propagatettnumber = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO PROPAGATE THE Acknowledged STATUS TO CHILD EVENTS
		elseif (property.Name = 'SEGPropagateAcknowledged') then

			set propagateacknowledged = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO PROPAGATE THE OwnerUID TO CHILD EVENTS
		elseif (property.Name = 'SEGPropagateOwnerUID') then

			set propagateowneruid = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO PROPAGATE THE OwnerGID TO CHILD EVENTS
		elseif (property.Name = 'SEGPropagateOwnerGID') then

			set propagateownergid = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO USE THE ScopeID PREFIX IN THE ScopeIDParent EVENT
		elseif (property.Name = 'SEGUseScopeIDPrefix') then

			set usescopeidprefix = property.IntValue;

		-- SPECIFIES THE ScopeID PREFIX TO USE IN THE ScopeIDParent EVENT
		elseif (property.Name = 'SEGScopeIDPrefix') then

			set scopeidprefix = property.CharValue;

		-- SPECIFIES WHETHER OR NOT TO INCLUDE THE ScopeID LABEL IN THE ScopeIDParent EVENT
		elseif (property.Name = 'SEGUseScopeIDLabel') then

			set usescopeidlabel = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO INCLUDE THE IMPACT AND CAUSE INFO IN THE ScopeIDParent EVENT
		elseif (property.Name = 'SEGUseScopeIDImpactCause') then

			set usescopeidimpactcause = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO INCLUDE THE CUSTOM TEXT IN THE ScopeIDParent EVENT
		elseif (property.Name = 'SEGUseScopeIDCustomText') then

			set usescopeidcustomtext = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO PROPAGATE THE CUSTOM TEXT TO THE ScopeIDParent EVENT
		-- BASED ON THE CUSTOM TEXT OF THE CHILD EVENT WITH THE HIGHEST CauseWeight
		elseif (property.Name = 'SEGPropagateTextToScopeIDParentCause') then

			set propagatetexttoscopeidparentcause = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO PROPAGATE THE CUSTOM TEXT TO THE ScopeIDParent EVENT
		-- BASED ON THE CUSTOM TEXT OF THE CHILD EVENT WITH THE HIGHEST ImpactWeight
		elseif (property.Name = 'SEGPropagateTextToScopeIDParentImpact') then

			set propagatetexttoscopeidparentimpact = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO PROPAGATE THE CUSTOM TEXT TO THE ScopeIDParent EVENT
		-- BASED ON THE CUSTOM TEXT OF THE CHILD EVENT WITH THE LOWEST FirstOccurrence
		elseif (property.Name = 'SEGPropagateTextToScopeIDParentFirst') then

			set propagatetexttoscopeidparentfirst = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO PROPAGATE THE CUSTOM TEXT TO THE ScopeIDParent EVENT
		-- BASED ON THE CUSTOM TEXT OF THE CHILD EVENT WITH THE HIGHEST LastOccurrence
		elseif (property.Name = 'SEGPropagateTextToScopeIDParentLast') then

			set propagatetexttoscopeidparentlast = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO INCLUDE THE NUMBER OF AFFECTED SITES IN THE ScopeIDParent EVENT
		elseif (property.Name = 'SEGUseScopeIDSitesAffected') then

			set usescopeidsitesaffected = property.IntValue;

		-- SPECIFIES THE LABEL TO USE WHEN REFERRING TO THE NUMBER OF SUB-GROUPS AFFECTED IN THE ScopeIDParent SUMMARY FIELD
		elseif (property.Name = 'SEGScopeIDSitesAffectedLabel') then

			set scopeidsitesaffectedlabel = property.CharValue;

		-- SPECIFIES WHETHER OR NOT TO INCLUDE THE NUMBER OF ACTIVE ALARMS IN THE ScopeIDParent EVENT
		elseif (property.Name = 'SEGUseScopeIDNumActiveAlarms') then

			set usescopeidnumactivealarms = property.IntValue;

		-- SPECIFIES THE UID TO USE WHEN INSERTING JOURNALS INTO SYNTHETIC PARENT EVENTS - DEFAULT IS ROOT
		elseif (property.Name = 'SEGJournalUID') then

			set journaluid = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO JOURNAL CHILD EVENTS TO THE ScopeIDParent EVENT
		elseif (property.Name = 'SEGJournalToScopeIDParent') then

			set journaltoscopeidparent = property.IntValue;

		-- SPECIFIES HOW MANY EVENTS TO ROLL UP INTO A SINGLE JOURNAL ENTRY
		elseif (property.Name = 'SEGJournalMaxEventsPerEntry') then

			set journalmaxeventsperentry = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO SEND THE ServerName:ServerSerial FIELD TO THE PARENT EVENT JOURNAL
		elseif (property.Name = 'SEGJournalServerNameServerSerial') then

			set journalservernameserverserial = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO SEND THE Node FIELD TO THE PARENT EVENT JOURNAL
		elseif (property.Name = 'SEGJournalNode') then

			set journalnode = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO SEND THE Summary FIELD TO THE PARENT EVENT JOURNAL
		elseif (property.Name = 'SEGJournalSummary') then

			set journalsummary = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO SEND THE AlertKey FIELD TO THE PARENT EVENT JOURNAL
		elseif (property.Name = 'SEGJournalAlertKey') then

			set journalalertkey = property.IntValue;

		-- SPECIFIES WHETHER OR NOT TO SEND THE CustomText FIELD TO THE PARENT EVENT JOURNAL
		elseif (property.Name = 'SEGJournalCustomText') then

			set journalcustomtext = property.IntValue;

		-- SPECIFIES MAXIMUM NUMBER OF EVENTS TO SEND TO THE PARENT EVENT JOURNAL
		elseif (property.Name = 'SEGMaxScopeIDJournals') then

			set maxscopeidjournals = property.IntValue;
		end if;
	end;

	-- IN CASE MULTIPLE CustomText PROPAGATION OPTIONS ARE INADVERTENTLY SELECTED,
	-- ENFORCE AN ORDER OF PRECEDENCE TO ENSURE UNDEFINED RESULTS ARE AVOIDED
	--
	-- ORDER OF PRECEDENCE IS:
	-- 1 PROPAGATE CustomText OF HIGHEST CauseWeight
	-- 2 PROPAGATE CustomText OF HIGHEST ImpactWeight
	-- 3 PROPAGATE CustomText OF LOWEST FirstOccurrence
	-- 4 PROPAGATE CustomText OF HIGHEST LastOccurrence
	--
	if (propagatetexttoscopeidparentcause = 1) then

		-- CLEAR OTHER SELECTED OPTIONS
		set propagatetexttoscopeidparentimpact = 0;
		set propagatetexttoscopeidparentfirst = 0;
		set propagatetexttoscopeidparentlast = 0;

	elseif (propagatetexttoscopeidparentimpact = 1) then

		-- CLEAR OTHER SELECTED OPTIONS
		set propagatetexttoscopeidparentfirst = 0;
		set propagatetexttoscopeidparentlast = 0;

	elseif (propagatetexttoscopeidparentfirst = 1) then

		-- CLEAR OTHER SELECTED OPTIONS
		set propagatetexttoscopeidparentlast = 0;

	end if;

	-- UPDATE EACH ScopeIDParent EVENT
	for each row scopeid in alerts.status where scopeid.AlertGroup in ('ScopeIDParent', 'Synthetic Event - Parent')
	begin

		-- RESET LOCAL VARIABLES
		-- alarmcounter: USED TO COUNT UP NUMBER OF AFFECTED SITES
		-- alarmcounter2: USED TO COUNT UP NUMBER OF SITE EVENT CHILDREN
		-- alarmcounter3: USED TO COUNT UP NUMBER OF EVENTS DIRECTLY UNDER ScopeIDParent
		set highcauseweight = 0;
		set highcausetext = 'UNKNOWN';
		set highimpactweight = 0;
		set highimpacttext  = 'UNKNOWN';
		set highseverity = 0;
		set lowfirstoccurrence = 0;
		set highlastoccurrence = 0;
		set customtext = '';
		set alarmcounter  = 0;
		set alarmcounter2  = 0;
		set alarmcounter3  = 0;
		set summary = '';
		set thisjournalentry = '';
		set scopeidparentjournalentry = '';
		set journalcounter = 0;

		-- EXAMINE EACH CHILD OF THE CURRENT ScopeIDParent EVENT
		for each row child in alerts.status where
			child.ParentIdentifier = scopeid.Identifier
		begin

			-- ONLY CONSIDER NON-CLEARED CHILD EVENTS
			if (child.Severity > 0) then

				-- INCLUDE CURRENT CHILD EVENT IN COUNTS
				-- PROCESS SiteNameParent EVENTS
				if (child.AlertGroup = 'SiteNameParent') then

					-- EXCLUDE SiteNameParent EVENTS THAT HAVE NO SiteName
					if (child.SiteName != 'NO SITENAME') then

						-- INCREMENT NUMBER OF AFFECTED SITES
						set alarmcounter = alarmcounter + 1;
					end if;

					-- ADD TO EVENT COUNTER THE NUMBER OF UNDERLYING EVENTS
					set alarmcounter2 = alarmcounter2 + child.Grade;

				-- ELSE EVENT IS A REAL EVENT AND NOT A SYNTHETIC ONE
				else

					-- STORE THE HIGHEST CauseWeight OF THE CHILDREN EVENTS
					-- AND ITS ASSOCIATED NormalisedAlarmName
					if (child.CauseWeight > highcauseweight) then
	
						set highcauseweight = child.CauseWeight;
						set highcausetext = child.NormalisedAlarmName;

						-- IF OPTION TO PROPAGATE CUSTOM TEXT TO ScopeIDParent EVENT FROM HIGHEST
						-- CauseWeight CHILD IS ENABLED, STORE CURRENT EVENT CUSTOM TEXT
						if (propagatetexttoscopeidparentcause = 1) then

							set customtext = child.CustomText;
						end if;
					end if;

					-- STORE THE HIGHEST ImpactWeight OF THE CHILDREN EVENTS
					-- AND ITS ASSOCIATED NormalisedAlarmName
					if (child.ImpactWeight > highimpactweight) then
	
						set highimpactweight = child.ImpactWeight;
						set highimpacttext = child.NormalisedAlarmName;

						-- IF OPTION TO PROPAGATE CUSTOM TEXT TO ScopeIDParent EVENT FROM HIGHEST
						-- ImpactWeight CHILD IS ENABLED, STORE CURRENT EVENT CUSTOM TEXT
						if (propagatetexttoscopeidparentimpact = 1) then

							set customtext = child.CustomText;
						end if;
					end if;

					-- INCREMENT EVENT COUNTER
					set alarmcounter3 = alarmcounter3 + 1;
				end if;

				-- STORE THE HIGHEST Severity OF THE CHILDREN EVENTS
				if (highseverity < child.Severity) then

					set highseverity = child.Severity;
				end if;

				-- STORE THE LOWEST NON-ZERO FirstOccurrence OF THE CHILDREN EVENTS
				if (lowfirstoccurrence > child.FirstOccurrence or lowfirstoccurrence = 0) then

					set lowfirstoccurrence = child.FirstOccurrence;

					-- IF OPTION TO PROPAGATE CUSTOM TEXT TO ScopeIDParent EVENT FROM LOWEST
					-- FirstOccurrence CHILD IS ENABLED, STORE CURRENT EVENT CUSTOM TEXT
					if (propagatetexttoscopeidparentfirst = 1) then

						set customtext = child.CustomText;
					end if;
				end if;

				-- STORE THE HIGHEST LastOccurrence OF THE CHILDREN EVENTS
				if (highlastoccurrence < child.LastOccurrence) then

					set highlastoccurrence = child.LastOccurrence;

					-- IF OPTION TO PROPAGATE CUSTOM TEXT TO ScopeIDParent EVENT FROM HIGHEST
					-- LastOccurrence CHILD IS ENABLED, STORE CURRENT EVENT CUSTOM TEXT
					if (propagatetexttoscopeidparentlast = 1) then

						set customtext = child.CustomText;
					end if;
				end if;

				-- PROPAGATE THE TICKET NUMBER FROM THE ScopeIDParent EVENT TO
				-- THE CURRENT CHILD IF THE CURRENT CHILD IS UNTICKETED,
				-- UNSUPPRESSED AND THE OPTION TO PROPAGATE TICKET NUMBER IS ENABLED
				if (scopeid.TTNumber != '' and child.TTNumber = '' and
					child.SuppressEscl != 4 and propagatettnumber = 1) then

					set child.TTNumber = scopeid.TTNumber;
				end if;

				-- PROPAGATE THE ACKNOWLEDGED STATUS FROM THE ScopeIDParent EVENT TO
				-- THE CURRENT CHILD IF THE CURRENT CHILD IS UNACKNOWLEDGED AND THE
				-- OPTION TO PROPAGATE ACKNOWLEDGED STATUS IS ENABLED
				if (scopeid.Acknowledged = 1 and child.Acknowledged != 1
					and propagateacknowledged = 1) then

					set child.Acknowledged = scopeid.Acknowledged;
				end if;

				-- PROPAGATE THE OwnerUID FROM THE ScopeIDParent EVENT TO THE
				-- CURRENT CHILD EVENT IF THE OWNER OF THE ScopeIDParent EVENT
				-- IS DIFFERENT TO THAT OF THE CHILD EVENT AND THE
				-- OPTION TO PROPAGATE OwnerUID IS ENABLED
				-- A VALUE OF 2 WILL ONLY PROPAGATE OWNERSHIP IF IT IS OWNED BY
				-- UID = Nobody 65534
				if (scopeid.OwnerUID != child.OwnerUID and (
					 propagateowneruid = 1 or
					(propagateowneruid = 2 and child.OwnerUID = 65534))) then

					set child.OwnerUID = scopeid.OwnerUID;
				end if;

				-- PROPAGATE THE OwnerGID FROM THE ScopeIDParent EVENT TO THE
				-- CURRENT CHILD EVENT IF THE GROUP OF THE ScopeIDParent EVENT
				-- IS DIFFERENT TO THAT OF THE CHILD EVENT AND THE
				-- OPTION TO PROPAGATE OwnerGID IS ENABLED
				-- A VALUE OF 2 WILL ONLY PROPAGATE OWNERSHIP IF IT IS OWNED BY
				-- GID = Public 0
				if (scopeid.OwnerGID != child.OwnerGID and (
					 propagateownergid = 1 or
					(propagateownergid = 2 and child.OwnerGID = 0))) then

					set child.OwnerGID = scopeid.OwnerGID;
				end if;

				-- CLEAR thisjournalentry VARIABLE
				set thisjournalentry = '';

				-- CONSTRUCT A JOURNAL ENTRY FOR CURRENT EVENT IF
				-- - THE CURRENT EVENT HAS NOT ALREADY BEEN JOURNALED
				-- - IF SENDING CHILD EVENT DATA AS JOURNALS TO ScopeIDParent IS ENABLED
				-- - IF THE MAXIMUM NUMBER OF EVENTS PER JOURNAL ENTRY HAS NOT BEEN EXCEEDED
				-- - IF THE MAXIMUM NUMBER OF EVENTS FOR THIS ScopeIDParent HAS NOT BEEN EXCEEDED
				-- - THE CURRENT EVENT IS NOT A SiteNameParent EVENT
				if (child.JournalSent = 0 and journaltoscopeidparent = 1 and
					journalcounter < journalmaxeventsperentry and
					(scopeid.Poll + journalcounter) < maxscopeidjournals and
					child.AlertGroup != 'SiteNameParent') then

					-- CHECK WHETHER OR NOT TO INCLUDE THE ServerName:ServerSerial IN THIS JOURNAL ENTRY
					if (journalservernameserverserial = 1) then

						set thisjournalentry = thisjournalentry + child.ServerName +
							':' + to_char(child.ServerSerial);
					end if;

					-- CHECK WHETHER OR NOT TO INCLUDE THE Node IN THIS JOURNAL ENTRY
					if (journalnode = 1 and child.Node != '') then

						-- ADD COLON BEFORE APPENDING TEXT TO THIS JOURNAL ENTRY
						if (thisjournalentry != '') then
							set thisjournalentry = thisjournalentry + ': ';
						end if;

						set thisjournalentry = thisjournalentry + child.Node;
					end if;

					-- CHECK WHETHER OR NOT TO INCLUDE THE Summary IN THIS JOURNAL ENTRY
					if (journalsummary = 1 and child.Summary != '') then

						-- ADD COLON BEFORE APPENDING TEXT TO THIS JOURNAL ENTRY
						if (thisjournalentry != '') then
							set thisjournalentry = thisjournalentry + ': ';
						end if;

						set thisjournalentry = thisjournalentry + child.Summary;
					end if;

					-- CHECK WHETHER OR NOT TO INCLUDE THE AlertKey IN THIS JOURNAL ENTRY
					if (journalalertkey = 1 and child.AlertKey != '') then

						-- ADD COLON BEFORE APPENDING TEXT TO THIS JOURNAL ENTRY
						if (thisjournalentry != '') then
							set thisjournalentry = thisjournalentry + ': ';
						end if;

						set thisjournalentry = thisjournalentry + child.AlertKey;
					end if;

					-- CHECK WHETHER OR NOT TO INCLUDE THE CustomText IN THIS JOURNAL ENTRY
					if (journalcustomtext = 1 and child.CustomText != '') then

						-- ADD COLON BEFORE APPENDING TEXT TO THIS JOURNAL ENTRY
						if (thisjournalentry != '') then
							set thisjournalentry = thisjournalentry + ': ';
						end if;

						set thisjournalentry = thisjournalentry + child.CustomText;
					end if;
				end if;

				-- ADD CURRENT EVENT TO ScopeIDParent JOURNAL ENTRY IF:
				-- - IF SENDING CHILD EVENT DATA AS JOURNALS TO ScopeIDParent IS ENABLED
				-- - IF THE MAXIMUM NUMBER OF EVENTS FOR THIS ScopeIDParent HAS NOT BEEN EXCEEDED
				-- - THE CURRENT JOURNAL ENTRY IS NOT NULL
				-- - THE CURRENT EVENT IS NOT A SiteNameParent EVENT
				if (journaltoscopeidparent = 1 and
					(scopeid.Poll + journalcounter) < maxscopeidjournals and
					thisjournalentry != '' and child.AlertGroup != 'SiteNameParent') then

					-- APPEND A NEW LINE CHARACTER IF THERE IS ALREADY TEXT TO ADD
					if (scopeidparentjournalentry != '') then
						set scopeidparentjournalentry = scopeidparentjournalentry + '\n';
					end if;

					-- ADD THE CURRENT JOURNAL ENTRY TO THE EXISTING
					set scopeidparentjournalentry = scopeidparentjournalentry + thisjournalentry;

					-- INCREMENT THE NUMBER OF JOURNALS BEING SENT
					set journalcounter = journalcounter + 1;

					-- MARK CHILD EVENT AS HAVING BEEN SENT
					set child.JournalSent = 1;
 				end if;
			end if;
		end;

		-- STORE THE NUMBER OF ACTIVE CHILD EVENTS IN THE GRADE FIELD, IF NOT ZERO
		if (alarmcounter2 != 0 or alarmcounter3 != 0) then

			set scopeid.Grade = alarmcounter2 + alarmcounter3;

		-- ELSE THE COUNT OF ACTIVE CHILD EVENTS IS ZERO, SO RESET GRADE FIELD TO ZERO
		elseif (scopeid.Grade != 0) then

			set scopeid.Grade = 0;
		end if;

		-- BEGIN THE CONSTRUCTION OF THE ScopeIDParent Summary FIELD

		-- SPECIFY WHETHER TO INCLUDE THE ScopeIDParent PREFIX
		if (usescopeidprefix = 1) then

			set summary = scopeidprefix;
		end if;

		-- SPECIFY WHETHER TO INCLUDE THE ScopeID LABEL
		if (usescopeidlabel = 1) then

			-- APPEND A COLON IF summary NOT BLANK
			if (summary != '') then
				set summary = summary + ': ';
			end if;

			set summary = summary + scopeid.ScopeID;
		end if;

		-- SPECIFY WHETHER TO INCLUDE THE CAUSE AND IMPACT TEXT
		-- DO NOT USE IF THERE ARE NO DIRECT CHILD EVENTS
		if (usescopeidimpactcause = 1 and alarmcounter3 != 0) then

			-- APPEND A COLON IF summary NOT BLANK
			if (summary != '') then
				set summary = summary + ': ';
			end if;

			-- APPEND CAUSE AND IMPACT TEXT
			if (highcausetext = 'UNKNOWN' and highimpacttext = 'UNKNOWN') then
				set summary = summary + 'CAUSE AND IMPACT: UNKNOWN';
			elseif (highcausetext = 'UNKNOWN' and highimpacttext != 'UNKNOWN') then
				set summary = summary + highimpacttext + ' UNKNOWN CAUSE';
			elseif (highcausetext != 'UNKNOWN' and highimpacttext = 'UNKNOWN') then
				set summary = summary + highcausetext + ' UNKNOWN IMPACT';
			elseif (highcausetext != 'UNKNOWN' and highimpacttext = highcausetext) then
				set summary = summary + 'CAUSE AND IMPACT: ' + highcausetext;
			else
				set summary = summary + highimpacttext +
					' caused by ' + highcausetext;
			end if;
		end if;

		-- SPECIFY WHETHER TO INCLUDE THE CUSTOM SUMMARY TEXT CustomText
		if (usescopeidcustomtext = 1 and scopeid.CustomText != '') then

			-- APPEND A COLON IF summary NOT BLANK
			if (summary != '') then
				set summary = summary + ': ';
			end if;

			-- APPEND CustomText
			set summary = summary + scopeid.CustomText;
		end if;

		-- SPECIFY WHETHER TO INCLUDE THE NUMBER OF SITES AFFECTED
		-- DO NOT INCLUDE IF NO SITES ARE AFFECTED
		if (usescopeidsitesaffected = 1 and alarmcounter != 0) then

			-- APPEND A COLON IF summary NOT BLANK
			if (summary != '') then
				set summary = summary + ': ';
			end if;

			-- APPEND NUMBER OF SITES AFFECTED
			set summary = summary + to_char(alarmcounter) + ' ' + scopeidsitesaffectedlabel;

			if (alarmcounter = 1) then
				set summary = summary + ' affected';
			else
				set summary = summary + 's affected';
			end if;
		end if;

		-- SPECIFY WHETHER TO INCLUDE THE NUMBER OF ACTIVE ALARMS IN THE GROUPING
		if (usescopeidnumactivealarms = 1) then

			-- APPEND A SPACE CHARACTER IF summary NOT BLANK
			if (summary != '') then
				set summary = summary + ' ';
			end if;

			-- APPEND TOTAL NUMBER OF UNDERLYING REAL EVENTS
			if ((alarmcounter2 + alarmcounter3) = 1) then
				set summary = summary + '(' +
					to_char(alarmcounter2 + alarmcounter3) + ' active alarm)';
			else
				set summary = summary + '(' +
					to_char(alarmcounter2 + alarmcounter3) + ' active alarms)';
			end if;
		end if;

		-- UPDATE Synthetic Event - Parent EVENT IF NOT CLEAR - OR IF ANY OF THE COUNTERS ARE NOT ZERO
		if (scopeid.AlertGroup = 'Synthetic Event - Parent' and
			(scopeid.Severity != 0 or alarmcounter != 0 or alarmcounter2 != 0 or alarmcounter3 != 0)) then

			-- SET THE Severity TO INDETERMINITE IF UNDERLYING EVENTS ARE CLEARED
			-- THIS WILL EVENTUALLY BE CLEARED WHEN TIME WINDOW CLOSES
			if (highseverity = 0) then

				set scopeid.Severity = 1;

			-- ELSE SET THE Severity TO THAT OF THE HIGHEST UNDERLYING EVENT
			else

				set scopeid.Severity = highseverity;
			end if;
		end if;

		-- UPDATE ScopeIDParent EVENT IF NOT CLEAR - OR IF ANY OF THE COUNTERS ARE NOT ZERO
		if (scopeid.AlertGroup = 'ScopeIDParent' and
			(scopeid.Severity != 0 or alarmcounter != 0 or alarmcounter2 != 0 or alarmcounter3 != 0)) then

			-- UPDATE Summary FIELD
			set scopeid.Summary = summary;

			-- SET THE Severity TO INDETERMINITE IF UNDERLYING EVENTS ARE CLEARED
			-- THIS WILL EVENTUALLY BE CLEARED WHEN TIME WINDOW CLOSES
			if (highseverity = 0) then

				set scopeid.Severity = 1;

			-- ELSE SET THE Severity TO THAT OF THE HIGHEST UNDERLYING EVENT
			else

				set scopeid.Severity = highseverity;
			end if;

			-- UPDATE FirstOccurrence BASED ON UNDERLYING EVENTS, IF NOT NULL
			if (lowfirstoccurrence != 0) then

				set scopeid.FirstOccurrence = lowfirstoccurrence;
			end if;

			-- UPDATE LastOccurrence BASED ON UNDERLYING EVENTS, IF NOT NULL
			if (highlastoccurrence != 0) then

				set scopeid.LastOccurrence = highlastoccurrence;
			end if;

			-- UPDATE CustomText FIELD OF THE PARENT IF ONE OF THE PROPAGATION
			-- FROM CHILD OPTIONS ARE ENABLED
			if (	propagatetexttoscopeidparentcause = 1 or
				propagatetexttoscopeidparentimpact = 1 or
				propagatetexttoscopeidparentfirst = 1 or
				propagatetexttoscopeidparentlast = 1) then

				set scopeid.CustomText = customtext;
			end if;

		end if;

		-- ADD A JOURNAL ENTRY TO THE CURRENT ScopeIDParent IF APPLICABLE
		if (journaltoscopeidparent = 1 and scopeidparentjournalentry != '') then

			-- ADD THE ROLLED UP CHILDREN EVENTS TO THE CURRENT SiteNameParent AS A JOURNAL ENTRY
			EXECUTE jinsert(scopeid.Serial, journaluid, getdate(),
				'CHILD EVENTS:\n' + scopeidparentjournalentry);

			-- UPDATE THE NUMBER OF CHILD EVENTS APPENDED TO THIS PARENT EVENT
			set scopeid.Poll = scopeid.Poll + journalcounter;

			-- APPEND NOTE THAT NO FURTHER JOURNALS WILL BE APPENDED TO THIS ScopeIDParent
			-- DUE TO THE MAXIMUM NUMBER HAVING BEEN REACHED
			if (scopeid.Poll = maxscopeidjournals) then

				EXECUTE jinsert(scopeid.Serial, journaluid, getdate() + 1,
					'*** MAXIMUM OF ' + to_char(maxscopeidjournals) +
					' EVENTS HAVE BEEN JOURNALED TO THIS PARENT');
			end if;
		end if;
	end;
end;
go

