/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.core.action;

import com.ibm.ws.pak.core.PakData;
import com.ibm.ws.pak.core.PakMessages;
import com.ibm.ws.pak.core.action.IPakInvokeAction;
import com.ibm.ws.pak.core.internal.install.PakInstaller;
import com.ibm.ws.pak.core.internal.uninstall.PakUnInstaller;
import com.ibm.ws.pak.internal.install.metadata.NIFHistory;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.utils.logging.ILogr;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PakInvokeAction
implements IPakInvokeAction {
    private static final String className = "PakInvokeAction";
    public static final String PAK_ADAPTER_PLUGIN_ID = "com.ibm.ws.pak";

    @Override
    public void initializeDebugLogger(ILogr logger) {
        Logr.initDebugLogger((ILogr)logger);
    }

    @Override
    public void initializeLogger(ILogr logger) {
        Logr.initLogger((ILogr)logger);
    }

    @Override
    public IStatus invokePakAction(PakData pakData, PropertyChangeListener progressListener) {
        IStatus iStatus;
        block8: {
            block7: {
                if (pakData == null) {
                    return this.createStatus(4, PakMessages.PAK_PAKDATA_NULL, null);
                }
                Logr.initLogger((String)pakData.getLogLocation());
                Logr.logMessage((String)PakMessages.bind((String)PakMessages.PAK_PAK_ACTION_BEGINS, (Object[])new Object[]{pakData.getOperation(), pakData.getPakName()}));
                if (!pakData.getOperation().equals("INSTALL")) break block7;
                this.invokePakInstallAction(pakData.getInstallProperties(), progressListener);
                IStatus iStatus2 = this.createStatus(0, null, null);
                this.commitAndCloseOfferingPakMetadata();
                Logr.logMessage((String)PakMessages.bind((String)PakMessages.PAK_PAK_ACTION_ENDS, (Object[])new Object[]{pakData.getOperation(), pakData.getPakName()}));
                return iStatus2;
            }
            if (!pakData.getOperation().equals("UNINSTALL")) break block8;
            this.invokePakUninstallAction(pakData.getInstallProperties(), progressListener);
            IStatus iStatus3 = this.createStatus(0, null, null);
            this.commitAndCloseOfferingPakMetadata();
            Logr.logMessage((String)PakMessages.bind((String)PakMessages.PAK_PAK_ACTION_ENDS, (Object[])new Object[]{pakData.getOperation(), pakData.getPakName()}));
            return iStatus3;
        }
        try {
            Logr.error((String)PakMessages.bind((String)PakMessages.PAK_PAKDATA_UNKNOWN_OPERATION, (Object)pakData.getOperation()));
            iStatus = this.createStatus(4, PakMessages.bind((String)PakMessages.PAK_PAKDATA_UNKNOWN_OPERATION, (Object)pakData.getOperation()), null);
            this.commitAndCloseOfferingPakMetadata();
        }
        catch (Exception e) {
            IStatus iStatus4;
            try {
                Logr.error((String)PakMessages.bind((String)PakMessages.PAK_PAK_OPERATION_FAILED, (Object)pakData.getOperation(), (Object)e.getMessage()));
                iStatus4 = this.createStatus(4, e.getMessage(), e);
                this.commitAndCloseOfferingPakMetadata();
            }
            catch (Throwable throwable) {
                this.commitAndCloseOfferingPakMetadata();
                Logr.logMessage((String)PakMessages.bind((String)PakMessages.PAK_PAK_ACTION_ENDS, (Object[])new Object[]{pakData.getOperation(), pakData.getPakName()}));
                throw throwable;
            }
            Logr.logMessage((String)PakMessages.bind((String)PakMessages.PAK_PAK_ACTION_ENDS, (Object[])new Object[]{pakData.getOperation(), pakData.getPakName()}));
            return iStatus4;
        }
        Logr.logMessage((String)PakMessages.bind((String)PakMessages.PAK_PAK_ACTION_ENDS, (Object[])new Object[]{pakData.getOperation(), pakData.getPakName()}));
        return iStatus;
    }

    public int invokePakInstallAction(Properties pakInstallProperties, PropertyChangeListener listener) throws Exception {
        Logr.methodEntry((String)className, (String)"invokePakInstallAction");
        PakInstaller pakInstaller = new PakInstaller();
        pakInstaller.addPropertyChangeListener(listener);
        int rc = pakInstaller.installPak(pakInstallProperties);
        pakInstaller.removePropertyChangeListener(listener);
        Logr.methodExit((String)className, (String)"invokePakInstallAction");
        return rc;
    }

    public int invokePakUninstallAction(Properties pakInstallProperties, PropertyChangeListener listener) throws Exception {
        Logr.methodEntry((String)className, (String)"invokePakUninstallAction");
        PakUnInstaller pakUninstaller = new PakUnInstaller();
        pakUninstaller.addPropertyChangeListener(listener);
        int rc = pakUninstaller.uninstallPak(pakInstallProperties);
        pakUninstaller.removePropertyChangeListener(listener);
        Logr.methodExit((String)className, (String)"invokePakUninstallAction");
        return rc;
    }

    @Override
    public void commitAndCloseOfferingPakMetadata() {
        try {
            NIFStack.commitAndClose();
            NIFHistory.commitAndClose();
        }
        catch (IOException e) {
            Logr.warn((String)className, (String)"commitAndCloseOfferingPakMetadata", (String)e.getMessage(), (Exception)e);
        }
        catch (ParserConfigurationException e) {
            Logr.warn((String)className, (String)"commitAndCloseOfferingPakMetadata", (String)e.getMessage(), (Exception)e);
        }
    }

    private IStatus createStatus(int severity, String msg, Exception e) {
        return new Status(severity, PAK_ADAPTER_PLUGIN_ID, 0, msg, (Throwable)e);
    }
}

