/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.Messages;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    private Util() {
    }

    public static boolean zosDatasetExists(Logger logger, String dsn) {
        boolean exists = false;
        try {
            logger.finest(dsn);
            if (dsn.startsWith("/")) {
                return false;
            }
            Class<?> recordFileCls = Class.forName("com.ibm.recordio.RecordFile");
            Constructor<?> recordFileConstructor = recordFileCls.getDeclaredConstructor(String.class);
            Method existsMethod = recordFileCls.getMethod("exists", new Class[0]);
            Object recordFile = recordFileConstructor.newInstance("//" + dsn);
            Boolean result = (Boolean)existsMethod.invoke(recordFile, (Object[])null);
            exists = result;
        }
        catch (ClassNotFoundException e) {
            if (Util.isOnZOS()) {
                logger.log(Level.SEVERE, Messages.getString("Util.0"), e);
            }
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, Messages.getString("Util.1"), e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, Messages.getString("Util.2"), e);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, Messages.getString("Util.3"), e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, Messages.getString("Util.4"), e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.FINE, Messages.getString("Util.5"), e);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, Messages.getString("Util.6"), e);
        }
        return exists;
    }

    public static boolean isOnZOS() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("z/OS") != -1;
    }

    public static boolean isOnWindows() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("Windows") != -1;
    }
}

