/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.DumpEvent;
import com.ibm.java.diagnostics.collector.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings {
    private static final Map<String, Level> logLevelOptionsMap = new HashMap<String, Level>();
    private File sf;
    Properties p = new Properties();
    Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Settings(DumpEvent de, Logger logger) throws IllegalArgumentException {
        if (de == null) {
            throw new IllegalArgumentException("de is null");
        }
        this.logger = logger;
        this.sf = de.getSettingsFile();
        if (this.sf != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.sf);
                this.p.load(fis);
                String settingsID = this.getSettingsID();
                logger.fine("Settings loaded, file ID: " + settingsID + ", location: " + this.sf.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                logger.log(Level.INFO, Messages.getString("Settings.0"), e);
            }
            catch (IOException e) {
                logger.log(Level.INFO, Messages.getString("Settings.1"), e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "IOException closing settings file", e);
                }
            }
        }
    }

    public String getSettingsID() {
        String id = null;
        id = this.p.containsKey("settings.id") ? this.p.getProperty("settings.id") : "id_not_set";
        return id;
    }

    public HashSet<File> getFilesToCollect() {
        Enumeration<?> names = this.p.propertyNames();
        HashSet<File> files = new HashSet<File>();
        while (names.hasMoreElements()) {
            String pName = (String)names.nextElement();
            if (pName == null || !pName.startsWith("file.")) continue;
            String filename = this.p.getProperty(pName);
            files.add(new File(filename));
        }
        return files;
    }

    public String getOutputDirPath() {
        return this.p.getProperty("output.dir");
    }

    private Level getLogLevel(String propertyName, Level defaultLevel) {
        String logLevelString = this.p.getProperty(propertyName);
        if (logLevelString != null) {
            logLevelString = logLevelString.trim();
            Set<String> validLevels = logLevelOptionsMap.keySet();
            for (String level : validLevels) {
                if (!logLevelString.equalsIgnoreCase(level)) continue;
                return logLevelOptionsMap.get(level);
            }
            String msg = MessageFormat.format("Invalid value \"{1}\" for property \"{0}\". Using default value of \"{2}\".", propertyName, logLevelString, defaultLevel);
            this.logger.warning(msg);
            return defaultLevel;
        }
        String msg = MessageFormat.format("No value set for property \"{0}\". Using default value of \"{1}\".", propertyName, defaultLevel);
        this.logger.warning(msg);
        return defaultLevel;
    }

    public Level getFileLogLevel() {
        return this.getLogLevel("loglevel.file", Level.CONFIG);
    }

    public Level getConsoleLogLevel() {
        return this.getLogLevel("loglevel.console", Level.WARNING);
    }

    public boolean getConfigCheckJavacore() {
        String configCheckJavacore = this.p.getProperty("config.check.javacore");
        if (configCheckJavacore != null) {
            return configCheckJavacore.equals("true");
        }
        return false;
    }

    public boolean getRunJextract() {
        String runJextract = this.p.getProperty("run.jextract");
        if (runJextract != null) {
            return Boolean.parseBoolean(runJextract);
        }
        return true;
    }

    static {
        logLevelOptionsMap.put("off", Level.OFF);
        logLevelOptionsMap.put("severe", Level.SEVERE);
        logLevelOptionsMap.put("warning", Level.WARNING);
        logLevelOptionsMap.put("info", Level.INFO);
        logLevelOptionsMap.put("config", Level.CONFIG);
        logLevelOptionsMap.put("fine", Level.FINE);
        logLevelOptionsMap.put("finer", Level.FINER);
        logLevelOptionsMap.put("finest", Level.FINEST);
        logLevelOptionsMap.put("all", Level.ALL);
    }
}

