/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.Util;
import java.io.File;
import java.util.logging.Logger;

public class DumpDescriptor {
    public static final String ZOS_DUMP_SECTION_TOKEN = "&DS";
    public static final String ZOS_FIRST_DUMP_SECTION = "001";
    public static final String ZOS_SECOND_DUMP_SECTION = "002";
    public static final String ZOS_64BIT_SYSTEM_DUMP_SUFFIX = ".X&DS";
    private DumpType dt;
    private File f;
    private String zosDatasetLabel;
    private boolean jextractRun = false;
    private int jextractRC;
    private File jextractZip;

    public DumpDescriptor(String filename) {
        this(new File(filename));
    }

    public DumpDescriptor(File f) {
        this(f, DumpDescriptor.inferDumpTypeFromFile(f));
    }

    public DumpDescriptor(String zosDatasetLabel, DumpType dt) {
        this.zosDatasetLabel = zosDatasetLabel;
        this.dt = dt;
    }

    public DumpDescriptor(File f, DumpType dt) {
        this.f = f;
        this.dt = dt;
    }

    private static DumpType inferDumpTypeFromFile(File file) {
        if (file == null) {
            return DumpType.UNKNOWN;
        }
        String basename = file.getName();
        if (basename.startsWith("javacore")) {
            return DumpType.JAVA;
        }
        if (basename.startsWith("heapdump")) {
            return DumpType.HEAP;
        }
        if (basename.startsWith("core")) {
            return DumpType.SYSTEM;
        }
        if (basename.startsWith("Snap")) {
            return DumpType.SNAP;
        }
        return DumpType.UNKNOWN;
    }

    public DumpType getDumpType() {
        return this.dt;
    }

    public void setDt(DumpType dt) {
        this.dt = dt;
    }

    public File getFile() {
        return this.f;
    }

    public void setFile(File f) {
        this.f = f;
    }

    public String getFilePath() {
        if (this.f != null) {
            return this.f.getPath();
        }
        return null;
    }

    public boolean isJextractRun() {
        return this.jextractRun;
    }

    public void setJextractRun(boolean jextractRun) {
        this.jextractRun = jextractRun;
    }

    public void setJextractRC(int rc) {
        this.jextractRC = rc;
    }

    public int getJextractRC() {
        return this.jextractRC;
    }

    public void setJextractZip(File jextractZip) {
        this.jextractZip = jextractZip;
    }

    public File getJextractZip() {
        return this.jextractZip;
    }

    public String getZosDatasetLabel() {
        return this.zosDatasetLabel;
    }

    public void setZosDatasetLabel(String label) {
        this.zosDatasetLabel = label;
    }

    public String getName() {
        if (this.f != null) {
            return this.f.getAbsolutePath();
        }
        if (this.zosDatasetLabel != null) {
            return this.zosDatasetLabel.replace(ZOS_DUMP_SECTION_TOKEN, ZOS_FIRST_DUMP_SECTION);
        }
        return null;
    }

    public boolean zosDatasetExists(Logger logger) {
        if (this.f != null) {
            return this.f.exists();
        }
        if (this.zosDatasetLabel != null) {
            String dsn = this.zosDatasetLabel.replace(ZOS_DUMP_SECTION_TOKEN, ZOS_FIRST_DUMP_SECTION);
            return Util.zosDatasetExists(logger, dsn);
        }
        return false;
    }

    public boolean zosDatasetIsSplit(Logger logger) {
        if (this.zosDatasetLabel != null && this.zosDatasetLabel.contains(ZOS_DUMP_SECTION_TOKEN)) {
            String dsn = this.zosDatasetLabel.replace(ZOS_DUMP_SECTION_TOKEN, ZOS_SECOND_DUMP_SECTION);
            return Util.zosDatasetExists(logger, dsn);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DumpType {
        SYSTEM,
        JAVA,
        HEAP,
        SNAP,
        VERBOSEGC,
        UNKNOWN;

    }
}

