/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class FileSniffer {
    private static final int ELF = 2135247942;
    private static final int MINIDUMP = 1296321872;
    private static final int USERDUMP_1 = 1431520594;
    private static final int USERDUMP_2 = 1146441040;
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;
    private static final int CORE_DUMP_XX_VERSION = 267312562;
    private static final int CORE_DUMP_X_VERSION = 267312561;
    private static int[] coreid = new int[]{2135247942, 1296321872, -992349888, -992349632};
    private static final String PHD_HEADER = "portable heap dump";
    private static final int PHD_HEADER_SIZE = "portable heap dump".length() + 2;
    private static final int ZIP_ID = 67324752;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoreFormatType getCoreFormat(ImageInputStream iis) throws IOException {
        try {
            int header = iis.readInt();
            int header2 = iis.readInt();
            if (header == 1296321872) {
                CoreFormatType coreFormatType = CoreFormatType.MINIDUMP;
                return coreFormatType;
            }
            if (header == 1431520594 && header2 == 1146441040) {
                CoreFormatType coreFormatType = CoreFormatType.USERDUMP;
                return coreFormatType;
            }
            if (header == 2135247942 && FileSniffer.isElfCoreFile(iis)) {
                CoreFormatType coreFormatType = CoreFormatType.ELF;
                return coreFormatType;
            }
            if (header == -992349888 || header == -992349632) {
                CoreFormatType coreFormatType = CoreFormatType.MVS;
                return coreFormatType;
            }
            if (header2 == 267312561 || header2 == 267312562) {
                CoreFormatType coreFormatType = CoreFormatType.XCOFF;
                return coreFormatType;
            }
            CoreFormatType coreFormatType = CoreFormatType.UNKNOWN;
            return coreFormatType;
        }
        finally {
            iis.seek(0L);
        }
    }

    public static boolean isCoreFile(InputStream in, long filesize) throws IOException {
        MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(in);
        return FileSniffer.isCoreFile(iis, filesize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCoreFile(ImageInputStream iis, long filesize) throws IOException {
        try {
            boolean bl;
            int header = iis.readInt();
            int header2 = iis.readInt();
            for (int i = 0; i < coreid.length; ++i) {
                if (header != coreid[i]) continue;
                if (header == 2135247942) {
                    boolean bl2 = FileSniffer.isElfCoreFile(iis);
                    return bl2;
                }
                boolean bl3 = true;
                return bl3;
            }
            if (header == 1431520594 && header2 == 1146441040) {
                bl = true;
                return bl;
            }
            if (header2 == 267312561 || header2 == 267312562) {
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
        finally {
            iis.seek(0L);
        }
    }

    private static boolean isElfCoreFile(ImageInputStream iis) throws IOException {
        boolean isCore = false;
        ByteOrder originalOrder = iis.getByteOrder();
        iis.seek(5L);
        byte order = iis.readByte();
        iis.seek(16L);
        short type = 0;
        if (order == 1) {
            iis.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            type = iis.readShort();
        } else if (order == 2) {
            iis.setByteOrder(ByteOrder.BIG_ENDIAN);
            type = iis.readShort();
        }
        if (type == 4) {
            isCore = true;
        }
        iis.setByteOrder(originalOrder);
        return isCore;
    }

    public static boolean isJavaCoreFile(InputStream in, long filesize) throws IOException {
        MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(in);
        return FileSniffer.isJavaCoreFile(iis, filesize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJavaCoreFile(ImageInputStream iis, long filesize) throws IOException {
        try {
            byte[] headBytes = new byte[256];
            iis.read(headBytes);
            ByteBuffer headByteBuffer = ByteBuffer.wrap(headBytes);
            String[] estimates = new String[]{"IBM1047", "UTF-16BE", "UTF-16LE", System.getProperty("file.encoding"), "IBM850"};
            try {
                Charset cs = null;
                for (int i = 0; i < estimates.length && cs == null; ++i) {
                    cs = FileSniffer.attemptCharset(headByteBuffer, Charset.forName(estimates[i]));
                }
                boolean bl = cs != null;
                return bl;
            }
            catch (UnsupportedCharsetException e) {
                boolean bl = false;
                iis.seek(0L);
                return bl;
            }
        }
        finally {
            iis.seek(0L);
        }
    }

    private static Charset attemptCharset(ByteBuffer headByteBuffer, Charset trialCharset) throws IOException {
        String sectionEyeCatcher = "0SECTION";
        String charsetEyeCatcher = "1TICHARSET";
        headByteBuffer.rewind();
        String head = trialCharset.decode(headByteBuffer).toString();
        if (head.indexOf("0SECTION") >= 0) {
            int idx = head.indexOf("1TICHARSET");
            if (idx >= 0) {
                String javacoreCharset = head.substring(idx += "1TICHARSET".length()).trim();
                javacoreCharset = javacoreCharset.split("\\s+")[0];
                try {
                    Charset trueCharset = Charset.forName(javacoreCharset);
                    ByteBuffer sanityTrial = trialCharset.encode("0SECTION");
                    ByteBuffer sanityTrue = trueCharset.encode("0SECTION");
                    if (sanityTrial.equals(sanityTrue)) {
                        return trueCharset;
                    }
                    throw new IOException("Ignoring Javacore encoding '" + javacoreCharset + "' hinted at by '" + "1TICHARSET" + "' eye catcher due to suspected change of encoding.\n" + "Eye catcher was readable using encoding '" + trialCharset.displayName() + "'.");
                }
                catch (IllegalCharsetNameException e) {
                }
                catch (UnsupportedCharsetException e) {
                    IOException ioe = new IOException("Unable to use Javacore encoding '" + javacoreCharset + "' hinted at by '" + "1TICHARSET" + "' eye catcher as the JVM does not support this encoding.");
                    ioe.initCause(e);
                    throw ioe;
                }
            } else {
                return trialCharset;
            }
        }
        return null;
    }

    public static boolean isPHDFile(InputStream in, long filesize) throws IOException {
        MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(in);
        return FileSniffer.isPHDFile(iis, filesize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPHDFile(ImageInputStream iis, long filesize) throws IOException {
        if (filesize < (long)PHD_HEADER_SIZE) {
            return false;
        }
        try {
            String header = FileSniffer.readUTF(iis, PHD_HEADER_SIZE);
            boolean bl = header.equals(PHD_HEADER);
            return bl;
        }
        finally {
            iis.reset();
        }
    }

    private static String readUTF(ImageInputStream iis, int maxlen) throws IOException {
        int length = iis.readUnsignedShort();
        if (length > maxlen && maxlen > 0) {
            length = maxlen;
        }
        byte[] buf = new byte[length];
        iis.readFully(buf);
        return new String(buf, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipFile(ImageInputStream iis) throws IOException {
        ByteOrder byteOrder = iis.getByteOrder();
        try {
            iis.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            iis.mark();
            int sig = iis.readInt();
            if (sig != 67324752) {
                boolean bl = false;
                return bl;
            }
            iis.seek(10L);
            int time = iis.readUnsignedShort();
            int seconds = (time & 0x1F) / 2;
            if (seconds < 0 || seconds > 60) {
                boolean bl = false;
                return bl;
            }
            int minutes = (time & 0x7E0) >> 5;
            if (minutes < 0 || minutes > 60) {
                boolean bl = false;
                return bl;
            }
            int hours = (time & 0xF800) >> 11;
            if (hours < 0 || hours > 23) {
                boolean bl = false;
                return bl;
            }
            int date = iis.readUnsignedShort();
            int day = date & 0x1F;
            if (day < 1 || day > 31) {
                boolean bl = false;
                return bl;
            }
            int month = (date & 0x1E0) >> 5;
            if (month < 1 || month > 12) {
                boolean bl = false;
                return bl;
            }
            int year = ((date & 0xFE00) >> 9) + 1980;
            if (year < 1980 || year > 2500) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            iis.setByteOrder(byteOrder);
            iis.reset();
        }
        return true;
    }

    public static boolean isZipFile(File file) throws IOException {
        FileImageInputStream fis = new FileImageInputStream(file);
        boolean result = FileSniffer.isZipFile(fis);
        fis.close();
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoreFormatType {
        ELF,
        MINIDUMP,
        MVS,
        XCOFF,
        USERDUMP,
        UNKNOWN;

    }
}

