/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.dtfj.utils.file.SimpleFileManager;
import com.ibm.dtfj.utils.file.UnzipFailedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public abstract class CompressedFileManager
extends SimpleFileManager {
    protected final byte[] buffer = new byte[4096];

    public CompressedFileManager(File file) {
        super(file);
    }

    public abstract void extract(File var1) throws IOException;

    public abstract void extract(ManagedImageSource var1, File var2) throws IOException;

    public abstract ImageInputStream getStream(ManagedImageSource var1) throws IOException;

    protected void checkDirectoryToExtractTo(File todir) {
        if (todir.exists()) {
            if (!todir.isDirectory()) {
                throw new IllegalArgumentException("The specified directory " + todir.getAbsolutePath() + " is not a directory ");
            }
        } else {
            todir.mkdirs();
        }
    }

    public ManagedImageSource getImageSource(String path) throws IOException {
        List<ManagedImageSource> candidates = this.getImageSources();
        if (candidates.contains(path)) {
            ManagedImageSource candidate = candidates.get(candidates.indexOf(path));
            return candidate;
        }
        throw new FileNotFoundException("The entry " + path + " was not found in " + this.managedFile.getAbsolutePath());
    }

    protected void extractEntry(InputStream in, File path) throws IOException {
        FileOutputStream out = null;
        long total = 0L;
        try {
            logger.fine("Extracting " + path.getName() + " to " + path.getAbsolutePath());
            out = new FileOutputStream(path);
            int bytesread = -1;
            while ((bytesread = in.read(this.buffer)) != -1) {
                total += (long)bytesread;
                out.write(this.buffer, 0, bytesread);
            }
        }
        catch (IOException e) {
            out.close();
            path.delete();
            throw new UnzipFailedException("Error occured when extracting " + path.getName() + " from archive to " + path.getAbsolutePath() + " : " + e.getMessage());
        }
        finally {
            logger.fine("Extracted " + total + " bytes");
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }
}

