/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.parser;

import com.ibm.dtfj.phd.parser.Base;
import com.ibm.dtfj.phd.parser.DumpClass;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import com.ibm.dtfj.phd.parser.PortableHeapDumpListener;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.io.PrintStream;

public class PrintHeapdump
extends Base {
    boolean hash;
    String[] types = new String[]{"bool", "char", "float", "double", "byte", "short", "int", "long"};
    int objectCount;
    int objectArrayCount;
    int classCount;
    int primitiveArrayCount;
    int totalObjectCount;
    int refCount;
    int minimumInstanceSize = 100;
    PrintStream out;
    static boolean is64Bit;

    public static void main(String[] args) throws Exception {
        new PrintHeapdump(args);
    }

    public PrintHeapdump(String[] args) throws Exception {
        this.parseOptions(args);
        this.out = System.out;
        this.parse(args[args.length - 1]);
    }

    public PrintHeapdump(String filename) throws Exception {
        this.out = System.out;
        this.parse(filename);
    }

    public PrintHeapdump(String filename, PrintStream out) throws Exception {
        this.out = out;
        this.parse(filename);
    }

    int roundup(int size) {
        return size + 7 & 0xFFFFFFF8;
    }

    void printRefs(LongEnumeration refs) {
        this.out.print("\t");
        while (refs.hasMoreElements()) {
            this.out.print("0x" + PrintHeapdump.hex(refs.nextLong()) + " ");
            ++this.refCount;
        }
        this.out.println("");
    }

    public void parse(String filename) throws Exception {
        HeapdumpReader reader = new HeapdumpReader(filename);
        this.out.println("// Version: " + reader.full_version());
        reader.parse(new PortableHeapDumpListener(){

            public void objectDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, boolean isPacked, boolean isNativePacked, long instanceSize) {
                DumpClass.foundClass(classAddress);
            }

            public void objectArrayDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, int length, long instanceSize, boolean isPacked, boolean isNativePacked) {
                DumpClass.foundClass(classAddress);
            }

            public void classDump(long address, long superAddress, String name, int instanceSize, int flags, int hashCode, LongEnumeration refs, boolean isPacked) {
                DumpClass.put(address, name, instanceSize);
                if (instanceSize >= 0 && instanceSize < PrintHeapdump.this.minimumInstanceSize) {
                    PrintHeapdump.this.minimumInstanceSize = instanceSize;
                }
            }

            public void primitiveArrayDump(long address, int type, int length, int flags, int hashCode, long instanceSize) {
            }
        });
        reader.close();
        reader = new HeapdumpReader(filename);
        is64Bit = reader.is64Bit();
        reader.parse(new PortableHeapDumpListener(){

            public void objectDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, boolean isPacked, boolean isNativePacked, long instanceSize) {
                DumpClass cl = DumpClass.get(classAddress);
                long size = cl.instanceSize;
                if (isPacked) {
                    size = instanceSize;
                }
                PrintHeapdump.this.out.println("0x" + PrintHeapdump.hexpad(address).toUpperCase() + " [" + size + "] " + cl.name + (PrintHeapdump.this.hash ? " [hashcode = " + Base.hex(hashCode) + "]" : "") + (isPacked ? " is packed " : "") + (isNativePacked ? " is native packed " : ""));
                PrintHeapdump.this.printRefs(refs);
                ++PrintHeapdump.this.objectCount;
                ++PrintHeapdump.this.totalObjectCount;
            }

            public void objectArrayDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, int length, long instanceSize, boolean isPacked, boolean isNativePacked) {
                DumpClass cl = DumpClass.get(classAddress);
                if (instanceSize == -1L) {
                    instanceSize = length + 4 << (is64Bit ? 3 : 2);
                    instanceSize = PrintHeapdump.this.roundup((int)instanceSize);
                }
                PrintHeapdump.this.out.println("0x" + PrintHeapdump.hexpad(address).toUpperCase() + " [" + instanceSize + "] array of " + cl.name + (PrintHeapdump.this.hash ? " [hashcode = " + Base.hex(hashCode) + "]" : ""));
                PrintHeapdump.this.printRefs(refs);
                ++PrintHeapdump.this.objectArrayCount;
                ++PrintHeapdump.this.totalObjectCount;
            }

            public void classDump(long address, long superAddress, String name, int instanceSize, int flags, int hashCode, LongEnumeration refs, boolean isPacked) {
                PrintHeapdump.this.out.println("0x" + PrintHeapdump.hexpad(address).toUpperCase() + " [" + (is64Bit ? "552" : "304") + "] class " + name + (PrintHeapdump.this.hash ? " [hashcode = " + Base.hex(hashCode) + "]" : "" + (isPacked ? " is packed " : " is not packed")));
                PrintHeapdump.this.printRefs(refs);
                ++PrintHeapdump.this.classCount;
                ++PrintHeapdump.this.totalObjectCount;
            }

            public void primitiveArrayDump(long address, int type, int length, int flags, int hashCode, long instanceSize) {
                if (instanceSize == -1L) {
                    instanceSize = (length << (type & 3)) + (is64Bit ? 24 : 12);
                    instanceSize = PrintHeapdump.this.roundup((int)instanceSize);
                }
                if (type >= PrintHeapdump.this.types.length) {
                    PrintHeapdump.this.out.println("Warning! bad type " + type + " found in following object");
                    type = 0;
                }
                PrintHeapdump.this.out.println("0x" + PrintHeapdump.hexpad(address).toUpperCase() + " [" + instanceSize + "] " + PrintHeapdump.this.types[type] + "[]" + (PrintHeapdump.this.hash ? " [hashcode = " + Base.hex(hashCode) + "]" : ""));
                ++PrintHeapdump.this.primitiveArrayCount;
                ++PrintHeapdump.this.totalObjectCount;
            }
        });
        reader.close();
        this.out.println("");
        this.out.println("// Breakdown - Classes: " + this.classCount + ", Objects: " + this.objectCount + ", ObjectArrays: " + this.objectArrayCount + ", PrimitiveArrays: " + this.primitiveArrayCount);
        this.out.println("// EOF:  Total 'Objects',Refs(null) : " + this.totalObjectCount + "," + this.refCount + "(0)");
    }

    String[] options() {
        return new String[]{"-hash"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tInclude the hash codes"};
    }

    public boolean parseOption(String arg, String opt) {
        if ("-hash".equals(arg)) {
            this.hash = true;
            return true;
        }
        return super.parseOption(arg, opt);
    }

    String className() {
        return "PrintHeapdump";
    }

    public static String hexpad(long word) {
        String s = is64Bit ? Long.toHexString(word) : Integer.toHexString((int)word);
        for (int i = s.length(); i < (is64Bit ? 16 : 8); ++i) {
            s = "0" + s;
        }
        return s;
    }

    public static String hex(long word) {
        String s = is64Bit ? String.format("%016X", word) : String.format("%08X", word);
        return s;
    }
}

