/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHDJavaMethod
implements JavaMethod {
    private JavaClass cls;
    private CorruptData cls_cd;
    private String name;
    private CorruptData name_cd;
    private String sig;
    private CorruptData sig_cd;
    private int mods;
    private CorruptData mods_cd;

    PHDJavaMethod(ImageAddressSpace space, JavaClass cls1, JavaMethod meta) {
        this.cls = cls1;
        try {
            this.name = meta.getName();
        }
        catch (CorruptDataException e) {
            this.name_cd = new PHDCorruptData(space, e);
        }
        try {
            this.sig = meta.getSignature();
        }
        catch (CorruptDataException e) {
            this.sig_cd = new PHDCorruptData(space, e);
        }
        try {
            this.mods = meta.getModifiers();
        }
        catch (CorruptDataException e) {
            this.mods_cd = new PHDCorruptData(space, e);
        }
    }

    PHDJavaMethod(ImageAddressSpace space, PHDJavaRuntime runtime, JavaMethod meta) {
        this(space, (JavaClass)null, meta);
        try {
            JavaClass metacls = meta.getDeclaringClass();
            ImagePointer ip = metacls.getID();
            if (ip != null) {
                this.cls = runtime.findClass(ip.getAddress());
            }
            if (this.cls == null) {
                this.cls = runtime.findClass(metacls.getName());
            }
        }
        catch (CorruptDataException e) {
            this.cls_cd = new PHDCorruptData(space, e);
        }
        catch (DataUnavailable e) {
            // empty catch block
        }
    }

    public Iterator<ImageSection> getBytecodeSections() {
        return Collections.emptyList().iterator();
    }

    public Iterator getCompiledSections() {
        return Collections.emptyList().iterator();
    }

    public JavaClass getDeclaringClass() throws CorruptDataException, DataUnavailable {
        this.checkCD(this.cls_cd);
        if (this.cls == null) {
            throw new DataUnavailable("No class");
        }
        return this.cls;
    }

    public int getModifiers() throws CorruptDataException {
        this.checkCD(this.mods_cd);
        return this.mods;
    }

    public String getName() throws CorruptDataException {
        this.checkCD(this.name_cd);
        return this.name;
    }

    public String getSignature() throws CorruptDataException {
        this.checkCD(this.sig_cd);
        return this.sig;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        PHDJavaMethod m = (PHDJavaMethod)o;
        return this.equals(this.cls, m.cls) && this.equals(this.name, m.name) && this.equals(this.sig, m.sig);
    }

    public int hashCode() {
        return this.hashCode(this.cls) ^ this.hashCode(this.name) ^ this.hashCode(this.sig);
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    private void checkCD(CorruptData cd) throws CorruptDataException {
        if (cd != null) {
            throw new CorruptDataException(cd);
        }
    }
}

