/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.phd.PHDImageAddressSpace;
import com.ibm.dtfj.phd.PHDImageFactory;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import com.ibm.dtfj.utils.ManagedImage;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHDImage
implements ManagedImage {
    private final File file;
    private final ArrayList<ImageAddressSpace> addressList;
    private final Image meta;
    private final List<HeapdumpReader> closeList = new LinkedList<HeapdumpReader>();
    private final URI source;
    private ManagedImageSource imageSource = null;

    PHDImage(File file) throws IOException {
        this(file, null);
    }

    PHDImage(File file, Image meta) throws IOException {
        this.file = file;
        this.meta = meta;
        this.source = null;
        try {
            Object o2;
            Iterator i2;
            ImageAddressSpace metaSpace = null;
            if (meta != null && (i2 = meta.getAddressSpaces()).hasNext() && !((o2 = i2.next()) instanceof CorruptData)) {
                metaSpace = (ImageAddressSpace)o2;
            }
            PHDImageAddressSpace imageAddress = new PHDImageAddressSpace(file, this, metaSpace);
            this.addressList = new ArrayList();
            this.addressList.add(imageAddress);
        }
        catch (Error e) {
            if (e.getClass() == Error.class) {
                IOException e1 = new IOException(MessageFormat.format("Problem opening dump {0} metafile {1}", file, meta));
                e1.initCause(e);
                throw e1;
            }
            throw e;
        }
    }

    PHDImage(URI source, ImageInputStream stream) throws IOException {
        this(source, stream, null);
    }

    PHDImage(URI source, ImageInputStream stream, Image meta) throws IOException {
        this.source = source;
        this.file = null;
        this.meta = meta;
        try {
            Object o2;
            Iterator i2;
            ImageAddressSpace metaSpace = null;
            if (meta != null && (i2 = meta.getAddressSpaces()).hasNext() && !((o2 = i2.next()) instanceof CorruptData)) {
                metaSpace = (ImageAddressSpace)o2;
            }
            PHDImageAddressSpace imageAddress = new PHDImageAddressSpace(stream, this, metaSpace);
            this.addressList = new ArrayList();
            this.addressList.add(imageAddress);
        }
        catch (Error e) {
            if (e.getClass() == Error.class) {
                IOException e1 = new IOException(MessageFormat.format("Problem opening dump {0} metafile {1}", this.file, meta));
                e1.initCause(e);
                throw e1;
            }
            throw e;
        }
    }

    public URI getSource() {
        if (this.source == null) {
            return this.file.toURI();
        }
        return this.source;
    }

    public Iterator<ImageAddressSpace> getAddressSpaces() {
        return this.addressList.iterator();
    }

    public long getCreationTime() throws DataUnavailable {
        if (this.file == null) {
            throw new DataUnavailable("File creation time not available.");
        }
        String name = this.file.getName();
        String prefix = "heapdump";
        int p = Math.max(0, name.indexOf(prefix));
        if ((name = name.substring(p)).startsWith(prefix)) {
            String dateTime = "yyyyMMdd.HHmmss";
            SimpleDateFormat sdf = new SimpleDateFormat(dateTime);
            ParsePosition pp = new ParsePosition(0);
            for (int i = prefix.length(); i < name.length(); ++i) {
                pp.setIndex(i);
                Date d = sdf.parse(name, pp);
                if (d == null || d.before(PHDImageFactory.earliestDump) || !d.before(PHDImageFactory.latestDump)) continue;
                return d.getTime();
            }
        }
        String[] s = name.split("\\.");
        prefix = "heapdump";
        if ((s.length == 3 || s.length == 4 && s[3].equals("gz")) && s[0].startsWith(prefix)) {
            try {
                Integer.parseInt(s[0].substring(prefix.length()));
                long l2 = Long.parseLong(s[1]);
                Date dF = new Date(l2 * 1000L);
                if (!dF.before(PHDImageFactory.earliestDump) && dF.before(PHDImageFactory.latestDump)) {
                    return dF.getTime();
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            if (this.meta != null) {
                return this.meta.getCreationTime();
            }
        }
        catch (DataUnavailable e) {
            // empty catch block
        }
        return this.file.lastModified();
    }

    public String getHostName() throws DataUnavailable, CorruptDataException {
        if (this.meta != null) {
            return this.meta.getHostName();
        }
        throw new DataUnavailable();
    }

    public Iterator<InetAddress> getIPAddresses() throws DataUnavailable {
        throw new DataUnavailable();
    }

    public long getInstalledMemory() throws DataUnavailable {
        if (this.meta != null) {
            return this.meta.getInstalledMemory();
        }
        throw new DataUnavailable();
    }

    public int getProcessorCount() throws DataUnavailable {
        if (this.meta != null) {
            return this.meta.getProcessorCount();
        }
        throw new DataUnavailable();
    }

    public String getProcessorSubType() throws DataUnavailable, CorruptDataException {
        if (this.meta != null) {
            return this.meta.getProcessorSubType();
        }
        throw new DataUnavailable();
    }

    public String getProcessorType() throws DataUnavailable, CorruptDataException {
        if (this.meta != null) {
            return this.meta.getProcessorType();
        }
        throw new DataUnavailable();
    }

    public String getSystemSubType() throws DataUnavailable, CorruptDataException {
        if (this.meta != null) {
            return this.meta.getSystemSubType();
        }
        throw new DataUnavailable();
    }

    public String getSystemType() throws DataUnavailable, CorruptDataException {
        if (this.meta != null) {
            return this.meta.getSystemType();
        }
        throw new DataUnavailable();
    }

    public void close() {
        if (this.addressList != null) {
            this.addressList.clear();
        }
        if (this.meta != null) {
            this.meta.close();
        }
        for (HeapdumpReader r : this.closeList.toArray(new HeapdumpReader[0])) {
            if (r == null) continue;
            r.releaseResources();
        }
        if (this.imageSource != null && this.imageSource.getExtractedTo() != null) {
            this.imageSource.getExtractedTo().delete();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void registerReader(HeapdumpReader reader) {
        this.closeList.add(reader);
    }

    public void unregisterReader(HeapdumpReader reader) {
        this.closeList.remove(reader);
    }

    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public ManagedImageSource getImageSource() {
        return this.imageSource;
    }

    @Override
    public void setImageSource(ManagedImageSource source) {
        this.imageSource = source;
    }
}

