/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.title;

import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.title.ITitleTypes;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TitleSectionParser
extends SectionParser
implements ITitleTypes {
    public TitleSectionParser() {
        super("TITLE");
    }

    protected void topLevelRule() throws ParserException {
        String fn;
        SimpleDateFormat sdf;
        String tm;
        IAttributeValueMap results = null;
        this.processTagLineRequired("1TISIGINFO");
        results = this.processTagLineRequired("1TIDATETIME");
        Date d = null;
        if (results != null && (tm = results.getTokenValue("title_date")) != null && (d = (sdf = new SimpleDateFormat("yyyy/MM/dd 'at' HH:mm:ss")).parse(tm, new ParsePosition(0))) != null) {
            long time = d.getTime();
            this.fImageBuilder.setCreationTime(time);
        }
        if ((results = this.processTagLineRequired("1TIFILENAME")) != null && (fn = results.getTokenValue("title_filename")) != null && d != null) {
            Date d2;
            Date d1;
            String pid = this.getPID(fn = fn.replaceAll(".*[\\\\/]", ""), d1 = d, d2 = new Date(d.getTime() + 300000L));
            if (pid == null) {
                d1 = new Date(d.getTime() - 93600000L);
                d2 = new Date(d.getTime() + 93600000L);
                pid = this.getPIDAIX(fn, d1, d2);
            }
            if (pid != null) {
                this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder().setID(pid);
            }
        }
    }

    private String getPID(String fn, Date d1, Date d2) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd.HHmmss");
        ParsePosition pp = new ParsePosition(0);
        block2: for (int i = 0; i < fn.length(); ++i) {
            pp.setIndex(i);
            Date dF = sdf.parse(fn, pp);
            if (dF == null || d1.before(dF) || !d2.after(dF)) continue;
            String[] rest = fn.substring(pp.getIndex()).split("\\.");
            for (int j = 0; j < rest.length; ++j) {
                if (rest[j].equals("")) continue;
                try {
                    int pid = Integer.parseInt(rest[j]);
                    return rest[j];
                }
                catch (NumberFormatException e) {
                    continue block2;
                }
            }
        }
        return null;
    }

    private String getPIDAIX(String fn, Date d1, Date d2) {
        String[] s = fn.split("\\.");
        String prefix = "javacore";
        if ((s.length == 3 || s.length == 4 && s[3].equals("gz")) && s[0].startsWith(prefix)) {
            try {
                int i1 = Integer.parseInt(s[0].substring(prefix.length()));
                long l2 = Long.parseLong(s[1]);
                Date dF = new Date(l2 * 1000L);
                if (!dF.before(d1) && dF.before(d2)) {
                    return Integer.toString(i1);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected void sovOnlyRules(String startingTag) throws ParserException {
    }
}

