/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.javacore.builder.IImageBuilderFactory;
import com.ibm.dtfj.javacore.parser.framework.parser.IErrorListener;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.DTFJComponentLoader;
import com.ibm.dtfj.javacore.parser.j9.J9TagManager;
import com.ibm.dtfj.javacore.parser.j9.ParserController;
import com.ibm.dtfj.javacore.parser.j9.registered.RegisteredComponents;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaCoreReader {
    private RegisteredComponents fComponents;
    private IImageBuilderFactory fImageBuilderFactory;

    public JavaCoreReader(IImageBuilderFactory imageBuilderFactory) {
        this.fImageBuilderFactory = imageBuilderFactory;
        this.fComponents = new RegisteredComponents();
    }

    public Image generateImage(InputStream input) throws IOException {
        try {
            byte[] head = new byte[256];
            input.read(head);
            ByteArrayInputStream headByteStream = new ByteArrayInputStream(head);
            Charset cs = this.getJavaCoreCodePage(headByteStream);
            SequenceInputStream stream = new SequenceInputStream(headByteStream, input);
            InputStreamReader reader = cs != null ? new InputStreamReader((InputStream)stream, cs) : new InputStreamReader(stream);
            List frameworkSections = new DTFJComponentLoader().loadSections();
            ParserController parserController = new ParserController(frameworkSections, this.fImageBuilderFactory);
            parserController.addErrorListener(new IErrorListener(){
                private Logger logger = Logger.getLogger("com.ibm.dtfj.log");

                public void handleEvent(String msg) {
                    this.logger.fine(msg);
                }
            });
            J9TagManager tagManager = J9TagManager.getCurrent();
            return parserController.parse(this.fComponents.getScannerManager(reader, tagManager));
        }
        catch (ParserException e) {
            IOException e1 = new IOException("Error parsing Javacore");
            e1.initCause(e);
            throw e1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Charset getJavaCoreCodePage(ByteArrayInputStream input) throws IOException {
        input.mark(256);
        Charset cs = null;
        try {
            byte[] headBytes = new byte[256];
            input.read(headBytes);
            ByteBuffer headByteBuffer = ByteBuffer.wrap(headBytes);
            String[] estimates = new String[]{"IBM1047", "UTF-16BE", "UTF-16LE", System.getProperty("file.encoding"), "IBM850"};
            try {
                for (int i = 0; i < estimates.length && cs == null; ++i) {
                    cs = this.attemptCharset(headByteBuffer, Charset.forName(estimates[i]));
                }
            }
            catch (UnsupportedCharsetException e) {
                // empty catch block
            }
        }
        catch (JavacoreFileEncodingException e) {
            Logger.getLogger("com.ibm.dtfj.log").log(Level.WARNING, e.getMessage(), e);
        }
        finally {
            input.reset();
        }
        return cs;
    }

    private Charset attemptCharset(ByteBuffer headByteBuffer, Charset trialCharset) throws JavacoreFileEncodingException {
        String sectionEyeCatcher = "0SECTION";
        String charsetEyeCatcher = "1TICHARSET";
        headByteBuffer.rewind();
        String head = trialCharset.decode(headByteBuffer).toString();
        if (head.indexOf("0SECTION") >= 0) {
            int idx = head.indexOf("1TICHARSET");
            if (idx >= 0) {
                String javacoreCharset = head.substring(idx += "1TICHARSET".length()).trim();
                javacoreCharset = javacoreCharset.split("\\s+")[0];
                try {
                    Charset trueCharset;
                    try {
                        trueCharset = Charset.forName(javacoreCharset);
                    }
                    catch (UnsupportedCharsetException c) {
                        trueCharset = Charset.forName("cp" + javacoreCharset);
                    }
                    ByteBuffer sanityTrial = trialCharset.encode("0SECTION");
                    ByteBuffer sanityTrue = trueCharset.encode("0SECTION");
                    if (sanityTrial.equals(sanityTrue)) {
                        return trueCharset;
                    }
                    throw new JavacoreFileEncodingException("Ignoring Javacore encoding '" + javacoreCharset + "' hinted at by '" + "1TICHARSET" + "' eye catcher due to suspected change of encoding.\n" + "Eye catcher was readable using encoding '" + trialCharset.displayName() + "'.");
                }
                catch (IllegalCharsetNameException e) {
                }
                catch (UnsupportedCharsetException e) {
                    throw new JavacoreFileEncodingException("Unable to use Javacore encoding '" + javacoreCharset + "' hinted at by '" + "1TICHARSET" + "' eye catcher as the JVM does not support this encoding.", e);
                }
            }
            return trialCharset;
        }
        return null;
    }

    private class JavacoreFileEncodingException
    extends Exception {
        public JavacoreFileEncodingException(String string) {
            super(string);
        }

        public JavacoreFileEncodingException(String string, Exception exception) {
            super(string, exception);
        }
    }
}

