/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9;

import com.ibm.dtfj.javacore.parser.framework.tag.ITagManager;
import com.ibm.dtfj.javacore.parser.framework.tag.ITagParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class J9TagManager
implements ITagManager {
    private HashMap fAllTags = new HashMap();
    private HashMap fTagParsers = new HashMap();
    private static J9TagManager fTagManager;
    public static final String CHECK_ALL = "check_all";
    private String fCommentType = "NULL";

    public static J9TagManager getCurrent() {
        if (fTagManager == null) {
            fTagManager = new J9TagManager();
        }
        return fTagManager;
    }

    public void loadTagParsers(ArrayList tagParsers) {
        if (tagParsers == null) {
            return;
        }
        this.fAllTags.clear();
        this.fTagParsers.clear();
        for (ITagParser parser : tagParsers) {
            if (parser == null) continue;
            this.fTagParsers.put(parser.getSectionName(), parser);
        }
        this.fillAllTags();
    }

    private void fillAllTags() {
        for (ITagParser parser : this.fTagParsers.values()) {
            Iterator itTags = parser.getTags();
            while (itTags.hasNext()) {
                String tag = (String)itTags.next();
                if (tag == null) continue;
                this.fAllTags.put(tag, tag);
            }
        }
    }

    public boolean hasTag(String identifier) {
        return this.fAllTags.containsKey(identifier);
    }

    public ITagParser getTagParser(String section) {
        return (ITagParser)this.fTagParsers.get(section);
    }

    public boolean isTagInSection(String tag, String section) {
        boolean result = false;
        if (section.equals(CHECK_ALL)) {
            result = this.fAllTags.containsKey(tag);
        } else {
            ITagParser parser = (ITagParser)this.fTagParsers.get(section);
            if (parser != null) {
                result = parser.hasTag(tag);
            }
        }
        return result;
    }

    public boolean isComment(CharSequence source) {
        boolean result = false;
        int length = 0;
        if (source != null && (length = this.fCommentType.length()) == source.length()) {
            for (int i = 0; i < length && (result = this.fCommentType.charAt(i) == source.charAt(i)); ++i) {
            }
        }
        return result;
    }
}

