/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.java.JavaRuntimeMemoryCategory;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JCJavaRuntimeMemoryCategory
implements JavaRuntimeMemoryCategory {
    private final String name;
    private final long deepAllocations;
    private final long deepBytes;
    private boolean shallowValuesSet = false;
    private long shallowAllocations;
    private long shallowBytes;
    private final List children = new LinkedList();
    private static final String nl = System.getProperty("line.separator");

    public JCJavaRuntimeMemoryCategory(String name, long deepBytes, long deepAllocations) {
        this.name = name;
        this.deepAllocations = deepAllocations;
        this.deepBytes = deepBytes;
    }

    public Iterator getChildren() {
        return Collections.unmodifiableList(this.children).iterator();
    }

    public void addChild(JavaRuntimeMemoryCategory child) {
        this.children.add(child);
    }

    public long getDeepAllocations() {
        return this.deepAllocations;
    }

    public long getDeepBytes() {
        return this.deepBytes;
    }

    public Iterator getMemorySections(boolean includeFreed) {
        return Collections.EMPTY_LIST.iterator();
    }

    public String getName() {
        return this.name;
    }

    public void setShallowCounters(long shallowBytes, long shallowAllocations) {
        this.shallowBytes = shallowBytes;
        this.shallowAllocations = shallowAllocations;
        this.shallowValuesSet = true;
    }

    public long getShallowAllocations() {
        if (this.shallowValuesSet) {
            return this.shallowAllocations;
        }
        if (this.children.size() == 0) {
            return this.deepAllocations;
        }
        return 0L;
    }

    public long getShallowBytes() {
        if (this.shallowValuesSet) {
            return this.shallowBytes;
        }
        if (this.children.size() == 0) {
            return this.deepBytes;
        }
        return 0L;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.buildPrintTree(buffer, 1);
        return buffer.toString();
    }

    private void buildPrintTree(StringBuffer buffer, int depth) {
        int i;
        if (depth > 1) {
            for (i = 0; i < depth - 1; ++i) {
                if (i > 0) {
                    buffer.append("    ");
                }
                buffer.append("|");
            }
            buffer.append(nl);
        }
        for (i = 0; i < depth - 2; ++i) {
            buffer.append("|    ");
        }
        if (depth > 1) {
            buffer.append("+--");
        }
        buffer.append(this.name);
        buffer.append(": ");
        buffer.append(Long.toString(this.deepBytes));
        buffer.append(" / ");
        buffer.append(Long.toString(this.deepAllocations));
        buffer.append(" allocation");
        if (this.deepAllocations != 1L) {
            buffer.append("s");
        }
        buffer.append(nl);
        for (JCJavaRuntimeMemoryCategory child : this.children) {
            child.buildPrintTree(buffer, depth + 1);
        }
        if (this.children.size() > 0 && this.getShallowBytes() > 0L) {
            JCJavaRuntimeMemoryCategory otherPseudoCategory = new JCJavaRuntimeMemoryCategory("Other", this.getShallowBytes(), this.getShallowAllocations());
            otherPseudoCategory.buildPrintTree(buffer, depth + 1);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : ((Object)this.children).hashCode());
        result = 31 * result + (int)(this.deepAllocations ^ this.deepAllocations >>> 32);
        result = 31 * result + (int)(this.deepBytes ^ this.deepBytes >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JCJavaRuntimeMemoryCategory)) {
            return false;
        }
        JCJavaRuntimeMemoryCategory other = (JCJavaRuntimeMemoryCategory)obj;
        if (this.children == null ? other.children != null : !((Object)this.children).equals(other.children)) {
            return false;
        }
        if (this.deepAllocations != other.deepAllocations) {
            return false;
        }
        if (this.deepBytes != other.deepBytes) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

