/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JavaStackFrame
implements com.ibm.dtfj.java.JavaStackFrame {
    private JavaRuntime _javaVM;
    private ImagePointer _basePointer;
    private JavaMethod _method;
    private ImagePointer _methodID;
    private ImagePointer _pc;
    private int _lineNumber;
    private Vector _stackRoots = new Vector();

    private JavaStackFrame(JavaRuntime javaVM, ImagePointer basePointer, ImagePointer pc, int lineNumber) {
        if (null == basePointer) {
            throw new IllegalArgumentException("A Java stack frame must have a non-null base pointer");
        }
        if (null == pc) {
            throw new IllegalArgumentException("A Java stack frame must have a non-null program counter");
        }
        this._javaVM = javaVM;
        this._basePointer = basePointer;
        this._pc = pc;
        this._lineNumber = lineNumber;
    }

    public JavaStackFrame(JavaRuntime javaVM, ImagePointer basePointer, JavaMethod method, ImagePointer pc, int lineNumber) {
        this(javaVM, basePointer, pc, lineNumber);
        if (null == method) {
            throw new IllegalArgumentException("A Java stack frame must refer to a non-null method");
        }
        this._method = method;
    }

    public JavaStackFrame(JavaRuntime javaVM, ImagePointer basePointer, ImagePointer methodID, ImagePointer pc, int lineNumber) {
        this(javaVM, basePointer, pc, lineNumber);
        this._methodID = methodID;
    }

    public ImagePointer getBasePointer() throws CorruptDataException {
        return this._basePointer;
    }

    public JavaLocation getLocation() throws CorruptDataException {
        if (this._method != null) {
            return new com.ibm.dtfj.java.j9.JavaLocation(this._method, this._pc, this._lineNumber);
        }
        return new com.ibm.dtfj.java.j9.JavaLocation(this._methodID, this._pc, this._lineNumber);
    }

    public void createObjectRef(long id) {
        JavaReference jRef = new JavaReference(this._javaVM, (Object)this, id, "StackFrame Root", 0, 4, 1);
        this._stackRoots.add(jRef);
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaStackFrame) {
            JavaStackFrame local = (JavaStackFrame)obj;
            isEqual = JavaStackFrame.equals(this._method, local._method) && JavaStackFrame.equals(this._pc, local._pc);
        }
        return isEqual;
    }

    private static int hashCode(Object o1) {
        return o1 == null ? 0 : o1.hashCode();
    }

    public int hashCode() {
        return JavaStackFrame.hashCode(this._method) ^ this._pc.hashCode() ^ JavaStackFrame.hashCode(this._methodID);
    }

    public Iterator getHeapRoots() {
        return this._stackRoots.iterator();
    }
}

