/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.j9.JavaClass;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;

public class JavaInstanceField
extends JavaField {
    private int _offset;

    public JavaInstanceField(JavaRuntime vm, String name, String signature, int modifiers, int offset, long classID) {
        super(vm, name, signature, modifiers, classID);
        if (null == vm) {
            throw new IllegalArgumentException("Java VM for an instance field cannot be null");
        }
        this._offset = offset;
    }

    private void checkDeclaringClass(com.ibm.dtfj.java.JavaObject object) throws CorruptDataException {
        JavaClass declaringClass = (JavaClass)this.getDeclaringClass();
        if (!declaringClass.isAncestorOf(object.getJavaClass())) {
            throw new IllegalArgumentException("The class for the JavaObject specified as a parameter does not match with the declaring class of this JavaField.");
        }
    }

    public Object getReferenceType(com.ibm.dtfj.java.JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(object)) {
            this.checkDeclaringClass(object);
            String sigPrefix = this.getSignature();
            if (sigPrefix.startsWith("L") || sigPrefix.startsWith("[")) {
                ImagePointer value = ((JavaObject)object).getFObjectAtOffset(this._offset);
                if (0L == value.getAddress()) {
                    return null;
                }
                try {
                    return this._javaVM.getObjectAtAddress(value);
                }
                catch (IllegalArgumentException e) {
                    throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData(e.getMessage(), value));
                }
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public boolean getBoolean(com.ibm.dtfj.java.JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(object)) {
            this.checkDeclaringClass(object);
            if (this.getSignature().equals("Z")) {
                return 0 != object.getID().getIntAt((long)this._offset);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public byte getByte(com.ibm.dtfj.java.JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(object)) {
            this.checkDeclaringClass(object);
            if (this.getSignature().equals("B")) {
                return (byte)object.getID().getIntAt((long)this._offset);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public char getChar(com.ibm.dtfj.java.JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(object)) {
            this.checkDeclaringClass(object);
            if (this.getSignature().equals("C")) {
                return (char)object.getID().getIntAt((long)this._offset);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public double getDouble(com.ibm.dtfj.java.JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(object)) {
            this.checkDeclaringClass(object);
            if (this.getSignature().equals("D")) {
                return object.getID().getDoubleAt((long)this._offset);
            }
            return super.getDouble(object);
        }
        throw new NullPointerException();
    }

    public float getFloat(com.ibm.dtfj.java.JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(object)) {
            this.checkDeclaringClass(object);
            if (this.getSignature().equals("F")) {
                return object.getID().getFloatAt((long)this._offset);
            }
            return super.getFloat(object);
        }
        throw new NullPointerException();
    }

    public int getInt(com.ibm.dtfj.java.JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(object)) {
            this.checkDeclaringClass(object);
            if (this.getSignature().equals("I")) {
                return object.getID().getIntAt((long)this._offset);
            }
            return super.getInt(object);
        }
        throw new NullPointerException();
    }

    public long getLong(com.ibm.dtfj.java.JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(object)) {
            this.checkDeclaringClass(object);
            if (this.getSignature().equals("J")) {
                return object.getID().getLongAt((long)this._offset);
            }
            return super.getLong(object);
        }
        throw new NullPointerException();
    }

    public short getShort(com.ibm.dtfj.java.JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(object)) {
            this.checkDeclaringClass(object);
            if (this.getSignature().equals("S")) {
                return (short)object.getID().getIntAt((long)this._offset);
            }
            return super.getShort(object);
        }
        throw new NullPointerException();
    }

    private boolean _isSafeToAccess(com.ibm.dtfj.java.JavaObject object) {
        return null != object && 0L != object.getID().getAddress();
    }
}

