/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.j9.JavaHeapRegion;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class JavaHeap
implements com.ibm.dtfj.java.JavaHeap {
    private JavaRuntime _javaVM;
    private String _name;
    private ImagePointer _id;
    private long _size;
    private HeapSubRegionSection[] _allSortedRegionSections;
    private List _heapRegions;
    private int _arrayletIdOffset;
    private int _arrayletIdWidth;
    private long _arrayletIdMask;
    private long _arrayletIdResult;
    private int _fobjectSize;
    private int _fobjectPointerScale;
    private long _fobjectPointerDisplacement;
    private int _classOffset;
    private int _classSize;
    private long _classAlignment;
    private boolean _isSWH;
    private static RegionMatcher _matcher = new RegionMatcher();

    public JavaHeap(JavaRuntime vm, String name, ImagePointer id, ImagePointer start, long size, int arrayletIdOffset, int arrayletIdWidth, long arrayletIdMask, long arrayletIdResult, int fobjectSize, int fobjectPointerScale, long fobjectPointerDisplacement, int classOffset, int classSize, long classAlignment, boolean isSWH) {
        if (null == vm) {
            throw new IllegalArgumentException("Java VM for a heap cannot be null");
        }
        if (null == name) {
            throw new IllegalArgumentException("JavaHeap name cannot be null");
        }
        this._javaVM = vm;
        this._id = id;
        this._name = name;
        this._size = size;
        this._arrayletIdOffset = arrayletIdOffset;
        this._arrayletIdWidth = arrayletIdWidth;
        this._arrayletIdMask = arrayletIdMask;
        this._arrayletIdResult = arrayletIdResult;
        this._fobjectSize = fobjectSize;
        this._fobjectPointerScale = fobjectPointerScale;
        this._fobjectPointerDisplacement = fobjectPointerDisplacement;
        this._classOffset = classOffset;
        this._classSize = classSize;
        this._classAlignment = classAlignment;
        this._isSWH = isSWH;
    }

    public Iterator getSections() {
        return new MultiLevelSectionIterator(this._heapRegions);
    }

    public String getName() {
        return this._name + "@" + this._id;
    }

    public Iterator getObjects() {
        return new MultiLevelExtentWalker(this._heapRegions);
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (null != this._name && obj instanceof JavaHeap) {
            JavaHeap local = (JavaHeap)obj;
            isEqual = this._javaVM.equals(local._javaVM) && this._name.equals(local._name) && this._id.equals(local._id) && this._size == local._size;
        }
        return isEqual;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._name.hashCode() ^ this._id.hashCode() ^ (int)this._size;
    }

    public JavaHeapRegion regionForPointer(ImagePointer address) {
        JavaHeapRegion match = null;
        int foundIndex = Arrays.binarySearch(this._allSortedRegionSections, address, _matcher);
        if (foundIndex >= 0 && foundIndex < this._allSortedRegionSections.length) {
            match = this._allSortedRegionSections[foundIndex].getRegion();
        }
        return match;
    }

    public int getArrayletIdentificationWidth() {
        return this._arrayletIdWidth;
    }

    public int getArrayletIdentificationOffset() {
        return this._arrayletIdOffset;
    }

    public long getArrayletIdentificationBitmask() {
        return this._arrayletIdMask;
    }

    public long getArrayletIdentificationResult() {
        return this._arrayletIdResult;
    }

    public void setRegions(Vector regions) {
        this._heapRegions = regions;
        Iterator outer = regions.iterator();
        Vector<HeapSubRegionSection> heapSubRegionSections = new Vector<HeapSubRegionSection>();
        while (outer.hasNext()) {
            JavaHeapRegion region = (JavaHeapRegion)outer.next();
            Iterator sections = region.getSections();
            while (sections.hasNext()) {
                ImageSection section = (ImageSection)sections.next();
                heapSubRegionSections.add(new HeapSubRegionSection(region, section));
            }
        }
        this._allSortedRegionSections = heapSubRegionSections.toArray(new HeapSubRegionSection[heapSubRegionSections.size()]);
        Arrays.sort(this._allSortedRegionSections, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                HeapSubRegionSection one = (HeapSubRegionSection)arg0;
                HeapSubRegionSection two = (HeapSubRegionSection)arg1;
                long delta = one.base() - two.base();
                int result = 0;
                if (delta < 0L) {
                    result = -1;
                } else if (delta > 0L) {
                    result = 1;
                }
                return result;
            }
        });
    }

    public int getFObjectSize() {
        return this._fobjectSize;
    }

    public long tokenToPointer(long fobject) {
        return fobject * (long)this._fobjectPointerScale + this._fobjectPointerDisplacement;
    }

    public ImagePointer readClassPointerRelativeTo(ImagePointer pointer) throws MemoryAccessException, CorruptDataException {
        long classPointer;
        if (8 == this._classSize) {
            classPointer = pointer.getLongAt((long)this._classOffset);
        } else if (4 == this._classSize) {
            classPointer = 0xFFFFFFFFL & (long)pointer.getIntAt((long)this._classOffset);
        } else {
            throw new IllegalArgumentException("Heap has unexpected class pointer size: " + this._classSize);
        }
        return this._id.getAddressSpace().getPointer(classPointer);
    }

    public ImagePointer readFObjectAt(ImagePointer basePointer, long offset) throws MemoryAccessException, CorruptDataException {
        long pointer;
        if (8 == this._fobjectSize) {
            pointer = this.tokenToPointer(basePointer.getLongAt(offset));
        } else if (4 == this._fobjectSize) {
            pointer = this.tokenToPointer(0xFFFFFFFFL & (long)basePointer.getIntAt(offset));
        } else {
            throw new IllegalArgumentException("Heap has unexpected size reference fields: " + this._fobjectSize);
        }
        return this._id.getAddressSpace().getPointer(pointer);
    }

    public long getClassAlignment() {
        return this._classAlignment;
    }

    public boolean isSWH() {
        return this._isSWH;
    }

    private class HeapSubRegionSection {
        private JavaHeapRegion _region;
        private ImageSection _section;

        private HeapSubRegionSection(JavaHeapRegion region, ImageSection section) {
            this._region = region;
            this._section = section;
        }

        public ImageSection getSection() {
            return this._section;
        }

        public JavaHeapRegion getRegion() {
            return this._region;
        }

        private long base() {
            return this._section.getBaseAddress().getAddress();
        }
    }

    private class MultiLevelExtentWalker
    implements Iterator {
        private Iterator _outer;
        private Iterator _inner;

        public MultiLevelExtentWalker(List list) {
            this._outer = list.iterator();
        }

        public boolean hasNext() {
            this._refreshInner();
            return this._inner.hasNext();
        }

        public Object next() {
            this._refreshInner();
            return this._inner.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("The core-resident Java heap is immutable");
        }

        private void _refreshInner() {
            if (null == this._inner || !this._inner.hasNext()) {
                if (this._outer.hasNext()) {
                    do {
                        this._inner = ((JavaHeapRegion)this._outer.next()).getObjects();
                    } while (!this._inner.hasNext() && this._outer.hasNext());
                } else {
                    this._inner = this._outer;
                }
            }
        }
    }

    private class MultiLevelSectionIterator
    implements Iterator {
        private Iterator _outer;
        private Iterator _inner;

        public MultiLevelSectionIterator(List list) {
            this._outer = list.iterator();
        }

        public boolean hasNext() {
            this._refreshInner();
            return this._inner.hasNext();
        }

        public Object next() {
            this._refreshInner();
            return this._inner.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("The core-resident Java heap is immutable");
        }

        private void _refreshInner() {
            if (null == this._inner || !this._inner.hasNext()) {
                this._inner = this._outer.hasNext() ? ((JavaHeapRegion)this._outer.next()).getSections() : this._outer;
            }
        }
    }

    private static class RegionMatcher
    implements Comparator {
        private RegionMatcher() {
        }

        public int compare(Object arg0, Object arg1) {
            HeapSubRegionSection region = (HeapSubRegionSection)arg0;
            ImagePointer pointer = (ImagePointer)arg1;
            int result = -1;
            ImageSection section = region.getSection();
            long base = section.getBaseAddress().getAddress();
            long offset = pointer.getAddress() - base;
            result = offset < 0L ? 1 : (offset < section.getSize() ? 0 : -1);
            return result;
        }
    }
}

