/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JavaClassLoader
implements com.ibm.dtfj.java.JavaClassLoader {
    private JavaRuntime _javaVM;
    private ImagePointer _id;
    private ImagePointer _objectID;
    private List _classIDs = new ArrayList();
    private JavaObject _object = null;
    private List _defined = null;
    private List _cached = null;

    public JavaClassLoader(JavaRuntime runtime, ImagePointer id, ImagePointer obj) {
        if (null == runtime) {
            throw new IllegalArgumentException("Java VM for class loader must not be null");
        }
        if (null == id) {
            throw new IllegalArgumentException("Class loader id must not be null");
        }
        this._javaVM = runtime;
        this._id = id;
        this._objectID = obj;
    }

    public Iterator getDefinedClasses() {
        if (null == this._defined) {
            Iterator cached = this._javaVM.getClasses();
            long thisID = this._id.getAddress();
            this._defined = new ArrayList();
            while (cached.hasNext()) {
                Object next = cached.next();
                if (next instanceof CorruptData) continue;
                JavaClass currentClass = (JavaClass)next;
                try {
                    JavaClassLoader currentClassLoader = (JavaClassLoader)currentClass.getClassLoader();
                    if (currentClassLoader == null || currentClassLoader._id.getAddress() != thisID) continue;
                    this._defined.add(currentClass);
                }
                catch (CorruptDataException e) {}
            }
        }
        return this._defined.iterator();
    }

    public Iterator getCachedClasses() {
        if (null == this._cached) {
            Iterator ids = this._classIDs.iterator();
            this._cached = new ArrayList();
            while (ids.hasNext()) {
                long oneID = (Long)ids.next();
                JavaClass oneClass = this._javaVM.getClassForID(oneID);
                if (null == oneClass) {
                    this._cached.add(new CorruptData("Cache reference to unknown class " + oneID, null));
                    continue;
                }
                this._cached.add(oneClass);
            }
        }
        return this._cached.iterator();
    }

    public JavaClass findClass(String name) throws CorruptDataException {
        Iterator classes = this.getDefinedClasses();
        JavaClass found = null;
        while (classes.hasNext() && null == found) {
            JavaClass one = (JavaClass)classes.next();
            if (!one.getName().equals(name)) continue;
            found = one;
        }
        return found;
    }

    public JavaObject getObject() throws CorruptDataException {
        if (null == this._object) {
            try {
                this._object = this._javaVM.getObjectAtAddress(this._objectID);
            }
            catch (IllegalArgumentException e) {
                throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData(e.getMessage(), this._objectID));
            }
        }
        return this._object;
    }

    public long getID() {
        return this._id.getAddress();
    }

    public void addClassID(long id) {
        this._classIDs.add(new Long(id));
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaClassLoader) {
            JavaClassLoader local = (JavaClassLoader)obj;
            isEqual = this._javaVM.equals(local._javaVM) && this._id.equals(local._id);
        }
        return isEqual;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._id.hashCode();
    }
}

