/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class Aix32Dump
extends NewAixDump {
    private static final int CONTEXT_OFFSET_IN_THREAD = 200;
    private static final int IAR_OFFSET_IN_CONTEXT = 24;
    private static final int GPR_OFFSET_IN_CONTEXT = 208;
    private static final int GPR_COUNT = 32;

    protected Aix32Dump(DumpReader reader) throws IOException {
        super(reader);
        this.readCore();
    }

    protected int readLoaderInfoFlags() throws IOException {
        return 0;
    }

    protected long userInfoOffset() {
        return 1008L;
    }

    protected int pointerSize() {
        return 32;
    }

    protected Map readRegisters(long threadOffset) throws IOException {
        TreeMap<String, Integer> registers = new TreeMap<String, Integer>();
        this.coreSeek(threadOffset + 200L + 24L);
        registers.put("iar", new Integer(this.coreReadInt()));
        registers.put("msr", new Integer(this.coreReadInt()));
        registers.put("cr", new Integer(this.coreReadInt()));
        registers.put("lr", new Integer(this.coreReadInt()));
        registers.put("ctr", new Integer(this.coreReadInt()));
        registers.put("xer", new Integer(this.coreReadInt()));
        registers.put("mq", new Integer(this.coreReadInt()));
        registers.put("tid", new Integer(this.coreReadInt()));
        registers.put("fpscr", new Integer(this.coreReadInt()));
        this.coreSeek(threadOffset + 200L + 208L);
        for (int i = 0; i < 32; ++i) {
            registers.put("gpr" + i, new Integer(this.coreReadInt()));
        }
        return registers;
    }

    protected long threadSize(long threadOffset) {
        return 792L;
    }

    protected long getStackPointerFrom(Map registers) {
        return (long)((Integer)registers.get("gpr1")).intValue() & 0xFFFFFFFFL;
    }

    protected long getInstructionPointerFrom(Map registers) {
        return (long)((Integer)registers.get("iar")).intValue() & 0xFFFFFFFFL;
    }

    protected long getLinkRegisterFrom(Map registers) {
        return (long)((Integer)registers.get("lr")).intValue() & 0xFFFFFFFFL;
    }

    protected int sizeofTopOfStack() {
        return 144;
    }
}

