/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.addressspace;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public abstract class CommonAddressSpace
implements IAbstractAddressSpace {
    private static final int BUFFER_MAX = 4096;
    private static final int MEMORY_CHECK_THRESHOLD = 0x100000;
    private MemoryRange[] _translations;
    private Integer _lastTranslationUsed = new Integer(0);
    private boolean _isLittleEndian;
    private boolean _is64Bit;
    private int lastAsid;
    private int[] _is64BitAsid;

    protected CommonAddressSpace(MemoryRange[] translations, boolean isLittleEndian, boolean is64Bit) {
        this._translations = CommonAddressSpace._sortRanges(translations);
        this._isLittleEndian = isLittleEndian;
        this._is64Bit = is64Bit;
        this.set64Bitness();
    }

    private static MemoryRange[] _sortRanges(MemoryRange[] ranges) {
        Arrays.sort(ranges, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                MemoryRange one = (MemoryRange)arg0;
                MemoryRange two = (MemoryRange)arg1;
                return CommonAddressSpace.compareAddress(one.getAsid(), one.getVirtualAddress(), two.getAsid(), two.getVirtualAddress());
            }
        });
        return ranges;
    }

    private void set64Bitness() {
        if (!this._is64Bit) {
            return;
        }
        int count = 0;
        for (int i = 0; i < this._translations.length; ++i) {
            if (this._translations[i].getVirtualAddress() + this._translations[i].getSize() < 0x100000000L) continue;
            int asid = this._translations[i].getAsid();
            int[] newa = new int[count + 1];
            for (int j = 0; j < count; ++j) {
                newa[j] = this._is64BitAsid[j];
            }
            newa[count] = asid;
            this._is64BitAsid = newa;
            ++count;
            while (i < this._translations.length && this._translations[i].getAsid() == asid) {
                ++i;
            }
        }
    }

    public Iterator getMemoryRanges() {
        return Arrays.asList(this._translations).iterator();
    }

    protected MemoryRange _residentRange(int asid, long address) throws MemoryAccessException {
        int range = CommonAddressSpace.findWhichMemoryRange(asid, address, this._translations, this._lastTranslationUsed, true);
        if (range >= 0) {
            return this._translations[range];
        }
        throw new MemoryAccessException(asid, address);
    }

    protected static int findWhichMemoryRange(int asid, long addr, MemoryRange[] ranges, Integer lastRange, boolean doLinearIfNotFound) {
        int retI = -1;
        int last = lastRange;
        int lastPlusOne = last + 1;
        if (last < ranges.length && ranges[last].contains(asid, addr) && (ranges[last].isInCoreFile() || !ranges[last].isInCoreFile() && ranges[last].getLibraryReader() != null)) {
            retI = last;
        } else if (lastPlusOne < ranges.length && ranges[lastPlusOne].contains(asid, addr) && (ranges[last].isInCoreFile() || !ranges[last].isInCoreFile() && ranges[last].getLibraryReader() != null)) {
            retI = lastPlusOne;
        } else {
            int mraAsid;
            long mraStartAddr;
            int highpos = ranges.length - 1;
            int lowpos = 0;
            while (lowpos <= highpos) {
                int currentPos = lowpos + (highpos - lowpos >>> 1);
                mraStartAddr = ranges[currentPos].getVirtualAddress();
                mraAsid = ranges[currentPos].getAsid();
                if (CommonAddressSpace.compareAddress(asid, addr, mraAsid, mraStartAddr) >= 0) {
                    if (CommonAddressSpace.compareAddress(asid, addr, mraAsid, mraStartAddr + ranges[currentPos].getSize()) < 0 && (ranges[currentPos].isInCoreFile() || !ranges[currentPos].isInCoreFile() && ranges[currentPos].getLibraryReader() != null)) {
                        retI = currentPos;
                        break;
                    }
                    lowpos = currentPos + 1;
                    continue;
                }
                highpos = currentPos - 1;
            }
            if (-1 == retI && doLinearIfNotFound) {
                for (int i = 0; i < lowpos; ++i) {
                    mraStartAddr = ranges[i].getVirtualAddress();
                    mraAsid = ranges[i].getAsid();
                    if (CommonAddressSpace.compareAddress(asid, addr, mraAsid, mraStartAddr) < 0 || CommonAddressSpace.compareAddress(asid, addr, mraAsid, mraStartAddr + ranges[i].getSize()) >= 0 || !ranges[i].isInCoreFile() && (ranges[i].isInCoreFile() || ranges[i].getLibraryReader() == null)) continue;
                    retI = i;
                    break;
                }
            }
        }
        if (-1 != retI) {
            lastRange = new Integer(retI);
        }
        return retI;
    }

    protected static int compareAddress(int lasid, long lhs, int rasid, long rhs) {
        if (lasid < rasid) {
            return -1;
        }
        if (lasid > rasid) {
            return 1;
        }
        if (lhs == rhs) {
            return 0;
        }
        if (lhs >= 0L && rhs >= 0L || lhs < 0L && rhs < 0L) {
            return lhs < rhs ? -1 : 1;
        }
        return lhs < rhs ? 1 : -1;
    }

    private boolean isMemoryAccessible(int asid, long address, int size) {
        long memhi;
        boolean rc = false;
        long cumulativeSize = 0L;
        int startRange = CommonAddressSpace.findWhichMemoryRange(asid, address, this._translations, this._lastTranslationUsed, true);
        if (startRange == -1) {
            return rc;
        }
        long hi = this._translations[startRange].getVirtualAddress() + this._translations[startRange].getSize();
        if (hi >= (memhi = address + (long)size)) {
            rc = true;
        } else {
            cumulativeSize = hi - address;
            for (int i = startRange + 1; i < this._translations.length; ++i) {
                long rangeBaseAddress = this._translations[i].getVirtualAddress();
                long rangeSize = this._translations[i].getSize();
                long rangeTopAddress = rangeBaseAddress + rangeSize;
                if (rangeBaseAddress == hi) {
                    if ((cumulativeSize += rangeSize) >= (long)size) {
                        rc = true;
                        break;
                    }
                } else {
                    if (rangeBaseAddress >= hi) break;
                    if (rangeTopAddress < hi) continue;
                    if ((cumulativeSize += rangeTopAddress - hi) >= (long)size) {
                        rc = true;
                        break;
                    }
                }
                hi = rangeTopAddress;
            }
        }
        return rc;
    }

    public byte[] getMemoryBytes(long vaddr, int size) {
        return this.getMemoryBytes(this.lastAsid, vaddr, size);
    }

    public byte[] getMemoryBytes(int asid, long vaddr, int size) {
        boolean getMem = true;
        this.lastAsid = asid;
        byte[] buffer = null;
        if (size < 0) {
            return null;
        }
        if (0L != vaddr) {
            if (size > 0x100000) {
                getMem = this.isMemoryAccessible(0, vaddr, size);
            }
            if (getMem) {
                buffer = new byte[size];
                try {
                    this.getBytesAt(asid, vaddr, buffer);
                }
                catch (MemoryAccessException e) {
                    buffer = null;
                }
            }
        }
        return buffer;
    }

    public long findPattern(byte[] whatBytes, int alignment, long startFrom) {
        int bufferMax = 4096;
        int align = 0 == alignment ? 1 : alignment;
        if (bufferMax < align) {
            bufferMax = align;
        } else if (0 != bufferMax % align) {
            bufferMax -= bufferMax % align;
        }
        long location = -1L;
        Iterator ranges = this.getMemoryRanges();
        while (-1L == location && ranges.hasNext()) {
            MemoryRange range = (MemoryRange)ranges.next();
            if (range.getAsid() < this.lastAsid) continue;
            if (range.getAsid() > this.lastAsid) {
                startFrom = 0L;
            }
            location = this.findPatternInRange(whatBytes, align, startFrom, range, bufferMax);
        }
        if (location == -1L) {
            this.lastAsid = 0;
        }
        return location;
    }

    private static int match(byte[] whatBytes, int matchedSoFar, byte[] buffer, int index) {
        int matched = matchedSoFar;
        for (int i = index; i < buffer.length && matched < whatBytes.length; ++i, ++matched) {
            if (buffer[i] == whatBytes[matched]) continue;
            return 0;
        }
        return matched;
    }

    private long findPatternInRange(byte[] whatBytes, int alignment, long start, MemoryRange range, int bufferMax) {
        if (range.getVirtualAddress() >= start || range.contains(start)) {
            long addr = start;
            if (addr < range.getVirtualAddress()) {
                addr = range.getVirtualAddress();
            }
            if (0L != addr % (long)alignment) {
                addr += (long)alignment - addr % (long)alignment;
            }
            long edge = range.getVirtualAddress() + range.getSize();
            int asid = range.getAsid();
            int matched = 0;
            long matchAddr = -1L;
            while (addr < edge) {
                long count;
                long bytesLeftInRange = edge - addr;
                long l = count = (long)bufferMax < bytesLeftInRange ? (long)bufferMax : bytesLeftInRange;
                if (0L != addr) {
                    byte[] buffer = this.getMemoryBytes(asid, addr, (int)count);
                    if (null != buffer) {
                        if (0 != matched) {
                            matched = CommonAddressSpace.match(whatBytes, matched, buffer, 0);
                        }
                        for (int i = 0; i < buffer.length && 0 == matched; i += alignment) {
                            matchAddr = addr + (long)i;
                            matched = CommonAddressSpace.match(whatBytes, 0, buffer, i);
                        }
                        if (whatBytes.length == matched) {
                            return matchAddr;
                        }
                    }
                } else {
                    System.err.println("Looking for address 0");
                }
                addr += count;
            }
        }
        return -1L;
    }

    public long getLongAt(int asid, long address) throws MemoryAccessException {
        byte[] buffer = new byte[8];
        this.getBytesAt(asid, address, buffer);
        this._byteSwap(buffer);
        return 0xFF00000000000000L & (long)buffer[0] << 56 | 0xFF000000000000L & (long)buffer[1] << 48 | 0xFF0000000000L & (long)buffer[2] << 40 | 0xFF00000000L & (long)buffer[3] << 32 | 0xFF000000L & (long)buffer[4] << 24 | 0xFF0000L & (long)buffer[5] << 16 | 0xFF00L & (long)buffer[6] << 8 | 0xFFL & (long)buffer[7];
    }

    public int getIntAt(int asid, long address) throws MemoryAccessException {
        byte[] buffer = new byte[4];
        this.getBytesAt(asid, address, buffer);
        this._byteSwap(buffer);
        return (0xFF & buffer[0]) << 24 | (0xFF & buffer[1]) << 16 | (0xFF & buffer[2]) << 8 | 0xFF & buffer[3];
    }

    public short getShortAt(int asid, long address) throws MemoryAccessException {
        byte[] buffer = new byte[2];
        this.getBytesAt(asid, address, buffer);
        this._byteSwap(buffer);
        return (short)((0xFF & buffer[0]) << 8 | 0xFF & buffer[1]);
    }

    public byte getByteAt(int asid, long address) throws MemoryAccessException {
        byte[] buffer = new byte[1];
        this.getBytesAt(asid, address, buffer);
        return buffer[0];
    }

    private void _byteSwap(byte[] buffer) {
        if (this._isLittleEndian) {
            int halfLength = buffer.length / 2;
            for (int x = 0; x < halfLength; ++x) {
                byte temp = buffer[buffer.length - 1 - x];
                buffer[buffer.length - 1 - x] = buffer[x];
                buffer[x] = temp;
            }
        }
    }

    public long getPointerAt(int asid, long address) throws MemoryAccessException {
        long ptr = 0L;
        ptr = this.bytesPerPointer(asid) == 8 ? this.getLongAt(asid, address) : 0xFFFFFFFFL & (long)this.getIntAt(asid, address);
        return ptr;
    }

    public abstract int getBytesAt(int var1, long var2, byte[] var4) throws MemoryAccessException;

    public int bytesPerPointer(int asid) {
        if (!this._is64Bit || this._is64BitAsid == null) {
            return 4;
        }
        for (int i = 0; i < this._is64BitAsid.length; ++i) {
            if (this._is64BitAsid[i] != asid) continue;
            return 8;
        }
        return 4;
    }
}

