/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.rap.dialogs;

import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.ui.rap.Messages;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class RapResourceSelectionDialog
extends ElementTreeSelectionDialog {
    private boolean showDirectoriesOnly = false;

    public RapResourceSelectionDialog(Shell shell, List<String> filterExtensions, boolean showDirectoriesOnly) {
        super(shell, (ILabelProvider)new FileBrowseLabelProvider(), (ITreeContentProvider)new FileBrowseContentProvider(filterExtensions, showDirectoriesOnly));
        this.showDirectoriesOnly = showDirectoriesOnly;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.showDirectoriesOnly) {
            final Button button = new Button(parent, 8);
            button.setText(Messages.RapResourceSelectionDialog_NewFolderButtonLabel);
            GridData gd = new GridData();
            gd.horizontalIndent = 15;
            button.setLayoutData((Object)gd);
            final TreeViewer viewer = this.getTreeViewer();
            button.setEnabled(!viewer.getSelection().isEmpty());
            viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    button.setEnabled(!viewer.getSelection().isEmpty());
                }
            });
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputDialog dialog = new InputDialog(RapResourceSelectionDialog.this.getShell(), Messages.RapResourceSelectionDialog_NewFolderDialogTitle, Messages.RapResourceSelectionDialog_NewFolderDialogMessage, Messages.RapResourceSelectionDialog_NewFolderDialogInitialValue, new IInputValidator(){

                        public String isValid(String newText) {
                            File file;
                            String result = null;
                            if (!PlatformUtils.validateFileName((String)newText).isOK()) {
                                result = Messages.RapResourceSelectionDialog_NewFolderValidator_IllegalFileName;
                            }
                            if ((file = new File(RapResourceSelectionDialog.this.getSelectedFile(viewer), newText)).exists()) {
                                result = Messages.RapResourceSelectionDialog_NewFolderValidator_FileAlreadyExists;
                            }
                            return result;
                        }
                    });
                    if (dialog.open() == 0) {
                        String newFolderName = dialog.getValue();
                        File f = RapResourceSelectionDialog.this.getSelectedFile(viewer);
                        if (f != null) {
                            File newFolder = new File(f, newFolderName);
                            if (!newFolder.mkdirs()) {
                                MessageDialog.openError((Shell)RapResourceSelectionDialog.this.getShell(), (String)Messages.RapResourceSelectionDialog_NewFolder_ErrorDialogTitle, (String)NLS.bind((String)Messages.RapResourceSelectionDialog_NewFolder_ErrorDialogMessage, (Object)newFolderName));
                            } else {
                                viewer.refresh();
                                viewer.setSelection((ISelection)new StructuredSelection((Object)newFolder), true);
                            }
                        }
                    }
                }
            });
        }
        return composite;
    }

    private File getSelectedFile(TreeViewer viewer) {
        TreeSelection selection = (TreeSelection)viewer.getSelection();
        return RapResourceSelectionDialog.getFileObject(selection.getFirstElement());
    }

    private static File getFileObject(Object element) {
        if (!(element instanceof File)) {
            return null;
        }
        return (File)element;
    }

    private static class FileBrowseContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private final List<String> filterExtensions;
        private boolean showDirectoriesOnly = false;

        public FileBrowseContentProvider(List<String> filterExtensions, boolean showDirectoriesOnly) {
            this.filterExtensions = filterExtensions != null ? filterExtensions : Collections.emptyList();
            this.showDirectoriesOnly = showDirectoriesOnly;
        }

        public Object[] getChildren(Object parentElement) {
            return this.listChildren(RapResourceSelectionDialog.getFileObject(parentElement));
        }

        private File[] listChildren(File f) {
            File[] files = f.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (FileBrowseContentProvider.this.showDirectoriesOnly) {
                        return false;
                    }
                    return FileBrowseContentProvider.this.isAcceptableFile(file.getName());
                }
            });
            return files;
        }

        private boolean isAcceptableFile(String filename) {
            if (this.filterExtensions.isEmpty()) {
                return true;
            }
            for (String extension : this.filterExtensions) {
                if (!filename.matches(extension)) continue;
                return true;
            }
            return false;
        }

        public Object getParent(Object element) {
            File f = RapResourceSelectionDialog.getFileObject(element);
            if (f == null) {
                return null;
            }
            return f.getParentFile();
        }

        public boolean hasChildren(Object element) {
            File f = RapResourceSelectionDialog.getFileObject(element);
            if (f == null) {
                return false;
            }
            if (f.isFile()) {
                return false;
            }
            File[] children = this.listChildren(f);
            return children != null && children.length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof File[]) {
                return (File[])inputElement;
            }
            return this.getChildren(inputElement);
        }
    }

    private static class FileBrowseLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private FileBrowseLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            File f = RapResourceSelectionDialog.getFileObject(element);
            if (f == null) {
                return null;
            }
            return FileSystemView.getFileSystemView().getSystemDisplayName(f);
        }
    }
}

