/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.rap;

import com.ibm.cic.common.ui.rap.dialogs.RapResourceSelectionDialog;
import com.ibm.cic.common.ui.services.FileDialogService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.widgets.Shell;

public class RapFileDialogService
extends FileDialogService {
    public RapFileDialogService(Shell shell) {
        super(shell);
    }

    public String run() {
        String[] filterExtensions = this.getFilterExtensions();
        ArrayList<String> listExtensions = new ArrayList<String>();
        if (filterExtensions.length > 0) {
            String[] stringArray = filterExtensions;
            int n = filterExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String fExt = stringArray[n2];
                listExtensions.addAll(Arrays.asList(fExt.split(";")));
                ++n2;
            }
        }
        ArrayList<String> newListExtensions = new ArrayList<String>();
        for (String entry : listExtensions) {
            String newEntry = entry.replace(".", "\\.").replace("*", ".*");
            newListExtensions.add(newEntry);
        }
        RapResourceSelectionDialog dialog = new RapResourceSelectionDialog(this.getShell(), newListExtensions, false);
        dialog.setTitle(this.getTitle());
        dialog.setMessage(this.getMessage());
        dialog.setInput(File.listRoots());
        String initialValue = this.getFilterPath();
        if (initialValue != null && !initialValue.isEmpty()) {
            File f = new File(initialValue);
            if (!f.exists()) {
                initialValue = System.getProperty("user.home");
            }
        } else {
            initialValue = System.getProperty("user.home");
        }
        dialog.setInitialSelection(new File(initialValue));
        dialog.setAllowMultiple(false);
        int retCode = dialog.open();
        if (retCode == 0) {
            Object result = dialog.getFirstResult();
            try {
                return result != null ? ((File)result).getCanonicalPath() : "";
            }
            catch (IOException iOException) {
                return "";
            }
        }
        return initialValue;
    }
}

