/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common;

import com.ibm.cic.licensing.common.DefaultMessengerProviderImpl;
import com.ibm.cic.licensing.common.IMessengerProvider;
import com.ibm.cic.licensing.common.util.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class MessengerFactory {
    private static MessengerFactory instance = new MessengerFactory();
    private static IMessengerProvider[] messengerCandidates;
    private static boolean messengersLoaded;

    static {
        messengersLoaded = false;
    }

    private MessengerFactory() {
    }

    public static MessengerFactory getInstance() {
        return instance;
    }

    private static void loadMessengerCandidates() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cic.licensing.common.messengerProvider");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            messengerCandidates = new IMessengerProvider[extensions.length];
            int i = 0;
            while (i < extensions.length) {
                IExtension currentExtension = extensions[i];
                IConfigurationElement[] configElements = currentExtension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement config = configElements[j];
                    if (config.getName().equals("licenseMessenger")) {
                        try {
                            MessengerFactory.messengerCandidates[i] = (IMessengerProvider)config.createExecutableExtension("class");
                            break;
                        }
                        catch (CoreException e) {
                            Logger.logNtrace((String)"MessengerFactory.loadMessengerCandidates() encountered error", (Exception)((Object)e));
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        messengersLoaded = true;
    }

    public static synchronized IMessengerProvider getMessenger() {
        if (!messengersLoaded) {
            MessengerFactory.loadMessengerCandidates();
        }
        IMessengerProvider messenger = null;
        int i = 0;
        while (i < messengerCandidates.length) {
            messenger = messengerCandidates[i];
            if (messenger != null) {
                return messenger;
            }
            ++i;
        }
        return new DefaultMessengerProviderImpl();
    }
}

