/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.internal.ui.wizards.PrimaryWizard;
import com.ibm.cic.common.ui.internal.views.AbstractCicWizardView;
import com.ibm.cic.common.ui.wizards.SkippableWizardPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;

public abstract class WizardConstructionPage
extends SkippableWizardPage {
    private final PrimaryWizard primaryWizard;

    protected WizardConstructionPage(String pageName, String title, String description, ImageDescriptor titleImage, PrimaryWizard primaryWizard) {
        super(pageName, title, titleImage);
        this.setDescription(description);
        this.primaryWizard = primaryWizard;
    }

    protected abstract IWizard createConstructedWizard();

    public void dispose() {
        super.dispose();
        if (this.isConstructedWizardShown()) {
            this.primaryWizard.getConstructedWizard().dispose();
        }
    }

    public IWizardPage getNextPage() {
        SkippableWizardPage skippablePage;
        IWizardPage startingPage;
        if (this.primaryWizard.getConstructedWizard() == null) {
            this.doSetConstructedWizard(this.createConstructedWizard());
        }
        if ((startingPage = this.primaryWizard.getConstructedWizard().getStartingPage()) instanceof SkippableWizardPage && (skippablePage = (SkippableWizardPage)startingPage).shouldSkip()) {
            return skippablePage.getNextPage();
        }
        return startingPage;
    }

    public IWizard getConstructedWizard() {
        return this.primaryWizard.getConstructedWizard();
    }

    private boolean isConstructedWizardShown() {
        return this.primaryWizard.getConstructedWizard() != null && this.primaryWizard.getConstructedWizard().getStartingPage().getControl() != null;
    }

    public boolean isPageComplete() {
        if (this.isConstructedWizardShown()) {
            return this.primaryWizard.getConstructedWizard().canFinish();
        }
        return false;
    }

    public void setConstructedWizard(IWizard constructedWizard) {
        this.doSetConstructedWizard(constructedWizard);
        if (this.isCurrentPage()) {
            this.getContainer().updateButtons();
        }
    }

    private void doSetConstructedWizard(IWizard wizard) {
        if (this.primaryWizard.getConstructedWizard() != null) {
            this.primaryWizard.getConstructedWizard().dispose();
            IWizardContainer container = this.getContainer();
            if (container instanceof AbstractCicWizardView) {
                ((AbstractCicWizardView)container).removeCreatedWizard(this.primaryWizard.getConstructedWizard());
            }
        }
        this.primaryWizard.setConstructedWizard(wizard);
    }
}

