/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIRegressingUpdateWarningUtil;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryUpdateWizard;
import com.ibm.cic.agent.internal.ui.wizards.ProfileSelectionPage;
import com.ibm.cic.agent.internal.ui.wizards.ProfileSelectionSection;
import com.ibm.cic.agent.internal.ui.wizards.UpdateProfileSelectionPage;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.parts.IFormContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class UpdateProfileSelectionSection
extends ProfileSelectionSection {
    private Button updateAllButton;
    private boolean isUpdateAll = false;
    private UpdateProfileSelectionPage profileSelectionPange;
    private IStatus regressingUpdateWarningAndUnavailableFixes = null;

    public UpdateProfileSelectionSection(IFormContext context, Composite parent, ProfileSelectionPage wizardPage, Object[] input) {
        super(context, parent, wizardPage, new String[0], 256, input);
        if (wizardPage instanceof UpdateProfileSelectionPage) {
            this.profileSelectionPange = (UpdateProfileSelectionPage)wizardPage;
        }
    }

    @Override
    protected Control createFilterButtons(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1, 1, false, false));
        this.updateAllButton = new Button(comp, 0x800020);
        this.updateAllButton.setText(Messages.UpdateProfileSelectionPage_updateAllButton);
        this.updateAllButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.updateAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateProfileSelectionSection.this.handleUpdateAllPressed(e);
            }
        });
        return comp;
    }

    private void handleUpdateAllPressed(SelectionEvent e) {
        IRepositoryGroup repositoryGroup = AgentUI.getDefault().getAgent().getRepositoryGroup();
        ServiceRepositoryUtils.unloadServiceRepositories((IRepositoryGroup)repositoryGroup);
        if (this.updateAllButton.getSelection()) {
            this.getTreePart().getTreeViewer().getTree().setEnabled(false);
            TreeItem[] items = this.getTreePart().getTreeViewer().getTree().getItems();
            Object[] profiles = new Profile[items.length];
            int i = 0;
            while (i < items.length) {
                profiles[i] = (Profile)items[i].getData();
                ++i;
            }
            Object[] previousSelection = this.wizardPage.getSelections();
            if (previousSelection != null && previousSelection.length < profiles.length) {
                this.wizardPage.resetLocationCheckStatus();
            }
            this.wizardPage.setSelection(profiles);
            this.isUpdateAll = true;
            this.checkRegressingUpdateAndUnavailableFixesWarnings();
        } else {
            this.wizardPage.resetLocationCheckStatus();
            this.getTreePart().getTreeViewer().getTree().setEnabled(true);
            this.getTreePart().getTreeViewer().getTree().deselectAll();
            this.wizardPage.setSelection(new Profile[0]);
            this.isUpdateAll = false;
            this.profileSelectionPange.setMessageWithStatus(null);
        }
    }

    public boolean isUpdateAll() {
        return this.isUpdateAll;
    }

    @Override
    public void setFocus() {
        super.setFocus();
        if (this.isUpdateAll) {
            this.getTreePart().getTreeViewer().getTree().setEnabled(false);
            if (this.regressingUpdateWarningAndUnavailableFixes.matches(2)) {
                this.profileSelectionPange.setMessageWithStatus(this.regressingUpdateWarningAndUnavailableFixes);
            }
        } else {
            this.profileSelectionPange.clearMessageStatus(false);
        }
    }

    private void checkRegressingUpdateAndUnavailableFixesWarnings() {
        if (this.regressingUpdateWarningAndUnavailableFixes == null) {
            CicMultiStatus[] unavailableFixesStatus = new CicMultiStatus[]{Statuses.ST.createMultiStatus()};
            Map[] repLocationMsgMap = new Map[]{new HashMap()};
            this.profileSelectionPange.searchForUpdatesOrFixes(unavailableFixesStatus, repLocationMsgMap, true);
            PrimaryUpdateWizard primaryUpdateWizard = (PrimaryUpdateWizard)this.wizardPage.getWizard();
            List selectedJobs = primaryUpdateWizard.getSelectedJobs();
            IStatus regressingUpdateWarning = AgentUIRegressingUpdateWarningUtil.checkRegressingUpdateWarningForMultiProfilesJobs(AgentJob.toArray((Collection)selectedJobs));
            if (unavailableFixesStatus[0].matches(2)) {
                if (regressingUpdateWarning.matches(2)) {
                    IStatus child;
                    CicMultiStatus regressionUpdateAndFixesNotAvailableWarnings = Statuses.ST.createMultiStatus();
                    regressionUpdateAndFixesNotAvailableWarnings.setMessage(com.ibm.cic.agent.internal.core.Messages.RegressionUpdateAndFixesNotAvailableWarnings);
                    IStatus[] iStatusArray = regressingUpdateWarning.getChildren();
                    int n = iStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        child = iStatusArray[n2];
                        regressionUpdateAndFixesNotAvailableWarnings.add(child);
                        ++n2;
                    }
                    iStatusArray = unavailableFixesStatus[0].getChildren();
                    n = iStatusArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        child = iStatusArray[n2];
                        regressionUpdateAndFixesNotAvailableWarnings.add(child);
                        ++n2;
                    }
                    this.regressingUpdateWarningAndUnavailableFixes = regressionUpdateAndFixesNotAvailableWarnings;
                } else {
                    this.regressingUpdateWarningAndUnavailableFixes = unavailableFixesStatus[0];
                }
            } else {
                this.regressingUpdateWarningAndUnavailableFixes = regressingUpdateWarning;
            }
        }
        if (this.regressingUpdateWarningAndUnavailableFixes.matches(2)) {
            this.profileSelectionPange.setMessageWithStatus(this.regressingUpdateWarningAndUnavailableFixes);
        }
    }
}

