/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.LocationCheckManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SpaceInfoUtils;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.sharedUI.SharedUIDependenciesCheckUtils;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.AvailableUpdatePage;
import com.ibm.cic.agent.internal.ui.wizards.AvailableUpdatePageWrapper;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryUpdateWizard;
import com.ibm.cic.agent.internal.ui.wizards.ProfileSelectionPage;
import com.ibm.cic.agent.internal.ui.wizards.UpdateProfileSelectionSection;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.repository.UnavailableUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class UpdateProfileSelectionPage
extends ProfileSelectionPage {
    static final CustomMessageWizardPage.WarningId LOCATION_CHECK_WARNING = new CustomMessageWizardPage.WarningId();
    static final CustomMessageWizardPage.ErrorId LOCATION_CHECK_ERROR = new CustomMessageWizardPage.ErrorId();
    private UpdateProfileSelectionSection updateProfileSection;
    private Object[] currentSelections;
    private boolean selectionChanged;
    private List currentProfiles;
    private final PrimaryUpdateWizard primaryUpdateWizard;
    private IStatus serviceReposStatus = Status.OK_STATUS;
    CicMultiStatus[] checkAdminStatus = new CicMultiStatus[]{Statuses.ST.createMultiStatus()};

    private IStatus getServiceReposStatus() {
        return this.serviceReposStatus;
    }

    private void setServiceReposStatus(IStatus serviceReposStatus) {
        this.serviceReposStatus = serviceReposStatus;
    }

    public UpdateProfileSelectionPage(String title, String description, PrimaryUpdateWizard primaryUpdateWizard) {
        super(title, description, primaryUpdateWizard);
        this.primaryUpdateWizard = primaryUpdateWizard;
        super.setHelpRef("com.ibm.cic.agent.ui.UpdateProfileSelectionPage");
    }

    @Override
    protected AgentUIWizard createInnerWizard() {
        return null;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.updateProfileSection = new UpdateProfileSelectionSection(context, parent, this, this.input);
        return this.updateProfileSection;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.updateProfileSection.setFocus();
        }
        super.setVisible(visible);
    }

    @Override
    protected CustomMessageWizardPage.ErrorId getLocationCheckError() {
        return LOCATION_CHECK_ERROR;
    }

    @Override
    protected CustomMessageWizardPage.WarningId getLocationCheckWarning() {
        return LOCATION_CHECK_WARNING;
    }

    @Override
    public IWizardPage getNextPage() {
        try {
            Status[] result = new Status[1];
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress((IStatus[])result){
                private final /* synthetic */ IStatus[] val$result;
                {
                    this.val$result = iStatusArray;
                }

                public void run(IProgressMonitor monitor) {
                    this.val$result[0] = UpdateProfileSelectionPage.this.prepareInstalledOfferingsInSelectedProfile(monitor);
                }
            });
            if (StatusUtil.isErrorOrCancel((IStatus)result[0])) {
                return this;
            }
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
            return this;
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
            return this;
        }
        IWizardPage nextStartingPage = this.primaryUpdateWizard.getNextPage((IWizardPage)this);
        if (this.updateProfileSection != null && this.updateProfileSection.isUpdateAll()) {
            IWizardPage firstPage;
            this.setUpdateAll(nextStartingPage, true);
            this.setSelectionChanged(nextStartingPage, this.selectionChanged);
            if (!this.performLocationChecks()) {
                return this;
            }
            Map[] repLocationMsgMap = new Map[]{new HashMap()};
            if (this.selectionChanged) {
                this.primaryUpdateWizard.getJobs().clear();
                this.searchForUpdatesOrFixes(this.checkAdminStatus, repLocationMsgMap);
            }
            List selectedJobs = this.primaryUpdateWizard.getSelectedJobs();
            AgentJob[] selectedJobsArray = AgentJob.toArray((Collection)selectedJobs);
            boolean noUpdates = selectedJobs.isEmpty();
            if (noUpdates && this.checkAdminStatus[0].isOK()) {
                this.selectionChanged = false;
                if (nextStartingPage instanceof AvailableUpdatePage) {
                    ((AvailableUpdatePage)nextStartingPage).setServiceReposStatus(this.getServiceReposStatus());
                }
                return nextStartingPage;
            }
            AgentUIUtils.reportRepositoryConnectionMsg(this.getShell(), this.serviceReposStatus, repLocationMsgMap[0]);
            try {
                Status[] status = new Status[1];
                if (noUpdates && !this.checkAdminStatus[0].isOK()) {
                    status[0] = Statuses.ST.createMultiStatus(4, this.checkAdminStatus[0].getChildren(), com.ibm.cic.agent.core.sharedUI.Messages.NoValidRecommendedUpdates, new Object[0]);
                } else {
                    CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress((IStatus[])status, selectedJobs, selectedJobsArray){
                        private final /* synthetic */ IStatus[] val$status;
                        private final /* synthetic */ List val$selectedJobs;
                        private final /* synthetic */ AgentJob[] val$selectedJobsArray;
                        {
                            this.val$status = iStatusArray;
                            this.val$selectedJobs = list;
                            this.val$selectedJobsArray = agentJobArray;
                        }

                        public void run(IProgressMonitor monitor) {
                            CicMultiStatus allStatus = Statuses.ST.createMultiStatus();
                            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{2, 1, 1, 1, 1});
                            this.val$status[0] = SharedUIUtils.prepareAndResolveSelectedJobs((List)this.val$selectedJobs, (IProgressMonitor)pm.next());
                            allStatus.add(this.val$status[0]);
                            if (!StatusUtil.isErrorOrCancel((IStatus)this.val$status[0])) {
                                this.val$status[0] = AgentUIUtils.runPrecheckBundles(this.val$selectedJobs, false);
                                allStatus.add(this.val$status[0]);
                            }
                            if (!StatusUtil.isErrorOrCancel((IStatus)this.val$status[0])) {
                                this.val$status[0] = SharedUIUtils.getAgentToleranceStatus((List)this.val$selectedJobs);
                                allStatus.add(this.val$status[0]);
                            }
                            if (!StatusUtil.isErrorOrCancel((IStatus)this.val$status[0])) {
                                this.val$status[0] = AgentUtil.getOfferingsApplicability((List)this.val$selectedJobs, (AgentJob[])this.val$selectedJobsArray);
                                allStatus.add(this.val$status[0]);
                            }
                            if (!StatusUtil.isErrorOrCancel((IStatus)this.val$status[0])) {
                                this.val$status[0] = AgentUI.getDefault().getAgent().checkInstall(this.val$selectedJobsArray, pm.next());
                                allStatus.add(this.val$status[0]);
                            }
                            if (!StatusUtil.isErrorOrCancel((IStatus)this.val$status[0])) {
                                this.val$status[0] = SharedUIDependenciesCheckUtils.checkDependenciesMultiFinalProfilesPrepareUnprepare((AgentJob[])this.val$selectedJobsArray, (IProgressMonitor)pm.next());
                                allStatus.add(this.val$status[0]);
                            }
                            if (!StatusUtil.isErrorOrCancel((IStatus)this.val$status[0])) {
                                int i = 0;
                                while (i < this.val$selectedJobs.size()) {
                                    AbstractJob job = (AbstractJob)this.val$selectedJobs.get(i);
                                    if (job instanceof UpdateOfferingJob) {
                                        IFeature[] defaultSelectedFeatures = Agent.getInstance().getDefaultFeatures((UpdateOfferingJob)job);
                                        job.setFeatures(Arrays.asList(defaultSelectedFeatures));
                                    }
                                    ++i;
                                }
                                List eclipseSizeList = SpaceInfoUtils.getEclipseCacheLocationSizeListMap((List)this.val$selectedJobs, (IProgressMonitor)pm.next());
                                Map locationMap = SpaceInfoUtils.getInstallLocationDriveSizeListMap((List)this.val$selectedJobs, (IProgressMonitor)pm.next());
                                this.val$status[0] = SpaceInfoUtils.verifySpaceInfo((List)eclipseSizeList, (Map)locationMap, new HashMap(), (String)com.ibm.cic.agent.core.sharedUI.Messages.FeatureSelectionPage_invalidAvailableDiskSpace);
                                allStatus.add(this.val$status[0]);
                            }
                            if (!StatusUtil.isErrorOrCancel((IStatus)this.val$status[0])) {
                                this.val$status[0] = StatusUtil.toSingleStatus((IStatus)allStatus);
                            }
                            pm.done();
                        }
                    });
                }
                if (StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                    WrapDetailUIDErrorDialog dlg = new WrapDetailUIDErrorDialog(this.getShell(), com.ibm.cic.agent.core.sharedUI.Messages.UpdateValidationErrorDlg_title, com.ibm.cic.agent.core.sharedUI.Messages.UpdateValidationErrorDlg_msg, (IStatus)status[0], 15);
                    dlg.open();
                    if (!this.selectedJobsTolerateAgent()) {
                        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                UpdateProfileSelectionPage.this.primaryUpdateWizard.checkForAgentUpdate();
                            }
                        });
                    }
                    this.selectionChanged = false;
                    return this;
                }
                if (StatusUtil.isWarning((IStatus)status[0])) {
                    WrapDetailUIDErrorDialog dlg = new WrapDetailUIDErrorDialog(this.getShell(), com.ibm.cic.agent.core.sharedUI.Messages.UpdateValidationWarningDlg_title, com.ibm.cic.agent.core.sharedUI.Messages.UpdateValidationWarningDlg_msg, (IStatus)status[0], 2);
                    dlg.open();
                }
            }
            catch (InvocationTargetException e) {
                AgentUI.reportException(e);
            }
            catch (InterruptedException e) {
                AgentUI.reportException(e);
            }
            if ((firstPage = nextStartingPage) != null && firstPage instanceof AvailableUpdatePage) {
                AvailableUpdatePage updatePage = (AvailableUpdatePage)firstPage;
                updatePage.setShouldSkip(true);
                if (this.selectionChanged) {
                    Object[] selectedJobArray = selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
                    updatePage.setSelection(selectedJobArray);
                    updatePage.setCurrentProfileList(Arrays.asList(this.primaryUpdateWizard.getSelectedProfiles()));
                }
                IWizardPage nextPage = ((AvailableUpdatePage)firstPage).getNextPage();
                this.selectionChanged = false;
                this.setMessageWithStatus(null);
                return nextPage;
            }
        } else {
            this.setUpdateAll(nextStartingPage, false);
            this.setSelectionChanged(nextStartingPage, this.selectionChanged);
            if (nextStartingPage instanceof AvailableUpdatePage) {
                ((AvailableUpdatePage)nextStartingPage).setShouldSkip(false);
            }
            if (!this.performLocationChecks()) {
                return this;
            }
        }
        this.selectionChanged = false;
        return nextStartingPage;
    }

    private boolean performLocationChecks() {
        CicMultiStatus status = this.performLocationPermissionCheck();
        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
            try {
                status = this.performOfferingLocationCheck();
            }
            catch (InvocationTargetException ite) {
                AgentUI.reportException(ite);
                return false;
            }
            catch (InterruptedException ie) {
                AgentUI.reportException(ie);
                return false;
            }
        }
        this.setLocationCheckStatus((IStatus)status);
        this.reportErrorOnPage((IStatus)status, LOCATION_CHECK_ERROR, LOCATION_CHECK_WARNING);
        return !StatusUtil.isErrorOrCancel((IStatus)status);
    }

    private IStatus performOfferingLocationCheck() throws InvocationTargetException, InterruptedException {
        Status[] result = new Status[1];
        Profile[] profileArray = this.primaryUpdateWizard.getSelectedProfiles();
        CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress((IStatus[])result, profileArray){
            private final /* synthetic */ IStatus[] val$result;
            private final /* synthetic */ Profile[] val$profileArray;
            {
                this.val$result = iStatusArray;
                this.val$profileArray = profileArray;
            }

            public void run(IProgressMonitor monitor) {
                this.val$result[0] = LocationCheckManager.getInstance().perform(this.val$profileArray, AgentJob.AgentJobType.UPDATE_JOB, monitor);
            }
        });
        return result[0];
    }

    private boolean selectedJobsTolerateAgent() {
        List selectedJobs = this.primaryUpdateWizard.getSelectedJobs();
        for (AbstractJob job : selectedJobs) {
            IStatus status;
            IOfferingOrFix oof = job.getOfferingOrFix();
            if (oof == null || (status = AgentUI.getDefault().getAgent().checkAgentRequirement(oof, false)).isOK()) continue;
            return false;
        }
        return true;
    }

    private void setUpdateAll(IWizardPage page, boolean updateAll) {
        if (page instanceof AvailableUpdatePageWrapper) {
            ((AvailableUpdatePageWrapper)page).setUpdateAll(updateAll);
        }
    }

    private void setSelectionChanged(IWizardPage page, boolean changed) {
        if (page instanceof AvailableUpdatePageWrapper) {
            ((AvailableUpdatePageWrapper)page).setSelectionChanged(changed);
        }
    }

    @Override
    protected void setSelection(Object[] selections) {
        this.currentSelections = this.getSelections();
        if (!Arrays.equals(selections, this.currentSelections)) {
            this.selectionChanged = true;
            this.checkAdminStatus[0] = Statuses.ST.createMultiStatus();
        } else {
            this.selectionChanged = false;
        }
        super.setSelection(selections);
        this.primaryUpdateWizard.setSelectedProfiles((Profile[])selections);
    }

    protected void searchForUpdatesOrFixes(CicMultiStatus[] adminStatus, Map[] repLocationMsgMap) {
        this.searchForUpdatesOrFixes(adminStatus, repLocationMsgMap, false);
    }

    protected void searchForUpdatesOrFixes(final CicMultiStatus[] adminStatus, final Map[] repLocationMsgMap, final boolean checkUnavailableFixes) {
        this.currentProfiles = Arrays.asList(this.primaryUpdateWizard.getSelectedProfiles());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                Agent agent = AgentUI.getDefault().getAgent();
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(3 * UpdateProfileSelectionPage.this.currentProfiles.size()));
                sm.setTaskName(Messages.AvailableUpdateSection_progressMsg);
                UpdateProfileSelectionPage.this.primaryUpdateWizard.getJobs().clear();
                IRepositoryGroup repositoryGroup = agent.getRepositoryGroup();
                for (Profile profile : UpdateProfileSelectionPage.this.currentProfiles) {
                    IOffering[] installedOfferings = agent.getInstalledOfferings(profile);
                    IStatus status = ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet((Map)repLocationMsgMap[0], (IRepositoryGroup)repositoryGroup, (IOffering[])installedOfferings, (IProgressMonitor)sm.newChild(1));
                    UpdateProfileSelectionPage.this.setServiceReposStatus(status);
                    CicMultiStatus recommendedUpdateOrFixStatus = Statuses.ST.createMultiStatus();
                    Map recommended = agent.getRecommendedUpdates(profile, recommendedUpdateOrFixStatus, (IProgressMonitor)sm.newChild(1));
                    CicMultiStatus unavailableFixesStatus = Statuses.ST.createMultiStatus();
                    SubMonitor sm2 = SubMonitor.convert((IProgressMonitor)sm.newChild(1), (int)(checkUnavailableFixes ? installedOfferings.length * 2 : installedOfferings.length));
                    IOffering[] iOfferingArray = installedOfferings;
                    int n = installedOfferings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IOffering installedOffering = iOfferingArray[n2];
                        IOffering recommendedUpdate = (IOffering)recommended.get(installedOffering.getIdentity());
                        if (recommendedUpdate != null) {
                            AbstractJob job = UpdateProfileSelectionPage.this.primaryUpdateWizard.createJob(installedOffering, profile, (IOfferingOrFix)recommendedUpdate);
                            job.setSelected(true);
                            UpdateProfileSelectionPage.this.primaryUpdateWizard.getJobs().add(job);
                        } else {
                            recommendedUpdate = installedOffering;
                        }
                        List fixes = agent.getRecommendedFixes(recommendedUpdate, recommendedUpdateOrFixStatus, (IProgressMonitor)sm2.newChild(1));
                        List<IFix> installedFixes = Arrays.asList(agent.getInstalledFixes(profile, recommendedUpdate));
                        fixes.removeAll(installedFixes);
                        for (IFix fix : fixes) {
                            if (!BitModeUtils.checkSupportedPlatformsAgainstProfile((IOfferingOrFix)fix, (IProfile)profile).isOK()) continue;
                            AbstractJob job = UpdateProfileSelectionPage.this.primaryUpdateWizard.createJob(recommendedUpdate, profile, (IOfferingOrFix)fix);
                            job.setSelected(true);
                            List selectedJobList = UpdateProfileSelectionPage.this.primaryUpdateWizard.getJobs();
                            if (UpdateProfileSelectionPage.this.fixJobIsInJobList(job, selectedJobList)) continue;
                            selectedJobList.add(job);
                        }
                        if (checkUnavailableFixes) {
                            List fixesToCheck = agent.findFixes(true, recommendedUpdate, (IProgressMonitor)sm2.newChild(1));
                            fixesToCheck.removeAll(installedFixes);
                            CicMultiStatus unavailableFixesForOffering = UpdateProfileSelectionPage.this.checkUnavailableFixes(profile, installedOffering, recommendedUpdate, fixesToCheck);
                            if (!unavailableFixesForOffering.isOK()) {
                                unavailableFixesStatus.add((IStatus)unavailableFixesForOffering);
                            }
                        }
                        ++n2;
                    }
                    if (checkUnavailableFixes) {
                        if (unavailableFixesStatus.isOK()) continue;
                        adminStatus[0].setMessage(com.ibm.cic.agent.internal.core.Messages.Update_FixesNotAvailableWarning);
                        adminStatus[0].addAll(Arrays.asList(unavailableFixesStatus.getChildren()));
                        continue;
                    }
                    if (recommendedUpdateOrFixStatus.isOK()) continue;
                    adminStatus[0].addAll(Arrays.asList(recommendedUpdateOrFixStatus.getChildren()));
                }
                sm.done();
            }
        };
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, runnable);
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    private boolean fixJobIsInJobList(AbstractJob fixJob, List selectedJobList) {
        int i = 0;
        while (i < selectedJobList.size()) {
            AbstractJob selectedJob = (AbstractJob)selectedJobList.get(i);
            if (fixJob.getType().equals((Object)selectedJob.getType()) && fixJob.getOfferingOrFix().equals(selectedJob.getOfferingOrFix()) && fixJob.getProfile().equals(selectedJob.getProfile())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private CicMultiStatus checkUnavailableFixes(Profile profile, IOffering installedOffering, IOffering recommendedUpdate, List<IFix> fixes) {
        boolean showInternalVersion = AgentUI.getDefault().getAgentPreferenceStore().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key());
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        status.setMessage(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Update_FixesNotAvailableForOfferingWarning, (Object[])new Object[]{installedOffering.getName(), profile.getProfileId(), OfferingUtil.getOfferingOrFixVersion((IOfferingOrFix)recommendedUpdate, (boolean)showInternalVersion)}));
        for (IFix fix : fixes) {
            if (!UnavailableUtils.isUnavailable((IContent)fix)) continue;
            status.add((IStatus)Statuses.ST.createStatus(2, 0, null, com.ibm.cic.agent.internal.core.Messages.FixIsNotAvailableReason, new Object[]{fix.getName(), UnavailableUtils.getUnavailableReason((IContent)fix)}));
        }
        return status;
    }
}

