/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.LocationCheckManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryRollbackWizard;
import com.ibm.cic.agent.internal.ui.wizards.ProfileSelectionPage;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;

public class RollbackProfileSelectionPage
extends ProfileSelectionPage {
    static final CustomMessageWizardPage.WarningId LOCATION_CHECK_WARNING = new CustomMessageWizardPage.WarningId();
    static final CustomMessageWizardPage.ErrorId LOCATION_CHECK_ERROR = new CustomMessageWizardPage.ErrorId();
    private final PrimaryRollbackWizard primaryRollbackWizard;

    public RollbackProfileSelectionPage(String title, String description, PrimaryRollbackWizard wizard) {
        super(title, description, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.RollbackProfileSelectionPage");
        this.primaryRollbackWizard = wizard;
    }

    @Override
    protected AgentUIWizard createInnerWizard() {
        return null;
    }

    @Override
    protected CustomMessageWizardPage.ErrorId getLocationCheckError() {
        return LOCATION_CHECK_ERROR;
    }

    @Override
    protected CustomMessageWizardPage.WarningId getLocationCheckWarning() {
        return LOCATION_CHECK_WARNING;
    }

    @Override
    public IWizardPage getNextPage() {
        if (!this.performLocationChecks()) {
            return this;
        }
        return this.getWizard().getNextPage((IWizardPage)this);
    }

    private boolean performLocationChecks() {
        CicMultiStatus locationCheckStatus = this.performLocationPermissionCheck();
        if (!StatusUtil.isErrorOrCancel((IStatus)locationCheckStatus)) {
            IStatus[] offeringLocationCheckStatus;
            block5: {
                IStatus[] prepareStatus = new IStatus[]{Status.OK_STATUS};
                offeringLocationCheckStatus = new IStatus[]{Status.OK_STATUS};
                this.performOfferingLocationCheck(prepareStatus, offeringLocationCheckStatus);
                if (!StatusUtil.isErrorOrCancel((IStatus)prepareStatus[0])) break block5;
                AgentUI.reportStatus(prepareStatus[0], true);
                return false;
            }
            try {
                locationCheckStatus = offeringLocationCheckStatus[0];
            }
            catch (InvocationTargetException ite) {
                AgentUI.reportException(ite);
                return false;
            }
            catch (InterruptedException ie) {
                AgentUI.reportException(ie);
                return false;
            }
        }
        this.setLocationCheckStatus((IStatus)locationCheckStatus);
        this.reportErrorOnPage((IStatus)locationCheckStatus, LOCATION_CHECK_ERROR, LOCATION_CHECK_WARNING);
        return !StatusUtil.isErrorOrCancel((IStatus)locationCheckStatus);
    }

    private void performOfferingLocationCheck(final IStatus[] prepareStatus, final IStatus[] locationCheckStatus) throws InvocationTargetException, InterruptedException {
        final Profile[] profileArray = this.primaryRollbackWizard.getSelectedProfiles();
        CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                SplitProgressMonitor sm = new SplitProgressMonitor(monitor, 2);
                prepareStatus[0] = RollbackProfileSelectionPage.this.prepareInstalledOfferingsInSelectedProfile(sm.next());
                if (!StatusUtil.isErrorOrCancel((IStatus)prepareStatus[0])) {
                    locationCheckStatus[0] = LocationCheckManager.getInstance().perform(profileArray[0], AgentJob.AgentJobType.ROLLBACK_JOB, sm.next());
                }
            }
        });
    }

    @Override
    protected void setSelection(Object[] selections) {
        super.setSelection(selections);
        this.primaryRollbackWizard.setSelectedProfiles((Profile[])selections);
    }
}

