/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.ResponseFileFromInstall;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.InstalledOfferingTreeFixNode;
import com.ibm.cic.agent.internal.ui.utils.InstalledOfferingTreePackageNode;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenInstalledPkgPage;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenWizard;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.ui.CICImages;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;

public class ResponseFileGenInstalledPkgWizard
extends ResponseFileGenWizard {
    private List selectedPkgFixNodes;

    public ResponseFileGenInstalledPkgWizard() {
        super(CICImages.WIZ_UNINSTALL);
    }

    @Override
    protected void addContentPages() {
        this.addPage((IWizardPage)new ResponseFileGenInstalledPkgPage(this.toolkit, Messages.ResponseFileGenerator_InstalledPkgPage_Title, Messages.ResponseFileGenerator_InstalledPkgPage_Des, this));
    }

    @Override
    protected void doGen(String outputFile) throws CoreException {
        ResponseFileFromInstall responseFileGen = new ResponseFileFromInstall();
        int i = 0;
        while (i < this.selectedPkgFixNodes.size()) {
            Object item = this.selectedPkgFixNodes.get(i);
            if (item instanceof InstalledOfferingTreePackageNode) {
                InstalledOfferingTreePackageNode pkgNode = (InstalledOfferingTreePackageNode)item;
                Profile profile = pkgNode.getProfileNode().getProfile();
                IOffering offering = pkgNode.getOffering();
                responseFileGen.addPackage(profile, offering.getIdentity(), offering.getVersion());
            } else if (item instanceof InstalledOfferingTreeFixNode) {
                InstalledOfferingTreeFixNode fixNode = (InstalledOfferingTreeFixNode)item;
                IFix fix = fixNode.getFix();
                Profile profile = fixNode.getPackageNode().getProfileNode().getProfile();
                responseFileGen.addPackage(profile, fix.getIdentity(), fix.getVersion());
            }
            ++i;
        }
        responseFileGen.generate(new File(outputFile));
    }

    void setSelections(List selectedNodes) {
        this.selectedPkgFixNodes = new ArrayList();
        int i = 0;
        while (i < selectedNodes.size()) {
            InstalledOfferingTreeFixNode fixNode;
            Object item = selectedNodes.get(i);
            if (item instanceof InstalledOfferingTreePackageNode) {
                this.selectedPkgFixNodes.add(item);
            } else if (item instanceof InstalledOfferingTreeFixNode && !this.alreadyAdded(this.selectedPkgFixNodes, fixNode = (InstalledOfferingTreeFixNode)item)) {
                this.selectedPkgFixNodes.add(item);
            }
            ++i;
        }
    }

    private boolean alreadyAdded(List selectedNodes, InstalledOfferingTreeFixNode fixNode) {
        int i = 0;
        while (i < selectedNodes.size()) {
            Object item = selectedNodes.get(i);
            if (item instanceof InstalledOfferingTreeFixNode) {
                InstalledOfferingTreeFixNode addedFixNode = (InstalledOfferingTreeFixNode)item;
                Profile addedProfile = addedFixNode.getPackageNode().getProfileNode().getProfile();
                Profile profile = fixNode.getPackageNode().getProfileNode().getProfile();
                IFix addedFix = addedFixNode.getFix();
                IFix fix = fixNode.getFix();
                if (addedProfile.equals(profile) && addedFix.equals(fix)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

