/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.FeatureViewerSorter;
import com.ibm.cic.agent.internal.ui.utils.ProfileTreeNode;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultContentProvider;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultLabelProvider;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.EditInstallSummaryPage;
import com.ibm.cic.agent.internal.ui.wizards.FeatureSelectionPage;
import com.ibm.cic.agent.internal.ui.wizards.SummaryPage;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MultipleProfileInstallSummaryPage
extends EditInstallSummaryPage {
    private TreeViewer featureViewer;
    private List previousSelectedJobs;
    private Profile currentDisplayedProfile;

    public MultipleProfileInstallSummaryPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.InstallSummaryPage");
    }

    public MultipleProfileInstallSummaryPage(FormToolkit toolkit, AgentUIWizard wizard, String description) {
        super(toolkit, wizard, description);
        super.setHelpRef("com.ibm.cic.agent.ui.InstallSummaryPage");
    }

    @Override
    protected void createTargetLocationControl(Composite container) {
        Section targetLocationSection = this.getToolkit().createSection(container, 512);
        targetLocationSection.setText(Messages.ConfirmationPage_targetLocation);
        Composite targetLocationComposite = this.getToolkit().createComposite((Composite)targetLocationSection);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        targetLocationComposite.setLayout((Layout)gridLayout);
        targetLocationSection.setClient((Control)targetLocationComposite);
        targetLocationSection.setLayoutData((Object)new GridData(4, 1, true, false));
        this.getToolkit().createLabel(targetLocationComposite, Messages.SummaryPage_commonComponentLocation);
        this.commonComponentLocation = new Text(targetLocationComposite, 8);
        this.commonComponentLocation.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    @Override
    protected void showProfiles() {
        String location = CacheLocationManager.getInstance().getCacheLocation();
        String processedLocation = TextProcessor.process((String)location);
        this.commonComponentLocation.setText(processedLocation);
    }

    @Override
    protected void createFeatureControl(Composite container) {
        Section featuresSection = this.getToolkit().createSection(container, 512);
        featuresSection.setText(Messages.InstallSummaryPage_featureTableTitle);
        Composite featuresComposite = this.getToolkit().createComposite((Composite)featuresSection);
        GridLayout compLayout = new GridLayout();
        compLayout.marginHeight = 0;
        featuresComposite.setLayout((Layout)compLayout);
        featuresSection.setClient((Control)featuresComposite);
        GridData data = new GridData(4, 4, true, true);
        featuresSection.setLayoutData((Object)data);
        int style = 2820;
        this.featureViewer = new TreeViewer(featuresComposite, style);
        this.getToolkit().adapt(this.featureViewer.getControl(), true, true);
        GridData gd = new GridData(1808);
        gd.heightHint = this.featureViewer.getTree().getItemHeight() * 5;
        this.featureViewer.getTree().setLayoutData((Object)gd);
        this.featureViewer.getTree().setHeaderVisible(true);
        TreeColumn packageCol = new TreeColumn(this.featureViewer.getTree(), 16384);
        packageCol.setText(Messages.InstallSummaryPage_featureTable_col1);
        packageCol.setWidth(400);
        TreeColumn dirCol = new TreeColumn(this.featureViewer.getTree(), 16384);
        dirCol.setText(Messages.FeatureSelectionPage_installLocation);
        dirCol.setWidth(200);
        this.featureViewer.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int treeWidth = ((MultipleProfileInstallSummaryPage)MultipleProfileInstallSummaryPage.this).featureViewer.getTree().getClientArea().width;
                int scrollBarWidth = 0;
                TreeColumn col1 = MultipleProfileInstallSummaryPage.this.featureViewer.getTree().getColumn(0);
                TreeColumn col2 = MultipleProfileInstallSummaryPage.this.featureViewer.getTree().getColumn(1);
                col1.setWidth(treeWidth - scrollBarWidth - col2.getWidth());
            }
        });
        IWizard wizard = this.getWizard();
        IWizardPage previousPage = wizard.getPreviousPage((IWizardPage)this);
        while (previousPage != null && !(previousPage instanceof FeatureSelectionPage)) {
            previousPage = wizard.getPreviousPage(previousPage);
        }
        if (previousPage == null) {
            this.featureViewer.setContentProvider((IContentProvider)new UpdateResultContentProvider());
        } else {
            ITreeContentProvider featureTreeContentProvider = ((FeatureSelectionPage)previousPage).getFeatureContentProvider();
            Map map = ((FeatureSelectionPage)previousPage).getJobToGroupMap();
            this.featureViewer.setContentProvider((IContentProvider)new UpdateResultContentProvider(featureTreeContentProvider, map));
        }
        this.featureViewer.setLabelProvider((IBaseLabelProvider)new UpdateResultLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        this.featureViewer.addFilter((ViewerFilter)new SummaryPage.FeatureFilter());
        this.featureViewer.setSorter((ViewerSorter)new FeatureViewerSorter());
        this.featureViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                MultipleProfileInstallSummaryPage.this.handleSelectionChanged(e);
            }
        });
        this.featureViewer.setInput(null);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.showFeatures();
            this.reflowFor((Control)this.featureViewer.getTree());
        }
        super.setVisible(visible);
    }

    private void handleSelectionChanged(SelectionChangedEvent e) {
        Profile profile;
        TreePath path;
        Object firstObj;
        ISelection selection = e.getSelection();
        if (!selection.isEmpty() && selection instanceof TreeSelection && (firstObj = (path = ((TreeSelection)selection).getPaths()[0]).getFirstSegment()) instanceof ProfileTreeNode && (profile = ((ProfileTreeNode)firstObj).getProfile()) != this.currentDisplayedProfile) {
            this.currentDisplayedProfile = profile;
            this.showEnvironmentForProfile(profile);
        }
    }

    @Override
    protected void showEnvironment() {
        TreeItem[] items = this.featureViewer.getTree().getItems();
        if (items.length > 0) {
            if (this.currentDisplayedProfile != null) {
                this.showEnvironmentForProfile(this.currentDisplayedProfile);
            } else {
                Object data = items[0].getData();
                if (data instanceof ProfileTreeNode) {
                    Profile profile;
                    this.currentDisplayedProfile = profile = ((ProfileTreeNode)data).getProfile();
                    this.showEnvironmentForProfile(profile);
                }
            }
        }
    }

    private void showFeatures() {
        List jobs = this.getSelectedJobs();
        if (jobs != null && !jobs.equals(this.previousSelectedJobs)) {
            this.resetFeatureTree(jobs);
        } else {
            IContentProvider contentProvider = this.featureViewer.getContentProvider();
            if (contentProvider instanceof UpdateResultContentProvider) {
                ((UpdateResultContentProvider)contentProvider).resetFeatures();
            }
            this.featureViewer.refresh();
            this.featureViewer.expandToLevel(3);
        }
        this.previousSelectedJobs = jobs;
    }

    private void resetFeatureTree(List jobs) {
        Map profileOfferingJobsMap = AgentUIUtils.generateProfileJobFeatureTree(jobs);
        this.featureViewer.setInput(profileOfferingJobsMap.values());
        this.featureViewer.expandToLevel(3);
        Tree tree = this.featureViewer.getTree();
        if (tree.getItemCount() > 0) {
            TreeItem item = tree.getItem(0);
            Object data = item.getData();
            this.featureViewer.setSelection((ISelection)new StructuredSelection(new Object[]{data}));
            tree.setTopItem(item);
        }
    }

    @Override
    protected List getSelectedJobs() {
        return super.getSortedSelectedJobs(false);
    }
}

