/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.LocationCheckManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIDependenciesCheckUtils;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.MultipleProfileInstallLocationDetailsPage;
import com.ibm.cic.agent.internal.ui.wizards.MultipleProfileInstallLocationSection;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MultipleProfileInstallLocationPage
extends AbstractAgentUIWizardPage {
    static final CustomMessageWizardPage.WarningId LOCATION_CHECK_WARNING = new CustomMessageWizardPage.WarningId();
    static final CustomMessageWizardPage.ErrorId LOCATION_CHECK_ERROR = new CustomMessageWizardPage.ErrorId();
    private MultipleProfileInstallLocationDetailsPage detailsSection;
    private MultipleProfileInstallLocationSection locationSection;
    private final Map profileSetLocationStatusMap = new HashMap();
    private final Map profileStatusMap = new HashMap();
    private Map profileLocationOverlapStatusMap;
    private Map profileDependencyStatusMap;
    private IStatus locationCheckStatus;

    public MultipleProfileInstallLocationPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, com.ibm.cic.agent.internal.ui.licenses.Messages.InstallLocationPage_title, Messages.MultipleProfileInstallLocationPageDes, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.MultipleProfileInstallLocationPage");
    }

    @Override
    protected IDetailsPage createDetailsSection() {
        this.detailsSection = new MultipleProfileInstallLocationDetailsPage(this);
        return this.detailsSection;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.locationSection = new MultipleProfileInstallLocationSection(context, parent, this);
        return this.locationSection;
    }

    Profile getSelection() {
        return this.locationSection.getSelection();
    }

    List getProfileProductJobs(Profile profile) {
        MapList profileProductJobs = this.getAgentWizard().getProfileProductJobsMap();
        List groupedJobs = profileProductJobs.get((Object)profile);
        return groupedJobs;
    }

    @Override
    protected int[] getWeights() {
        return new int[]{40, 60};
    }

    void validateProfileSelectionChange() {
        this.resetCurrentProfileStatus(false);
    }

    void handleInstallLocationChange(String directory) {
        IStatus profileStatus;
        IStatus locationOverlapStatus;
        this.resetLocationCheckStatus();
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        Profile currentProfile = this.getSelection();
        IStatus setInstallLocationStatus = this.validateInstallDirectory(currentProfile, directory);
        this.profileSetLocationStatusMap.put(currentProfile, setInstallLocationStatus);
        if (StatusUtil.isErrorOrCancel((IStatus)setInstallLocationStatus)) {
            this.locationSection.refresh();
            this.setErrorStateWithStatus(LOCATION_CHECK_ERROR, setInstallLocationStatus);
            this.setWarningState(LOCATION_CHECK_WARNING, null);
            return;
        }
        status.add(setInstallLocationStatus);
        MapList profileProductJobs = this.getAgentWizard().getProfileProductJobsMap();
        Set<Profile> profilesWithExistingLocations = this.buildAllowExistingLocationProfileSet(profileProductJobs);
        this.validateShadowProfileLocationOverlap(this.getProductProfileList(), profilesWithExistingLocations);
        if (this.profileLocationOverlapStatusMap != null && (locationOverlapStatus = (IStatus)this.profileLocationOverlapStatusMap.get(currentProfile)) != null) {
            if (StatusUtil.isErrorOrCancel((IStatus)locationOverlapStatus)) {
                this.locationSection.refresh();
                this.setErrorStateWithStatus(LOCATION_CHECK_ERROR, locationOverlapStatus);
                this.setWarningState(LOCATION_CHECK_WARNING, null);
                return;
            }
            status.add(locationOverlapStatus);
        }
        if ((profileStatus = (IStatus)this.profileStatusMap.get(currentProfile)) != null) {
            if (StatusUtil.isErrorOrCancel((IStatus)profileStatus)) {
                this.locationSection.refresh();
                this.displayProfileErrorStatus(profileStatus, false);
                this.setWarningState(LOCATION_CHECK_WARNING, null);
                return;
            }
            status.add(profileStatus);
        }
        this.locationSection.refresh();
        if (status.getSeverity() == 2) {
            this.setErrorState(LOCATION_CHECK_ERROR, null);
            this.setWarningState(LOCATION_CHECK_WARNING, MultiStatusUtil.getFailureMessage((IStatus)status, (String)LogUtil.NEWLINE));
        } else {
            this.setErrorState(LOCATION_CHECK_ERROR, null);
            this.setWarningState(LOCATION_CHECK_WARNING, null);
        }
        this.detailsSection.updateLocationInfo();
        this.updateButtons();
    }

    void handleBitModeChange(int bits) {
        Profile profile = this.getSelection();
        MapList profileProductJobs = this.getAgentWizard().getProfileProductJobsMap();
        List groupedJobs = profileProductJobs.get((Object)profile);
        AgentJob[] jobs = groupedJobs.toArray(new AgentJob[groupedJobs.size()]);
        if (bits == 32) {
            BitModeUtils.setProfilePlatformProperties((Profile)profile, (AgentJob[])jobs, (String)BitModeUtils.get32bitArch());
        } else {
            BitModeUtils.setProfilePlatformProperties((Profile)profile, (AgentJob[])jobs, (String)BitModeUtils.get64bitArch());
        }
        this.handleInstallLocationChange(BitModeUtils.getProfileInstallLocationForBitMode((Profile)profile));
    }

    public boolean isPageComplete() {
        if (this.profileSetLocationStatusMap != null) {
            Collection setLocationStatusColletion = this.profileSetLocationStatusMap.values();
            for (IStatus status : setLocationStatusColletion) {
                if (status == null || !StatusUtil.isErrorOrCancel((IStatus)status)) continue;
                return false;
            }
        }
        if (this.profileStatusMap != null) {
            Collection profileStatusCollection = this.profileStatusMap.values();
            for (IStatus status : profileStatusCollection) {
                if (status == null || !StatusUtil.isErrorOrCancel((IStatus)status)) continue;
                return false;
            }
        }
        if (this.profileLocationOverlapStatusMap != null) {
            Collection profileLocationOverlapStatusCollection = this.profileLocationOverlapStatusMap.values();
            for (IStatus status : profileLocationOverlapStatusCollection) {
                if (status == null || !StatusUtil.isErrorOrCancel((IStatus)status)) continue;
                return false;
            }
        }
        return !this.hasLocationCheckFailed();
    }

    boolean hasLocationCheckFailed() {
        if (this.locationCheckStatus == null) {
            return false;
        }
        return StatusUtil.isErrorOrCancel((IStatus)this.locationCheckStatus);
    }

    void setLocationCheckStatus(IStatus status) {
        this.locationCheckStatus = status;
    }

    public IWizardPage getNextPage() {
        try {
            Status[] result = new Status[1];
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress((IStatus[])result){
                private final /* synthetic */ IStatus[] val$result;
                {
                    this.val$result = iStatusArray;
                }

                public void run(IProgressMonitor monitor) {
                    this.val$result[0] = LocationCheckManager.getInstance().initializeAndPerform(MultipleProfileInstallLocationPage.this.getAgentWizard().getJobsArray(), monitor);
                }
            });
            this.setLocationCheckStatus((IStatus)result[0]);
            this.reportErrorOnPage((IStatus)result[0], LOCATION_CHECK_ERROR, LOCATION_CHECK_WARNING);
            if (StatusUtil.isErrorOrCancel((IStatus)result[0])) {
                return this;
            }
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
            return this;
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
            return this;
        }
        return super.getNextPage();
    }

    protected void resetLocationCheckStatus() {
        this.locationCheckStatus = Status.OK_STATUS;
        this.setErrorState(LOCATION_CHECK_ERROR, null);
        this.setWarningState(LOCATION_CHECK_WARNING, null);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && super.getNextPage() != null;
    }

    private IStatus validateInstallDirectory(Profile profile, String installDir, boolean resetInstallLocation) {
        MapList profileProductJobs;
        List groupedJobs;
        IStatus appStatus;
        CicMultiStatus returnStatus = Statuses.ST.createMultiStatus();
        if (resetInstallLocation) {
            IStatus resetLocationStatus = this.resetInstallLocation(profile, installDir);
            if (StatusUtil.isErrorOrCancel((IStatus)resetLocationStatus)) {
                return resetLocationStatus;
            }
            returnStatus.add(resetLocationStatus);
        }
        if (StatusUtil.isErrorOrCancel((IStatus)(appStatus = AgentUtil.getOfferingsApplicability((List)(groupedJobs = (profileProductJobs = this.getAgentWizard().getProfileProductJobsMap()).get((Object)profile)))))) {
            return appStatus;
        }
        returnStatus.add(appStatus);
        IStatus fixAppStatus = BitModeUtils.checkFixBitModeSupportedAgainstProfile((Collection)AgentUtil.getFixesFromJobs((AgentJob[])groupedJobs.toArray(new AgentJob[groupedJobs.size()])), (Profile)profile);
        if (StatusUtil.isErrorOrCancel((IStatus)fixAppStatus)) {
            return fixAppStatus;
        }
        returnStatus.add(fixAppStatus);
        ICicStatus vistaWarning = AgentUtil.validateVistaVirtualizationLocation((String)installDir, (IOffering[])AgentUIUtils.getSelectedProductOfferingArray(groupedJobs));
        if (StatusUtil.isErrorOrCancel((IStatus)vistaWarning)) {
            return vistaWarning;
        }
        returnStatus.add((IStatus)vistaWarning);
        return returnStatus;
    }

    private IStatus validateInstallDirectory(Profile profile, String installDir) {
        return this.validateInstallDirectory(profile, installDir, true);
    }

    private IStatus validateProfile(Profile profile) {
        IStatus dependencyStatus = (IStatus)this.profileDependencyStatusMap.get(profile);
        return dependencyStatus;
    }

    void initializeProfileProperties() {
        MapList profileProductJobs = this.getAgentWizard().getProfileProductJobsMap();
        Set profileSet = profileProductJobs.keySet();
        for (Profile profile : profileSet) {
            List profileJobs = profileProductJobs.get((Object)profile);
            BitModeUtils.initializeProfilePlatformProperties((Profile)profile, (AgentJob[])profileJobs.toArray(new AgentJob[profileJobs.size()]));
        }
    }

    void validateInitialStatus() {
        this.setPEKProfileToJob();
        this.profileDependencyStatusMap = AgentUIDependenciesCheckUtils.checkDependenciesPeerInstall(AgentUtil.getSelectedProductAgentJobs((Collection)this.getSelectedJobs()));
        MapList profileProductJobs = this.getAgentWizard().getProfileProductJobsMap();
        Set profileSet = profileProductJobs.keySet();
        for (Profile profile : profileSet) {
            IStatus setInstallLocationStatus = this.validateInstallDirectory(profile, profile.getInstallLocation());
            this.profileSetLocationStatusMap.put(profile, setInstallLocationStatus);
            IStatus profileStatus = this.validateProfile(profile);
            this.profileStatusMap.put(profile, profileStatus);
        }
        Set<Profile> profilesWithExistingLocations = this.buildAllowExistingLocationProfileSet(profileProductJobs);
        this.validateShadowProfileLocationOverlap(new ArrayList(profileSet), profilesWithExistingLocations);
    }

    private Set<Profile> buildAllowExistingLocationProfileSet(MapList profileProductJobs) {
        Set profileSet = profileProductJobs.keySet();
        HashSet<Profile> profilesWithExistingLocations = new HashSet<Profile>();
        for (Profile profile : profileSet) {
            AgentJob[] jobs;
            List jobsList = profileProductJobs.get((Object)profile);
            AgentJob[] agentJobArray = jobs = jobsList.toArray(new AgentJob[jobsList.size()]);
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                if (OfferingProperty.isExistingLocationAllowed((IOffering)job.getOffering())) {
                    profilesWithExistingLocations.add(profile);
                }
                ++n2;
            }
        }
        return profilesWithExistingLocations;
    }

    private void validateShadowProfileLocationOverlap(List allProfiles, Set profilesWithExistingLocations) {
        ArrayList<Profile> shadowProfileList = new ArrayList<Profile>(allProfiles.size());
        for (Profile profile : allProfiles) {
            if (!profile.isShadow()) continue;
            shadowProfileList.add(profile);
        }
        this.profileLocationOverlapStatusMap = null;
        if (!shadowProfileList.isEmpty()) {
            Profile[] shadowProfileArray = shadowProfileList.toArray(new Profile[shadowProfileList.size()]);
            this.profileLocationOverlapStatusMap = Profile.validateLocationCollision((Profile[])shadowProfileArray, (Set)profilesWithExistingLocations);
        }
    }

    void resetCurrentProfileStatus(boolean refreshProfileTable) {
        IStatus profileStatus;
        IStatus locationOverlapStatus;
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        Profile currentProfile = this.getSelection();
        IStatus setLocationStatus = (IStatus)this.profileSetLocationStatusMap.get(currentProfile);
        if (refreshProfileTable) {
            this.locationSection.refresh();
        }
        if (setLocationStatus != null) {
            if (StatusUtil.isErrorOrCancel((IStatus)setLocationStatus)) {
                this.setErrorStateWithStatus(LOCATION_CHECK_ERROR, setLocationStatus);
                this.setWarningState(LOCATION_CHECK_WARNING, null);
                return;
            }
            status.add(setLocationStatus);
        }
        if (this.profileLocationOverlapStatusMap != null && (locationOverlapStatus = (IStatus)this.profileLocationOverlapStatusMap.get(currentProfile)) != null) {
            if (StatusUtil.isErrorOrCancel((IStatus)locationOverlapStatus)) {
                this.setErrorStateWithStatus(LOCATION_CHECK_ERROR, locationOverlapStatus);
                this.setWarningState(LOCATION_CHECK_WARNING, null);
                return;
            }
            status.add(locationOverlapStatus);
        }
        if ((profileStatus = (IStatus)this.profileStatusMap.get(currentProfile)) != null) {
            if (StatusUtil.isErrorOrCancel((IStatus)profileStatus)) {
                this.displayProfileErrorStatus(profileStatus, true);
                this.setWarningState(LOCATION_CHECK_WARNING, null);
                return;
            }
            status.add(profileStatus);
        }
        if (status.getSeverity() == 2) {
            this.setErrorState(LOCATION_CHECK_ERROR, null);
            this.setWarningState(LOCATION_CHECK_WARNING, MultiStatusUtil.getFailureMessage((IStatus)status, (String)LogUtil.NEWLINE));
        } else {
            this.setErrorState(LOCATION_CHECK_ERROR, null);
            this.setWarningState(LOCATION_CHECK_WARNING, null);
        }
    }

    void revalidateProfileStatus() {
        MapList profileProductJobs = this.getAgentWizard().getProfileProductJobsMap();
        Set profileSet = profileProductJobs.keySet();
        for (Profile profile : profileSet) {
            IStatus setInstallLocationStatus = this.validateInstallDirectory(profile, profile.getInstallLocation(), false);
            this.profileSetLocationStatusMap.put(profile, setInstallLocationStatus);
        }
        Set<Profile> profilesWithExistingLocations = this.buildAllowExistingLocationProfileSet(profileProductJobs);
        this.validateShadowProfileLocationOverlap(new ArrayList(profileSet), profilesWithExistingLocations);
    }

    private void setPEKProfileToJob() {
        List selectedJobs = this.getSelectedJobsWithoutAgentJob();
        int i = 0;
        while (i < selectedJobs.size()) {
            AgentJob job = (AgentJob)selectedJobs.get(i);
            Profile profile = job.getProfile();
            IOffering offering = job.getOffering();
            if (offering != null && LicenseUtils.isPEKOffering((IOffering)offering) && !profile.getProfileKind().equals("license")) {
                job.setProfile(Profile.getLicenseProfile((Agent)Agent.getInstance()));
            }
            ++i;
        }
    }

    @Override
    protected void setFocus() {
        this.locationSection.setInput(this.getSelectedJobs());
        this.detailsSection.showInstalledOfferings();
        this.detailsSection.showDiskSpaceInfo();
    }

    void displayProfileErrorStatus(IStatus profileStatus, boolean displayDialog) {
        this.setErrorStateWithStatus(LOCATION_CHECK_ERROR, profileStatus);
        if (profileStatus.isMultiStatus() && displayDialog) {
            this.displayStatusInDialog(profileStatus);
        }
    }

    private IStatus constructOfferingInterdependencyError(IStatus statusFromCore) {
        if (statusFromCore.getCode() != 402 && statusFromCore.getCode() != 401) {
            return statusFromCore;
        }
        String msgFromCore = statusFromCore.getMessage();
        CicMultiStatus result = Statuses.ST.createMultiStatusFromStatus(statusFromCore);
        if (statusFromCore.getCode() == 401) {
            result.setMessage(String.valueOf(msgFromCore) + Messages.InstallLocationPage_offeringInterdependencyError_singleProfile);
        } else {
            result.setMessage(String.valueOf(msgFromCore) + Messages.InstallLocationPage_offeringInterdependencyErrorPackageOnly_singleProfile);
        }
        return result;
    }

    private void displayStatusInDialog(final IStatus status) {
        if (this.getControl() != null && this.getControl().isVisible()) {
            DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WrapDetailUIDErrorDialog dlg = new WrapDetailUIDErrorDialog(AgentUI.getActiveWorkbenchShell(), com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, null, MultipleProfileInstallLocationPage.this.constructOfferingInterdependencyError(status), 12);
                    dlg.open();
                }
            });
        }
    }

    private IStatus resetInstallLocation(Profile profile, String location) {
        if (!profile.isShadow()) {
            return Status.OK_STATUS;
        }
        IStatus setLocationStatus = profile.setInstallLocation(location);
        if (!StatusUtil.isErrorOrCancel((IStatus)setLocationStatus)) {
            profile.setNeedsRequalification();
            MapList profileProductJobs = this.getAgentWizard().getProfileProductJobsMap();
            List groupedJobs = profileProductJobs.get((Object)profile);
            IStatus status = SharedUIUtils.checkBitModeArtifacts((List)groupedJobs, (Profile)profile);
            if (!status.isOK()) {
                return status;
            }
        }
        return setLocationStatus;
    }

    void setSelection(List profileList) {
        List productProfileList = this.getProductProfileList();
        productProfileList.clear();
        if (profileList != null) {
            int i = 0;
            while (i < profileList.size()) {
                Profile profile = (Profile)profileList.get(i);
                productProfileList.add(profile);
                ++i;
            }
        }
    }

    Map getProfileSetLocationMap() {
        return this.profileSetLocationStatusMap;
    }

    Map getProfileStatusMap() {
        return this.profileStatusMap;
    }

    Map getProfileLocationOverlapStatusMap() {
        return this.profileLocationOverlapStatusMap;
    }
}

