/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIDisableCancelWizard;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.FeatureSelectionPage;
import com.ibm.cic.agent.internal.ui.wizards.ModifyCompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.ModifyLocaleLanguagePage;
import com.ibm.cic.agent.internal.ui.wizards.ModifySummaryPage;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.ui.CICImages;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizardPage;

public class ModifyWizard
extends AgentUIDisableCancelWizard {
    private final Map offeringStatusBeforeModify = new HashMap();

    public ModifyWizard() {
        super(null, Messages.ModifyWizard_modifying, CICImages.WIZ_MODIFY);
    }

    public void addPages() {
        ModifyLocaleLanguagePage environmentPage = new ModifyLocaleLanguagePage(this.toolkit, this);
        this.addPage((IWizardPage)environmentPage);
        environmentPage.setHelpRef("com.ibm.cic.agent.ui.ModifyLocaleLanguagePage");
        FeatureSelectionPage featureSelectionPage = new FeatureSelectionPage(this.toolkit, Messages.ModifyWizard_featuresTitle, Messages.ModifyWizard_featuresDescription, this, false);
        featureSelectionPage.setHelpRef("com.ibm.cic.agent.ui.FeatureSelectionPage");
        this.addPage((IWizardPage)featureSelectionPage);
        this.addExtensionPages("com.ibm.cic.agent.ui.MissingCustomPanelModifyWizard");
        this.addSingleConfigurationPage(Messages.ModifyWizard_featuresTitle, "com.ibm.cic.agent.ui.MissingCustomPanelSingleConfigurationPage");
        this.addPage((IWizardPage)new ModifySummaryPage(this.toolkit, this));
    }

    protected String getUserFeedbackTitle() {
        return Messages.ModifyWizard_warningTitle;
    }

    protected String getDefaultUserFeedbackMessage() {
        return Messages.ModifyWizard_warningMessage;
    }

    @Override
    protected AbstractJob createJob(Profile profile, IOfferingOrFix offering) {
        return new ModifyJob(profile, offering);
    }

    @Override
    public CompletionPage createCompletionPage(IStatus status) {
        return new ModifyCompletionPage(this.toolkit, this, status);
    }

    @Override
    protected String getRestartMessage() {
        return Messages.RestartProfileMsg;
    }

    @Override
    protected WizardType getWizardType() {
        return WizardType.MODIFY;
    }

    private void addJobsToList(ModifyJob job, List features, List newJobs, boolean localeLangChanged, boolean install) {
        if (features.size() > 0 || localeLangChanged) {
            ModifyJob newJob = new ModifyJob(job.getProfile(), (IOfferingOrFix)job.getOffering(), install ? AgentJob.AgentJobType.INSTALL_JOB : AgentJob.AgentJobType.UNINSTALL_JOB);
            newJob.setFeatureIds(features.size() > 0 ? Util.toFeatureIdString((Collection)features) : "-");
            newJob.setSelected(job.isSelected());
            newJobs.add(newJob);
        }
    }

    private void recordModifyOfferingStatus(ModifyJob modifyJob) {
        IOffering offering = modifyJob.getOffering();
        if (offering != null) {
            Agent agent = AgentUI.getDefault().getAgent();
            Set installedFeatures = agent.getInstalledFeatures(modifyJob.getProfile(), offering);
            this.offeringStatusBeforeModify.put(offering, installedFeatures);
        }
    }

    protected Map getOfferingStatusList() {
        return this.offeringStatusBeforeModify;
    }

    @Override
    protected IStatus performTask(IProgressMonitor monitor) {
        LinkedList toInstallAgentJobs = new LinkedList();
        LinkedList toUninstallAgentJobs = new LinkedList();
        LinkedList<AbstractJob> toInstallPekOfferingJobs = new LinkedList<AbstractJob>();
        Agent agent = AgentUI.getDefault().getAgent();
        for (AbstractJob abstractJob : this.getJobs()) {
            if (abstractJob.isModify() && abstractJob.isSelected()) {
                Set removedLangSet;
                ModifyJob modifyJob = (ModifyJob)abstractJob;
                this.recordModifyOfferingStatus(modifyJob);
                LinkedList featuresToAdd = new LinkedList();
                LinkedList featuresToRemove = new LinkedList();
                modifyJob.determineFeaturesToAddRemove((IAgent)agent, featuresToAdd, featuresToRemove);
                boolean localeLangAdded = false;
                boolean localeLangRemoved = false;
                Profile profile = modifyJob.getProfile();
                Set addedLangSet = (Set)this.getAddedLocaleLangsMap().get(profile);
                if (addedLangSet != null && !addedLangSet.isEmpty()) {
                    localeLangAdded = true;
                }
                if ((removedLangSet = (Set)this.getRemovedLocaleLangsMap().get(profile)) != null && !removedLangSet.isEmpty()) {
                    localeLangRemoved = true;
                }
                this.addJobsToList(modifyJob, featuresToAdd, toInstallAgentJobs, localeLangAdded, true);
                this.addJobsToList(modifyJob, featuresToRemove, toUninstallAgentJobs, localeLangRemoved, false);
                continue;
            }
            if (!abstractJob.isInstall() || !abstractJob.isSelected()) continue;
            toInstallPekOfferingJobs.add(abstractJob);
        }
        int installJobSize = toInstallAgentJobs.size();
        int uninstallJobSize = toUninstallAgentJobs.size();
        int pekOfferingSize = toInstallPekOfferingJobs.size();
        int totalWork = installJobSize + uninstallJobSize + pekOfferingSize;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
        CicMultiStatus returnStatus = Statuses.ST.createMultiStatus();
        IStatus status = agent.install(toInstallAgentJobs.toArray(new AgentJob[installJobSize]), this.getCollectedArtifacts(), (Agent.IDisableCancel)this, (IProgressMonitor)subMonitor.newChild(installJobSize));
        if (status.matches(4) || status.matches(8)) {
            if (toInstallAgentJobs.size() > 0) {
                Profile modifyProfile = ((AgentJob)toInstallAgentJobs.get(0)).getProfile();
                this.restoreProfileNLs(modifyProfile);
            }
            return status;
        }
        if (!status.isOK()) {
            returnStatus = Statuses.ST.createMultiStatusFromStatus(status);
        }
        if ((status = agent.uninstall(toUninstallAgentJobs.toArray(new AgentJob[uninstallJobSize]), null, (Agent.IDisableCancel)this, (IProgressMonitor)subMonitor.newChild(uninstallJobSize))).matches(4) || status.matches(8)) {
            return status;
        }
        if (!status.isOK()) {
            if (returnStatus.isOK()) {
                returnStatus = Statuses.ST.createMultiStatusFromStatus(status);
            } else {
                returnStatus.add(status);
            }
        }
        if (pekOfferingSize > 0) {
            status = agent.install(toInstallPekOfferingJobs.toArray(new AgentJob[pekOfferingSize]), this.getCollectedArtifacts(), (Agent.IDisableCancel)this, (IProgressMonitor)subMonitor.newChild(pekOfferingSize));
            if (status.matches(4) || status.matches(8)) {
                return status;
            }
            if (!status.isOK()) {
                if (returnStatus.isOK()) {
                    returnStatus = Statuses.ST.createMultiStatusFromStatus(status);
                } else {
                    returnStatus.add(status);
                }
            }
        }
        return returnStatus;
    }

    private void restoreProfileNLs(Profile modifyProfile) {
        String currentLNs;
        String previousNLs = (String)this.getPreviousLocaleLangsMap().get(modifyProfile);
        if (previousNLs != null && !previousNLs.equals(currentLNs = modifyProfile.getData("cic.selector.nl"))) {
            modifyProfile.setData("cic.selector.nl", previousNLs);
        }
    }

    @Override
    public void setInput(Object[] items) {
        if (items instanceof Profile[]) {
            this.createJobsFromProfiles((Profile[])items);
        }
    }

    private void createJobsFromProfiles(Profile[] profiles) {
        List productProfiles = this.getProductProfileList();
        List agentProfiles = this.getAgentProfileList();
        Map profileLocaleLangsMap = this.getProfileLocaleLanguagesMap();
        List wizardJobs = this.getJobs();
        productProfiles.clear();
        agentProfiles.clear();
        profileLocaleLangsMap.clear();
        wizardJobs.clear();
        Agent agent = AgentUI.getDefault().getAgent();
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (profile.getProfileKind().equals("self")) {
                agentProfiles.add(profile);
            } else {
                productProfiles.add(profile);
            }
            profileLocaleLangsMap.put(profile, profile.getData("cic.selector.nl"));
            IOffering[] offerings = agent.getInstalledOfferings(profile);
            int j = 0;
            while (j < offerings.length) {
                wizardJobs.add(this.createJob(profile, (IOfferingOrFix)offerings[j]));
                if (!agent.isAgentOffering((IOfferingOrFix)offerings[j])) {
                    List installPEKJob = AgentUtil.getPekInstallJobs((IOffering)offerings[j]);
                    if (installPEKJob != null && installPEKJob.size() > 0) {
                        int k = 0;
                        while (k < installPEKJob.size()) {
                            AbstractJob pekJob = (AbstractJob)installPEKJob.get(k);
                            pekJob.setSelected(false);
                            ++k;
                        }
                    }
                    wizardJobs.addAll(installPEKJob);
                }
                ++j;
            }
            ++n2;
        }
    }

    public boolean isHelpAvailable() {
        return true;
    }

    protected String getStatusMessage(IStatus status) {
        if (status.matches(8)) {
            return Messages.ModifyCanceledMsg;
        }
        return Messages.ModifyFailedMsg;
    }

    protected String getKeepDownloadedMessage() {
        return Messages.KeepDownloadedMsgForModify;
    }

    protected String getKeepDownloadedDlgTitle(IStatus status) {
        if (status.matches(8)) {
            return Messages.ModifyCanceledTitle;
        }
        return Messages.ModifyFailedTitle;
    }
}

