/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.LocaleLanguageUtils;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.common.core.definitions.LanguageCode;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.wizardry.AbstractCicWizardPage;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LocaleLanguagePage
extends AbstractCicWizardPage {
    protected AgentUIWizard wizard;
    private final CustomMessageWizardPage.WarningId localeLangWarningId = new CustomMessageWizardPage.WarningId();
    private final String[] languageCodes;
    private final Map<String, String> codeButtonLabelMap;
    private final Map<String, String> codeLabelMap;
    protected Map<String, Set<String>> buttonLabelCodeMap;
    protected Button[] languageCheckBtns;
    private String platformLocaleCode;
    private String[] commonLangButtonLabels;
    private String[] nonCommonLangButtonLabels;
    private final Set commonLanguages = new HashSet();
    private Set nonCommonLanguages = new HashSet();
    private final Set requiredLanguages = new HashSet();
    private IStatus previousApplicabilityCheckStatus;
    private List<Profile> shadowProfileList;
    private final Set<String> selectedLocaleLanguageCode = new HashSet<String>();
    private List<Profile> lastSelectedProfileList = null;
    private boolean validLangSelection = false;
    private Button selectAllButton;
    private Button clearAllButton;
    private Section nonCommonLangSection;

    public LocaleLanguagePage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(com.ibm.cic.agent.internal.ui.licenses.Messages.InstallWizard_featuresTitle, toolkit, com.ibm.cic.agent.internal.ui.licenses.Messages.InstallWizard_featuresTitle, com.ibm.cic.agent.core.sharedUI.Messages.EnvironmentPage_des);
        this.wizard = wizard;
        this.languageCodes = ProfileLanguageUtils.getLocaleLanguageCodes();
        this.codeButtonLabelMap = LocaleLanguageUtils.getLocaleCodeButtonLabelMap();
        this.codeLabelMap = ProfileLanguageUtils.getLocaleCodeLabelMap();
        this.buttonLabelCodeMap = LocaleLanguageUtils.getButtonLabelLocaleCodeMap();
        this.previousApplicabilityCheckStatus = Status.OK_STATUS;
    }

    public void createControl(Composite parent) {
        this.checkAvailableLocaleLanguages();
        Composite container = this.getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        if (this.wizard.isMultipleProfileInstall()) {
            this.populateShadowProfileList();
            if (!this.shadowProfileList.isEmpty()) {
                this.createDescriptionControl(container);
            }
        }
        this.createLanguageControl(container);
        this.setControl((Control)container);
    }

    private void createDescriptionControl(Composite parent) {
        Composite container = this.getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginTop = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        StringBuffer pkgGroupLabels = new StringBuffer();
        for (Profile profile : this.shadowProfileList) {
            pkgGroupLabels.append(profile.getProfileId());
            pkgGroupLabels.append(", ");
        }
        String profileLabels = pkgGroupLabels.substring(0, pkgGroupLabels.length() - 2);
        Label descriptionLabel = this.getToolkit().createLabel(container, NLS.bind((String)Messages.MultipleProfileLocaleLangDes_2, (Object)profileLabels), 64);
        descriptionLabel.setLayoutData((Object)new GridData(768));
    }

    private void populateShadowProfileList() {
        this.shadowProfileList = new ArrayList<Profile>();
        HashSet profiles = new HashSet();
        if (!this.wizard.isMultipleProfileInstall()) {
            List selectedProductProfiles = this.wizard.getProductProfileList();
            if (selectedProductProfiles != null && !selectedProductProfiles.isEmpty()) {
                profiles.addAll(selectedProductProfiles);
            }
        } else {
            Set productProfiles = this.wizard.getProfileProductJobsMap().keySet();
            profiles.addAll(productProfiles);
        }
        for (Profile profile : profiles) {
            if (!profile.isShadow()) continue;
            this.shadowProfileList.add(profile);
        }
    }

    private void checkAvailableLocaleLanguages() {
        if (this.commonLanguages.isEmpty() && this.nonCommonLanguages.isEmpty()) {
            List selectedProductJobs = AgentUtil.getSelectedProductAgentJobs((Collection)this.wizard.getSelectedJobs());
            HashSet allOfferingLanguages = new HashSet();
            int i = 0;
            while (i < selectedProductJobs.size()) {
                AbstractJob job = (AbstractJob)selectedProductJobs.get(i);
                IOffering offering = job.getOffering();
                if (offering != null) {
                    Set pkgLanguages = OfferingProperty.getSupportedLocales((IOffering)offering);
                    Set supportedLangs = ProfileLanguageUtils.getLocaleLanguageCodeSet();
                    supportedLangs.retainAll(pkgLanguages);
                    allOfferingLanguages.addAll(supportedLangs);
                    if (this.commonLanguages.isEmpty()) {
                        this.commonLanguages.addAll(supportedLangs);
                    } else {
                        this.commonLanguages.retainAll(supportedLangs);
                    }
                    this.requiredLanguages.addAll(OfferingProperty.getRequiredLocales((IOffering)offering));
                }
                ++i;
            }
            this.commonLanguages.add(LanguageCode.ENGLISH.getId());
            this.requiredLanguages.add(LanguageCode.ENGLISH.getId());
            allOfferingLanguages.removeAll(this.commonLanguages);
            this.nonCommonLanguages = allOfferingLanguages;
        }
    }

    private void createLanguageControl(Composite container) {
        this.createButtonLabels();
        if (!this.wizard.isMultipleProfileInstall()) {
            new Label(container, 0);
        }
        boolean hasNonCommonLangs = this.nonCommonLangButtonLabels != null && this.nonCommonLangButtonLabels.length > 0;
        Section commonLangSection = this.getToolkit().createSection(container, 512);
        if (hasNonCommonLangs) {
            commonLangSection.setText(com.ibm.cic.agent.core.sharedUI.Messages.EnvironmentPage_commonLanguage);
        } else {
            commonLangSection.setText(com.ibm.cic.agent.core.sharedUI.Messages.EnvironmentPage_language);
        }
        commonLangSection.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite commonLangComp = this.getToolkit().createComposite((Composite)commonLangSection, 2048);
        commonLangSection.setClient((Control)commonLangComp);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        commonLangComp.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 1, false, false);
        commonLangComp.setLayoutData((Object)gridData);
        int buttonSize = this.commonLangButtonLabels.length;
        if (hasNonCommonLangs) {
            buttonSize += this.nonCommonLangButtonLabels.length;
        }
        this.languageCheckBtns = new Button[buttonSize];
        int i = 0;
        while (i < this.commonLangButtonLabels.length) {
            this.languageCheckBtns[i] = this.createCheckButton(commonLangComp, this.commonLangButtonLabels[i]);
            ++i;
        }
        if (hasNonCommonLangs) {
            new Label(container, 0);
            this.nonCommonLangSection = this.getToolkit().createSection(container, 514);
            this.nonCommonLangSection.setText(com.ibm.cic.agent.core.sharedUI.Messages.EnvironmentPage_nonCommonLanguage);
            this.nonCommonLangSection.setLayoutData((Object)new GridData(4, 1, true, false));
            Composite nonCommonLangComp = this.getToolkit().createComposite((Composite)this.nonCommonLangSection, 2048);
            this.nonCommonLangSection.setClient((Control)nonCommonLangComp);
            layout = new GridLayout();
            layout.numColumns = 5;
            nonCommonLangComp.setLayout((Layout)layout);
            gridData = new GridData(4, 1, false, false);
            nonCommonLangComp.setLayoutData((Object)gridData);
            int commonLangSize = this.commonLangButtonLabels.length;
            int i2 = 0;
            while (i2 < this.nonCommonLangButtonLabels.length) {
                this.languageCheckBtns[i2 + commonLangSize] = this.createCheckButton(nonCommonLangComp, this.nonCommonLangButtonLabels[i2]);
                ++i2;
            }
        }
        Composite buttonContainer = this.getToolkit().createComposite(container);
        GridLayout buttonCompLayout = new GridLayout();
        buttonCompLayout.numColumns = 2;
        buttonContainer.setLayout((Layout)buttonCompLayout);
        GridData buttonCompData = new GridData(0x1000008, 1, false, false);
        buttonContainer.setLayoutData((Object)buttonCompData);
        this.selectAllButton = this.getToolkit().createButton(buttonContainer, Messages.EnvironmentPage_SelectAllButton, 8);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocaleLanguagePage.this.checkAllButtons(true);
            }
        });
        this.clearAllButton = this.getToolkit().createButton(buttonContainer, Messages.EnvironmentPage_ClearAllButton, 8);
        this.clearAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocaleLanguagePage.this.checkAllButtons(false);
            }
        });
    }

    private void checkAllButtons(boolean check) {
        if (this.nonCommonLangSection != null && !this.nonCommonLangSection.isExpanded()) {
            this.nonCommonLangSection.setExpanded(true);
        }
        Button[] buttonArray = this.languageCheckBtns;
        int n = this.languageCheckBtns.length;
        int n2 = 0;
        while (n2 < n) {
            Button languageCheckBtn = buttonArray[n2];
            if (languageCheckBtn.isEnabled() && languageCheckBtn.getSelection() != check) {
                languageCheckBtn.setSelection(check);
                this.updateLanguageSelection(languageCheckBtn.getText(), check);
            }
            ++n2;
        }
        this.validateLocaleLanguages(false);
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = this.getToolkit().createButton(parent, label, 32);
        button.setLayoutData((Object)new GridData(4, 1, true, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button selectedBtn = (Button)e.getSource();
                LocaleLanguagePage.this.updateLanguageSelection(selectedBtn.getText(), selectedBtn.getSelection());
                LocaleLanguagePage.this.validateLocaleLanguages(false);
            }
        });
        return button;
    }

    private void createButtonLabels() {
        String languageCode;
        String currentNL = Platform.getNL();
        String[] stringArray = this.languageCodes;
        int n = this.languageCodes.length;
        int n2 = 0;
        while (n2 < n) {
            languageCode = stringArray[n2];
            if (languageCode.startsWith(currentNL)) {
                this.platformLocaleCode = languageCode;
                break;
            }
            ++n2;
        }
        if (this.platformLocaleCode == null) {
            stringArray = this.languageCodes;
            n = this.languageCodes.length;
            n2 = 0;
            while (n2 < n) {
                languageCode = stringArray[n2];
                if (currentNL.startsWith(languageCode)) {
                    this.platformLocaleCode = languageCode;
                    break;
                }
                ++n2;
            }
        }
        ArrayList<String> commonLangButtonList = new ArrayList<String>();
        ArrayList<String> nonCommonLangButtonList = new ArrayList<String>();
        if (this.platformLocaleCode != null) {
            String label = this.codeButtonLabelMap.get(this.platformLocaleCode);
            if (this.commonLanguages.contains(this.platformLocaleCode)) {
                commonLangButtonList.add(label);
            } else if (this.nonCommonLanguages.contains(this.platformLocaleCode)) {
                nonCommonLangButtonList.add(label);
            }
        }
        String[] stringArray2 = this.languageCodes;
        int n3 = this.languageCodes.length;
        int n4 = 0;
        while (n4 < n3) {
            String code = stringArray2[n4];
            String label = this.codeButtonLabelMap.get(code);
            if (this.commonLanguages.contains(code) && !commonLangButtonList.contains(label)) {
                commonLangButtonList.add(label);
            } else if (this.nonCommonLanguages.contains(code) && !nonCommonLangButtonList.contains(label)) {
                nonCommonLangButtonList.add(label);
            }
            ++n4;
        }
        this.commonLangButtonLabels = commonLangButtonList.toArray(new String[commonLangButtonList.size()]);
        this.nonCommonLangButtonLabels = nonCommonLangButtonList.toArray(new String[nonCommonLangButtonList.size()]);
    }

    private void updateLanguageSelection(String label, boolean add) {
        Set<String> codes = this.buttonLabelCodeMap.get(label);
        if (codes != null) {
            for (String code : codes) {
                if (add) {
                    this.selectedLocaleLanguageCode.add(code);
                    continue;
                }
                this.selectedLocaleLanguageCode.remove(code);
            }
            this.setLocaleLanguageSet(this.selectedLocaleLanguageCode);
        }
    }

    protected void setLocaleLanguageSet(Set localeSet) {
        String value = ProfileLanguageUtils.convertCodeSetToString((Set)localeSet);
        Map profileLocaleLangMap = this.wizard.getProfileLocaleLanguagesMap();
        for (Profile profile : this.shadowProfileList) {
            profileLocaleLangMap.put(profile, value);
        }
    }

    private boolean twoListEqual(List<Profile> list1, List<Profile> list2) {
        if (list1 != null && list2 != null) {
            if (list1.size() != list2.size()) {
                return false;
            }
            HashSet<Profile> set1 = new HashSet<Profile>(list1);
            HashSet<Profile> set2 = new HashSet<Profile>(list2);
            set1.removeAll(set2);
            return set1.isEmpty();
        }
        return false;
    }

    protected Set<String> getDefaultSelections() {
        HashSet<String> result = new HashSet<String>();
        result.add(LanguageCode.ENGLISH.getId());
        if (this.platformLocaleCode != null && this.commonLanguages.contains(this.platformLocaleCode)) {
            result.add(this.platformLocaleCode);
        }
        if (this.requiredLanguages != null && !this.requiredLanguages.isEmpty()) {
            result.addAll(this.requiredLanguages);
        }
        return result;
    }

    private void selectDefaultSelections(Set<String> defaultSelections) {
        Button[] buttonArray = this.languageCheckBtns;
        int n = this.languageCheckBtns.length;
        int n2 = 0;
        while (n2 < n) {
            Button languageCheckBtn = buttonArray[n2];
            Set<String> codes = this.buttonLabelCodeMap.get(languageCheckBtn.getText());
            if (codes != null && codes.size() > 0) {
                boolean selected = false;
                for (String code : codes) {
                    if (!defaultSelections.contains(code)) continue;
                    selected = true;
                    break;
                }
                boolean required = false;
                for (String code : codes) {
                    if (!this.requiredLanguages.contains(code)) continue;
                    required = true;
                    break;
                }
                if (selected) {
                    languageCheckBtn.setSelection(true);
                    if (required) {
                        languageCheckBtn.setEnabled(false);
                    } else {
                        languageCheckBtn.setEnabled(true);
                    }
                } else {
                    languageCheckBtn.setSelection(false);
                    languageCheckBtn.setEnabled(true);
                }
            }
            ++n2;
        }
        this.selectedLocaleLanguageCode.addAll(defaultSelections);
    }

    private void displayLocaleLanguages() {
        List profiles = this.wizard.getProfiles();
        if (profiles.isEmpty()) {
            return;
        }
        boolean profileChanged = false;
        List selectedProductProfileList = this.wizard.getProductProfileList();
        profileChanged = selectedProductProfileList != this.lastSelectedProfileList ? true : !this.twoListEqual(selectedProductProfileList, this.lastSelectedProfileList);
        this.lastSelectedProfileList = selectedProductProfileList;
        if (profileChanged) {
            this.wizard.getProfileLocaleLanguagesMap().clear();
            this.selectedLocaleLanguageCode.clear();
            this.populateShadowProfileList();
            Set<String> defaultSelections = this.getDefaultSelections();
            this.selectDefaultSelections(defaultSelections);
            this.setLocaleLanguageSet(defaultSelections);
            if (this.allButtonsDisabled()) {
                this.selectAllButton.setEnabled(false);
                this.clearAllButton.setEnabled(false);
            } else {
                this.selectAllButton.setEnabled(true);
                this.clearAllButton.setEnabled(true);
            }
        }
        this.validateLocaleLanguages(true);
    }

    private boolean allButtonsDisabled() {
        Button[] buttonArray = this.languageCheckBtns;
        int n = this.languageCheckBtns.length;
        int n2 = 0;
        while (n2 < n) {
            Button languageCheckBtn = buttonArray[n2];
            if (languageCheckBtn.isEnabled()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void setFocus() {
        this.displayLocaleLanguages();
    }

    public boolean isPageComplete() {
        if (!super.isPageComplete()) {
            return false;
        }
        if (this.shouldSkip()) {
            return true;
        }
        return this.getControl() != null && this.validLangSelection;
    }

    private void validateLocaleLanguages(boolean checkApplicability) {
        IStatus applicabilityCheckStatus = this.previousApplicabilityCheckStatus;
        if (checkApplicability) {
            List selectedProductJobs = AgentUtil.getSelectedProductAgentJobs((Collection)this.wizard.getSelectedJobs());
            if (selectedProductJobs.size() > 0) {
                AgentJob job = (AgentJob)selectedProductJobs.get(0);
                applicabilityCheckStatus = job.isInstall() ? AgentUtil.getOfferingsApplicability((List)selectedProductJobs) : AgentUtil.getOfferingsApplicability((List)selectedProductJobs, (AgentJob[])AgentJob.toArray((Collection)selectedProductJobs));
            }
            this.previousApplicabilityCheckStatus = applicabilityCheckStatus;
        }
        if (applicabilityCheckStatus.getSeverity() == 4) {
            this.setErrorMessageWithStatus(applicabilityCheckStatus);
            this.validLangSelection = false;
        } else {
            IStatus langConsistencyStatus = this.checkLangConsistency();
            if (langConsistencyStatus.getSeverity() == 4) {
                this.setErrorMessageWithStatus(langConsistencyStatus);
                this.validLangSelection = false;
            } else {
                this.setErrorMessage(null);
                this.validLangSelection = true;
                if (langConsistencyStatus.getSeverity() == 2 && applicabilityCheckStatus.getSeverity() == 2) {
                    CicMultiStatus resultStatus = Statuses.ST.createMultiStatus(com.ibm.cic.common.core.utils.Messages.MultipleWarnings, new Object[0]);
                    resultStatus.add(langConsistencyStatus);
                    resultStatus.add(applicabilityCheckStatus);
                    this.setWarningMessageWithStatus(this.localeLangWarningId, (IStatus)resultStatus);
                } else if (applicabilityCheckStatus.getSeverity() == 2) {
                    this.setWarningMessageWithStatus(this.localeLangWarningId, applicabilityCheckStatus);
                } else if (langConsistencyStatus.getSeverity() == 2) {
                    this.setWarningMessageWithStatus(this.localeLangWarningId, langConsistencyStatus);
                } else {
                    this.setWarningMessageWithStatus(this.localeLangWarningId, null);
                }
            }
        }
        this.getWizard().getContainer().updateButtons();
    }

    private IStatus checkLangConsistency() {
        ArrayList<String> selectedNonSupportedLangLabels = new ArrayList<String>();
        if (this.nonCommonLangButtonLabels != null && this.nonCommonLangButtonLabels.length > 0) {
            int commonLangBtnSize = this.commonLangButtonLabels.length;
            int i = 0;
            while (i < this.nonCommonLangButtonLabels.length) {
                String label;
                Set<String> codes;
                Button button = this.languageCheckBtns[i + commonLangBtnSize];
                if (button.getSelection() && (codes = this.buttonLabelCodeMap.get(button.getText())) != null && codes.size() > 0 && !selectedNonSupportedLangLabels.contains(label = this.codeLabelMap.get(codes.iterator().next()))) {
                    selectedNonSupportedLangLabels.add(label);
                }
                ++i;
            }
        }
        if (!selectedNonSupportedLangLabels.isEmpty()) {
            StringBuffer nonSupportedLangs = new StringBuffer((String)selectedNonSupportedLangLabels.get(0));
            String msg = NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.EnvironmentPage_nonSupportedLangMsg, (Object)nonSupportedLangs);
            if (selectedNonSupportedLangLabels.size() > 1) {
                int i = 1;
                while (i < selectedNonSupportedLangLabels.size()) {
                    nonSupportedLangs.append(", ");
                    nonSupportedLangs.append((String)selectedNonSupportedLangLabels.get(i));
                    ++i;
                }
                msg = NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.EnvironmentPage_nonSupportedLangsMsg, (Object)nonSupportedLangs.toString());
            }
            return new Status(2, "com.ibm.cic.agent.ui", msg);
        }
        return Status.OK_STATUS;
    }

    public boolean shouldSkip() {
        List selectedProductProfiles = this.wizard.getProductProfileList();
        if (selectedProductProfiles == null || selectedProductProfiles.isEmpty()) {
            return true;
        }
        this.populateShadowProfileList();
        if (this.shadowProfileList.isEmpty()) {
            return true;
        }
        return this.hasOnlyEnglishLocale();
    }

    protected boolean hasOnlyEnglishLocale() {
        this.checkAvailableLocaleLanguages();
        HashSet superSet = new HashSet(this.commonLanguages);
        superSet.addAll(this.nonCommonLanguages);
        if (superSet.size() == 1 && superSet.contains(LanguageCode.ENGLISH.getId())) {
            this.selectedLocaleLanguageCode.clear();
            this.selectedLocaleLanguageCode.add(LanguageCode.ENGLISH.getId());
            this.setLocaleLanguageSet(this.selectedLocaleLanguageCode);
            return true;
        }
        return false;
    }
}

