/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.utils.ProfileOfferingFeature;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.EclipseStyleLicensePage;
import com.ibm.cic.agent.internal.ui.wizards.LicenseImportCompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.LicenseImportPage;
import com.ibm.cic.agent.internal.ui.wizards.LicenseImportSummaryPage;
import com.ibm.cic.common.core.internal.LicenseFactory;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.ui.CICImages;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;

public class LicenseImportWizard
extends AgentUIWizard {
    private final ProfileOfferingFeature profileOfferingFeature;
    private final IOffering initPekOffering;
    private final RepositoryGroup licenseKitRepoGroup;

    public LicenseImportWizard(ProfileOfferingFeature pof, IOffering pekOffering) {
        super(null, null, CICImages.WIZ_LICENSES);
        this.profileOfferingFeature = pof;
        this.initPekOffering = pekOffering;
        this.licenseKitRepoGroup = new RepositoryGroup("LicenseImportWizard");
    }

    public IRepositoryGroup getLicenseRepositoryGroup() {
        return this.licenseKitRepoGroup;
    }

    public void addPages() {
        IOffering offering = this.profileOfferingFeature.getProfileOffering().getOffering();
        LicenseImportPage licenseImportPage = new LicenseImportPage(this.toolkit, this, offering, this.profileOfferingFeature.getFeatureOrGroup(), this.initPekOffering);
        this.addPage((IWizardPage)licenseImportPage);
        EclipseStyleLicensePage eclipseStyleLicensePage = new EclipseStyleLicensePage(this.toolkit, this, new LicenseFactory.License[0]);
        eclipseStyleLicensePage.setPageComplete(false);
        eclipseStyleLicensePage.setHelpRef("com.ibm.cic.agent.ui.EclipseStyleLicensePage");
        this.addPage((IWizardPage)eclipseStyleLicensePage);
        super.addPages();
        this.addPage((IWizardPage)new LicenseImportSummaryPage(this.toolkit, this));
    }

    protected AbstractJob createJob(IOfferingOrFix offeringOrFix, Map offeringFixProfileMap) {
        return null;
    }

    @Override
    protected String getRestartMessage() {
        return null;
    }

    @Override
    protected AbstractJob createJob(Profile profile, IOfferingOrFix offering) {
        return null;
    }

    @Override
    protected WizardType getWizardType() {
        return WizardType.LICENSE_MANAGEMENT;
    }

    @Override
    protected IStatus performTask(IProgressMonitor monitor) {
        boolean useWizardGroup;
        Agent agent = AgentUI.getDefault().getAgent();
        Profile licprofile = Profile.getLicenseProfile((Agent)agent);
        AgentJob[] installjobs = this.getJobsArray();
        ArrayList<AgentJob> installjobList = new ArrayList<AgentJob>();
        ArrayList<UninstallJob> uninstalljobList = new ArrayList<UninstallJob>();
        AgentJob[] agentJobArray = installjobs;
        int n = installjobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob installjob = agentJobArray[n2];
            IOffering offering = installjob.getOffering();
            if (offering != null && LicenseUtils.isPEKOffering((IOffering)offering)) {
                installjobList.add(installjob);
                if (AgentUtil.isPekInstalled((IOffering)offering)) {
                    IStatus status = RepositoryUtils.resolve((IOfferingOrFix)offering, (IProgressMonitor)new NullProgressMonitor());
                    if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                        return status;
                    }
                    uninstalljobList.add(new UninstallJob(licprofile, (IOfferingOrFix)offering));
                }
            }
            ++n2;
        }
        Agent.SetRestoreExternalAgentGroup agentGroupSetAndRestore = null;
        boolean bl = useWizardGroup = !this.getLicenseRepositoryGroup().getRepositories().isEmpty();
        if (useWizardGroup) {
            agentGroupSetAndRestore = new Agent.SetRestoreExternalAgentGroup(agent, this.getLicenseRepositoryGroup());
        }
        try {
            if (uninstalljobList.size() > 0) {
                agent.uninstall(uninstalljobList.toArray(new AgentJob[uninstalljobList.size()]), false, monitor);
            }
            Profile.getLicenseProfile((Agent)agent);
            IStatus status = agent.install(installjobList.toArray(new AgentJob[installjobList.size()]), monitor);
            this.licenseKitRepoGroup.removeAllRepositories();
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            if (agentGroupSetAndRestore != null) {
                agentGroupSetAndRestore.restorePreviousAgentGroup();
            }
        }
    }

    @Override
    public void setInput(Object[] items) {
    }

    public boolean isHelpAvailable() {
        return true;
    }

    @Override
    public CompletionPage createCompletionPage(IStatus succeeded) {
        return new LicenseImportCompletionPage(this.toolkit, this, succeeded);
    }
}

