/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.LocationCheckManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.SharedUIDependenciesCheckUtils;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIDependenciesCheckUtils;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.InstalledOfferingTreeFixNode;
import com.ibm.cic.agent.internal.ui.utils.InstalledOfferingTreePackageNode;
import com.ibm.cic.agent.internal.ui.utils.InstalledOfferingTreeProfileNode;
import com.ibm.cic.agent.internal.ui.utils.LicenseProfileFilter;
import com.ibm.cic.agent.internal.ui.utils.ProductProfileFilter;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIPrimaryPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.IInstalledOfferingsPage;
import com.ibm.cic.agent.internal.ui.wizards.InstalledOfferingSection;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryWizard;
import com.ibm.cic.agent.internal.ui.wizards.UninstallWizard;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class InstalledOfferingsPage
extends AbstractAgentUIPrimaryPage
implements IInstalledOfferingsPage {
    static final CustomMessageWizardPage.WarningId LOCATION_CHECK_WARNING = new CustomMessageWizardPage.WarningId();
    static final CustomMessageWizardPage.ErrorId LOCATION_CHECK_ERROR = new CustomMessageWizardPage.ErrorId();
    static final CustomMessageWizardPage.ErrorId VALIDATE_SELECTED_OFFERINGS_ERROR = new CustomMessageWizardPage.ErrorId();
    static final CustomMessageWizardPage.WarningId VALIDATE_SELECTED_OFFERINGS_WARNING = new CustomMessageWizardPage.WarningId();
    private InstalledOfferingSection offeringSection;
    private List jobs = null;
    private boolean validationSuccess = false;
    private IStatus locationCheckStatus;
    private List previousSelectedJobs = null;

    public InstalledOfferingsPage(String title, String description, PrimaryWizard wizard) {
        super(title, description, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.InstalledOfferingsPage");
    }

    private void createAllJobs() {
        Agent agent = Agent.getInstance();
        Profile[] profiles = agent.getVisibleProfiles();
        ProductProfileFilter profileFilter = new ProductProfileFilter();
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (profileFilter.select(null, null, profile)) {
                IOffering[] offerings = agent.getInstalledOfferings(profile);
                HashSet<IFix> fixSet = new HashSet<IFix>();
                IOffering[] iOfferingArray = offerings;
                int n3 = offerings.length;
                int n4 = 0;
                while (n4 < n3) {
                    IOffering offering = iOfferingArray[n4];
                    AbstractJob offeringJob = this.createJob(profile, (IOfferingOrFix)offering);
                    this.jobs.add(offeringJob);
                    IFix[] fixes = agent.getInstalledFixes(profile, offering);
                    int j = 0;
                    while (j < fixes.length) {
                        if (!fixSet.contains(fixes[j])) {
                            AbstractJob fixJob = this.createJob(profile, (IOfferingOrFix)fixes[j]);
                            this.jobs.add(fixJob);
                            fixSet.add(fixes[j]);
                        }
                        ++j;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    protected AgentUIWizard createInnerWizard() {
        UninstallWizard wizard = new UninstallWizard();
        return wizard;
    }

    protected AbstractJob createJob(Profile profile, IOfferingOrFix offering) {
        UninstallJob job = new UninstallJob(profile, offering);
        job.setSelected(false);
        return job;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.offeringSection = new InstalledOfferingSection(context, parent, this);
        return this.offeringSection;
    }

    public List getJobs() {
        return this.jobs;
    }

    @Override
    public IWizardPage getNextPage() {
        try {
            Status[] result = new Status[1];
            Object[] currentSelections = this.getSelections();
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress((IStatus[])result, currentSelections){
                private final /* synthetic */ IStatus[] val$result;
                private final /* synthetic */ Object[] val$currentSelections;
                {
                    this.val$result = iStatusArray;
                    this.val$currentSelections = objectArray;
                }

                public void run(IProgressMonitor monitor) {
                    this.val$result[0] = LocationCheckManager.getInstance().initializeAndPerform((AgentJob[])((AbstractJob[])this.val$currentSelections), monitor);
                }
            });
            this.setLocationCheckStatus((IStatus)result[0]);
            this.reportErrorOnPage((IStatus)result[0], LOCATION_CHECK_ERROR, LOCATION_CHECK_WARNING);
            if (StatusUtil.isErrorOrCancel((IStatus)result[0])) {
                return this;
            }
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
            return this;
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
            return this;
        }
        return super.getNextPage();
    }

    private CicMultiStatus performLocationPermissionCheck(AbstractJob[] selectedJobs) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        TreeSet<Profile> profiles = new TreeSet<Profile>(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Profile profile1 = (Profile)arg0;
                Profile profile2 = (Profile)arg1;
                return profile1.getProfileId().compareTo(profile2.getProfileId());
            }
        });
        AbstractJob[] abstractJobArray = selectedJobs;
        int n = selectedJobs.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractJob job = abstractJobArray[n2];
            Profile jobProfile = job.getProfile();
            if (jobProfile != null) {
                profiles.add(job.getProfile());
            }
            ++n2;
        }
        for (Profile profile : profiles) {
            status.add(AgentUtil.validateInstallDirectoryPermissions((String)profile.getInstallLocation()));
        }
        return status;
    }

    @Override
    public boolean isPageComplete() {
        return this.canFlipToNextPage();
    }

    @Override
    public boolean canFlipToNextPage() {
        if (super.canFlipToNextPage()) {
            return this.validationSuccess && !this.hasLocationCheckFailed();
        }
        return false;
    }

    protected boolean hasLocationCheckFailed() {
        if (this.locationCheckStatus == null) {
            return false;
        }
        return StatusUtil.isErrorOrCancel((IStatus)this.locationCheckStatus);
    }

    protected void setLocationCheckStatus(IStatus status) {
        this.locationCheckStatus = status;
    }

    protected void resetLocationCheckStatus() {
        this.locationCheckStatus = Status.OK_STATUS;
        this.setErrorState(LOCATION_CHECK_ERROR, null);
        this.setWarningState(LOCATION_CHECK_WARNING, null);
    }

    private IStatus prepareSelectedOfferings(List jobToPrepare, IProgressMonitor monitor) {
        ArrayList<IOfferingOrFix> offeringsToPrepare = new ArrayList<IOfferingOrFix>();
        if (jobToPrepare == null) {
            Object[] currentSelections;
            Object[] objectArray = currentSelections = this.getSelections();
            int n = currentSelections.length;
            int n2 = 0;
            while (n2 < n) {
                Object currentSelection = objectArray[n2];
                AbstractJob job = (AbstractJob)currentSelection;
                offeringsToPrepare.add(job.getOfferingOrFix());
                ++n2;
            }
        } else {
            int i = 0;
            while (i < jobToPrepare.size()) {
                AbstractJob job = (AbstractJob)jobToPrepare.get(i);
                offeringsToPrepare.add(job.getOfferingOrFix());
                ++i;
            }
        }
        if (!offeringsToPrepare.isEmpty()) {
            return SharedUIUtils.prepareOfferingsAndFixes(offeringsToPrepare, (IProgressMonitor)monitor);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected void setSelection(Object[] selectedObjects) {
        this.validationSuccess = false;
        super.setSelection(selectedObjects);
    }

    public void validateSelectedOfferings(final boolean isCheck) {
        try {
            final IStatus[] status = new IStatus[]{Status.OK_STATUS};
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    IStatus unloadStatus;
                    SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)8);
                    CicMultiStatus allStatus = Statuses.ST.createMultiStatus(com.ibm.cic.common.core.utils.Messages.MultipleWarnings, new Object[0]);
                    List<AbstractJob> currentSelectedJobList = Arrays.asList(InstalledOfferingsPage.this.getSelectedJobs());
                    List deselectedJobs = AgentUIUtils.getDeselectedJobs(InstalledOfferingsPage.this.previousSelectedJobs, currentSelectedJobList);
                    InstalledOfferingsPage.this.previousSelectedJobs = currentSelectedJobList;
                    if (!(isCheck || deselectedJobs == null || deselectedJobs.isEmpty() || (unloadStatus = Agent.getInstance().unloadAgentBundles((IProgressMonitor)sm.newChild(1, 0))).isOK())) {
                        AgentUI.reportStatus(unloadStatus, false);
                    }
                    status[0] = InstalledOfferingsPage.this.prepareSelectedOfferings(currentSelectedJobList, (IProgressMonitor)sm.newChild(1, 0));
                    allStatus.add(status[0]);
                    AbstractJob[] currentSelectedJobArray = (AbstractJob[])InstalledOfferingsPage.this.getSelections();
                    if (!StatusUtil.isErrorOrCancel((IStatus)status[0]) && currentSelectedJobArray != null) {
                        status[0] = InstalledOfferingsPage.this.performLocationPermissionCheck(currentSelectedJobArray);
                        allStatus.add(status[0]);
                    }
                    if (!StatusUtil.isErrorOrCancel((IStatus)status[0]) && currentSelectedJobArray != null) {
                        status[0] = BitModeUtils.check64bitImSupported((AgentJob[])currentSelectedJobArray);
                        allStatus.add(status[0]);
                    }
                    if (!StatusUtil.isErrorOrCancel((IStatus)status[0]) && currentSelectedJobArray != null) {
                        status[0] = AgentUIUtils.runPrecheckBundles(currentSelectedJobArray, false);
                        allStatus.add(status[0]);
                    }
                    sm.setWorkRemaining(6);
                    if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                        IStatus dependencyStatus;
                        if (currentSelectedJobArray != null && currentSelectedJobArray.length > 0) {
                            SubMonitor cm = sm.newChild(3, 0);
                            cm.beginTask(com.ibm.cic.agent.core.sharedUI.Messages.InstalledOfferingPage_validatePkgProgress, 3);
                            status[0] = Agent.getInstance().checkUninstall((AgentJob[])currentSelectedJobArray, (IProgressMonitor)cm.newChild(3));
                            allStatus.add(status[0]);
                        }
                        sm.setWorkRemaining(3);
                        if (!StatusUtil.isErrorOrCancel((IStatus)status[0]) && !(dependencyStatus = SharedUIDependenciesCheckUtils.checkDependenciesMultiFinalProfilesPrepareUnprepare((AgentJob[])currentSelectedJobArray, (IProgressMonitor)sm.newChild(3, 0))).isOK()) {
                            status[0] = AgentUIDependenciesCheckUtils.processDependencyStatus(dependencyStatus, true);
                            allStatus.add(status[0]);
                        }
                    }
                    if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                        status[0] = StatusUtil.toSingleStatus((IStatus)allStatus);
                    }
                    monitor.done();
                }
            });
            if (StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                this.validationSuccess = false;
                this.setWarningState(VALIDATE_SELECTED_OFFERINGS_WARNING, null);
                String errorMsg = status[0].getMessage().trim();
                if (errorMsg.length() > 0) {
                    this.setErrorStateWithStatus(VALIDATE_SELECTED_OFFERINGS_ERROR, status[0]);
                } else {
                    this.setErrorState(VALIDATE_SELECTED_OFFERINGS_ERROR, Messages.InstalledOfferingPage_cannotUninstallPkg);
                }
                if (status[0].isMultiStatus() && status[0].getChildren() != null && status[0].getChildren().length > 0) {
                    String message = null;
                    if (status[0].getMessage().trim().length() == 0) {
                        message = Messages.InstalledOfferingPage_cannotUninstallPkg;
                    }
                    WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(AgentUI.getActiveWorkbenchShell(), com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, message, status[0], 15);
                    errorDialog.open();
                }
            } else if (status[0].getSeverity() == 2) {
                this.validationSuccess = true;
                this.setErrorState(VALIDATE_SELECTED_OFFERINGS_ERROR, null);
                this.setWarningMessageWithStatus(VALIDATE_SELECTED_OFFERINGS_WARNING, status[0]);
            } else {
                this.validationSuccess = true;
                this.setErrorState(VALIDATE_SELECTED_OFFERINGS_ERROR, null);
                this.setWarningMessageWithStatus(VALIDATE_SELECTED_OFFERINGS_WARNING, null);
            }
            if (this.getContainer().getCurrentPage() == this) {
                this.getContainer().updateButtons();
            }
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    protected AbstractJob[] getSelectedJobs() {
        ArrayList<AbstractJob> selectedJobs = new ArrayList<AbstractJob>();
        for (AbstractJob job : this.getJobs()) {
            if (!job.isSelected()) continue;
            selectedJobs.add(job);
        }
        return selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
    }

    @Override
    protected void setInput(Object[] items) {
        this.jobs = new ArrayList();
        if (items == null) {
            this.createAllJobs();
        } else {
            LicenseProfileFilter profileFilter = new LicenseProfileFilter();
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile;
                Object item = objectArray[n2];
                if (item instanceof UninstallJob && profileFilter.select(null, null, profile = ((UninstallJob)item).getProfile())) {
                    this.jobs.add(item);
                }
                ++n2;
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.offeringSection.setFocus();
        }
        super.setVisible(visible);
    }

    @Override
    public void defaultChecked() {
        this.setSelection(this.getSelectedJobs());
        if (AgentInput.getInstance().getMode() == 1) {
            this.validateSelectedOfferings(true);
        }
    }

    @Override
    public void checkStatusChanged(boolean checked) {
        this.setSelection(this.getSelectedJobs());
        this.resetLocationCheckStatus();
        this.validateSelectedOfferings(checked);
    }

    @Override
    public Map<Profile, InstalledOfferingTreeProfileNode> generateInput() {
        HashMap<Profile, InstalledOfferingTreeProfileNode> profileMap = new HashMap<Profile, InstalledOfferingTreeProfileNode>();
        int size = this.jobs.size();
        int i = 0;
        while (i < size) {
            AbstractJob job = (AbstractJob)this.jobs.get(i);
            Profile profile = job.getProfile();
            InstalledOfferingTreeProfileNode profileNode = (InstalledOfferingTreeProfileNode)profileMap.get(profile);
            if (profileNode == null) {
                profileNode = new InstalledOfferingTreeProfileNode(profile);
                profileMap.put(profile, profileNode);
                this.createPackageFixNodes(profileNode);
            }
            ++i;
        }
        return profileMap;
    }

    private void createPackageFixNodes(InstalledOfferingTreeProfileNode profileNode) {
        IOffering[] offerings;
        Profile profile = profileNode.getProfile();
        IOffering[] iOfferingArray = offerings = Agent.getInstance().getInstalledOfferings(profile);
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IFix[] fixes;
            IOffering offering = iOfferingArray[n2];
            AbstractJob offeringJob = this.findJob(profile, (IOfferingOrFix)offering);
            InstalledOfferingPackageNode pkgNode = new InstalledOfferingPackageNode(offeringJob, profileNode);
            profileNode.addPackage(pkgNode);
            IFix[] iFixArray = fixes = Agent.getInstance().getInstalledFixes(profile, offering);
            int n3 = fixes.length;
            int n4 = 0;
            while (n4 < n3) {
                IFix fix = iFixArray[n4];
                AbstractJob fixJob = this.findJob(profile, (IOfferingOrFix)fix);
                InstalledOfferingFixNode fixNode = new InstalledOfferingFixNode(fixJob, (InstalledOfferingTreePackageNode)pkgNode);
                pkgNode.addFix(fixNode);
                ++n4;
            }
            ++n2;
        }
    }

    private AbstractJob findJob(Profile profile, IOfferingOrFix offeringOrFix) {
        List wizardJobs = this.getJobs();
        for (AbstractJob job : wizardJobs) {
            if (!profile.equals(job.getProfile()) || !offeringOrFix.equals(job.getOfferingOrFix())) continue;
            return job;
        }
        AbstractJob newJob = this.createJob(profile, offeringOrFix);
        wizardJobs.add(newJob);
        return newJob;
    }

    @Override
    public boolean fixDependOnOffering() {
        return true;
    }

    private static class InstalledOfferingFixNode
    extends InstalledOfferingTreeFixNode {
        private final AbstractJob fixJob;

        public InstalledOfferingFixNode(AbstractJob job, InstalledOfferingTreePackageNode parent) {
            super(job.getFix(), parent);
            this.fixJob = job;
        }

        @Override
        public Object getAdapter(Class adapter) {
            if (adapter == AbstractJob.class) {
                return this.fixJob;
            }
            return super.getAdapter(adapter);
        }

        @Override
        public boolean isSelected() {
            return this.fixJob.isSelected();
        }

        @Override
        public void setSelected(boolean selected) {
            this.fixJob.setSelected(selected);
        }
    }

    private static class InstalledOfferingPackageNode
    extends InstalledOfferingTreePackageNode {
        private final AbstractJob offeringJob;

        public InstalledOfferingPackageNode(AbstractJob job, InstalledOfferingTreeProfileNode profileNode) {
            super(job.getOffering(), profileNode);
            this.offeringJob = job;
        }

        @Override
        public Object getAdapter(Class adapter) {
            if (adapter == AbstractJob.class) {
                return this.offeringJob;
            }
            return super.getAdapter(adapter);
        }

        @Override
        public boolean isSelected() {
            return this.offeringJob.isSelected();
        }

        @Override
        public void setSelected(boolean selected) {
            this.offeringJob.setSelected(selected);
        }
    }
}

