/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.factories.LauncherFactory;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.InstallAgentUtils;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultContentProvider;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultLabelProvider;
import com.ibm.cic.agent.internal.ui.utils.UpdateResultTreeViewerSorter;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.RebootCompletionPage;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.RebootRequest;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class InstallCompletionPage
extends RebootCompletionPage {
    protected Label installedPkgLabel;
    protected Label launcherOrNotInstalledPkgLabel;
    protected TreeViewer installedPkgViewer;
    protected TreeViewer notInstalledPkgViewer;
    private Label installIMLabel;
    private Label restartIMLabel;
    protected List installedAgentNProductJobs = new ArrayList();
    protected List notInstalledJobs = new ArrayList();
    private boolean isIMInstalled = false;

    public InstallCompletionPage(FormToolkit toolkit, AgentUIWizard wizard, IStatus status) {
        super(toolkit, Messages.InstallCompletionPage_title, "", wizard, status);
        super.setHelpRef("com.ibm.cic.agent.ui.InstallCompletionPage");
    }

    private boolean displayLaunchers() {
        return this.notInstalledJobs.isEmpty() && this.hasLauncherAndNoRebootRequested;
    }

    private boolean displayTwoColumns() {
        return this.displayLaunchers() || !this.installedAgentNProductJobs.isEmpty() && !this.notInstalledJobs.isEmpty();
    }

    @Override
    protected Composite createDetailControl(Composite container) {
        this.checkInstalledJobs();
        this.checkExistence();
        this.hasLauncherAndNoRebootRequested = !this.launchers.isEmpty() && !RebootRequest.isSet();
        Composite comp = this.getToolkit().createComposite(container);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        Label fillerLabel1 = this.getToolkit().createLabel(comp, "");
        GridData gd = new GridData();
        int fillerWidth = 0;
        fillerWidth = this.displayTwoColumns() ? 20 : 150;
        gd.widthHint = fillerWidth;
        fillerLabel1.setLayoutData((Object)gd);
        Composite detailComp = this.getToolkit().createComposite(comp);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        if (this.displayTwoColumns()) {
            gridLayout.numColumns = 2;
            gridLayout.makeColumnsEqualWidth = true;
        }
        detailComp.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        detailComp.setLayoutData((Object)data);
        int detailCompNumColumns = gridLayout.numColumns;
        this.createDetailResultTextControl(detailComp, detailCompNumColumns);
        Composite labelComp = this.getToolkit().createComposite(detailComp);
        GridData compGridData = new GridData();
        compGridData.grabExcessHorizontalSpace = true;
        compGridData.horizontalAlignment = 4;
        compGridData.horizontalSpan = detailCompNumColumns;
        labelComp.setLayoutData((Object)compGridData);
        GridLayout compLayout = new GridLayout();
        compLayout.marginBottom = 0;
        compLayout.verticalSpacing = 0;
        if (this.displayTwoColumns()) {
            compLayout.numColumns = 2;
            compLayout.makeColumnsEqualWidth = true;
            compLayout.horizontalSpacing = 10;
        }
        labelComp.setLayout((Layout)compLayout);
        this.installedPkgLabel = this.getToolkit().createLabel(labelComp, "", 64);
        GridData gridData = new GridData();
        gridData.widthHint = 300;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.installedPkgLabel.setLayoutData((Object)gridData);
        if (this.displayTwoColumns()) {
            this.launcherOrNotInstalledPkgLabel = this.getToolkit().createLabel(labelComp, "");
            gridData = new GridData();
            gridData.widthHint = 300;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 1;
            gridData.grabExcessHorizontalSpace = true;
            this.launcherOrNotInstalledPkgLabel.setLayoutData((Object)gridData);
        }
        Composite treeComp = this.getToolkit().createComposite(detailComp);
        compGridData = new GridData(4, 4, true, true);
        compGridData.horizontalSpan = detailCompNumColumns;
        treeComp.setLayoutData((Object)compGridData);
        compLayout = new GridLayout();
        if (this.displayTwoColumns()) {
            compLayout.numColumns = 2;
            compLayout.makeColumnsEqualWidth = true;
            compLayout.horizontalSpacing = 10;
        }
        treeComp.setLayout((Layout)compLayout);
        int style = 101124;
        this.installedPkgViewer = new TreeViewer(treeComp, style);
        this.getToolkit().adapt(this.installedPkgViewer.getControl(), true, true);
        gd = new GridData(1808);
        gd.heightHint = this.installedPkgViewer.getTree().getItemHeight() * 6;
        gd.widthHint = 300;
        this.installedPkgViewer.getTree().setLayoutData((Object)gd);
        this.installedPkgViewer.getTree().setLinesVisible(false);
        this.configureInstalledPkgViewer();
        this.installedPkgViewer.setInput(null);
        if (this.displayTwoColumns()) {
            if (this.displayLaunchers()) {
                this.launcherOrNotInstalledPkgLabel.setText(Messages.InstallCompletionPage_launchPkgLabel);
                this.launcherButtons = new ArrayList();
                ScrolledComposite scrolled = new ScrolledComposite(treeComp, 2816);
                scrolled.setExpandHorizontal(true);
                scrolled.setExpandVertical(true);
                scrolled.setLayoutData((Object)new GridData(1808));
                Composite buttonsComp = new Composite((Composite)scrolled, 0);
                buttonsComp.setLayout((Layout)new GridLayout());
                buttonsComp.setLayoutData((Object)new GridData(1808));
                buttonsComp.setBackground(treeComp.getBackground());
                for (LauncherFactory.Launcher launcher : this.launchers) {
                    Button btn = this.getToolkit().createButton(buttonsComp, launcher.getLabel(), 16);
                    this.launcherButtons.add(btn);
                    if (!Agent.getInstance().isSkipInstall()) continue;
                    btn.setEnabled(false);
                }
                Button btn = this.getToolkit().createButton(buttonsComp, Messages.InstallCompletionPage_notLaunchPkgButton, 16);
                this.launcherButtons.add(btn);
                if (Agent.getInstance().isSkipInstall()) {
                    btn.setEnabled(false);
                    btn.setSelection(true);
                } else if (!this.launcherButtons.isEmpty()) {
                    ((Button)this.launcherButtons.get(0)).setSelection(true);
                }
                scrolled.setContent((Control)buttonsComp);
                scrolled.setMinSize(buttonsComp.computeSize(-1, -1));
            } else {
                style = 101124;
                this.notInstalledPkgViewer = new TreeViewer(treeComp, style);
                this.getToolkit().adapt(this.notInstalledPkgViewer.getControl(), true, true);
                gd = new GridData(1808);
                gd.heightHint = this.notInstalledPkgViewer.getTree().getItemHeight() * 6;
                gd.widthHint = 300;
                this.notInstalledPkgViewer.getTree().setLayoutData((Object)gd);
                this.notInstalledPkgViewer.getTree().setLinesVisible(false);
                this.configureNotInstalledPkgViewer();
                this.notInstalledPkgViewer.setInput(null);
            }
        }
        if (this.isIMInstalled && this.installedAgentNProductJobs.size() > 1 && !AgentUI.getDefault().getAgent().isRecordMode()) {
            Label fillerLabel = this.getToolkit().createLabel(detailComp, "");
            gd = new GridData();
            gd.horizontalSpan = detailCompNumColumns;
            fillerLabel.setLayoutData((Object)gd);
            Profile profile = (Profile)this.getAgentWizard().getAgentProfileList().get(0);
            this.installIMLabel = this.getToolkit().createLabel(detailComp, "", 64);
            String processedIMLocation = TextProcessor.process((String)profile.getInstallLocation());
            this.installIMLabel.setText(NLS.bind((String)Messages.InstallCompletionPage_imInstalled, (Object)processedIMLocation));
            gd = new GridData();
            gd.widthHint = 300;
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = detailCompNumColumns;
            this.installIMLabel.setLayoutData((Object)gd);
        }
        if (this.isIMInstalled && this.installedAgentNProductJobs.size() == 1 && this.notInstalledJobs.isEmpty() && !AgentUI.getDefault().getAgent().isRecordMode()) {
            this.restartIMLabel = this.getToolkit().createLabel(detailComp, Messages.InstallCompletionPage_restartNewIM, 64);
            gd = new GridData();
            gd.widthHint = 300;
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = detailCompNumColumns;
            this.restartIMLabel.setLayoutData((Object)gd);
        }
        Label fillerLabel2 = this.getToolkit().createLabel(comp, "");
        gd = new GridData();
        gd.widthHint = fillerWidth;
        fillerLabel2.setLayoutData((Object)gd);
        return detailComp;
    }

    protected void configureInstalledPkgViewer() {
        this.installedPkgViewer.setContentProvider((IContentProvider)new UpdateResultContentProvider(false));
        this.installedPkgViewer.setLabelProvider((IBaseLabelProvider)new UpdateResultLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        this.installedPkgViewer.setSorter((ViewerSorter)new UpdateResultTreeViewerSorter());
    }

    protected void configureNotInstalledPkgViewer() {
        this.notInstalledPkgViewer.setContentProvider((IContentProvider)new UpdateResultContentProvider(false));
        this.notInstalledPkgViewer.setLabelProvider((IBaseLabelProvider)new UpdateResultLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        this.notInstalledPkgViewer.setSorter((ViewerSorter)new UpdateResultTreeViewerSorter());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.showResultText();
            this.showInstallDetails();
            this.reflowFor((Control)this.resultText);
            this.reflowFor((Control)this.installedPkgViewer.getTree());
            this.reflowFor(this.getControl());
            this.installedPkgViewer.expandAll();
            if (this.notInstalledPkgViewer != null) {
                this.notInstalledPkgViewer.expandAll();
            }
        }
        super.setVisible(visible);
    }

    private void showResultText() {
        if (this.result == 0) {
            this.resultText.setText(Messages.InstallCompletionPage_result_success);
        } else if (this.result == 3) {
            this.resultText.setText(Messages.InstallCompletionPage_result_completeWithWarning);
        } else if (this.result == 2) {
            this.resultText.setText(Messages.InstallCompletionPage_result_cancel);
        } else if (this.offeringsInstalled) {
            this.resultText.setText(Messages.InstallCompletionPage_result_completeWithError);
        } else {
            this.resultText.setText(Messages.InstallCompletionPage_result_fail);
        }
    }

    protected String getInstalledPkgLabel(boolean singlePkg) {
        if (singlePkg) {
            return Messages.InstallCompletionPage_installedPkgLabel;
        }
        return Messages.InstallCompletionPage_installedPkgsLabel;
    }

    protected void showInstallDetails() {
        if (this.installedAgentNProductJobs.size() > 0) {
            Map map;
            if (this.installedAgentNProductJobs.size() > 1) {
                List installedProductJobs = InstallAgentUtils.getSelectedJobsWithoutAgentJob(this.installedAgentNProductJobs);
                if (installedProductJobs.size() > 1) {
                    this.installedPkgLabel.setText(this.getInstalledPkgLabel(false));
                } else {
                    this.installedPkgLabel.setText(this.getInstalledPkgLabel(true));
                }
            } else {
                this.installedPkgLabel.setText(this.getInstalledPkgLabel(true));
            }
            if (this.installedAgentNProductJobs.size() > 1) {
                map = AgentUIUtils.generateProfileJobFeatureTree(InstallAgentUtils.getSelectedJobsWithoutAgentJob(this.installedAgentNProductJobs));
                this.installedPkgViewer.setInput(map.values());
            } else {
                map = AgentUIUtils.generateProfileJobFeatureTree(this.installedAgentNProductJobs);
                this.installedPkgViewer.setInput(map.values());
            }
            this.installedPkgViewer.addFilter((ViewerFilter)new PekFilter());
            if (this.notInstalledJobs.size() > 0) {
                if (this.notInstalledJobs.size() > 1) {
                    this.launcherOrNotInstalledPkgLabel.setText(Messages.InstallCompletionPage_installPkgsFailLabel);
                } else {
                    this.launcherOrNotInstalledPkgLabel.setText(Messages.InstallCompletionPage_installPkgFailLabel);
                }
                map = AgentUIUtils.generateProfileJobFeatureTree(this.notInstalledJobs);
                this.notInstalledPkgViewer.setInput(map.values());
                this.notInstalledPkgViewer.addFilter((ViewerFilter)new PekFilter());
            }
        } else if (this.notInstalledJobs.size() > 0) {
            if (this.notInstalledJobs.size() > 1) {
                this.installedPkgLabel.setText(Messages.InstallCompletionPage_installPkgsFailLabel);
            } else {
                this.installedPkgLabel.setText(Messages.InstallCompletionPage_installPkgFailLabel);
            }
            Map map = AgentUIUtils.generateProfileJobFeatureTree(this.notInstalledJobs);
            this.installedPkgViewer.setInput(map.values());
            this.installedPkgViewer.addFilter((ViewerFilter)new PekFilter());
        }
        this.installedPkgLabel.getParent().layout();
    }

    public void setLaunchers(Map offeringLauncherMap) {
        LinkedHashSet<LauncherFactory.Launcher> launcherSet = new LinkedHashSet<LauncherFactory.Launcher>();
        List jobs = this.getSelectedJobs();
        for (AbstractJob job : jobs) {
            IOffering offering = job.getOffering();
            List launcherList = (List)offeringLauncherMap.get(offering);
            if (launcherList == null) continue;
            int j = 0;
            while (j < launcherList.size()) {
                LauncherFactory.Launcher launcher = (LauncherFactory.Launcher)launcherList.get(j);
                launcher.setProfile(job.getProfile());
                launcherSet.add(launcher);
                ++j;
            }
        }
        this.launchers = LauncherFactory.Launcher.reorder(launcherSet);
    }

    private void checkInstalledJobs() {
        this.installedAgentNProductJobs.clear();
        this.notInstalledJobs.clear();
        List selectedJobsToInstall = this.getSelectedJobs();
        int i = 0;
        while (i < selectedJobsToInstall.size()) {
            AbstractJob job = (AbstractJob)selectedJobsToInstall.get(i);
            Profile profile = job.getProfile();
            if (!profile.getProfileKind().equals("license")) {
                if (profile.getProfileKind().equals("self")) {
                    IOffering imOffering = job.getOffering();
                    if (imOffering != null) {
                        IOffering installedIMOffering = Agent.getInstance().getInstalledOffering(profile, imOffering.getIdentity());
                        if (installedIMOffering != null && installedIMOffering.getVersion().equals((Object)imOffering.getVersion())) {
                            this.isIMInstalled = true;
                            this.installedAgentNProductJobs.add(job);
                        } else {
                            this.notInstalledJobs.add(job);
                        }
                    }
                } else {
                    IOffering offering = job.getOffering();
                    IFix fix = job.getFix();
                    if (offering != null) {
                        IOffering installedOffering = Agent.getInstance().getInstalledOffering(profile, offering.getIdentity());
                        if (installedOffering != null && installedOffering.getVersion().equals((Object)offering.getVersion())) {
                            this.installedAgentNProductJobs.add(job);
                        } else {
                            this.notInstalledJobs.add(job);
                        }
                    } else if (fix != null) {
                        if (AgentUIUtils.isFixInstalled(fix, profile)) {
                            this.installedAgentNProductJobs.add(job);
                        } else {
                            this.notInstalledJobs.add(job);
                        }
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void performDone() {
        if (this.rebootNow()) {
            PlatformUtils.reboot();
        } else {
            Profile newProfile;
            if (RebootRequest.isSet()) {
                RebootRequest.setRebootLater();
            }
            if (this.notInstalledJobs.isEmpty() && !this.launchers.isEmpty() && !RebootRequest.isSet()) {
                this.launchSelected();
            }
            if (this.notInstalledJobs.isEmpty() && !AgentUI.getDefault().getAgent().isRecordMode() && (newProfile = this.getSelectedAgentProfile()) != null) {
                if (AgentInput.getInstance().getMode() == 1) {
                    List selectedJobs = this.getSelectedJobs();
                    if (selectedJobs.size() == 1) {
                        List jobs = this.getJobs();
                        if (jobs.size() == 1) {
                            AbstractJob job = (AbstractJob)jobs.get(0);
                            AgentInstall.getInstance().setPostAgentInstallInput((AgentJob)job);
                        }
                        AgentRelaunch.getInstance().setNeedsRelaunch(true);
                    }
                } else {
                    DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            UiServices.getInstance().restartWorkbench();
                        }
                    });
                }
            }
        }
    }

    private Profile getSelectedAgentProfile() {
        List selectedJobs = this.getSelectedJobs();
        int i = 0;
        while (i < selectedJobs.size()) {
            AbstractJob job = (AbstractJob)selectedJobs.get(i);
            Profile profile = job.getProfile();
            if (profile != null && profile.isAgentProfile()) {
                return profile;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected String getRebootRequestLabel() {
        return com.ibm.cic.agent.core.sharedUI.Messages.RebootCompletionPage_rebootInstallLabel;
    }

    @Override
    protected void createConfigureLicenseControl(Composite container) {
        if (this.notInstalledJobs.isEmpty() && CmdLine.CL.isLiveInput() && AgentInput.getInstance().isNeedConfigureFloatingLicense() && !AgentUtil.onlyInstallAgent((List)this.getSelectedJobs())) {
            Composite configureLicenseComp = this.getToolkit().createComposite(container);
            configureLicenseComp.setLayout((Layout)new GridLayout());
            GridData data = new GridData(4, 4, true, false);
            if (this.hasLauncherAndNoRebootRequested) {
                data.horizontalSpan = 2;
            }
            configureLicenseComp.setLayoutData((Object)data);
            Label configureLicenseLabel = this.getToolkit().createLabel(configureLicenseComp, Messages.InstallCompletionPage_configLicenseMsg, 64);
            configureLicenseLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        }
    }

    @Override
    protected void createSpaceNoticeControl(Composite container) {
        if (this.needCreateSpaceNoticeControl()) {
            List selectedJobs;
            Layout layout = container.getLayout();
            int numSpan = 1;
            if (layout instanceof GridLayout) {
                numSpan = ((GridLayout)layout).numColumns;
            }
            if (AgentUtil.hasInstallAgentJob((List)(selectedJobs = this.getSelectedJobs()))) {
                Label separatorLabel = this.getToolkit().createLabel(container, "", 258);
                GridData gd = new GridData(4, 1, true, false);
                gd.horizontalSpan = numSpan;
                gd.verticalIndent = 10;
                separatorLabel.setLayoutData((Object)gd);
            }
            final Link noteLink = new Link(container, 64);
            this.getToolkit().adapt((Control)noteLink, false, false);
            noteLink.setText(Messages.FeatureSelectionPage_noteLabel);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.widthHint = 250;
            gridData.horizontalSpan = numSpan;
            noteLink.setLayoutData((Object)gridData);
            noteLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)noteLink.getShell(), (String)"com.ibm.cic.agent.ui.DownloadCachePage", (String[])new String[]{"com.ibm.cic.agent.ui.DownloadCachePage"}, null);
                    dlg.open();
                }
            });
            this.createSpaceNoticeControl = true;
        }
    }

    @Override
    public String getCompletionPageFinishLabel() {
        if (this.notInstalledJobs.isEmpty() && AgentUtil.onlyInstallAgent((List)this.getSelectedJobs()) && !AgentUI.getDefault().getAgent().isRecordMode()) {
            return Messages.InstallCompletionPage_restartImFinishLabel;
        }
        return super.getCompletionPageFinishLabel();
    }

    private static class PekFilter
    extends ViewerFilter {
        private PekFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof InstallJob) {
                InstallJob job = (InstallJob)element;
                IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
                if (offeringOrFix instanceof IFix) {
                    return true;
                }
                IOffering offering = job.getOffering();
                return offering != null && !LicenseUtils.isPEKOffering((IOffering)offering);
            }
            return true;
        }
    }
}

