/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SpaceInfoUtils;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.FeatureViewerSorter;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.UpdateWizard;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IllegalFeatureStateException;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.FormatUtil;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.dialogs.YesNoErrorDialog;
import com.ibm.cic.common.ui.parts.CheckboxTreePart;
import com.ibm.cic.common.ui.parts.TreePart;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class FeatureSelectionPage
extends AbstractAgentUIWizardPage {
    static final CustomMessageWizardPage.ErrorId NO_ENOUGH_SPACE_ERROR = new CustomMessageWizardPage.ErrorId();
    static final CustomMessageWizardPage.ErrorId OFFERING_INTERDEPENDENCY_ERROR = new CustomMessageWizardPage.ErrorId();
    static final CustomMessageWizardPage.WarningId OFFERING_INTERDEPENDENCY_WARNING = new CustomMessageWizardPage.WarningId();
    static final CustomMessageWizardPage.ErrorId OFFERING_FEATURESELECTION_ERROR = new CustomMessageWizardPage.ErrorId();
    static final CustomMessageWizardPage.ErrorId OFFERING_NOFEATURESELECTED_ERROR = new CustomMessageWizardPage.ErrorId();
    static final CustomMessageWizardPage.WarningId OFFERING_APPLICABILITY_WARNING = new CustomMessageWizardPage.WarningId();
    static final CustomMessageWizardPage.ErrorId OFFERING_APPLICABILITY_ERROR = new CustomMessageWizardPage.ErrorId();
    static final CustomMessageWizardPage.ErrorId RESOLVE_FEATURE_ERROR = new CustomMessageWizardPage.ErrorId();
    private static final String COLOR_RED = "red";
    private FormText detailsDesc;
    private Label detailsTitleLabel;
    private TreeViewer featureDependencyViewer;
    private CheckboxTreeViewer featureTreeViewer;
    private Object previousSelection;
    private Table diskSpaceTable;
    private TableItem commonLocationSizeTableItem;
    private List installLocationSizeTableItems;
    private FeatureDependencyContentProvider featureDependencyContentProvider;
    private BasicFeatureLabelProvider featureDependencyLabelProvider;
    private FeatureGroupContentProvider featureContentProvider;
    private FeatureLabelProvider featureLabelProvider;
    private final Map jobToDefaultFeatureSet = new HashMap();
    private HashMap featuresMap = new HashMap();
    private final HashMap jobsToGroupMap = new HashMap();
    private ArrayList selectedJobs;
    private List selectedProductJobs;
    private HashSet uncheckedDependents;
    private HashMap jobToNewFeaturesMap;
    private int selectMode = 2;
    private boolean selectRecommendedByDefault = false;
    private String lastProfileSignature = null;
    private boolean hasLicensedFeatures = false;
    private boolean hasNewVisibleFeature = false;
    List eclipseCacheLocationSizeList = null;
    Map installLocationSizeMap = null;
    boolean hasZeroFeatureSelectionError = false;
    boolean hasOfferingInterdependenciesError = false;
    boolean hasNoEnoughtSpaceError = false;
    boolean hasOfferingApplicabilityError = false;
    boolean validatingSelectedFeaturesWasCanceled = false;
    boolean delayFeatureValidation = false;
    boolean performValidationOnNextButton = false;
    private StackLayout spaceLayout;
    private Composite noDiskSpaceComp;
    private Composite diskSpaceTableComp;

    public FeatureSelectionPage(FormToolkit toolkit, String title, String description, AgentUIWizard wizard, boolean selectRecommended) {
        super(toolkit, title, description, wizard);
        this.selectRecommendedByDefault = selectRecommended;
    }

    private void addToFeatureMap(FeatureNode featureNode) {
        AbstractJob job = this.findJob(featureNode);
        if (job != null) {
            HashMap<IFeature, FeatureNode> featureToNodeMap = (HashMap<IFeature, FeatureNode>)this.featuresMap.get(job);
            if (featureToNodeMap == null) {
                featureToNodeMap = new HashMap<IFeature, FeatureNode>();
                this.featuresMap.put(job, featureToNodeMap);
            }
            featureToNodeMap.put(featureNode.getFeature(), featureNode);
        }
    }

    private void checkAllFeatures(List jobs, boolean checked, int selectionMode) {
        int i = 0;
        while (i < jobs.size()) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            Object[] children = (Object[])this.jobsToGroupMap.get(job);
            if (children != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    HashSet unselectDependencies = new HashSet();
                    List closure = job.findClosure(((FeatureGroupNode)element).getFeatureGroup(), checked, unselectDependencies, selectionMode);
                    this.checkFeatures(closure, (AgentJob)job, checked);
                    if (checked) {
                        List exclusion = job.findExclusionFeatures(closure);
                        this.checkFeatures(exclusion, (AgentJob)job, false);
                    }
                    ++n2;
                }
            }
            ++i;
        }
    }

    private void checkDefaultFeatures(boolean restoreDefaultButton) {
        TreeItem[] rootItems;
        this.resetFeatureSelections(this.selectedJobs);
        this.selectMode = 2;
        if (restoreDefaultButton) {
            this.checkAllFeatures(this.selectedJobs, false, this.selectMode);
        }
        if (this.jobToDefaultFeatureSet.size() > 0) {
            ArrayList jobsNotInResponseFile = new ArrayList();
            this.checkDefaultFeaturesFromResponseFile(jobsNotInResponseFile);
            if (jobsNotInResponseFile.size() > 0) {
                if (this.selectRecommendedByDefault) {
                    this.checkRecommendedFeatures(jobsNotInResponseFile);
                } else {
                    this.checkInstalledFeatures(jobsNotInResponseFile);
                }
            }
        } else if (this.selectRecommendedByDefault) {
            this.checkRecommendedFeatures(this.selectedJobs);
        } else {
            this.checkInstalledFeatures(this.selectedJobs);
        }
        if ((rootItems = this.featureTreeViewer.getTree().getItems()) != null) {
            TreeItem[] treeItemArray = rootItems;
            int n = rootItems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem rootItem = treeItemArray[n2];
                boolean checked = this.featureTreeViewer.getChecked(rootItem.getData());
                boolean grayed = this.featureTreeViewer.getGrayed(rootItem.getData());
                if (!checked && !grayed) {
                    this.featureTreeViewer.setGrayChecked(rootItem.getData(), true);
                }
                ++n2;
            }
        }
        if (restoreDefaultButton && this.delayFeatureValidation) {
            this.clearValidationResult();
        } else {
            DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FeatureSelectionPage.this.validateCheckedFeatures(true);
                    IStatus featureSelectionStatus = FeatureSelectionPage.this.getFeatureSelectionStatus();
                    if (StatusUtil.isErrorOrCancel((IStatus)featureSelectionStatus)) {
                        FeatureSelectionPage.this.setPageComplete(false);
                        FeatureSelectionPage.this.setErrorStateWithStatus(OFFERING_FEATURESELECTION_ERROR, FeatureSelectionPage.this.fixStatusMsg(featureSelectionStatus));
                    } else {
                        FeatureSelectionPage.this.setErrorState(OFFERING_FEATURESELECTION_ERROR, null);
                    }
                }
            });
        }
    }

    private IStatus getFeatureSelectionStatus() {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        for (AgentJob job : this.selectedJobs) {
            IStatus status = job.getFeatureSelectionStatus();
            if (!status.matches(4)) continue;
            result.add(status);
        }
        return result;
    }

    private void checkFeatures(Collection featureCollection, AgentJob job, boolean checked) {
        HashMap featureToNodeMap = (HashMap)this.featuresMap.get(job);
        for (IFeatureBase item : featureCollection) {
            AbstractNode node = (AbstractNode)featureToNodeMap.get(item);
            if (!checked) {
                if (job.getDependencySelectedFeatures().contains(item)) continue;
                this.updateParents(this.featureTreeViewer, node, checked);
                continue;
            }
            if (job.getUserSelectedFeatures().contains(item)) {
                this.updateParents(this.featureTreeViewer, node, checked);
                continue;
            }
            if (!job.getDependencySelectedFeatures().contains(item)) continue;
            this.selectElementPlusParents(this.featureTreeViewer, node, checked);
        }
        if (!featureCollection.isEmpty()) {
            HashSet featuresSet = new HashSet();
            featuresSet.addAll(featureCollection);
            featuresSet.addAll(job.getUserSelectedFeatures());
            featuresSet.addAll(job.getDependencySelectedFeatures());
            for (IFeatureBase item : featuresSet) {
                AbstractNode node = (AbstractNode)featureToNodeMap.get(item);
                this.featureTreeViewer.update((Object)node, null);
            }
        }
    }

    private void checkDefaultFeaturesFromResponseFile(List jobsNotHaveFeaturesInResponseFile) {
        int i = 0;
        while (i < this.selectedJobs.size()) {
            AbstractJob job = (AbstractJob)this.selectedJobs.get(i);
            HashMap featureToNodeMap = (HashMap)this.featuresMap.get(job);
            if (featureToNodeMap != null && !featureToNodeMap.isEmpty()) {
                Set features = (Set)this.jobToDefaultFeatureSet.get(job);
                job.resetFeatureSelectionSet();
                if (features != null && !features.isEmpty()) {
                    this.calculateDependencyForDefaultSelectedFeatures((AgentJob)job, features);
                    this.checkFeatures(features, (AgentJob)job, true);
                } else {
                    jobsNotHaveFeaturesInResponseFile.add(job);
                }
            }
            ++i;
        }
    }

    private void checkInstalledFeatures(List jobs) {
        Agent agent = AgentUI.getDefault().getAgent();
        int i = 0;
        while (i < jobs.size()) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            if (!job.isInstall()) {
                IFeature[] defaultSelectedFeatures;
                UpdateOfferingJob updateJob;
                IOffering newVersionOffering;
                job.resetFeatureSelectionSet();
                ArrayList<IFeature> featureNodesToBeSelected = new ArrayList<IFeature>();
                if (job instanceof ModifyJob) {
                    ModifyJob modifyJob = (ModifyJob)job;
                    Set installedFeatures = agent.getInstalledFeatures(modifyJob.getProfile(), modifyJob.getOffering());
                    this.calculateDependencyForDefaultSelectedFeatures((AgentJob)job, installedFeatures);
                    featureNodesToBeSelected.addAll(installedFeatures);
                } else if (job instanceof UpdateOfferingJob && (newVersionOffering = (updateJob = (UpdateOfferingJob)job).getOffering()) != null && (defaultSelectedFeatures = agent.getDefaultFeatures(updateJob)) != null && defaultSelectedFeatures.length > 0) {
                    List<IFeature> defaultSelectedFeatureList = Arrays.asList(defaultSelectedFeatures);
                    this.calculateDependencyForDefaultSelectedFeatures((AgentJob)job, defaultSelectedFeatureList);
                    featureNodesToBeSelected.addAll(defaultSelectedFeatureList);
                }
                this.checkFeatures(featureNodesToBeSelected, (AgentJob)job, true);
            }
            ++i;
        }
    }

    private void calculateDependencyForDefaultSelectedFeatures(AgentJob job, Collection features) {
        HashSet processedElements = new HashSet();
        ArrayList defaultSelectedFeatures = new ArrayList(features);
        job.addDependsOnFeatures(processedElements, defaultSelectedFeatures);
    }

    protected void checkItem(CheckboxTreeViewer viewer, Object element, boolean checked, boolean grayed) {
        this.selectItem(element, checked);
        if (element instanceof AbstractJob && !checked && !grayed) {
            viewer.setChecked(element, false);
            viewer.setGrayChecked(element, true);
            return;
        }
        viewer.setChecked(element, checked);
        viewer.setGrayed(element, grayed);
    }

    private IStatus fixStatusMsg(IStatus status) {
        IStatus[] childrenStatus;
        String msg = status.getMessage();
        if (msg.trim().length() > 0) {
            return status;
        }
        if (status.isMultiStatus() && (childrenStatus = status.getChildren()).length > 0) {
            IStatus subStatus = childrenStatus[0];
            String childrenMsg = subStatus.getMessage();
            if (childrenMsg.trim().length() == 0) {
                childrenMsg = Messages.FeatureSelectionPage_genericErrorOrWarningMsg;
            }
            CicMultiStatus return_status = Statuses.ST.createMultiStatus(status.getSeverity(), status.getCode(), status.getChildren(), status.getException(), childrenMsg, new Object[0]);
            return return_status;
        }
        ICicStatus return_status = Statuses.ST.createStatus(status, Messages.FeatureSelectionPage_genericErrorOrWarningMsg, new Object[0]);
        return return_status;
    }

    private IStatus checkZeroFeatureSelection() {
        if (this.selectedProductJobs == null || this.selectedProductJobs.isEmpty()) {
            return Status.OK_STATUS;
        }
        IStatus status = AgentUtil.checkZeroFeatureSelection((AgentJob[])AgentJob.toArray((Collection)this.selectedProductJobs), (boolean)true);
        return status;
    }

    private IStatus checkOfferingInterdependencies(IProgressMonitor monitor) {
        if (this.selectedProductJobs == null || this.selectedProductJobs.isEmpty()) {
            return Status.OK_STATUS;
        }
        IStatus interdependencyStatus = AgentUI.getDefault().getAgent().checkOfferingFeatureInterdependencies((Collection)this.selectedProductJobs, monitor);
        if (StatusUtil.isErrorOrCancel((IStatus)interdependencyStatus) || StatusUtil.isWarning((IStatus)interdependencyStatus)) {
            String message = StatusUtil.isErrorOrCancel((IStatus)interdependencyStatus) ? Messages.FeatureSelectionPage_FeatureDependency_Error : Messages.FeatureSelectionPage_FeatureDependency_Warning;
            CicMultiStatus status = Statuses.ST.createMultiStatusWithChild(interdependencyStatus, message, new Object[0]);
            interdependencyStatus = status;
        }
        return interdependencyStatus;
    }

    private void checkRecommendedFeatures(List jobs) {
        this.selectMode = 1;
        this.checkAllFeatures(jobs, true, this.selectMode);
    }

    private void configureFeatureDependencyViewer(TreeViewer viewer) {
        this.featureDependencyContentProvider = new FeatureDependencyContentProvider(this.featureContentProvider);
        this.featureDependencyLabelProvider = new BasicFeatureLabelProvider();
        this.createFeatureDependencyColumns(viewer);
        StructuredSelection selection = (StructuredSelection)this.featureTreeViewer.getSelection();
        this.setFeatureDependencyTreeInput(viewer, selection.getFirstElement());
    }

    private void setFeatureDependencyTreeInput(TreeViewer viewer, Object input) {
        TreeItem item;
        viewer.getTree().removeAll();
        CategoryNode dependOnCategoryNode = null;
        CategoryNode dependentCategoryNode = null;
        if (input instanceof FeatureGroupNode) {
            dependOnCategoryNode = ((FeatureGroupNode)input).getDependsOnCategory();
            dependentCategoryNode = ((FeatureGroupNode)input).getDependentsCategory();
        } else if (input instanceof FeatureNode) {
            dependOnCategoryNode = ((FeatureNode)input).getDependsOnCategory();
            dependentCategoryNode = ((FeatureNode)input).getDependentsCategory();
        } else {
            return;
        }
        if (!dependOnCategoryNode.getChildrenList().isEmpty()) {
            item = new TreeItem(viewer.getTree(), 0);
            item.setImage(this.featureDependencyLabelProvider.getImage(dependOnCategoryNode));
            item.setText(this.featureDependencyLabelProvider.getText(dependOnCategoryNode));
            item.setData((Object)dependOnCategoryNode);
            this.featureDependencyContentProvider.setDependencyFeatureList(dependOnCategoryNode.getChildrenList());
            this.generateTreeItems(item);
            item.setExpanded(true);
        }
        if (!dependentCategoryNode.getChildrenList().isEmpty()) {
            item = new TreeItem(viewer.getTree(), 0);
            item.setImage(this.featureDependencyLabelProvider.getImage(dependentCategoryNode));
            item.setText(this.featureDependencyLabelProvider.getText(dependentCategoryNode));
            item.setData((Object)dependentCategoryNode);
            this.featureDependencyContentProvider.setDependencyFeatureList(dependentCategoryNode.getChildrenList());
            this.generateTreeItems(item);
            item.setExpanded(true);
        }
    }

    private void generateTreeItems(TreeItem parent) {
        Object[] childrenArray;
        Object parentData = parent.getData();
        Object[] objectArray = childrenArray = this.featureDependencyContentProvider.getChildren(parentData);
        int n = childrenArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            TreeItem item = new TreeItem(parent, 0);
            item.setData(element);
            item.setText(this.featureDependencyLabelProvider.getText(element));
            item.setImage(this.featureDependencyLabelProvider.getImage(element));
            this.generateTreeItems(item);
            item.setExpanded(true);
            ++n2;
        }
    }

    private void configureFeatureViewer(TreeViewer viewer) {
        this.featureContentProvider = new FeatureGroupContentProvider();
        this.featureLabelProvider = new FeatureLabelProvider(DisplayKeeper.INSTANCE.getDisplay());
        viewer.setLabelProvider((IBaseLabelProvider)this.featureLabelProvider);
        viewer.setContentProvider((IContentProvider)this.featureContentProvider);
        viewer.addFilter((ViewerFilter)new FeatureViewerFilter());
        viewer.setSorter((ViewerSorter)new FeatureViewerSorter());
        this.createFeatureViewerColumns(viewer);
    }

    private boolean confirmCheckedElements(AgentJob job, Object element, Collection featuresList, boolean checked) {
        if (checked || this.uncheckedDependents.isEmpty()) {
            return true;
        }
        MultiStatus status = new MultiStatus("com.ibm.cic.agent.ui", 0, Messages.FeatureSelectionPage_uncheckDependentsMessage, null);
        Iterator iterator = this.uncheckedDependents.iterator();
        while (iterator.hasNext()) {
            AbstractNode featureNode = this.getFeatureOrGroupNode(job, (IFeatureBase)iterator.next());
            if (featureNode == null || !featureNode.isSelected()) continue;
            status.add((IStatus)new Status(2, "com.ibm.cic.agent.ui", 0, this.featureLabelProvider.getText(featureNode), null));
        }
        if (status.isOK()) {
            return true;
        }
        YesNoErrorDialog dialog = new YesNoErrorDialog(this.getShell(), Messages.FeatureSelectionPage_header, null, (IStatus)status, 2);
        return dialog.open() == 2;
    }

    private AbstractNode getFeatureOrGroupNode(AgentJob job, IFeatureBase featureOrGroup) {
        HashMap map = (HashMap)this.featuresMap.get(job);
        if (map != null) {
            return (AbstractNode)map.get(featureOrGroup);
        }
        return null;
    }

    @Override
    public void createControl(Composite parent) {
        FormToolkit toolKit = this.getToolkit();
        SashForm sashForm = new SashForm(parent, 0);
        toolKit.adapt((Control)sashForm, false, false);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        sashForm.setLayout((Layout)layout);
        sashForm.setOrientation(512);
        this.hasLicensedFeatures = this.checkLicensedFeatures();
        this.hasNewVisibleFeature = this.checkIfHaveNewVisibleFeatures();
        this.createTreeSection(toolKit, (Composite)sashForm);
        this.createDetailsSection(toolKit, (Composite)sashForm);
        sashForm.setWeights(new int[]{60, 40});
        this.setControl((Control)sashForm);
    }

    private void primeSelection() {
        Tree featureTree = this.featureTreeViewer.getTree();
        if (featureTree.getItemCount() > 0) {
            TreeItem item = featureTree.getItem(0);
            this.featureTreeViewer.setSelection((ISelection)new StructuredSelection(item.getData()));
        }
    }

    private void createDescriptionSection(FormToolkit toolKit, Composite parent) {
        int defaultHeight;
        Font font = parent.getFont();
        Composite composite = toolKit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Section section = this.toolkit.createSection(composite, 512);
        section.setLayoutData((Object)new GridData(1808));
        section.marginHeight = 5;
        section.marginWidth = 0;
        section.setText(com.ibm.cic.agent.core.sharedUI.Messages.DetailsPage_title);
        Composite container = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        container.setLayout((Layout)gridLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.detailsTitleLabel = this.toolkit.createLabel(container, null, 64);
        final Font titleCustomFont = CommonUIUtils.createBoldFont((Display)DisplayKeeper.INSTANCE.getDisplay(), (Font)font);
        this.detailsTitleLabel.setFont(titleCustomFont);
        this.detailsTitleLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.detailsTitleLabel.setLayoutData((Object)new GridData(768));
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (titleCustomFont != null && !titleCustomFont.isDisposed()) {
                    titleCustomFont.dispose();
                }
            }
        });
        HyperlinkAdapter urlAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String url = (String)e.getHref();
                if (url != null) {
                    FeatureSelectionPage.this.openURL(url);
                }
            }
        };
        SharedScrolledComposite descScrolledForm = new SharedScrolledComposite(container, 0x200 | toolKit.getOrientation()){};
        descScrolledForm.setExpandVertical(true);
        toolKit.adapt((Composite)descScrolledForm);
        GridData gridData = new GridData(4, 4, true, true);
        descScrolledForm.setLayoutData((Object)gridData);
        this.detailsDesc = new FormText((Composite)descScrolledForm, 64);
        descScrolledForm.setContent((Control)this.detailsDesc);
        this.detailsDesc.setHyperlinkSettings((HyperlinkSettings)toolKit.getHyperlinkGroup());
        this.detailsDesc.addHyperlinkListener((IHyperlinkListener)urlAction);
        GridData data = new GridData(4, 4, true, true);
        this.detailsDesc.setLayoutData((Object)data);
        this.detailsDesc.setText("", false, false);
        toolKit.adapt((Control)this.detailsDesc, true, true);
        this.detailsDesc.setColor(COLOR_RED, DisplayKeeper.INSTANCE.getDisplay().getSystemColor(3));
        gridData.minimumHeight = defaultHeight = this.calculateHeight(descScrolledForm);
        descScrolledForm.pack();
    }

    private int calculateHeight(SharedScrolledComposite comp) {
        int height = 0;
        GC gc = new GC((Drawable)comp);
        gc.setFont(comp.getFont());
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        gc.dispose();
        height = 3 * lineHeight;
        if (this.detailsDesc != null) {
            height += 3 * this.detailsDesc.marginHeight;
        }
        return height;
    }

    private void createDetailsSection(FormToolkit toolKit, Composite parent) {
        Composite detailsComposite = toolKit.createComposite(parent);
        GridLayout detailsLayout = new GridLayout();
        detailsLayout.marginWidth = 0;
        detailsLayout.marginHeight = 0;
        detailsLayout.numColumns = 1;
        detailsComposite.setLayout((Layout)detailsLayout);
        detailsComposite.setLayoutData((Object)new GridData(1808));
        this.createDescriptionSection(this.toolkit, detailsComposite);
        this.createDiskSpaceSection(toolKit, detailsComposite);
    }

    private void createDiskSpaceSection(FormToolkit toolKit, Composite parent) {
        Composite container = toolKit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        container.setLayoutData((Object)data);
        Section spaceSection = this.getToolkit().createSection(container, 512);
        spaceSection.setText(Messages.ConfirmationPage_requiredSpace);
        Composite spaceComposite = this.getToolkit().createComposite((Composite)spaceSection);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        spaceComposite.setLayout((Layout)gridLayout);
        spaceComposite.setLayoutData((Object)new GridData(768));
        spaceSection.setClient((Control)spaceComposite);
        spaceSection.setLayoutData((Object)new GridData(768));
        Composite spaceInfoContainer = this.getToolkit().createComposite(spaceComposite);
        this.spaceLayout = new StackLayout();
        spaceInfoContainer.setLayout((Layout)this.spaceLayout);
        spaceInfoContainer.setLayoutData((Object)new GridData(768));
        this.diskSpaceTableComp = this.getToolkit().createComposite(spaceInfoContainer);
        GridLayout diskSpaceTableCompLayout = new GridLayout();
        diskSpaceTableCompLayout.marginWidth = 0;
        this.diskSpaceTableComp.setLayoutData((Object)new GridData(768));
        this.diskSpaceTableComp.setLayout((Layout)new GridLayout());
        this.spaceLayout.topControl = this.diskSpaceTableComp;
        this.diskSpaceTable = new Table(this.diskSpaceTableComp, 772);
        TableLayout tableLayout = new TableLayout();
        this.diskSpaceTable.setLayout((Layout)tableLayout);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = AgentUtil.hasInstallAgentJob((List)this.getAgentWizard().getSelectedJobs()) ? this.diskSpaceTable.getItemHeight() * 4 : this.diskSpaceTable.getItemHeight() * 3;
        this.diskSpaceTable.setLayoutData((Object)gd);
        int firstColWidth = this.calculateFirstColumnWidth(this.diskSpaceTable);
        this.createTableColumn(this.diskSpaceTable, 16384, tableLayout, 0, firstColWidth);
        int colWidth = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskSpaceTable, Messages.FeatureSelectionPage_column_driveName);
        this.createTableColumn(this.diskSpaceTable, 16384, tableLayout, 1, Math.max(80, colWidth));
        colWidth = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskSpaceTable, Messages.FeatureSelectionPage_column_requiredSpace);
        this.createTableColumn(this.diskSpaceTable, 131072, tableLayout, 2, Math.max(80, colWidth));
        colWidth = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskSpaceTable, Messages.FeatureSelectionPage_column_temporarySpace);
        this.createTableColumn(this.diskSpaceTable, 131072, tableLayout, 3, Math.max(90, colWidth));
        colWidth = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskSpaceTable, Messages.FeatureSelectionPage_column_totalSpace);
        this.createTableColumn(this.diskSpaceTable, 131072, tableLayout, 4, Math.max(90, colWidth));
        colWidth = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskSpaceTable, Messages.FeatureSelectionPage_column_availableSpace);
        this.createTableColumn(this.diskSpaceTable, 131072, tableLayout, 5, Math.max(80, colWidth));
        this.diskSpaceTable.pack();
        this.noDiskSpaceComp = this.getToolkit().createComposite(spaceInfoContainer);
        this.noDiskSpaceComp.setLayout((Layout)new GridLayout());
        this.noDiskSpaceComp.setLayoutData((Object)new GridData(768));
        Label noDiskSpaceInfoLabel = this.getToolkit().createLabel(this.noDiskSpaceComp, Messages.FeatureSelectionPage_noDiskSpaceInfo);
        noDiskSpaceInfoLabel.setLayoutData((Object)new GridData(768));
    }

    private int calculateFirstColumnWidth(Table table) {
        int width1 = AgentUIUtils.calculateSpaceTableColumnWidth(table, Messages.FeatureSelectionPage_commonComponentLocation);
        int width2 = AgentUIUtils.calculateSpaceTableColumnWidth(table, Messages.FeatureSelectionPage_installLocation);
        return Math.max(width1, width2);
    }

    private IStatus createFeatureDependencies(IProgressMonitor monitor) {
        Agent agent = AgentUI.getDefault().getAgent();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.selectedJobs.size());
        int i = 0;
        while (i < this.selectedJobs.size()) {
            IStatus res;
            AbstractJob job = (AbstractJob)this.selectedJobs.get(i);
            IOffering offering = job.getOffering();
            if (offering != null && !(res = agent.computeAllFeaturesInterdependencies(job.getProfile(), offering, (IProgressMonitor)sm.newChild(1))).isOK()) {
                return res;
            }
            ++i;
        }
        for (Map.Entry entry : this.featuresMap.entrySet()) {
            AbstractJob job = (AbstractJob)entry.getKey();
            HashMap featureToNodeMap = (HashMap)entry.getValue();
            Iterator featureNodes = featureToNodeMap.values().iterator();
            while (featureNodes.hasNext()) {
                ((FeatureNode)featureNodes.next()).createDependencies(job);
            }
        }
        return Status.OK_STATUS;
    }

    private void createFeatureDependencyColumns(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        this.createTreeColumn(tree, 16384, Messages.FeatureSelectionPage_column_additionalFeatures, tableLayout, 400);
        tree.setLayout((Layout)tableLayout);
    }

    private void createFeatureDependencyTree(FormToolkit toolKit, Composite parent) {
        FeatureDependencyPart featurePart = new FeatureDependencyPart();
        featurePart.createControl(parent, 0, 1, toolKit);
        UiServices.getInstance().paintBordersFor(toolKit, parent);
        this.featureDependencyViewer = featurePart.getTreeViewer();
        featurePart.setMinimumSize(400, 50);
        this.configureFeatureDependencyViewer(this.featureDependencyViewer);
    }

    private void createFeatureGroupTree(FormToolkit toolKit, Composite parent) {
        FeatureGroupPart groupPart = new FeatureGroupPart();
        groupPart.createControl(parent, 0, 2, toolKit);
        UiServices.getInstance().paintBordersFor(toolKit, parent);
        this.featureTreeViewer = groupPart.getTreeViewer();
        groupPart.setMinimumSize(520, 50);
        this.configureFeatureViewer((TreeViewer)this.featureTreeViewer);
    }

    private void createFeatureViewerColumns(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        if (this.hasLicensedFeatures) {
            this.createTreeColumn(tree, 16384, Messages.FeatureSelectionPage_column_primaryFeatures, null, this.hasNewVisibleFeature ? 500 : 570);
            if (this.hasNewVisibleFeature) {
                this.createTreeColumn(tree, 16384, com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryView_statusCol, null, 70);
            }
            this.createTreeColumn(tree, 16384, Messages.AvailableOfferingSection_columnLicense, null, 100);
        } else {
            this.createTreeColumn(tree, 16384, Messages.FeatureSelectionPage_column_primaryFeatures, null, this.hasNewVisibleFeature ? 600 : 670);
            if (this.hasNewVisibleFeature) {
                this.createTreeColumn(tree, 16384, com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryView_statusCol, null, 70);
            }
        }
    }

    private boolean checkLicensedFeatures() {
        IOffering[] offerings = this.getSelectedProductOfferings();
        if (offerings != null && offerings.length > 0) {
            IOffering[] iOfferingArray = offerings;
            int n = offerings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering offering = iOfferingArray[n2];
                IInstallableUnit[] ius = LicenseUtils.getFeatureIplaUnits((IOffering)offering);
                if (ius != null && ius.length > 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkIfHaveNewVisibleFeatures() {
        AgentUIWizard wizard = this.getAgentWizard();
        this.jobToNewFeaturesMap = new HashMap();
        if (wizard instanceof UpdateWizard) {
            List selectedProductJobList = this.getSelectedProductJobs();
            int i = 0;
            while (i < selectedProductJobList.size()) {
                Set newFeatures;
                AbstractJob job = (AbstractJob)selectedProductJobList.get(i);
                if (job instanceof UpdateOfferingJob && (newFeatures = this.getNewVisibleFeatures((UpdateOfferingJob)job)).size() > 0) {
                    this.jobToNewFeaturesMap.put(job, newFeatures);
                }
                ++i;
            }
        }
        return this.jobToNewFeaturesMap.size() > 0;
    }

    private Set getNewVisibleFeatures(UpdateOfferingJob updateJob) {
        IOffering base = updateJob.getUpdatedOffering();
        IOffering update = updateJob.getOffering();
        Set newFeatures = OfferingUtil.toFeatures((IFeature[])OfferingUtil.getVisibleFeatures((IOffering)update));
        newFeatures.removeAll(OfferingUtil.toFeatures((IFeature[])OfferingUtil.getAllFeatures((IOffering)base)));
        return newFeatures;
    }

    private Object[] createRootNodes(List selectedJobList) {
        this.selectedJobs = new ArrayList(selectedJobList);
        this.selectedProductJobs = AgentUtil.getSelectedProductAgentJobs((Collection)this.selectedJobs);
        this.resetFeatureStatus(this.selectedJobs);
        ArrayList<AbstractJob> returnJobs = new ArrayList<AbstractJob>(selectedJobList.size());
        for (AbstractJob selectedJob : selectedJobList) {
            IOffering offering = selectedJob.getOffering();
            if (offering == null || LicenseUtils.isPEKOffering((IOffering)offering)) continue;
            this.featureContentProvider.getChildren(selectedJob);
            returnJobs.add(selectedJob);
        }
        return returnJobs.toArray();
    }

    private TableItem createRow(Table parent, int style, String[] strings) {
        TableItem tableItem = new TableItem(parent, style);
        tableItem.setText(strings);
        return tableItem;
    }

    private TableColumn createTableColumn(Table parent, int style, TableLayout tableLayout, int columnIndex, int width) {
        TableColumn column = new TableColumn(parent, style, columnIndex);
        if (tableLayout == null) {
            column.setWidth(width);
        } else {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(width, width, true));
        }
        return column;
    }

    private TreeColumn createTreeColumn(Tree tree, int style, String name, TableLayout tableLayout, int width) {
        TreeColumn column = new TreeColumn(tree, style);
        column.setText(name);
        column.setResizable(true);
        if (tableLayout == null) {
            column.setWidth(width);
        } else {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(width, width, true));
        }
        return column;
    }

    private void createTreeSection(final FormToolkit toolKit, Composite parent) {
        Composite composite = toolKit.createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        final Composite treeArea = toolKit.createComposite(composite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 2;
        layout.marginLeft = 2;
        layout.marginWidth = 0;
        treeArea.setLayout((Layout)layout);
        treeArea.setLayoutData((Object)new GridData(1808));
        this.createFeatureGroupTree(toolKit, treeArea);
        Composite buttonsArea = toolKit.createComposite(composite, 0);
        layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        buttonsArea.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 1, true, false);
        buttonsArea.setLayoutData((Object)gridData);
        Button showButton = toolKit.createButton(buttonsArea, Messages.FeatureSelectionPage_showDependencies, 32);
        GridData showBtnData = new GridData(4, 0x1000000, true, false);
        showButton.setLayoutData((Object)showBtnData);
        showButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    FeatureSelectionPage.this.createFeatureDependencyTree(toolKit, treeArea);
                    GridData gd = (GridData)FeatureSelectionPage.this.featureTreeViewer.getControl().getLayoutData();
                    gd.horizontalSpan = 1;
                } else {
                    FeatureSelectionPage.this.featureDependencyViewer.getControl().dispose();
                    FeatureSelectionPage.this.featureDependencyViewer = null;
                    GridData gd = (GridData)FeatureSelectionPage.this.featureTreeViewer.getControl().getLayoutData();
                    gd.horizontalSpan = 2;
                }
                treeArea.layout();
                treeArea.redraw();
            }
        });
        Composite buttonGroup = new Composite(buttonsArea, 0);
        GridLayout buttonGroupLayout = new GridLayout(2, false);
        buttonGroupLayout.marginHeight = 0;
        buttonGroupLayout.horizontalSpacing = 2;
        buttonGroup.setLayout((Layout)buttonGroupLayout);
        buttonGroup.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Button expandAllButton = toolKit.createButton(buttonGroup, Messages.FeatureSelectionPage_expandAll, 8);
        expandAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureSelectionPage.this.featureTreeViewer.expandAll();
            }
        });
        Button collapseAllButton = toolKit.createButton(buttonGroup, Messages.FeatureSelectionPage_collapseAll, 8);
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureSelectionPage.this.featureTreeViewer.collapseAll();
            }
        });
        String buttonLabel = null;
        buttonLabel = this.selectRecommendedByDefault ? Messages.FeatureSelectionPage_restoreDefault : Messages.FeatureSelectionPage_restoreInstalled;
        Button restoreButton = toolKit.createButton(buttonsArea, buttonLabel, 8);
        restoreButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureSelectionPage.this.doCheckDefaultFeatures();
            }
        });
        Composite legendComposite = new Composite(buttonsArea, 0);
        GridLayout legendLayout = new GridLayout(2, false);
        legendLayout.horizontalSpacing = 0;
        legendLayout.marginWidth = 0;
        legendLayout.marginHeight = 0;
        legendComposite.setLayout((Layout)legendLayout);
        GridData legendData = new GridData(1, 1, true, false);
        legendData.horizontalSpan = 3;
        legendComposite.setLayoutData((Object)legendData);
        Label dependentIcon = toolKit.createLabel(legendComposite, "", 0);
        dependentIcon.setImage(this.featureLabelProvider.getFeatureDependencyImage());
        dependentIcon.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        Label dependentLegendText = toolKit.createLabel(legendComposite, "", 64);
        dependentLegendText.setText("- " + Messages.FeatureSelectionPage_dependentsLegend);
        dependentLegendText.setLayoutData((Object)new GridData(1, 1, true, false));
    }

    private void doCheckDefaultFeatures() {
        this.checkDefaultFeatures(true);
    }

    private void featureDependencySelectionChanged(IStructuredSelection selection) {
        this.showDetails(selection);
    }

    private boolean allFeatureNodesRequired(AgentJob job, List featuresClosure) {
        int i = 0;
        while (i < featuresClosure.size()) {
            AbstractNode node;
            Object object = featuresClosure.get(i);
            if (object != null && object instanceof IFeatureBase && (node = this.getFeatureOrGroupNode(job, (IFeatureBase)object)) != null && !node.isRequired()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean allFeatureNodesSelected(AgentJob job, List featuresClosure) {
        int i = 0;
        while (i < featuresClosure.size()) {
            AbstractNode node;
            Object object = featuresClosure.get(i);
            if (object != null && object instanceof IFeatureBase && (node = this.getFeatureOrGroupNode(job, (IFeatureBase)object)) != null && !node.isSelected()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void featureElementChecked(CheckboxTreeViewer viewer, Object element, boolean checked) {
        List featuresClosure = null;
        List featuresExclusion = null;
        this.uncheckedDependents = new HashSet();
        AgentJob jobContext = null;
        Object elementToCalculateClosure = element;
        if (elementToCalculateClosure instanceof AbstractJob) {
            jobContext = (AgentJob)elementToCalculateClosure;
            Object[] rootFeatureGroup = (Object[])this.jobsToGroupMap.get(elementToCalculateClosure);
            if (rootFeatureGroup != null && rootFeatureGroup.length == 1) {
                elementToCalculateClosure = rootFeatureGroup[0];
            }
        }
        if (elementToCalculateClosure instanceof FeatureGroupNode) {
            FeatureGroupNode groupNode = (FeatureGroupNode)elementToCalculateClosure;
            if (jobContext == null) {
                jobContext = this.findJob(groupNode);
            }
            this.selectMode = 2;
            if (!this.hasAllFeaturesSelected(groupNode)) {
                if (this.hasFeaturesSelected(groupNode, true)) {
                    checked = true;
                } else {
                    checked = true;
                    this.selectMode = 1;
                }
            }
            featuresClosure = jobContext.findClosure(groupNode.getFeatureGroup(), checked, (Set)this.uncheckedDependents, this.selectMode);
            if (this.selectMode == 1 && (featuresClosure.isEmpty() || this.allFeatureNodesRequired(jobContext, featuresClosure) || this.allFeatureNodesSelected(jobContext, featuresClosure))) {
                this.selectMode = 2;
                featuresClosure = jobContext.findClosure(groupNode.getFeatureGroup(), checked, (Set)this.uncheckedDependents, this.selectMode);
            }
            if (checked) {
                featuresExclusion = jobContext.findExclusionFeatures(featuresClosure);
            }
        } else {
            FeatureNode featureNode = (FeatureNode)elementToCalculateClosure;
            jobContext = this.findJob(featureNode);
            this.selectMode = 0;
            featuresClosure = jobContext.findClosure(featureNode.getFeature(), checked, (Set)this.uncheckedDependents, this.selectMode);
            if (checked) {
                featuresExclusion = jobContext.findExclusionFeatures(featuresClosure);
            }
        }
        if (featuresClosure == null || featuresClosure.isEmpty() || !this.confirmCheckedElements(jobContext, element, featuresClosure, checked)) {
            this.updateItem(this.featureTreeViewer, element, !checked);
        } else {
            this.checkFeatures(featuresClosure, jobContext, checked);
            if (featuresExclusion != null && !featuresExclusion.isEmpty()) {
                this.checkFeatures(featuresExclusion, jobContext, false);
            }
            this.setErrorState(OFFERING_FEATURESELECTION_ERROR, null);
            if (!this.delayFeatureValidation) {
                this.validateCheckedFeatures(false);
            } else {
                this.clearValidationResult();
            }
        }
        viewer.setSelection((ISelection)new StructuredSelection(element));
    }

    private void clearValidationResult() {
        this.performValidationOnNextButton = true;
        this.setErrorState(OFFERING_NOFEATURESELECTED_ERROR, null);
        this.setErrorState(OFFERING_INTERDEPENDENCY_ERROR, null);
        this.setWarningState(OFFERING_INTERDEPENDENCY_WARNING, null);
        this.setErrorState(NO_ENOUGH_SPACE_ERROR, null);
        this.hasZeroFeatureSelectionError = false;
        this.hasOfferingInterdependenciesError = false;
        this.hasNoEnoughtSpaceError = false;
        this.setPageComplete(!this.hasZeroFeatureSelectionError && !this.hasOfferingInterdependenciesError && !this.hasNoEnoughtSpaceError && !this.hasOfferingApplicabilityError);
        this.displayDiskSpaceInfo(false);
    }

    private void displayDiskSpaceInfo(boolean infoAvailable) {
        if (infoAvailable) {
            this.spaceLayout.topControl = this.diskSpaceTableComp;
            this.diskSpaceTableComp.getParent().layout();
        } else {
            this.spaceLayout.topControl = this.noDiskSpaceComp;
            this.noDiskSpaceComp.getParent().layout();
        }
    }

    private void validateCheckedFeatures(boolean recreateSpaceTable) {
        final IStatus[] zeroFeatureSelectionStatus = new IStatus[]{Status.OK_STATUS};
        final IStatus[] featureInterdependencyStatus = new IStatus[]{Status.OK_STATUS};
        final IStatus[] checkAvailableSpaceStatus = new IStatus[]{Status.OK_STATUS};
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    SplitProgressMonitor sm = new SplitProgressMonitor(monitor, Messages.FeatureSelectionPage_validateFeaturesProgress, new int[]{4, 8});
                    zeroFeatureSelectionStatus[0] = FeatureSelectionPage.this.checkZeroFeatureSelection();
                    if (!StatusUtil.isErrorOrCancel((IStatus)zeroFeatureSelectionStatus[0])) {
                        featureInterdependencyStatus[0] = FeatureSelectionPage.this.checkOfferingInterdependencies(sm.next());
                        if (!StatusUtil.isErrorOrCancel((IStatus)featureInterdependencyStatus[0])) {
                            checkAvailableSpaceStatus[0] = FeatureSelectionPage.this.checkDiskSpaceInfo(sm.next());
                        }
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            IStatus status = AgentUI.reportException(target, false);
            this.setWarningState(OFFERING_INTERDEPENDENCY_WARNING, null);
            this.setErrorStateWithStatus(OFFERING_INTERDEPENDENCY_ERROR, status);
            this.eclipseCacheLocationSizeList = null;
            this.installLocationSizeMap = null;
            this.setPageComplete(false);
            return;
        }
        catch (InterruptedException interruptedException) {
            checkAvailableSpaceStatus[0] = Statuses.CANCEL.get(Messages.FeatureSelectionPage_validateFeaturesCancel, new Object[0]);
        }
        if (StatusUtil.isCancel((IStatus)zeroFeatureSelectionStatus[0]) || StatusUtil.isCancel((IStatus)featureInterdependencyStatus[0]) || StatusUtil.isCancel((IStatus)checkAvailableSpaceStatus[0])) {
            this.validatingSelectedFeaturesWasCanceled = true;
            this.eclipseCacheLocationSizeList = null;
            this.installLocationSizeMap = null;
        } else {
            this.validatingSelectedFeaturesWasCanceled = false;
        }
        this.hasZeroFeatureSelectionError = StatusUtil.isErrorOrCancel((IStatus)zeroFeatureSelectionStatus[0]);
        this.hasOfferingInterdependenciesError = StatusUtil.isErrorOrCancel((IStatus)featureInterdependencyStatus[0]);
        this.hasNoEnoughtSpaceError = StatusUtil.isErrorOrCancel((IStatus)checkAvailableSpaceStatus[0]);
        this.setPageComplete(!this.hasZeroFeatureSelectionError && !this.hasOfferingInterdependenciesError && !this.hasNoEnoughtSpaceError && !this.hasOfferingApplicabilityError);
        if (this.hasZeroFeatureSelectionError) {
            this.setErrorStateWithStatus(OFFERING_NOFEATURESELECTED_ERROR, this.fixStatusMsg(zeroFeatureSelectionStatus[0]));
        } else {
            this.setErrorState(OFFERING_NOFEATURESELECTED_ERROR, null);
        }
        if (this.hasOfferingInterdependenciesError) {
            this.setWarningState(OFFERING_INTERDEPENDENCY_WARNING, null);
            this.setErrorStateWithStatus(OFFERING_INTERDEPENDENCY_ERROR, this.fixStatusMsg(featureInterdependencyStatus[0]));
        } else if (featureInterdependencyStatus[0].getSeverity() == 2) {
            this.setErrorState(OFFERING_INTERDEPENDENCY_ERROR, null);
            this.setWarningStateWithStatus(OFFERING_INTERDEPENDENCY_WARNING, this.fixStatusMsg(featureInterdependencyStatus[0]));
        } else {
            this.setErrorState(OFFERING_INTERDEPENDENCY_ERROR, null);
            this.setWarningState(OFFERING_INTERDEPENDENCY_WARNING, null);
        }
        this.setErrorStateWithStatus(NO_ENOUGH_SPACE_ERROR, this.hasNoEnoughtSpaceError ? checkAvailableSpaceStatus[0] : null);
        if (this.eclipseCacheLocationSizeList != null && this.installLocationSizeMap != null) {
            this.showDiskSpaceInformation(recreateSpaceTable);
            this.displayDiskSpaceInfo(true);
        } else {
            this.displayDiskSpaceInfo(false);
        }
    }

    private void featureSelectionChanged(IStructuredSelection selection) {
        this.showDetails(selection);
        Object selectedObj = ((StructuredSelection)selection).getFirstElement();
        if (this.previousSelection != selectedObj) {
            this.previousSelection = selectedObj;
            if (this.featureDependencyViewer == null) {
                return;
            }
            this.setFeatureDependencyTreeInput(this.featureDependencyViewer, selectedObj);
            this.featureDependencyViewer.getTree().layout();
        }
    }

    private AbstractJob findJob(AbstractNode element) {
        Object parent = element.getParent();
        while (parent != null) {
            if (parent instanceof AbstractJob) {
                return (AbstractJob)parent;
            }
            parent = ((AbstractNode)parent).getParent();
        }
        return null;
    }

    private String getApplicabilityMessage(Object element) {
        IStatus status = Status.OK_STATUS;
        if (element instanceof FeatureNode) {
            FeatureNode featureNode = (FeatureNode)element;
            status = featureNode.getApplicabilityStatus();
            if (status.isOK() && featureNode.getAuxiliaryApplicabilityStatus() != null && !featureNode.getAuxiliaryApplicabilityStatus().isOK()) {
                status = featureNode.getAuxiliaryApplicabilityStatus();
            }
        } else if (element instanceof FeatureGroupNode) {
            status = ((FeatureGroupNode)element).getApplicabilityStatus();
        }
        if (status.isOK()) {
            return null;
        }
        return MultiStatusUtil.getFailureMessage((IStatus)status);
    }

    private List getDependentFeatures(AbstractJob job, FeatureNode featureNode) {
        IFeature feature = featureNode.getFeature();
        ArrayList<FeatureNode> featureNodes = new ArrayList<FeatureNode>();
        try {
            IFeature[] dependents;
            IFeature[] iFeatureArray = dependents = feature.getDependentFeatures();
            int n = dependents.length;
            int n2 = 0;
            while (n2 < n) {
                IFeature dependent = iFeatureArray[n2];
                featureNodes.add(this.getFeatureNode(job, dependent));
                ++n2;
            }
            return featureNodes;
        }
        catch (IllegalFeatureStateException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
            e.printStackTrace();
            return featureNodes;
        }
    }

    private List getDependsOnFeatures(AbstractJob job, FeatureNode featureNode) {
        IFeature feature = featureNode.getFeature();
        ArrayList<FeatureNode> featureNodes = new ArrayList<FeatureNode>();
        try {
            IFeature[] requires;
            IFeature[] iFeatureArray = requires = feature.getRequiredFeatures();
            int n = requires.length;
            int n2 = 0;
            while (n2 < n) {
                IFeature require = iFeatureArray[n2];
                featureNodes.add(this.getFeatureNode(job, require));
                ++n2;
            }
        }
        catch (IllegalFeatureStateException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
            e.printStackTrace();
        }
        return featureNodes;
    }

    private IFeatureBase getFeatureBase(Object element) {
        IFeatureGroup featureBase = null;
        if (element instanceof FeatureGroupNode) {
            featureBase = ((FeatureGroupNode)element).getFeatureGroup();
        } else if (element instanceof FeatureNode) {
            featureBase = ((FeatureNode)element).getFeature();
        }
        return featureBase;
    }

    public ITreeContentProvider getFeatureContentProvider() {
        return this.featureContentProvider;
    }

    public Map getJobToGroupMap() {
        return this.jobsToGroupMap;
    }

    private String getFeatureDescription(IFeature feature) {
        Information information = feature.getInformation();
        return this.getFeatureDescription(information == null ? null : information.getDescription(), null);
    }

    private String getFeatureDescription(String desc, String url) {
        if (desc != null) {
            desc = AgentUIUtils.convertSpecialCharsForDescription(desc);
            if (url == null) {
                return desc;
            }
            String link = " <a href=\"" + url + "\">" + Messages.DetailsPage_moreInfo + "</a>";
            String fullText = String.valueOf(desc) + link;
            return fullText;
        }
        return "";
    }

    private FeatureNode getFeatureNode(AbstractJob job, IFeature feature) {
        HashMap featureToNodeMap = (HashMap)this.featuresMap.get(job);
        if (featureToNodeMap == null) {
            return null;
        }
        return (FeatureNode)featureToNodeMap.get(feature);
    }

    private int getFeaturesCount(IOffering offering) {
        if (offering == null) {
            return 0;
        }
        List allFeatures = offering.getFilteredFeatures(new IOffering.FeatureFilter(){

            public boolean canAccept(IFeature feature) {
                return feature != null;
            }
        });
        return allFeatures.size();
    }

    private String getGroupDescription(IFeatureGroup featureGroup) {
        Information information = featureGroup.getInformation();
        return this.getFeatureDescription(information == null ? null : information.getDescription(), null);
    }

    protected String getObjectDescription(Object object) {
        String offeringDesc;
        Information info;
        if (object instanceof IFeatureGroup) {
            return this.getGroupDescription((IFeatureGroup)object);
        }
        if (object instanceof IFeature) {
            return this.getFeatureDescription((IFeature)object);
        }
        if (object instanceof IOffering && (info = ((IOffering)object).getInformation()) != null && (offeringDesc = info.getDescription()) != null) {
            return AgentUIUtils.convertSpecialCharsForDescription(offeringDesc);
        }
        return "";
    }

    private String getProfileSignature() {
        StringBuffer result = new StringBuffer();
        List jobs = this.getJobs();
        for (AbstractJob job : jobs) {
            String installLocation;
            Profile profile = job.getProfile();
            if (result.length() != 0) {
                result.append(',');
            }
            if ((installLocation = profile.getInstallLocation()) != null) {
                result.append(installLocation);
            }
            result.append(';');
            String eclipseLocation = profile.getEclipseLocation();
            if (eclipseLocation != null) {
                result.append(eclipseLocation);
            }
            result.append(';');
            String profileKind = profile.getProfileKind();
            if (profileKind != null) {
                result.append(profileKind);
            }
            result.append(';');
            String arch = profile.getArch();
            result.append(arch);
        }
        return result.toString();
    }

    protected int[] getProgressWeightages(List jobs) {
        int[] result = new int[jobs.size()];
        int index = 0;
        for (AgentJob job : jobs) {
            result[index++] = this.getFeaturesCount(job.getOffering());
        }
        return result;
    }

    private boolean hasAllFeaturesSelected(AbstractNode element) {
        Object[] children;
        FeatureGroupNode groupNode;
        if (!element.canSelect()) {
            return true;
        }
        if (!element.isSelected()) {
            return false;
        }
        if (element instanceof FeatureGroupNode && (groupNode = (FeatureGroupNode)element).hasMutuallyExclusiveChildren()) {
            return true;
        }
        Object[] objectArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element2 = objectArray[n2];
            AbstractNode child = (AbstractNode)element2;
            if (!this.hasAllFeaturesSelected(child)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean hasFeaturesSelected(AbstractNode element, boolean onlyOptional) {
        Object[] children;
        Object[] objectArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element2 = objectArray[n2];
            AbstractNode child = (AbstractNode)element2;
            if (child.isSelected()) {
                if (onlyOptional) {
                    if (!child.isRequired()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            if (this.hasFeaturesSelected(child, onlyOptional)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void inputChanged() {
        this.featuresMap = new HashMap();
        this.jobsToGroupMap.clear();
        this.selectedJobs = new ArrayList();
        this.selectedProductJobs = new ArrayList();
        this.jobToDefaultFeatureSet.clear();
        this.hasZeroFeatureSelectionError = false;
        this.hasOfferingInterdependenciesError = false;
        this.hasNoEnoughtSpaceError = false;
        this.hasOfferingApplicabilityError = false;
        final Object[] rootNodes = new Object[1];
        final IStatus[] resolveFeatureStatus = new IStatus[]{Status.OK_STATUS};
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    Object[] roots = FeatureSelectionPage.this.createRootNodes(FeatureSelectionPage.this.getSelectedJobs());
                    resolveFeatureStatus[0] = FeatureSelectionPage.this.createFeatureDependencies(monitor);
                    if (monitor.isCanceled()) {
                        resolveFeatureStatus[0] = Statuses.CANCEL.get(Messages.FeatureSelectionPage_offeringResolveProcessWasCanceled, new Object[0]);
                    }
                    monitor.done();
                    rootNodes[0] = roots;
                }
            });
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException interruptedException) {
            resolveFeatureStatus[0] = Statuses.CANCEL.get(Messages.FeatureSelectionPage_offeringResolveProcessWasCanceled, new Object[0]);
        }
        if (StatusUtil.isErrorOrCancel((IStatus)resolveFeatureStatus[0])) {
            this.setErrorStateWithStatus(RESOLVE_FEATURE_ERROR, resolveFeatureStatus[0]);
            this.setPageComplete(false);
            this.featureTreeViewer.setInput(null);
            this.lastProfileSignature = null;
            this.selectedJobs = null;
            this.selectedProductJobs = null;
            return;
        }
        this.delayFeatureValidation = AgentUIUtils.delayFeatureValidation(AgentJob.toArray((Collection)this.selectedProductJobs));
        this.setErrorStateWithStatus(RESOLVE_FEATURE_ERROR, null);
        this.featureTreeViewer.setInput(rootNodes[0]);
        this.setDefaultExpandStatus(rootNodes, this.areMultipleOfferingsSelected());
        this.resetFeatureSelections(this.selectedJobs);
        this.saveResponseFileSelections();
        this.checkDefaultFeatures(false);
        this.setTopItem();
        this.primeSelection();
    }

    private void resetFeatureSelections(List jobs) {
        int i = 0;
        while (i < jobs.size()) {
            AgentJob job = (AgentJob)jobs.get(i);
            job.resetFeatureSelectionSet();
            ++i;
        }
    }

    private void resetFeatureStatus(List jobs) {
        int i = 0;
        while (i < jobs.size()) {
            AgentJob job = (AgentJob)jobs.get(i);
            job.resetFeatureStatus();
            ++i;
        }
    }

    private void setDefaultExpandStatus(Object[] roots, boolean multipleOfferings) {
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object root = objectArray[n2];
            if (root instanceof Object[]) {
                this.setDefaultExpandStatus((Object[])root, multipleOfferings);
            } else if (root instanceof AbstractJob) {
                boolean expandFeatureTree;
                AbstractJob job = (AbstractJob)root;
                boolean bl = job.expandFeatureTree() == null ? !multipleOfferings : (expandFeatureTree = job.expandFeatureTree().booleanValue());
                if (expandFeatureTree) {
                    this.featureTreeViewer.expandToLevel(root, -1);
                } else {
                    this.featureTreeViewer.collapseToLevel(root, -1);
                }
            }
            ++n2;
        }
    }

    private boolean areMultipleOfferingsSelected() {
        IOffering[] selectedProductOfferings = this.getSelectedProductOfferings();
        return selectedProductOfferings != null && selectedProductOfferings.length > 1;
    }

    private void saveResponseFileSelections() {
        for (AbstractJob job : this.getSelectedJobs()) {
            IOffering offering = job.getOffering();
            if (offering == null || this.jobToDefaultFeatureSet.containsKey(job) || LicenseUtils.isPEKOffering((IOffering)offering)) continue;
            HashSet defaultFeatures = new HashSet();
            job.resetFeatures();
            List featureList = job.getFeatures();
            if (featureList != null && !featureList.isEmpty()) {
                defaultFeatures.addAll(featureList);
            }
            if (defaultFeatures.isEmpty()) continue;
            this.jobToDefaultFeatureSet.put(job, defaultFeatures);
        }
    }

    protected boolean isVisibleItem(Object element) {
        if (element instanceof AbstractNode) {
            return ((AbstractNode)element).isVisible();
        }
        return element instanceof AbstractJob;
    }

    private void openURL(String urlName) {
        URL url;
        try {
            url = new URL(urlName);
        }
        catch (MalformedURLException e) {
            AgentUI.reportException(e);
            return;
        }
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
        }
        catch (PartInitException e) {
            AgentUI.reportException(e);
        }
    }

    private void setTopItem() {
        Tree tree = this.featureTreeViewer.getTree();
        if (tree.getItemCount() > 0) {
            TreeItem item = tree.getItem(0);
            tree.setTopItem(item);
        }
    }

    private IStatus checkDiskSpaceInfo(IProgressMonitor monitor) {
        if (Agent.getInstance().isSkipInstall()) {
            return Status.OK_STATUS;
        }
        if (monitor.isCanceled()) {
            return ICicStatus.CANCEL_STATUS;
        }
        SplitProgressMonitor sm = new SplitProgressMonitor(monitor, new int[]{1, 1});
        this.getAgentWizard().swapProfileLocaleSettings();
        this.eclipseCacheLocationSizeList = SpaceInfoUtils.getEclipseCacheLocationSizeListMap((List)this.getAgentWizard().getSelectedJobs(), (IProgressMonitor)sm.next());
        this.getAgentWizard().swapProfileLocaleSettings();
        if (this.eclipseCacheLocationSizeList == null) {
            return Status.OK_STATUS;
        }
        if (sm.isCanceled()) {
            return ICicStatus.CANCEL_STATUS;
        }
        this.installLocationSizeMap = SpaceInfoUtils.getInstallLocationDriveSizeListMap((List)this.getAgentWizard().getSelectedJobs(), (IProgressMonitor)sm.next());
        if (this.installLocationSizeMap == null) {
            return Status.OK_STATUS;
        }
        HashMap resultMap = new HashMap();
        IStatus spaceValidationStatus = SpaceInfoUtils.verifySpaceInfo((List)this.eclipseCacheLocationSizeList, (Map)this.installLocationSizeMap, resultMap, (String)com.ibm.cic.agent.core.sharedUI.Messages.FeatureSelectionPage_invalidAvailableDiskSpace);
        AgentUI.getDefault().setTotalSizeMap(resultMap);
        return spaceValidationStatus;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            boolean profileChanged = false;
            String profileSignature = this.getProfileSignature();
            if (!profileSignature.equals(this.lastProfileSignature)) {
                profileChanged = true;
                this.lastProfileSignature = profileSignature;
                this.inputChanged();
            }
            if (this.selectedJobs != null && this.selectedProductJobs != null) {
                boolean isModifyFlow;
                boolean bl = isModifyFlow = this.selectedProductJobs.size() > 0 && ((AgentJob)this.selectedProductJobs.get(0)).isModify();
                if (isModifyFlow) {
                    IStatus applicabilityCheckStatus = AgentUtil.getOfferingsApplicability((List)this.selectedProductJobs, (AgentJob[])AgentJob.toArray((Collection)this.selectedProductJobs));
                    this.hasOfferingApplicabilityError = StatusUtil.isErrorOrCancel((IStatus)applicabilityCheckStatus);
                    if (this.hasOfferingApplicabilityError) {
                        this.setWarningState(OFFERING_APPLICABILITY_WARNING, null);
                        this.setErrorStateWithStatus(OFFERING_APPLICABILITY_ERROR, this.fixStatusMsg(applicabilityCheckStatus));
                    } else if (applicabilityCheckStatus.getSeverity() == 2) {
                        this.setErrorState(OFFERING_APPLICABILITY_ERROR, null);
                        this.setWarningStateWithStatus(OFFERING_APPLICABILITY_WARNING, this.fixStatusMsg(applicabilityCheckStatus));
                    } else {
                        this.setErrorState(OFFERING_APPLICABILITY_ERROR, null);
                        this.setWarningState(OFFERING_APPLICABILITY_WARNING, null);
                    }
                }
                if (this.validatingSelectedFeaturesWasCanceled && !profileChanged) {
                    DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FeatureSelectionPage.this.validateCheckedFeatures(false);
                        }
                    });
                } else {
                    if (!profileChanged) {
                        final IStatus[] spaceStatus = new IStatus[]{Status.OK_STATUS};
                        try {
                            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) {
                                    spaceStatus[0] = FeatureSelectionPage.this.checkDiskSpaceInfo(monitor);
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            Throwable target = e.getTargetException();
                            AgentUI.reportException(target, false);
                        }
                        catch (InterruptedException interruptedException) {
                            spaceStatus[0] = ICicStatus.CANCEL_STATUS;
                        }
                        this.hasNoEnoughtSpaceError = StatusUtil.isErrorOrCancel((IStatus)spaceStatus[0]);
                        this.setErrorStateWithStatus(NO_ENOUGH_SPACE_ERROR, this.hasNoEnoughtSpaceError ? spaceStatus[0] : null);
                    }
                    if (!profileChanged || isModifyFlow) {
                        this.setPageComplete(!this.hasZeroFeatureSelectionError && !this.hasOfferingInterdependenciesError && !this.hasNoEnoughtSpaceError && !this.hasOfferingApplicabilityError);
                    }
                    if (this.eclipseCacheLocationSizeList != null && this.installLocationSizeMap != null) {
                        this.showDiskSpaceInformation(true);
                        this.displayDiskSpaceInfo(true);
                    } else {
                        this.displayDiskSpaceInfo(false);
                    }
                }
            }
        }
        super.setVisible(visible);
    }

    public void showDetails(IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        String title = "";
        String description = "";
        if (firstElement instanceof AbstractJob) {
            IOffering offering = ((AbstractJob)firstElement).getOffering();
            if (offering != null) {
                title = AgentUIUtils.getOfferingOrFixLabel((IOfferingOrFix)offering);
                description = "<form><p>" + this.getObjectDescription(offering) + "</p></form>";
            }
        } else {
            String errorMessage;
            IFeatureBase featureBase = this.getFeatureBase(firstElement);
            if (featureBase != null) {
                title = this.featureLabelProvider.getText(firstElement);
                description = this.getObjectDescription(featureBase);
            }
            if ((errorMessage = this.getApplicabilityMessage(firstElement)) != null) {
                String escErrorMsg = AgentUIUtils.escapeSpecialChars(errorMessage);
                description = "<form><p><span color=\"red\">" + escErrorMsg + "</span><br></br>" + description + "</p></form>";
            } else {
                description = "<form><p>" + description + "</p></form>";
            }
        }
        this.detailsTitleLabel.setText(title);
        this.detailsDesc.setText(description, description.startsWith("<form>"), false);
        this.reflow((Control)this.detailsDesc);
    }

    protected void reflow(Control c) {
        Composite parent = c.getParent();
        while (parent != null) {
            if (parent instanceof SharedScrolledComposite) {
                SharedScrolledComposite scrolledComp = (SharedScrolledComposite)parent;
                scrolledComp.reflow(true);
                Rectangle origRec = this.detailsDesc.getBounds();
                int parentCompWidth = scrolledComp.getClientArea().width;
                if (origRec.width == parentCompWidth) break;
                this.detailsDesc.setBounds(origRec.x, origRec.y, parentCompWidth, origRec.height);
                this.detailsDesc.redraw();
                break;
            }
            parent.layout();
            parent = parent.getParent();
        }
    }

    private void showDiskSpaceInformation(boolean recreateTable) {
        int rowCount = 0;
        if (recreateTable) {
            this.diskSpaceTable.removeAll();
        } else if (this.diskSpaceTable.getItemCount() == 0) {
            recreateTable = true;
        }
        if (this.eclipseCacheLocationSizeList != null) {
            this.showCacheLocationSizeInfo(this.eclipseCacheLocationSizeList, recreateTable);
            rowCount = 2;
        }
        ArrayList<String[]> sizeLabelList = new ArrayList<String[]>();
        Set driveSet = this.installLocationSizeMap.keySet();
        for (String driveName : driveSet) {
            List sizeList = (List)this.installLocationSizeMap.get(driveName);
            String[] sizeLabel = new String[sizeList.size() + 2];
            sizeLabel[0] = driveName;
            int i = 0;
            while (i < sizeList.size()) {
                long size = (Long)sizeList.get(i);
                sizeLabel[i + 1] = size != 0L ? FormatUtil.formatBytes((long)size) : "";
                ++i;
            }
            sizeLabel[sizeList.size() + 1] = SpaceInfoUtils.getAvailableSpace((String)driveName);
            sizeLabelList.add(sizeLabel);
        }
        if (!sizeLabelList.isEmpty()) {
            if (recreateTable) {
                this.installLocationSizeTableItems = new ArrayList(sizeLabelList.size());
            }
            this.showProductFeatureSizeInfo(sizeLabelList, recreateTable);
            rowCount += sizeLabelList.size();
        }
        if (recreateTable) {
            GridData data = (GridData)this.diskSpaceTable.getLayoutData();
            data.heightHint = this.diskSpaceTable.getItemHeight() * rowCount;
            this.diskSpaceTable.redraw();
            this.reflow((Control)this.diskSpaceTable);
        }
    }

    private void showProductFeatureSizeInfo(List sizeLabelList, boolean recreateTable) {
        if (!recreateTable) assert (sizeLabelList.size() == this.installLocationSizeTableItems.size());
        int i = 0;
        while (i < sizeLabelList.size()) {
            String[] sizeLabels = (String[])sizeLabelList.get(i);
            if (recreateTable) {
                String installLocationLabel = Messages.FeatureSelectionPage_installLocation;
                if (i > 0) {
                    installLocationLabel = "";
                }
                TableItem item = this.createRow(this.diskSpaceTable, 0, new String[]{installLocationLabel, TextProcessor.process((String)sizeLabels[0]), sizeLabels[1], sizeLabels[2], sizeLabels[3], sizeLabels[4]});
                this.installLocationSizeTableItems.add(item);
            } else {
                TableItem item = (TableItem)this.installLocationSizeTableItems.get(i);
                if (!item.isDisposed()) {
                    item.setText(1, TextProcessor.process((String)sizeLabels[0]));
                    item.setText(2, sizeLabels[1]);
                    item.setText(3, sizeLabels[2]);
                    item.setText(4, sizeLabels[3]);
                    item.setText(5, sizeLabels[4]);
                }
            }
            ++i;
        }
    }

    private void showCacheLocationSizeInfo(List cacheSizeList, boolean recreateTable) {
        String eclipseLocation = CacheLocationManager.getInstance().getCacheLocation();
        long cacheLocationInstallSize = 0L;
        long tempSize = 0L;
        long maxInstallSize = 0L;
        if (cacheSizeList != null && cacheSizeList.size() == 3) {
            cacheLocationInstallSize = (Long)cacheSizeList.get(0);
            tempSize = (Long)cacheSizeList.get(1);
            maxInstallSize = (Long)cacheSizeList.get(2);
        }
        String driveName = PlatformUtils.getLocationDevice((String)eclipseLocation);
        String installSize = FormatUtil.formatBytes((long)cacheLocationInstallSize);
        String temp = FormatUtil.formatBytes((long)tempSize);
        String max = FormatUtil.formatBytes((long)maxInstallSize);
        String availableSize = SpaceInfoUtils.getAvailableSpace((String)eclipseLocation);
        if (recreateTable) {
            this.createRow(this.diskSpaceTable, 0, new String[]{"", Messages.FeatureSelectionPage_column_driveName, Messages.FeatureSelectionPage_column_requiredSpace, Messages.FeatureSelectionPage_column_temporarySpace, Messages.FeatureSelectionPage_column_totalSpace, Messages.FeatureSelectionPage_column_availableSpace});
            this.commonLocationSizeTableItem = this.createRow(this.diskSpaceTable, 0, new String[]{Messages.FeatureSelectionPage_commonComponentLocation, TextProcessor.process((String)driveName), installSize, temp, max, availableSize});
        } else {
            this.commonLocationSizeTableItem.setText(1, TextProcessor.process((String)driveName));
            this.commonLocationSizeTableItem.setText(2, installSize);
            this.commonLocationSizeTableItem.setText(3, temp);
            this.commonLocationSizeTableItem.setText(4, max);
            this.commonLocationSizeTableItem.setText(5, availableSize);
        }
    }

    protected void updateItem(CheckboxTreeViewer viewer, Object element, boolean preferredState) {
        Object[] rootFeatureGroup;
        Object[] children = null;
        if (element instanceof AbstractNode) {
            children = ((AbstractNode)element).getChildren();
        } else if (element instanceof AbstractJob && (rootFeatureGroup = (Object[])this.jobsToGroupMap.get(element)) != null && rootFeatureGroup.length == 1) {
            children = ((FeatureGroupNode)rootFeatureGroup[0]).getChildren();
        }
        if (children == null) {
            return;
        }
        boolean containsSelected = false;
        boolean containsUnselected = false;
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (containsSelected && containsUnselected) break;
            boolean checked = viewer.getChecked(child);
            boolean grayed = viewer.getGrayed(child);
            if (this.isVisibleItem(child)) {
                containsSelected |= checked;
                containsUnselected |= !checked || grayed;
            } else {
                containsSelected |= ((AbstractNode)child).isSelected();
            }
            ++n2;
        }
        if (containsSelected || containsUnselected) {
            this.checkItem(viewer, element, containsSelected, containsSelected && containsUnselected);
        } else {
            this.checkItem(viewer, element, preferredState, false);
        }
    }

    protected void updateParents(CheckboxTreeViewer viewer, Object element, boolean checked) {
        if (element instanceof AbstractNode) {
            ITreeContentProvider treeProvider = (ITreeContentProvider)viewer.getContentProvider();
            this.updateItem(viewer, element, checked);
            this.updateParents(viewer, treeProvider.getParent(element), checked);
        } else if (element instanceof AbstractJob) {
            this.updateItem(viewer, element, checked);
        }
    }

    private void selectItem(Object element, boolean preferredState) {
        if (element instanceof AbstractJob) {
            Object[] rootFeatureGroup = (Object[])this.jobsToGroupMap.get(element);
            element = rootFeatureGroup != null && rootFeatureGroup.length == 1 ? rootFeatureGroup[0] : null;
        }
        if (element != null && element instanceof AbstractNode) {
            AbstractNode node = (AbstractNode)element;
            Object[] children = node.getChildren();
            int length = children.length;
            if (length > 0 && !preferredState) {
                int i = 0;
                while (i < length) {
                    AbstractNode child = (AbstractNode)children[i];
                    if (child.isSelected()) {
                        node.setSelected(true);
                        return;
                    }
                    ++i;
                }
                node.setSelected(false);
            } else {
                node.setSelected(preferredState);
            }
        }
    }

    private void selectElementPlusParents(CheckboxTreeViewer viewer, Object element, boolean checked) {
        if (element instanceof AbstractNode) {
            ITreeContentProvider treeProvider = (ITreeContentProvider)viewer.getContentProvider();
            this.selectItem(element, checked);
            this.selectElementPlusParents(viewer, treeProvider.getParent(element), checked);
        }
    }

    public boolean shouldSkip() {
        boolean allFixes = AgentUIUtils.allFixJobs(this.getSelectedJobs());
        return allFixes;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        if (this.performValidationOnNextButton) {
            this.validateCheckedFeatures(false);
            if (!this.isPageComplete()) {
                return this;
            }
            this.performValidationOnNextButton = false;
        }
        return super.getNextPage();
    }

    abstract class AbstractNode {
        private boolean isSelected = false;
        private final Object parent;

        AbstractNode(Object parent) {
            this.parent = parent;
        }

        public boolean canSelect() {
            return true;
        }

        public boolean canRemove() {
            return true;
        }

        public abstract Object[] getChildren();

        public Object getParent() {
            return this.parent;
        }

        public boolean isRecommended() {
            return false;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public abstract boolean isVisible();

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        protected void selectPekOfferingJob(AbstractNode featureOrGroupNode) {
            if (featureOrGroupNode instanceof FeatureGroupNode || featureOrGroupNode instanceof FeatureNode) {
                IOffering productOffering;
                Object featureOrGroup = null;
                featureOrGroup = featureOrGroupNode instanceof FeatureGroupNode ? ((FeatureGroupNode)featureOrGroupNode).getFeatureGroup() : ((FeatureNode)featureOrGroupNode).getFeature();
                if (featureOrGroup == null) {
                    return;
                }
                AbstractJob job = FeatureSelectionPage.this.findJob(featureOrGroupNode);
                if (job != null && job.isModify() && (productOffering = job.getOffering()) != null) {
                    IInstallableUnit iu = LicenseUtils.getFeatureIplaUnit((IOffering)productOffering, (IFeatureBase)featureOrGroup);
                    if (iu == null) {
                        return;
                    }
                    List jobs = FeatureSelectionPage.this.getJobs();
                    AbstractJob pekOfferingJob = null;
                    int i = 0;
                    while (i < jobs.size()) {
                        AbstractJob pekJob = (AbstractJob)jobs.get(i);
                        IOffering pekOffering = pekJob.getOffering();
                        if (pekOffering != null && pekJob.isInstall() && LicenseUtils.isPEKOffering((IOffering)pekOffering) && LicenseUtils.isPekApplicableToFeature((IOffering)pekOffering, (IOffering)productOffering, (IFeatureBase)featureOrGroup)) {
                            pekOfferingJob = pekJob;
                            break;
                        }
                        ++i;
                    }
                    if (pekOfferingJob != null) {
                        if (this.isSelected) {
                            pekOfferingJob.setSelected(true);
                        } else {
                            pekOfferingJob.setSelected(false);
                        }
                    }
                }
            }
        }
    }

    class BasicFeatureLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private final AgentUILabelProvider agentLabelProvider = AgentUI.getDefault().getLabelProvider();

        public BasicFeatureLabelProvider() {
            this.agentLabelProvider.connect((Object)this);
        }

        public void dispose() {
            this.agentLabelProvider.disconnect((Object)this);
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getText(element);
                }
            }
            return "";
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof AbstractJob) {
                IOffering offering = ((AbstractJob)element).getOffering();
                return this.agentLabelProvider.getOfferingImage(offering);
            }
            if (element instanceof FeatureGroupNode) {
                return this.agentLabelProvider.get(CommonImages.DESC_FEATUREGROUP_OBJ);
            }
            if (element instanceof FeatureNode) {
                return this.agentLabelProvider.get(CommonImages.DESC_FEATURE_OBJ);
            }
            if (element instanceof CategoryNode) {
                return this.agentLabelProvider.get(CICImages.DESC_CATEGORY_OBJ);
            }
            return null;
        }

        public String getText(Object element) {
            IOfferingOrFix offeringOrFix;
            if (element instanceof AbstractJob && (offeringOrFix = ((AbstractJob)element).getOfferingOrFix()) != null) {
                return OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix);
            }
            if (element instanceof FeatureGroupNode) {
                FeatureGroupNode groupNode = (FeatureGroupNode)element;
                if (groupNode.isVisible()) {
                    return SharedUIUtils.getFeatureBaseLabel((IFeatureBase)groupNode.getFeatureGroup());
                }
                return this.getText(groupNode.getParent());
            }
            if (element instanceof FeatureNode) {
                FeatureNode featureNode = (FeatureNode)element;
                if (featureNode.isVisible()) {
                    return SharedUIUtils.getFeatureBaseLabel((IFeatureBase)featureNode.getFeature());
                }
                return this.getText(featureNode.getParent());
            }
            if (element instanceof CategoryNode) {
                return ((CategoryNode)element).getName();
            }
            return super.getText(element);
        }
    }

    class CategoryNode
    extends AbstractNode {
        private final List children;
        private final String name;

        public CategoryNode(String name, Object parent) {
            super(parent);
            this.children = new ArrayList();
            this.name = name;
        }

        public void addAllFeatureNodes(List featureNodes) {
            this.children.addAll(featureNodes);
        }

        public void addFeatureNode(FeatureNode featureNode) {
            this.children.add(featureNode);
        }

        @Override
        public Object[] getChildren() {
            return this.children.toArray();
        }

        public List getChildrenList() {
            return this.children;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean isVisible() {
            return this.children.size() > 0;
        }
    }

    private static class FeatureDependencyContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private final FeatureGroupContentProvider featuresContentProvider;
        private List dependencyFeatureList;

        public FeatureDependencyContentProvider(FeatureGroupContentProvider featuresContentProvider) {
            this.featuresContentProvider = featuresContentProvider;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof CategoryNode) {
                Object[] children = ((CategoryNode)parentElement).getChildren();
                if (children == null || children.length == 0) {
                    return new Object[0];
                }
                Object parent = null;
                if (children[0] instanceof FeatureNode) {
                    parent = ((FeatureNode)children[0]).getParent();
                } else if (children[0] instanceof FeatureGroupNode) {
                    parent = ((FeatureGroupNode)children[0]).getParent();
                }
                while (parent != null && !(parent instanceof AbstractJob)) {
                    parent = parent instanceof FeatureGroupNode ? ((FeatureGroupNode)parent).getParent() : null;
                }
                if (parent != null) {
                    return new Object[]{parent};
                }
            } else {
                Object[] children = this.featuresContentProvider.getChildren(parentElement);
                ArrayList<Object> filteredChildren = new ArrayList<Object>();
                if (children != null && children.length > 0) {
                    Object[] objectArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (this.visibleDependencyNodes(element)) {
                            filteredChildren.add(element);
                        }
                        ++n2;
                    }
                }
                return filteredChildren.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof CategoryNode) {
                return this.getChildren(element).length > 0;
            }
            return this.featuresContentProvider.hasChildren(element);
        }

        public void setDependencyFeatureList(List featureList) {
            this.dependencyFeatureList = featureList;
        }

        private boolean visibleDependencyNodes(Object element) {
            if (element instanceof FeatureNode) {
                return ((FeatureNode)element).isVisible() && this.dependencyFeatureList.contains(element);
            }
            if (element instanceof FeatureGroupNode) {
                Object[] children = ((FeatureGroupNode)element).getChildren();
                if (children != null && children.length > 0) {
                    Object[] objectArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element2 = objectArray[n2];
                        if (this.visibleDependencyNodes(element2)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
    }

    class FeatureDependencyPart
    extends TreePart {
        public FeatureDependencyPart() {
            super(new String[0]);
        }

        @Override
        protected void selectionChanged(IStructuredSelection selection) {
            FeatureSelectionPage.this.featureDependencySelectionChanged(selection);
        }
    }

    class FeatureGroupContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        FeatureGroupContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AbstractJob) {
                Object[] children = (Object[])FeatureSelectionPage.this.jobsToGroupMap.get(parentElement);
                if (children == null) {
                    ArrayList<FeatureGroupNode> childrenList = new ArrayList<FeatureGroupNode>();
                    IOffering offering = ((AbstractJob)parentElement).getOffering();
                    if (offering != null) {
                        IFeatureGroup featureGroup = offering.getFeatureGroup();
                        childrenList.add(new FeatureGroupNode(featureGroup, parentElement));
                    }
                    children = childrenList.toArray(new Object[childrenList.size()]);
                    FeatureSelectionPage.this.jobsToGroupMap.put(parentElement, children);
                }
                ArrayList<Object> return_result = new ArrayList<Object>();
                if (children != null) {
                    Object[] objectArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof FeatureGroupNode) {
                            return_result.addAll(Arrays.asList(((FeatureGroupNode)object).getChildren()));
                        }
                        ++n2;
                    }
                }
                return return_result.toArray();
            }
            if (parentElement instanceof FeatureGroupNode) {
                return ((FeatureGroupNode)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public Object getParent(Object element) {
            if (element instanceof AbstractNode) {
                Object parentObj = ((AbstractNode)element).getParent();
                if (parentObj != null && parentObj instanceof FeatureGroupNode) {
                    Object grandParentObj = ((FeatureGroupNode)parentObj).getParent();
                    if (grandParentObj != null && grandParentObj instanceof AbstractJob) {
                        return grandParentObj;
                    }
                    return parentObj;
                }
                return parentObj;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    public class FeatureGroupNode
    extends AbstractNode {
        private Object[] children;
        private final IFeatureGroup featureGroup;
        private CategoryNode dependentsCategory;
        private CategoryNode dependsOnCategory;
        private IStatus applicabilityStatus;

        public FeatureGroupNode(IFeatureGroup featureGroup, Object parent) {
            super(parent);
            this.featureGroup = featureGroup;
            this.createChildren();
        }

        @Override
        public boolean canSelect() {
            AbstractJob job = FeatureSelectionPage.this.findJob(this);
            if (job != null) {
                return job.canBeSelected((IFeatureBase)this.featureGroup);
            }
            return true;
        }

        public void createChildren() {
            List childrenList = this.featureGroup.getChildren();
            ArrayList<AbstractNode> childrenNodes = new ArrayList<AbstractNode>();
            for (Object element : childrenList) {
                if (element instanceof IFeatureGroup) {
                    childrenNodes.add(new FeatureGroupNode((IFeatureGroup)element, this));
                    continue;
                }
                if (!(element instanceof IFeature)) continue;
                FeatureNode featureNode = new FeatureNode((IFeature)element, this);
                childrenNodes.add(featureNode);
                FeatureSelectionPage.this.addToFeatureMap(featureNode);
            }
            this.children = childrenNodes.toArray();
        }

        public IStatus getApplicabilityStatus() {
            if (this.applicabilityStatus == null) {
                AbstractJob job = FeatureSelectionPage.this.findJob(this);
                this.applicabilityStatus = job.getFeatureOrGroupApplicabilityStatus((IFeatureBase)this.featureGroup);
            }
            return this.applicabilityStatus;
        }

        @Override
        public Object[] getChildren() {
            return this.children;
        }

        public Object[] getDependencyCategories() {
            return new Object[]{this.getDependsOnCategory(), this.getDependentsCategory()};
        }

        public CategoryNode getDependentsCategory() {
            if (this.dependentsCategory == null) {
                this.dependentsCategory = new CategoryNode(Messages.FeatureSelectionPage_category_dependents, this);
                Object[] objectArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    FeatureNode featureNode;
                    Object element = objectArray[n2];
                    if (element instanceof FeatureNode && !(featureNode = (FeatureNode)element).isVisible()) {
                        List dependents = featureNode.getDependentsCategory().getChildrenList();
                        for (FeatureNode dependent : dependents) {
                            if (dependent.getParent() == this) continue;
                            this.dependentsCategory.addFeatureNode(dependent);
                        }
                    }
                    ++n2;
                }
            }
            return this.dependentsCategory;
        }

        public CategoryNode getDependsOnCategory() {
            if (this.dependsOnCategory == null) {
                this.dependsOnCategory = new CategoryNode(Messages.FeatureSelectionPage_category_dependsOn, this);
                Object[] objectArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    FeatureNode featureNode;
                    Object element = objectArray[n2];
                    if (element instanceof FeatureNode && !(featureNode = (FeatureNode)element).isVisible()) {
                        List dependsOn = featureNode.getDependsOnCategory().getChildrenList();
                        for (FeatureNode dependent : dependsOn) {
                            if (dependent.getParent() == this) continue;
                            this.dependsOnCategory.addFeatureNode(dependent);
                        }
                    }
                    ++n2;
                }
            }
            return this.dependsOnCategory;
        }

        public IFeatureGroup getFeatureGroup() {
            return this.featureGroup;
        }

        public boolean hasMutuallyExclusiveChildren() {
            return this.featureGroup.hasMutuallyExclusiveChildren();
        }

        @Override
        public boolean isRecommended() {
            AbstractJob job = FeatureSelectionPage.this.findJob(this);
            return job.isFeatureOrGroupRecommended((IFeatureBase)this.featureGroup);
        }

        @Override
        public boolean isRequired() {
            Object parentObj = this.getParent();
            if (parentObj != null && parentObj instanceof AbstractJob) {
                return true;
            }
            return this.featureGroup.isRequired();
        }

        @Override
        public void setSelected(boolean isSelected) {
            super.setSelected(isSelected);
            this.selectPekOfferingJob(this);
        }

        @Override
        public boolean isVisible() {
            IOffering po = this.getParentOfferingOfFeatureGroup(this.featureGroup);
            if (po != null && LicenseUtils.isPEKOffering((IOffering)po)) {
                return false;
            }
            AbstractJob job = FeatureSelectionPage.this.findJob(this);
            if (job != null) {
                return job.isFeatureOrGroupVisible((IFeatureBase)this.featureGroup);
            }
            return true;
        }

        private IOffering getParentOfferingOfFeatureGroup(IFeatureGroup fg) {
            if (FeatureSelectionPage.this.selectedJobs != null) {
                int i = 0;
                while (i < FeatureSelectionPage.this.selectedJobs.size()) {
                    IFeatureGroup rootFeatureGroup;
                    AbstractJob job = (AbstractJob)FeatureSelectionPage.this.selectedJobs.get(i);
                    IOffering offering = job.getOffering();
                    if (offering != null && (rootFeatureGroup = offering.getFeatureGroup()) != null && rootFeatureGroup.equals(fg)) {
                        return offering;
                    }
                    ++i;
                }
            }
            return null;
        }

        public String toString() {
            return this.featureGroup.toString();
        }
    }

    class FeatureGroupPart
    extends CheckboxTreePart {
        public FeatureGroupPart() {
            super(new String[0]);
        }

        @Override
        protected void elementChecked(Object element, boolean checked) {
            CheckboxTreeViewer treeViewer = this.getTreeViewer();
            FeatureSelectionPage.this.featureElementChecked(treeViewer, element, checked);
        }

        @Override
        protected void selectionChanged(IStructuredSelection selection) {
            FeatureSelectionPage.this.featureSelectionChanged(selection);
        }
    }

    class FeatureLabelProvider
    extends BasicFeatureLabelProvider
    implements ITableFontProvider {
        private final Color disabledColor;
        private Font boldFont;
        private final AgentUILabelProvider agentLabelProvider = AgentUI.getDefault().getLabelProvider();

        public FeatureLabelProvider(Display display) {
            this.agentLabelProvider.connect((Object)this);
            this.disabledColor = CommonUIUtils.createDisabledColor((Display)display);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.agentLabelProvider.disconnect((Object)this);
            this.disabledColor.dispose();
        }

        @Override
        public Color getForeground(Object element, int columnIndex) {
            FeatureGroupNode groupNode;
            if (element instanceof FeatureNode && !((FeatureNode)element).canSelect()) {
                return this.disabledColor;
            }
            if (element instanceof FeatureGroupNode && !(groupNode = (FeatureGroupNode)element).canSelect()) {
                return this.disabledColor;
            }
            if (element instanceof AbstractJob) {
                Object rootFeatureGroup = FeatureSelectionPage.this.jobsToGroupMap.get(element);
                if (rootFeatureGroup != null && rootFeatureGroup instanceof Object[]) {
                    Object[] rootArray = (Object[])rootFeatureGroup;
                    boolean displayDisabledColor = true;
                    int i = 0;
                    while (i < rootArray.length && displayDisabledColor) {
                        FeatureGroupNode groupNode2 = (FeatureGroupNode)rootArray[i];
                        if (this.hasVisibleChildren(groupNode2)) {
                            displayDisabledColor = false;
                        }
                        ++i;
                    }
                    if (displayDisabledColor) {
                        return this.disabledColor;
                    }
                } else {
                    return this.disabledColor;
                }
            }
            return super.getForeground(element, columnIndex);
        }

        private boolean hasVisibleChildren(FeatureGroupNode featureGroupNode) {
            Object[] children = featureGroupNode.getChildren();
            if (children == null || children.length == 0) {
                return false;
            }
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (((AbstractNode)element).isVisible()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                if (FeatureSelectionPage.this.hasNewVisibleFeature) {
                    return this.getFeatureStatus(element);
                }
                if (FeatureSelectionPage.this.hasLicensedFeatures) {
                    return this.getLicenseType(element);
                }
            } else if (columnIndex == 2) {
                return this.getLicenseType(element);
            }
            return super.getColumnText(element, columnIndex);
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof FeatureNode) {
                FeatureNode featureNode = (FeatureNode)element;
                AbstractJob job = FeatureSelectionPage.this.findJob(featureNode);
                if (job != null && job.getDependencySelectedFeatures().contains(featureNode.getFeature())) {
                    return this.agentLabelProvider.get(CICImages.DESC_FEATUREDEPENDENT_OBJ);
                }
                return null;
            }
            return super.getImage(element);
        }

        private String getFeatureStatus(Object element) {
            Set newFeatureSet;
            FeatureNode featureNode;
            AbstractJob job;
            if (element instanceof FeatureNode && (job = FeatureSelectionPage.this.findJob(featureNode = (FeatureNode)element)) != null && (newFeatureSet = (Set)FeatureSelectionPage.this.jobToNewFeaturesMap.get(job)) != null && newFeatureSet.contains(featureNode.getFeature())) {
                return Messages.FeatureSelectionPage_newFeature;
            }
            return "";
        }

        private String getLicenseType(Object element) {
            String runtimeLicenseKind;
            if (!(element instanceof FeatureGroupNode) && !(element instanceof FeatureNode)) {
                return "";
            }
            AbstractNode node = (AbstractNode)element;
            AbstractJob job = FeatureSelectionPage.this.findJob(node);
            if (job == null) {
                return "";
            }
            IOffering offering = job.getOffering();
            if (offering == null) {
                return "";
            }
            IFeatureGroup featureBase = null;
            if (node instanceof FeatureGroupNode) {
                featureBase = ((FeatureGroupNode)node).getFeatureGroup();
            } else if (node instanceof FeatureNode) {
                featureBase = ((FeatureNode)node).getFeature();
            }
            if (featureBase == null) {
                return "";
            }
            IInstallableUnit iu = LicenseUtils.getFeatureIplaUnit((IOffering)offering, (IFeatureBase)featureBase);
            if (iu == null) {
                return "";
            }
            IOffering[] pekOfferings = this.getPekOfferings();
            IOffering applicablePekOffering = AgentUtil.getApplicablePekOffering((IOffering)offering, (IFeatureBase)featureBase, Arrays.asList(pekOfferings));
            if (applicablePekOffering != null) {
                return LicenseUtils.getLicenseKinds((IOffering)applicablePekOffering, (boolean)true);
            }
            if (job.isModify() || job.isUpdate()) {
                boolean isInstalled = this.isFeatureBaseInstalled((IFeatureBase)featureBase, job);
                String runtimeLicenseKind2 = LicenseUtils.getRuntimeLicenseKind((IInstallableUnit)iu);
                if (isInstalled || !runtimeLicenseKind2.equals(LicenseUtils.LICENSE_TYPE_NODELOCKED)) {
                    return runtimeLicenseKind2;
                }
            } else if (this.isOfferingInstalled(offering) && !(runtimeLicenseKind = LicenseUtils.getRuntimeLicenseKind((IInstallableUnit)iu)).equals(LicenseUtils.LICENSE_TYPE_NODELOCKED)) {
                return runtimeLicenseKind;
            }
            return LicenseUtils.getLocalizedLicenseKind((IInstallableUnit)iu);
        }

        public IOffering[] getPekOfferings() {
            ArrayList<IOffering> return_value = new ArrayList<IOffering>();
            List jobs = FeatureSelectionPage.this.getJobs();
            int i = 0;
            while (i < jobs.size()) {
                AbstractJob job = (AbstractJob)jobs.get(i);
                IOffering offering = job.getOffering();
                if (offering != null && LicenseUtils.isPEKOffering((IOffering)offering)) {
                    return_value.add(offering);
                }
                ++i;
            }
            return return_value.toArray(new IOffering[return_value.size()]);
        }

        private boolean isOfferingInstalled(IOffering offering) {
            HashSet installedOfferings = AgentUIUtils.getInstalledProductOfferings();
            return installedOfferings.contains(offering);
        }

        private boolean isFeatureBaseInstalled(IFeatureBase featureBase, AbstractJob job) {
            Profile profile = job.getProfile();
            IOffering offering = null;
            if (job.isModify()) {
                offering = job.getOffering();
            } else if (job.isUpdate()) {
                offering = ((UpdateOfferingJob)job).getUpdatedOffering();
            }
            if (offering != null) {
                Agent agent = AgentUI.getDefault().getAgent();
                Set installedFeatures = agent.getInstalledFeatures(profile, offering);
                if (featureBase instanceof IFeature) {
                    return installedFeatures.contains(featureBase);
                }
                if (featureBase instanceof IFeatureGroup) {
                    IFeatureGroup group = (IFeatureGroup)featureBase;
                    AgentUIUtils.isFeatureGroupInstalled(group, profile, offering);
                }
            }
            return false;
        }

        public Font getFont(Object element, int columnIndex) {
            Set newFeatures;
            FeatureNode featureNode;
            AbstractJob job;
            if (element instanceof FeatureNode && FeatureSelectionPage.this.hasNewVisibleFeature && (job = FeatureSelectionPage.this.findJob(featureNode = (FeatureNode)element)) != null && (newFeatures = (Set)FeatureSelectionPage.this.jobToNewFeaturesMap.get(job)) != null && newFeatures.contains(featureNode.getFeature())) {
                if (this.boldFont == null) {
                    FontData[] data = JFaceResources.getDefaultFont().getFontData();
                    this.boldFont = JFaceResources.getFontRegistry().getBold(data[0].getName());
                }
                return this.boldFont;
            }
            return JFaceResources.getDefaultFont();
        }

        public Image getFeatureDependencyImage() {
            return this.agentLabelProvider.get(CICImages.DESC_FEATUREDEPENDENT_OBJ);
        }
    }

    public class FeatureNode
    extends AbstractNode {
        private final IFeature feature;
        private CategoryNode dependsOnCategory;
        private CategoryNode dependentsCategory;
        private IStatus applicabilityStatus;
        private IStatus auxiliaryApplicabilityStatus;

        FeatureNode(IFeature feature, FeatureGroupNode parent) {
            super(parent);
            this.feature = feature;
        }

        @Override
        public boolean canSelect() {
            AbstractJob job = FeatureSelectionPage.this.findJob(this);
            if (job != null) {
                return job.canBeSelected((IFeatureBase)this.feature);
            }
            return true;
        }

        @Override
        public boolean canRemove() {
            AbstractJob job = FeatureSelectionPage.this.findJob(this);
            if (job != null) {
                return job.canBeRemoved((IFeatureBase)this.feature);
            }
            return true;
        }

        public void createDependencies(AbstractJob job) {
            this.dependsOnCategory = new CategoryNode(Messages.FeatureSelectionPage_category_dependsOn, this);
            this.dependentsCategory = new CategoryNode(Messages.FeatureSelectionPage_category_dependents, this);
            this.dependsOnCategory.addAllFeatureNodes(FeatureSelectionPage.this.getDependsOnFeatures(job, this));
            this.dependentsCategory.addAllFeatureNodes(FeatureSelectionPage.this.getDependentFeatures(job, this));
        }

        public IStatus getApplicabilityStatus() {
            if (this.applicabilityStatus == null) {
                AbstractJob job = FeatureSelectionPage.this.findJob(this);
                this.applicabilityStatus = job.getFeatureOrGroupApplicabilityStatus((IFeatureBase)this.feature);
            }
            return this.applicabilityStatus;
        }

        public IStatus getAuxiliaryApplicabilityStatus() {
            if (this.auxiliaryApplicabilityStatus == null) {
                AbstractJob job = FeatureSelectionPage.this.findJob(this);
                this.auxiliaryApplicabilityStatus = job.getFeatureOrGroupAuxiliaryApplicabilityStatus((IFeatureBase)this.feature);
            }
            return this.auxiliaryApplicabilityStatus;
        }

        @Override
        public Object[] getChildren() {
            return new Object[0];
        }

        public Object[] getDependencyCategories() {
            return new Object[]{this.dependsOnCategory, this.dependentsCategory};
        }

        public CategoryNode getDependentsCategory() {
            return this.dependentsCategory;
        }

        public CategoryNode getDependsOnCategory() {
            return this.dependsOnCategory;
        }

        public IFeature getFeature() {
            return this.feature;
        }

        @Override
        public boolean isRecommended() {
            AbstractJob job = FeatureSelectionPage.this.findJob(this);
            return job.isFeatureOrGroupRecommended((IFeatureBase)this.feature);
        }

        @Override
        public boolean isRequired() {
            return this.feature.isRequired();
        }

        @Override
        public boolean isVisible() {
            AbstractJob job = FeatureSelectionPage.this.findJob(this);
            if (job != null) {
                return job.isFeatureOrGroupVisible((IFeatureBase)this.feature);
            }
            return true;
        }

        @Override
        public void setSelected(boolean isSelected) {
            super.setSelected(isSelected);
            AbstractJob job = FeatureSelectionPage.this.findJob(this);
            if (job != null) {
                if (isSelected) {
                    if (this.canSelect()) {
                        job.addFeature(this.feature);
                    } else if (this.canRemove()) {
                        job.removeFeature(this.feature);
                    } else {
                        job.addFeature(this.feature);
                    }
                } else {
                    job.removeFeature(this.feature);
                }
                this.selectPekOfferingJob(this);
            }
        }

        public String toString() {
            return this.feature.toString();
        }
    }

    class FeatureViewerFilter
    extends ViewerFilter {
        FeatureViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return FeatureSelectionPage.this.isVisibleItem(element);
        }
    }
}

