/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.sharedUI.FeatureGroupStatus;
import com.ibm.cic.agent.core.sharedUI.FeatureStatus;
import com.ibm.cic.agent.core.sharedUI.OfferingFeatureStatus;
import com.ibm.cic.agent.core.sharedUI.PrerequisiteCheckerUtils;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.FormTextUtil;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.services.IClipboard;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ConditionalInstallPage
extends AbstractAgentUIWizardPage {
    private List offeringFeatureStatusList = null;
    private boolean isSkipped = false;
    private StackLayout viewerLayout;
    private Composite successComp;
    private Composite errorComp;
    private TreeViewer viewer;
    private FormText detailsDesc;
    private ScrolledComposite detailsComp;
    private IClipboard clipboard;
    private IStatus selectedDisplayStatus;
    private static final String showDetailsActionID = "showdetails_id";

    public ConditionalInstallPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(com.ibm.cic.agent.internal.ui.licenses.Messages.ConditionalInstallPage_title, toolkit, com.ibm.cic.agent.internal.ui.licenses.Messages.ConditionalInstallPage_title, Messages.ConditionalInstallPage_des, wizard);
    }

    public ConditionalInstallPage(FormToolkit toolkit, AgentUIWizard wizard, String title) {
        super(title, toolkit, com.ibm.cic.agent.internal.ui.licenses.Messages.ConditionalInstallPage_title, Messages.ConditionalInstallPage_des, wizard);
    }

    public ConditionalInstallPage(String id, FormToolkit toolkit, String title, String description, AgentUIWizard wizard) {
        super(id, toolkit, title, description, wizard);
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    private void primeSelection() {
        Tree msgTree = this.viewer.getTree();
        if (msgTree.getItemCount() > 0) {
            Object selection = null;
            TreeItem item = msgTree.getItem(0);
            Object data = item.getData();
            if (data instanceof OfferingFeatureStatus) {
                CicMultiStatus status = ((OfferingFeatureStatus)data).getOfferingOrFixStatus();
                if (status != null) {
                    selection = data;
                } else {
                    int childrenCount = item.getItemCount();
                    if (childrenCount > 0) {
                        TreeItem firstChildItem = item.getItem(0);
                        selection = firstChildItem.getData();
                    }
                }
            }
            if (selection != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection(selection));
            }
        }
    }

    private void createErrorSection(FormToolkit toolKit, Composite parent) {
        SashForm sashForm = new SashForm(parent, 0);
        toolKit.adapt((Control)sashForm, false, false);
        GridLayout formLayout = new GridLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        sashForm.setLayout((Layout)formLayout);
        sashForm.setLayoutData((Object)new GridData(1808));
        sashForm.setOrientation(256);
        Composite treeComposite = toolKit.createComposite((Composite)sashForm);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        treeComposite.setLayout((Layout)layout);
        treeComposite.setLayoutData((Object)new GridData(1808));
        this.viewer = new TreeViewer(treeComposite, 2820);
        this.getToolkit().adapt(this.viewer.getControl(), true, true);
        this.viewer.setContentProvider((IContentProvider)new FeatureStatusContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FeatureStatusLabelProvider());
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.viewer.getTree().getItemHeight() * 5;
        gridData.widthHint = 200;
        CtrlcKeyListener ctrlcListener = new CtrlcKeyListener();
        this.viewer.getTree().addKeyListener((KeyListener)ctrlcListener);
        this.viewer.getTree().setLayoutData((Object)gridData);
        new TreeColumn(this.viewer.getTree(), 0x800000);
        this.viewer.setInput(null);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection structuredSelection;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !(structuredSelection = (StructuredSelection)selection).isEmpty()) {
                    Object selectedElement = structuredSelection.getFirstElement();
                    ConditionalInstallPage.this.showDetails(selectedElement);
                }
            }
        });
        this.detailsComp = new ScrolledComposite((Composite)sashForm, 2816);
        this.getToolkit().adapt((Composite)this.detailsComp);
        GridData compData = new GridData(1808);
        compData.widthHint = 300;
        this.detailsComp.setLayoutData((Object)compData);
        final Composite linkContainer = this.getToolkit().createComposite((Composite)this.detailsComp, 0);
        GridLayout linkContainerLayout = new GridLayout();
        linkContainerLayout.verticalSpacing = 0;
        linkContainerLayout.horizontalSpacing = 0;
        linkContainer.setLayout((Layout)linkContainerLayout);
        this.detailsComp.setContent((Control)linkContainer);
        this.detailsComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle rec = ConditionalInstallPage.this.detailsComp.getClientArea();
                int width = rec.width;
                ScrollBar vBar = ConditionalInstallPage.this.detailsComp.getVerticalBar();
                if (vBar != null) {
                    int scrollBarWidth = vBar.getSize().x;
                    width -= scrollBarWidth;
                }
                Point point = linkContainer.computeSize(width > 0 ? width : -1, -1);
                linkContainer.setSize(point);
                linkContainer.layout();
            }
        });
        this.detailsDesc = new FormText(linkContainer, 64);
        GridData detailsData = new GridData(1808);
        detailsData.widthHint = 300;
        this.detailsDesc.setLayoutData((Object)detailsData);
        this.detailsDesc.setHyperlinkSettings((HyperlinkSettings)this.getToolkit().getHyperlinkGroup());
        this.detailsDesc.setParagraphsSeparated(true);
        this.detailsDesc.setWhitespaceNormalized(true);
        this.detailsDesc.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String href = e.getHref().toString();
                if (ConditionalInstallPage.showDetailsActionID.contentEquals(href)) {
                    if (ConditionalInstallPage.this.selectedDisplayStatus != null) {
                        WrapDetailUIDErrorDialog dlg = new WrapDetailUIDErrorDialog(ConditionalInstallPage.this.detailsDesc.getShell(), CommonUIUtils.getDialogTitleBasedOnStatus((IStatus)ConditionalInstallPage.this.selectedDisplayStatus), null, ConditionalInstallPage.this.selectedDisplayStatus, 14, true);
                        dlg.open();
                    }
                } else {
                    AgentUI.getDefault().showURL(href);
                }
            }
        });
        FormTextCtrlCkeyListener formTextctrlcListener = new FormTextCtrlCkeyListener();
        this.detailsDesc.addKeyListener((KeyListener)formTextctrlcListener);
        sashForm.setWeights(new int[]{35, 65});
    }

    private void refreshPressed() {
        this.offeringFeatureStatusList = this.validateFeatures();
        this.resetLayout();
    }

    private void resetLayout() {
        if (this.offeringFeatureStatusList.isEmpty()) {
            this.viewerLayout.topControl = this.successComp;
            this.successComp.getParent().layout();
            this.setDescription(Messages.ConditionalInstallPage_des2);
            this.setPageComplete(true);
        } else {
            boolean hasError = this.hasError(this.offeringFeatureStatusList);
            this.viewerLayout.topControl = this.errorComp;
            this.viewer.setInput((Object)this.offeringFeatureStatusList);
            this.viewer.expandAll();
            this.viewer.getTree().getColumn(0).pack();
            this.errorComp.getParent().layout();
            this.primeSelection();
            if (this.offeringFeatureStatusList.size() == 1) {
                this.setDescription(Messages.ConditionalInstallPage_des2);
            } else {
                this.setDescription(Messages.ConditionalInstallPage_des);
            }
            this.setPageComplete(!hasError);
        }
    }

    private String addShowDetails(String displayMsg) {
        StringBuffer returnString = new StringBuffer(displayMsg);
        returnString.append(LogUtil.NEWLINE);
        returnString.append("<a href=\"showdetails_id\"> " + com.ibm.cic.common.ui.internal.Messages.ConditionalPage_showDetail + "</a>");
        return returnString.toString();
    }

    private String calculateDetailMsgStatus(IStatus status, String doubleNewLineMsg, String singleNewLineMsg) {
        String resultMsg = doubleNewLineMsg;
        if (CommonSharedUIUtils.hasUID((IStatus)status, (boolean)true)) {
            CicMultiStatus multiStatus;
            String statusMsg;
            resultMsg = this.addShowDetails(singleNewLineMsg);
            if (status instanceof CicMultiStatus && ((statusMsg = (multiStatus = (CicMultiStatus)status).getMessage()) == null || statusMsg.length() == 0)) {
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    CicMultiStatus mStatus = Statuses.ERROR.getMultiStatus(doubleNewLineMsg, new Object[0]);
                    mStatus.addAll((IStatus)multiStatus);
                    this.selectedDisplayStatus = mStatus;
                } else if (status.getSeverity() == 2) {
                    CicMultiStatus mStatus = Statuses.WARNING.getMultiStatus(doubleNewLineMsg, new Object[0]);
                    mStatus.addAll((IStatus)multiStatus);
                    this.selectedDisplayStatus = mStatus;
                }
            }
        }
        return resultMsg;
    }

    private String getDetails(Object element, StringBuffer copyBuffer) {
        String detailMsg = "";
        this.selectedDisplayStatus = null;
        if (element instanceof OfferingFeatureStatus) {
            OfferingFeatureStatus ofStatus = (OfferingFeatureStatus)element;
            CicMultiStatus status = ofStatus.getOfferingOrFixStatus();
            if (status != null && !status.isOK()) {
                this.selectedDisplayStatus = status;
                detailMsg = MultiStatusUtil.getFailureMessage((IStatus)status, (String)(String.valueOf(LogUtil.NEWLINE) + LogUtil.NEWLINE)).trim();
                if (detailMsg.length() > 0) {
                    copyBuffer.append(detailMsg);
                    String singleNewLineMsg = MultiStatusUtil.getFailureMessage((IStatus)status, (String)LogUtil.NEWLINE).trim();
                    detailMsg = this.calculateDetailMsgStatus((IStatus)status, detailMsg, singleNewLineMsg);
                } else {
                    if (status.matches(12)) {
                        detailMsg = NLS.bind((String)Messages.ConditionalInstallPage_errorMsg1, (Object)ofStatus.getOfferingOrFix().getName());
                    } else if (status.matches(3)) {
                        detailMsg = NLS.bind((String)Messages.ConditionalInstallPage_errorMsg2, (Object)ofStatus.getOfferingOrFix().getName());
                    }
                    copyBuffer.append(detailMsg);
                }
            } else {
                boolean hasErrorFeatureOrGroup = ofStatus.offeringContainErrorFeatureOrGroup();
                detailMsg = hasErrorFeatureOrGroup ? NLS.bind((String)Messages.ConditionalInstallPage_errorMsg1, (Object)ofStatus.getOfferingOrFix().getName()) : NLS.bind((String)Messages.ConditionalInstallPage_errorMsg2, (Object)ofStatus.getOfferingOrFix().getName());
                copyBuffer.append(detailMsg);
            }
        } else if (element instanceof FeatureStatus || element instanceof FeatureGroupStatus) {
            String featureOrGroupName = null;
            featureOrGroupName = element instanceof FeatureStatus ? ((FeatureStatus)element).getFeatureLabel() : ((FeatureGroupStatus)element).getFeatureGroupLabel();
            IStatus status = null;
            status = element instanceof FeatureStatus ? ((FeatureStatus)element).getStatus() : ((FeatureGroupStatus)element).getStatus();
            this.selectedDisplayStatus = status;
            detailMsg = MultiStatusUtil.getFailureMessage((IStatus)status, (String)(String.valueOf(LogUtil.NEWLINE) + LogUtil.NEWLINE)).trim();
            if (detailMsg.length() > 0) {
                copyBuffer.append(detailMsg);
                String singleNewLineMsg = MultiStatusUtil.getFailureMessage((IStatus)status, (String)LogUtil.NEWLINE).trim();
                detailMsg = this.calculateDetailMsgStatus(status, detailMsg, singleNewLineMsg);
            } else {
                if (status.matches(12)) {
                    detailMsg = NLS.bind((String)Messages.ConditionalInstallPage_errorMsg1, (Object)featureOrGroupName);
                } else if (status.matches(3)) {
                    detailMsg = NLS.bind((String)Messages.ConditionalInstallPage_errorMsg2, (Object)featureOrGroupName);
                }
                copyBuffer.append(detailMsg);
            }
        }
        return detailMsg;
    }

    private void showDetails(Object element) {
        String detailMsg = this.getDetails(element, new StringBuffer()).replaceAll("\n", "<br/>").replaceAll("&&", "&");
        try {
            this.detailsDesc.setText("<form><p>" + FormTextUtil.escapeHTMLString((String)detailMsg).toString() + "</p></form>", true, true);
        }
        catch (IllegalArgumentException e) {
            Agent.getLogger().note((Throwable)e);
            this.detailsDesc.setText(detailMsg, false, true);
        }
        Composite parent = this.detailsDesc.getParent();
        if (parent != null) {
            Rectangle rec = this.detailsComp.getClientArea();
            if (rec.height == 0 && rec.width == 0 && rec.x == 0 && rec.y == 0) {
                return;
            }
            int width = rec.width;
            ScrollBar vBar = this.detailsComp.getVerticalBar();
            if (vBar != null) {
                width -= vBar.getSize().x;
            }
            Point minSize = parent.computeSize(width > 0 ? width : -1, -1);
            parent.setSize(minSize);
            parent.layout();
        }
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = this.getToolkit().createComposite(parent);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        Section errorMsgSection = this.getToolkit().createSection(container, 512);
        errorMsgSection.setText(Messages.ConditionalInstallPage_error);
        Composite msgComposite = this.getToolkit().createComposite((Composite)errorMsgSection);
        GridLayout msgLayout = new GridLayout();
        msgLayout.marginHeight = 0;
        msgLayout.marginWidth = 0;
        msgComposite.setLayout((Layout)msgLayout);
        msgComposite.setLayoutData((Object)new GridData(1808));
        errorMsgSection.setClient((Control)msgComposite);
        errorMsgSection.setLayoutData((Object)new GridData(1808));
        Composite layoutComp = this.getToolkit().createComposite(msgComposite);
        this.viewerLayout = new StackLayout();
        this.viewerLayout.marginWidth = 0;
        this.viewerLayout.marginHeight = 0;
        layoutComp.setLayout((Layout)this.viewerLayout);
        layoutComp.setLayoutData((Object)new GridData(1808));
        this.errorComp = this.getToolkit().createComposite(layoutComp, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.errorComp.setLayout((Layout)gridLayout);
        this.errorComp.setLayoutData((Object)new GridData(1808));
        this.createErrorSection(this.getToolkit(), this.errorComp);
        this.successComp = this.getToolkit().createComposite(layoutComp, 2048);
        this.successComp.setLayout((Layout)new GridLayout());
        this.successComp.setLayoutData((Object)new GridData(1808));
        Label validationSuccessLabel = this.getToolkit().createLabel(this.successComp, com.ibm.cic.agent.core.sharedUI.Messages.ConditionalInstallPage_validationSuccess, 64);
        validationSuccessLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Button successRefreshButton = this.getToolkit().createButton(msgComposite, Messages.ConditionalInstallPage_refreshButton, 8);
        successRefreshButton.setLayoutData((Object)new GridData(131072, 1024, false, false));
        successRefreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionalInstallPage.this.refreshPressed();
            }
        });
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    @Override
    protected void setFocus() {
        if (this.offeringFeatureStatusList == null) {
            this.offeringFeatureStatusList = this.validateFeatures();
        }
        this.resetLayout();
        this.viewer.getTree().setFocus();
    }

    private boolean hasError(List featureStatus) {
        for (OfferingFeatureStatus offeringFeatureStatus : featureStatus) {
            CicMultiStatus offeringOrFixStatus = offeringFeatureStatus.getOfferingOrFixStatus();
            if (offeringOrFixStatus != null && offeringOrFixStatus.matches(12)) {
                return true;
            }
            boolean hasErrorFeatureOrGroup = offeringFeatureStatus.offeringContainErrorFeatureOrGroup();
            if (!hasErrorFeatureOrGroup) continue;
            return true;
        }
        return false;
    }

    public boolean shouldSkip() {
        boolean shouldSkip;
        if (this.offeringFeatureStatusList == null) {
            this.offeringFeatureStatusList = this.validateFeatures();
        }
        this.isSkipped = shouldSkip = this.offeringFeatureStatusList.isEmpty();
        return shouldSkip;
    }

    public boolean isPageComplete() {
        if (this.isSkipped) {
            return true;
        }
        return super.isPageComplete();
    }

    public IWizardPage skipToNextPage() {
        this.setPageComplete(true);
        return this.getNextPage();
    }

    public List validateFeatures() {
        final ArrayList statusList = new ArrayList();
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    statusList.addAll(PrerequisiteCheckerUtils.validateFeatures((IProgressMonitor)monitor, (List)ConditionalInstallPage.this.getSelectedJobs(), (boolean)AgentUI.getDefault().getAgentPreferenceStore().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key()), (ConditionalInstallPage.this.getAgentWizard().getWizardType().equals(WizardType.INSTALL) && !ConditionalInstallPage.this.getAgentWizard().isMultipleProfileInstall() ? 1 : 0) != 0));
                }
            });
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e, false);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e, false);
        }
        return statusList;
    }

    private class CtrlcKeyListener
    extends KeyAdapter {
        private CtrlcKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\u0003') {
                if (ConditionalInstallPage.this.clipboard != null) {
                    ConditionalInstallPage.this.clipboard.dispose();
                }
                ConditionalInstallPage.this.clipboard = UiServices.getInstance().createClipboard(DisplayKeeper.INSTANCE.getDisplay());
                if (ConditionalInstallPage.this.clipboard != null) {
                    Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
                    TreeItem[] selectedItems = ConditionalInstallPage.this.viewer.getTree().getSelection();
                    Object[] copyText = new String[selectedItems.length];
                    int i = 0;
                    while (i < selectedItems.length) {
                        StringBuffer copyTextBuffer = new StringBuffer();
                        ConditionalInstallPage.this.getDetails(selectedItems[i].getData(), copyTextBuffer);
                        copyText[i] = copyTextBuffer.toString();
                        ++i;
                    }
                    ConditionalInstallPage.this.clipboard.setContents(copyText, types);
                }
            }
        }
    }

    private static class FeatureStatusContentProvider
    implements ITreeContentProvider {
        private FeatureStatusContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof OfferingFeatureStatus) {
                ArrayList result = new ArrayList();
                OfferingFeatureStatus offeringFeatureStatus = (OfferingFeatureStatus)parentElement;
                result.addAll(offeringFeatureStatus.getFeatureStatusList());
                result.addAll(offeringFeatureStatus.getFeatureGroupStatusList());
                return result.toArray();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof OfferingFeatureStatus) {
                OfferingFeatureStatus offeringFeatureStatus = (OfferingFeatureStatus)element;
                List featureStatusList = offeringFeatureStatus.getFeatureStatusList();
                if (featureStatusList != null && !featureStatusList.isEmpty()) {
                    return true;
                }
                List featureGroupStatusList = offeringFeatureStatus.getFeatureGroupStatusList();
                if (featureGroupStatusList != null && !featureGroupStatusList.isEmpty()) {
                    return true;
                }
            }
            return false;
        }

        public void inputChanged(Viewer theViewer, Object oldInput, Object newInput) {
        }
    }

    private static class FeatureStatusLabelProvider
    implements ITableLabelProvider {
        private final AgentUILabelProvider agentUILabelProvider = AgentUI.getDefault().getLabelProvider();

        FeatureStatusLabelProvider() {
            this.agentUILabelProvider.connect(this);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.agentUILabelProvider.disconnect(this);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof FeatureStatus) {
                    IStatus status = ((FeatureStatus)element).getStatus();
                    if (status.matches(12)) {
                        return this.agentUILabelProvider.get(CommonImages.LOG_ERROR);
                    }
                    if (status.matches(2)) {
                        return this.agentUILabelProvider.get(CommonImages.LOG_WARNING);
                    }
                    if (status.matches(1)) {
                        return this.agentUILabelProvider.get(CommonImages.LOG_INFO);
                    }
                    return this.agentUILabelProvider.get(CommonImages.DESC_FEATURE_OBJ);
                }
                if (element instanceof FeatureGroupStatus) {
                    IStatus status = ((FeatureGroupStatus)element).getStatus();
                    if (status.matches(12)) {
                        return this.agentUILabelProvider.get(CommonImages.LOG_ERROR);
                    }
                    if (status.matches(2)) {
                        return this.agentUILabelProvider.get(CommonImages.LOG_WARNING);
                    }
                    if (status.matches(1)) {
                        return this.agentUILabelProvider.get(CommonImages.LOG_INFO);
                    }
                    return this.agentUILabelProvider.get(CommonImages.DESC_FEATUREGROUP_OBJ);
                }
                if (element instanceof OfferingFeatureStatus) {
                    IOfferingOrFix offeringOrFix;
                    OfferingFeatureStatus ofStatus = (OfferingFeatureStatus)element;
                    CicMultiStatus status = ofStatus.getOfferingOrFixStatus();
                    if (status != null) {
                        if (status.matches(12)) {
                            return this.agentUILabelProvider.get(CommonImages.LOG_ERROR);
                        }
                        if (status.matches(2)) {
                            return this.agentUILabelProvider.get(CommonImages.LOG_WARNING);
                        }
                        if (status.matches(1)) {
                            return this.agentUILabelProvider.get(CommonImages.LOG_INFO);
                        }
                    }
                    if ((offeringOrFix = ((OfferingFeatureStatus)element).getOfferingOrFix()) instanceof IOffering) {
                        return this.agentUILabelProvider.getOfferingImage((IOffering)offeringOrFix);
                    }
                    return this.agentUILabelProvider.get(CommonImages.DESC_FIX_OBJ);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof OfferingFeatureStatus) {
                    OfferingFeatureStatus offeringFeatureStatus = (OfferingFeatureStatus)element;
                    IOfferingOrFix offeringOrFix = offeringFeatureStatus.getOfferingOrFix();
                    return AgentUIUtils.getOfferingOrFixLabel(offeringOrFix);
                }
                if (element instanceof FeatureStatus) {
                    return ((FeatureStatus)element).getFeatureLabel();
                }
                if (element instanceof FeatureGroupStatus) {
                    return ((FeatureGroupStatus)element).getFeatureGroupLabel();
                }
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class FormTextCtrlCkeyListener
    extends KeyAdapter {
        private FormTextCtrlCkeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\u0003') {
                ConditionalInstallPage.this.detailsDesc.copy();
            }
        }
    }
}

