/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SpaceInfoUtils;
import com.ibm.cic.agent.internal.core.AgentPathValidator;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.InstallAgentUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.wizardry.AbstractCicWizardPage;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class CommonLocationPage
extends AbstractAgentUIWizardPage {
    public static final CustomMessageWizardPage.ErrorId COMMON_LOCATION_ERROR = new CustomMessageWizardPage.ErrorId();
    public static final CustomMessageWizardPage.WarningId COMMON_LOCATION_WARNING = new CustomMessageWizardPage.WarningId();
    private String eclipseCacheLocation = null;
    private Button commonLocationButton;
    private Text commonLocationText;
    private Table diskspaceTable;
    private Composite locationComposite;
    private Composite detailsComposite;
    private boolean hasCommonLocationError = false;
    private boolean hasAgentInstallLocationError = false;
    public static final CustomMessageWizardPage.ErrorId AGENT_INSTALL_LOCATION_ERROR = new CustomMessageWizardPage.ErrorId();
    public static final CustomMessageWizardPage.WarningId AGENT_INSTALL_LOCATION_WARNING = new CustomMessageWizardPage.WarningId();
    private Button agentLocationButton;
    private Text agentLocationText;
    private IOffering agentOffering;
    private Profile agentProfile;
    private AbstractJob agentJob;
    private boolean hasAgentInstalled;

    public CommonLocationPage(FormToolkit toolkit, AgentUIWizard wizard, String desc) {
        super(toolkit, com.ibm.cic.agent.internal.ui.licenses.Messages.InstallLocationPage_title, desc, wizard);
    }

    @Override
    public void createControl(Composite parent) {
        this.detailsComposite = this.getToolkit().createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 5;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        this.detailsComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 1, true, false);
        this.detailsComposite.setLayoutData((Object)gd);
        this.createWarningArea(this.detailsComposite);
        this.createCommonLocationArea(this.detailsComposite);
        if (AgentUtil.hasInstallAgentJob((List)this.getSelectedJobs())) {
            Label separatorLabel = new Label(this.locationComposite, 0);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.horizontalSpan = 3;
            separatorLabel.setLayoutData((Object)gridData);
            Composite AgentWarningComp = this.toolkit.createComposite(this.locationComposite, 2048);
            layout = new GridLayout();
            layout.numColumns = 2;
            AgentWarningComp.setLayout((Layout)layout);
            gridData = new GridData(4, 1, true, false);
            gridData.horizontalSpan = 3;
            AgentWarningComp.setLayoutData((Object)gridData);
            Label warningIcon = this.toolkit.createLabel(AgentWarningComp, "", 0);
            warningIcon.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
            warningIcon.setImage(DisplayKeeper.INSTANCE.getDisplay().getSystemImage(2));
            Label AgentWarningMessage = this.toolkit.createLabel(AgentWarningComp, Messages.AgentInstallLocationPage_warningMsg, 64);
            AgentWarningMessage.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.createInstallLocationArea(this.locationComposite);
            Label separatorLabel2 = new Label(this.locationComposite, 0);
            gridData = new GridData(4, 1, true, false);
            gridData.horizontalSpan = 3;
            separatorLabel2.setLayoutData((Object)gridData);
        }
        this.createDiskspaceSection(this.detailsComposite);
        this.setControl((Control)this.detailsComposite);
    }

    private void createWarningArea(Composite parent) {
        Composite warningComposite = this.toolkit.createComposite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        warningComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 1, true, false);
        data.horizontalIndent = 5;
        warningComposite.setLayoutData((Object)data);
        Label warningIcon = this.toolkit.createLabel(warningComposite, "", 0);
        warningIcon.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        warningIcon.setImage(DisplayKeeper.INSTANCE.getDisplay().getSystemImage(8));
        Label warningMessage = this.toolkit.createLabel(warningComposite, Messages.CommonLocationPage_informationMessage, 64);
        warningMessage.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createCommonLocationArea(final Composite parent) {
        this.locationComposite = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 2;
        this.locationComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 1, true, false);
        data.horizontalIndent = 2;
        this.locationComposite.setLayoutData((Object)data);
        String initialEclipseCacheLocation = "";
        try {
            initialEclipseCacheLocation = this.getEclipseCacheLocation();
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
            this.setErrorState(COMMON_LOCATION_ERROR, e.getMessage());
            this.hasCommonLocationError = true;
            this.setPageComplete(false);
            initialEclipseCacheLocation = "";
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.trim().length() == 0) {
                message = e.toString();
            }
            this.setErrorState(COMMON_LOCATION_ERROR, message);
            this.hasCommonLocationError = true;
            this.setPageComplete(false);
            AgentUI.reportException(e, false);
            initialEclipseCacheLocation = "";
        }
        this.toolkit.createLabel(this.locationComposite, Messages.CommonLocationPage_commonLocationLabel);
        this.commonLocationText = this.toolkit.createText(this.locationComposite, TextProcessor.process((String)initialEclipseCacheLocation), 2048);
        this.commonLocationText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.commonLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String directory = ((Text)e.widget).getText();
                CommonLocationPage.this.handleCommonLocationChange(TextProcessor.deprocess((String)directory.trim()));
                if (CommonLocationPage.this.agentLocationText != null) {
                    String agentDirectory = CommonLocationPage.this.agentLocationText.getText().trim();
                    CommonLocationPage.this.checkInitialAgentLocation(TextProcessor.deprocess((String)agentDirectory));
                }
            }
        });
        this.commonLocationButton = this.toolkit.createButton(this.locationComposite, Messages.CommonLocationPage_browseButton, 8);
        this.commonLocationButton.setEnabled(false);
        this.commonLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String directory = UiServices.getInstance().getDirectoryDialog(parent.getShell()).title(Messages.CommonLocationPage_commonDialogTitle).message(Messages.CommonLocationPage_commonDialogMessage).filterPath(TextProcessor.deprocess((String)CommonLocationPage.this.commonLocationText.getText())).run();
                if (directory != null) {
                    CommonLocationPage.this.commonLocationText.setText(TextProcessor.process((String)directory.trim()));
                }
            }
        });
        boolean enabled = this.isEditableCommonLocation();
        this.commonLocationText.setEditable(enabled);
        this.commonLocationButton.setEnabled(enabled);
    }

    protected void createDiskspaceSection(Composite container) {
        Section spaceSection = this.toolkit.createSection(container, 512);
        spaceSection.marginWidth = 0;
        spaceSection.setText(Messages.InstallLocationDetailsPage_diskspaceInfo);
        GridData data1 = new GridData(4, 1, true, false);
        spaceSection.setLayoutData((Object)data1);
        Composite spaceComposite = this.toolkit.createComposite((Composite)spaceSection, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        spaceComposite.setLayout((Layout)layout);
        spaceSection.setClient((Control)spaceComposite);
        int originalBorderStyle = this.toolkit.getBorderStyle();
        this.toolkit.setBorderStyle(0);
        int spaceTableStyle = 32772;
        this.diskspaceTable = this.toolkit.createTable(spaceComposite, spaceTableStyle);
        GridData data = new GridData(4, 1, false, false);
        data.heightHint = this.diskspaceTable.getItemHeight() * 2;
        this.diskspaceTable.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 80, false));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(7, 150, false));
        this.diskspaceTable.setLayout((Layout)tableLayout);
        new TableColumn(this.diskspaceTable, 16384, 0);
        new TableColumn(this.diskspaceTable, 16384, 1);
        this.diskspaceTable.pack();
        this.toolkit.setBorderStyle(originalBorderStyle);
    }

    String getEclipseCacheLocation() throws AbstractVariableSubstitution.VariableSubstitutionException {
        if (this.eclipseCacheLocation == null) {
            List jobs = AgentUtil.getSelectedProductAgentJobs((Collection)this.getAgentWizard().getSelectedJobs());
            this.eclipseCacheLocation = CacheLocationManager.getInstance().getEclipseCacheLocation(jobs);
        }
        return this.eclipseCacheLocation;
    }

    private void checkInitialCommonLocation(String directory) {
        if (this.isWizardReady()) {
            IStatus status = this.validateCommonDirectory(directory);
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                this.setPageComplete(false);
                this.setWarningState(COMMON_LOCATION_WARNING, null);
                this.setErrorStateWithStatus(COMMON_LOCATION_ERROR, status);
                this.hasCommonLocationError = true;
                return;
            }
            if (status.matches(2)) {
                this.setPageComplete(!this.hasAgentInstallLocationError);
                this.setWarningStateWithStatus(COMMON_LOCATION_WARNING, status);
                this.setErrorState(COMMON_LOCATION_ERROR, null);
                this.hasCommonLocationError = false;
            } else {
                this.setPageComplete(!this.hasAgentInstallLocationError);
                this.setWarningState(COMMON_LOCATION_WARNING, null);
                this.setErrorState(COMMON_LOCATION_ERROR, null);
                this.hasCommonLocationError = false;
            }
        }
    }

    void handleCommonLocationChange(String directory) {
        if (this.isWizardReady()) {
            IStatus status = this.validateCommonDirectory(directory);
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                this.setPageComplete(false);
                this.setWarningState(COMMON_LOCATION_WARNING, null);
                this.setErrorStateWithStatus(COMMON_LOCATION_ERROR, status);
                this.hasCommonLocationError = true;
                return;
            }
            if (status.matches(2)) {
                this.setPageComplete(!this.hasAgentInstallLocationError);
                this.setWarningStateWithStatus(COMMON_LOCATION_WARNING, status);
                this.setErrorState(COMMON_LOCATION_ERROR, null);
                this.hasCommonLocationError = false;
            } else {
                this.setPageComplete(!this.hasAgentInstallLocationError);
                this.setWarningState(COMMON_LOCATION_WARNING, null);
                this.setErrorState(COMMON_LOCATION_ERROR, null);
                this.hasCommonLocationError = false;
            }
            this.setEclipseCacheLocation(directory);
            this.showDiskSpaceInfo();
        }
    }

    boolean isEditableCommonLocation() {
        return AgentUI.getDefault().isEclipseCacheChangeable();
    }

    private boolean isWizardReady() {
        return this.getWizard().getContainer().getCurrentPage() != null;
    }

    public void nextPage() {
        try {
            this.saveEclipseCacheLocation();
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
            this.setErrorState(COMMON_LOCATION_ERROR, e.getMessage());
        }
    }

    private void saveEclipseCacheLocation() throws AbstractVariableSubstitution.VariableSubstitutionException {
        String location = this.getEclipseCacheLocation();
        CacheLocationManager.getInstance().setCacheLocation(location);
    }

    void setEclipseCacheLocation(String location) {
        this.eclipseCacheLocation = location;
    }

    @Override
    protected void setFocus() {
        if (this.commonLocationText != null) {
            String commonLocation = this.commonLocationText.getText().trim();
            this.checkInitialCommonLocation(TextProcessor.deprocess((String)commonLocation));
        }
        if (!this.hasCommonLocationError && this.agentLocationText != null) {
            String initialAgentLocation = this.agentLocationText.getText().trim();
            this.checkInitialAgentLocation(TextProcessor.deprocess((String)initialAgentLocation));
        }
        this.showDiskSpaceInfo();
    }

    public boolean shouldSkip() {
        return !this.isEditableCommonLocation() || Agent.getInstance().isPortable();
    }

    protected void showDiskSpaceInfo() {
        this.diskspaceTable.removeAll();
        TableItem tableItem = new TableItem(this.diskspaceTable, 0);
        tableItem.setText(new String[]{Messages.InstallLocationDetailsPage_spaceTable_volumeName, Messages.InstallLocationDetailsPage_spaceTable_availableSpace});
        int width1 = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, Messages.InstallLocationDetailsPage_spaceTable_volumeName);
        int width2 = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, Messages.InstallLocationDetailsPage_spaceTable_availableSpace);
        try {
            String volumeName = PlatformUtils.getLocationDevice((String)this.getEclipseCacheLocation());
            String availableSpace = SpaceInfoUtils.getAvailableSpace((String)volumeName);
            TableItem item = new TableItem(this.diskspaceTable, 0);
            item.setText(new String[]{TextProcessor.process((String)volumeName), availableSpace});
            int width = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, volumeName);
            width1 = Math.max(width1, width);
            width = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, availableSpace);
            width2 = Math.max(width2, width);
            if (this.agentProfile != null) {
                String agentLocationVolumeName = PlatformUtils.getLocationDevice((String)this.agentProfile.getInstallLocation());
                boolean sameVolumeName = volumeName.equals(agentLocationVolumeName);
                if ("win32".equals(Platform.getOS())) {
                    sameVolumeName = volumeName.equalsIgnoreCase(agentLocationVolumeName);
                }
                if (!sameVolumeName) {
                    String agentAvailableSpace = SpaceInfoUtils.getAvailableSpace((String)agentLocationVolumeName);
                    TableItem item2 = new TableItem(this.diskspaceTable, 0);
                    item2.setText(new String[]{TextProcessor.process((String)agentLocationVolumeName), agentAvailableSpace});
                    width = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, agentLocationVolumeName);
                    width1 = Math.max(width1, width);
                    width = AgentUIUtils.calculateSpaceTableColumnWidth(this.diskspaceTable, agentAvailableSpace);
                    width2 = Math.max(width2, width);
                }
            }
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
            this.setErrorState(COMMON_LOCATION_ERROR, e.getMessage());
            this.setPageComplete(false);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.trim().length() == 0) {
                message = e.toString();
            }
            this.setErrorState(COMMON_LOCATION_ERROR, message);
            this.setPageComplete(false);
            AgentUI.reportException(e, true);
        }
        TableColumn col1 = this.diskspaceTable.getColumn(0);
        col1.setWidth(width1);
        TableColumn col2 = this.diskspaceTable.getColumn(1);
        col2.setWidth(width2);
        this.diskspaceTable.pack();
        this.diskspaceTable.redraw();
        this.reflowFor((Control)this.diskspaceTable);
    }

    protected void reflowFor(Control c) {
        for (Composite parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof SharedScrolledComposite) {
                SharedScrolledComposite scrolledComp = (SharedScrolledComposite)parent;
                scrolledComp.reflow(true);
                break;
            }
            parent.layout();
            if (parent == null || !(parent instanceof ScrolledForm)) continue;
            ((ScrolledForm)parent).reflow(true);
            break;
        }
    }

    IStatus validateCommonDirectory(String directory) {
        IStatus[] children;
        if (directory == null || directory.length() == 0) {
            return new Status(4, "com.ibm.cic.agent.ui", -1, Messages.CommonLocationPage_enterCommonDirectory, null);
        }
        CicMultiStatus status = Statuses.ST.createMultiStatus(com.ibm.cic.common.core.utils.Messages.MultipleWarnings, new Object[0]);
        IStatus fileNameStatus = PlatformUtils.validatePath((String)directory);
        if (StatusUtil.isErrorOrCancel((IStatus)fileNameStatus)) {
            return new Status(4, "com.ibm.cic.agent.ui", -1, String.valueOf(Messages.CommonLocationPage_invalidCommonDirectory) + " " + fileNameStatus.getMessage(), null);
        }
        status.add(fileNameStatus);
        IStatus permStatus = AgentUtil.validateCommonDirectoryPermissions((String)directory);
        if (StatusUtil.isErrorOrCancel((IStatus)permStatus)) {
            return permStatus;
        }
        status.add(permStatus);
        IOffering[] ofs = this.getSelectedProductOfferings();
        ICicStatus cacheLocationStatus = AgentUtil.validateCacheLocation((List)this.getSelectedJobs(), (String)directory, (IOffering[])ofs);
        if (StatusUtil.isErrorOrCancel((IStatus)cacheLocationStatus)) {
            return cacheLocationStatus;
        }
        status.add((IStatus)cacheLocationStatus);
        ICicStatus vistaLocationStatus = AgentUtil.validateVistaVirtualizationLocation((String)directory, (IOffering[])this.getSelectedProductOfferings());
        if (StatusUtil.isErrorOrCancel((IStatus)vistaLocationStatus)) {
            return vistaLocationStatus;
        }
        status.add((IStatus)vistaLocationStatus);
        if (status.matches(2) && (children = status.getChildren()) != null && children.length == 1) {
            return children[0];
        }
        status.add(AgentPathValidator.checkSymbolicLinks((String)directory));
        return status;
    }

    public void validatePage() throws AbstractCicWizardPage.ValidationFailed {
        String directory = TextProcessor.deprocess((String)this.commonLocationText.getText().trim());
        IStatus status = this.validateCommonDirectory(directory);
        if (status.matches(4) || status.matches(8)) {
            throw new AbstractCicWizardPage.ValidationFailed(status.getMessage());
        }
    }

    private void createInstallLocationArea(final Composite parent) {
        this.agentProfile = this.createNewProfile(this.getSelectedJobs());
        Profile.setLicenseProfileInstallLocation((Profile)this.agentProfile);
        this.setSelection(this.agentProfile);
        this.toolkit.createLabel(parent, Messages.AgentInstallLocationPage_locationLabel);
        String initialLocation = "";
        if (this.agentProfile != null) {
            initialLocation = this.agentProfile.getInstallLocation();
        }
        this.agentLocationText = this.toolkit.createText(parent, TextProcessor.process((String)initialLocation), 2048);
        this.agentLocationText.setLayoutData((Object)new GridData(4, 1, true, false));
        if (this.hasAgentInstalled) {
            this.agentLocationText.setEnabled(false);
        }
        this.agentLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String directory = ((Text)e.widget).getText();
                String commonDirectory = CommonLocationPage.this.commonLocationText.getText().trim();
                CommonLocationPage.this.checkInitialCommonLocation(TextProcessor.deprocess((String)commonDirectory));
                CommonLocationPage.this.handleAgentLocationChange(TextProcessor.deprocess((String)directory.trim()));
            }
        });
        this.agentLocationButton = this.toolkit.createButton(parent, Messages.AgentInstallLocationPage_browseButton, 8);
        if (this.hasAgentInstalled) {
            this.agentLocationButton.setEnabled(false);
        }
        this.agentLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String directory = UiServices.getInstance().getDirectoryDialog(parent.getShell()).title(Messages.CommonLocationPage_commonDialogTitle).message(Messages.AgentInstallLocationDlg_msg).filterPath(TextProcessor.deprocess((String)CommonLocationPage.this.agentLocationText.getText())).run();
                if (directory != null) {
                    CommonLocationPage.this.agentLocationText.setText(TextProcessor.process((String)directory.trim()));
                }
            }
        });
    }

    Profile createNewProfile(List jobs) {
        if (jobs == null || jobs.size() == 0) {
            return null;
        }
        Agent agent = AgentUI.getDefault().getAgent();
        int i = 0;
        while (i < jobs.size()) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            IOffering offering = job.getOffering();
            if (offering != null && agent.isAgentOffering((IOfferingOrFix)offering)) {
                this.agentOffering = offering;
                this.agentJob = job;
                break;
            }
            ++i;
        }
        if (this.agentOffering == null) {
            return null;
        }
        this.hasAgentInstalled = InstallAgentUtils.hasAgentInstalled();
        Profile profile = agent.getAgentProfile();
        if (profile == null) {
            profile = AgentUtil.makeNewIMProfileForJob((AbstractJob)this.agentJob);
        } else if (!this.hasAgentInstalled) {
            agent.deleteProfile(profile);
        }
        return profile;
    }

    void setSelection(Profile profile) {
        List profilesList = this.getAgentProfileList();
        profilesList.clear();
        Map profileLocaleLangs = this.getProfileLocalLanguagesMap();
        profileLocaleLangs.clear();
        if (profile != null) {
            profilesList.add(profile);
            Set supportedLangSet = OfferingProperty.getSupportedLocales((IOffering)this.agentOffering);
            String supportedLangString = ProfileLanguageUtils.convertCodeSetToString((Set)supportedLangSet);
            String currentLocaleLangs = profile.getData("cic.selector.nl");
            if (currentLocaleLangs == null || currentLocaleLangs.length() == 0) {
                profileLocaleLangs.put(profile, supportedLangString);
            } else {
                profileLocaleLangs.put(profile, currentLocaleLangs);
            }
            this.updateJobsProfile(profile);
        }
    }

    private void updateJobsProfile(Profile profile) {
        if (this.agentOffering != null) {
            int length = Integer.MAX_VALUE;
            int pathLength = PlatformUtils.getMaxInstallLocationLengthForOffering((IOffering)this.agentOffering);
            if (pathLength < length) {
                length = pathLength;
            }
            profile.setMaxInstallLocationLength(length);
        }
        if (this.agentJob != null) {
            this.agentJob.setProfile(profile);
        }
    }

    private void checkInitialAgentLocation(String location) {
        if (this.isWizardReady()) {
            IStatus status = this.validateAgentDirectory(location);
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                this.setErrorStateWithStatus(AGENT_INSTALL_LOCATION_ERROR, status);
                this.setWarningStateWithStatus(AGENT_INSTALL_LOCATION_WARNING, null);
                this.setPageComplete(false);
                this.hasAgentInstallLocationError = true;
            } else if (status.matches(2)) {
                this.setErrorStateWithStatus(AGENT_INSTALL_LOCATION_ERROR, null);
                this.setWarningStateWithStatus(AGENT_INSTALL_LOCATION_WARNING, status);
                this.setPageComplete(!this.hasCommonLocationError);
                this.hasAgentInstallLocationError = false;
            } else {
                this.setErrorState(AGENT_INSTALL_LOCATION_ERROR, null);
                this.setWarningState(AGENT_INSTALL_LOCATION_WARNING, null);
                this.setPageComplete(!this.hasCommonLocationError);
                this.hasAgentInstallLocationError = false;
            }
        }
    }

    void handleAgentLocationChange(String directory) {
        CicMultiStatus status = Statuses.ST.createMultiStatus(com.ibm.cic.common.core.utils.Messages.MultipleWarnings, new Object[0]);
        IStatus setInstallLocationStatus = this.setAgentInstallLocation(directory);
        if (StatusUtil.isErrorOrCancel((IStatus)setInstallLocationStatus)) {
            this.setErrorStateWithStatus(AGENT_INSTALL_LOCATION_ERROR, setInstallLocationStatus);
            this.setWarningStateWithStatus(AGENT_INSTALL_LOCATION_WARNING, null);
            this.setPageComplete(false);
            this.hasAgentInstallLocationError = true;
            return;
        }
        status.add(setInstallLocationStatus);
        IStatus validationStatus = this.validateAgentDirectory(directory);
        if (StatusUtil.isErrorOrCancel((IStatus)validationStatus)) {
            this.setErrorStateWithStatus(AGENT_INSTALL_LOCATION_ERROR, validationStatus);
            this.setWarningStateWithStatus(AGENT_INSTALL_LOCATION_WARNING, null);
            this.setPageComplete(false);
            this.hasAgentInstallLocationError = true;
            return;
        }
        status.add(validationStatus);
        if (status.getSeverity() == 2) {
            IStatus[] children = status.getChildren();
            if (children != null && children.length == 1) {
                this.setWarningStateWithStatus(AGENT_INSTALL_LOCATION_WARNING, children[0]);
            } else {
                this.setWarningStateWithStatus(AGENT_INSTALL_LOCATION_WARNING, (IStatus)status);
            }
        } else {
            this.setWarningStateWithStatus(AGENT_INSTALL_LOCATION_WARNING, null);
        }
        this.setErrorState(AGENT_INSTALL_LOCATION_ERROR, null);
        this.setPageComplete(!this.hasCommonLocationError);
        this.hasAgentInstallLocationError = false;
        this.showDiskSpaceInfo();
    }

    private IStatus setAgentInstallLocation(String location) {
        String oldLocation = this.agentProfile.getInstallLocation();
        if (oldLocation.equals(location)) {
            return Status.OK_STATUS;
        }
        IStatus status = this.agentProfile.setInstallLocation(location);
        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
            this.agentProfile.setNeedsRequalification();
            Profile.setLicenseProfileInstallLocation((Profile)this.agentProfile);
        }
        return status;
    }

    private IStatus validateAgentDirectory(String directory) {
        CicMultiStatus return_status = Statuses.ST.createMultiStatus();
        if (this.agentJob == null) {
            return return_status;
        }
        ArrayList<AbstractJob> agentJobList = new ArrayList<AbstractJob>();
        agentJobList.add(this.agentJob);
        String commonLocation = null;
        try {
            commonLocation = this.getEclipseCacheLocation();
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException variableSubstitutionException) {}
        IStatus verifyStatus = AgentUtil.validateJobsInstallLocation(agentJobList, (String)commonLocation);
        if (StatusUtil.isErrorOrCancel((IStatus)verifyStatus)) {
            return verifyStatus;
        }
        return_status.add(verifyStatus);
        verifyStatus = AgentUtil.getOfferingsApplicability(agentJobList);
        if (StatusUtil.isErrorOrCancel((IStatus)verifyStatus)) {
            return verifyStatus;
        }
        return_status.add(verifyStatus);
        verifyStatus = AgentUtil.validateVistaVirtualizationLocation(agentJobList, (IOffering[])new IOffering[]{this.agentOffering});
        if (StatusUtil.isErrorOrCancel((IStatus)verifyStatus)) {
            return verifyStatus;
        }
        return_status.add(verifyStatus);
        if (return_status.matches(2)) {
            IStatus[] children = return_status.getChildren();
            if (children != null && children.length == 1) {
                return children[0];
            }
            return_status.setMessage(com.ibm.cic.common.core.utils.Messages.MultipleWarnings);
        }
        return return_status;
    }
}

