/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIDependenciesCheckUtils;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIPrimaryPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.AvailableRollbackSection;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryRollbackWizard;
import com.ibm.cic.agent.internal.ui.wizards.RollbackWizard;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class AvailableRollbackPage
extends AbstractAgentUIPrimaryPage {
    private AvailableRollbackSection rollbackSection;
    private boolean validationSuccess = false;
    private final PrimaryRollbackWizard primaryRollbackWizard;
    private final CustomMessageWizardPage.WarningId rollbackWarning = new CustomMessageWizardPage.WarningId();
    private final CustomMessageWizardPage.ErrorId rollbackError = new CustomMessageWizardPage.ErrorId();

    public AvailableRollbackPage(String title, String description, PrimaryRollbackWizard primaryRollbackWizard) {
        super(title, description, primaryRollbackWizard);
        super.setHelpRef("com.ibm.cic.agent.ui.AvailableRollbackPage");
        this.primaryRollbackWizard = primaryRollbackWizard;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.rollbackSection = new AvailableRollbackSection(context, parent, this);
        return this.rollbackSection;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setWarningState(this.rollbackWarning, null);
            this.setErrorState(this.rollbackError, null);
            this.rollbackSection.checkInputChanged();
            this.rollbackSection.setFocus();
        }
    }

    @Override
    protected AgentUIWizard createInnerWizard() {
        RollbackWizard innerWizard = new RollbackWizard();
        return innerWizard;
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.primaryRollbackWizard.hasSelectedJob() && this.validationSuccess;
    }

    @Override
    public boolean isPageComplete() {
        return this.primaryRollbackWizard.hasSelectedJob() && this.validationSuccess;
    }

    @Override
    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    private IStatus prepareAndResolveJobs(List jobs, IProgressMonitor monitor) {
        if (jobs == null) {
            return SharedUIUtils.prepareAndResolveSelectedJobs((List)this.primaryRollbackWizard.getJobs(), (IProgressMonitor)monitor);
        }
        return SharedUIUtils.prepareAndResolveSelectedJobs((List)jobs, (IProgressMonitor)monitor);
    }

    public void validateSelectedOfferings(final List addedJobs, final List deselectedJobs) {
        try {
            final IStatus[] status = new IStatus[]{Status.OK_STATUS};
            final List selectedJobs = this.primaryRollbackWizard.getSelectedJobs();
            final AgentJob[] selectedJobsArray = AgentJob.toArray((Collection)selectedJobs);
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        AbstractJob[] jobs;
                        int[] taskTicks = null;
                        taskTicks = !(addedJobs != null && !addedJobs.isEmpty() || deselectedJobs != null && !deselectedJobs.isEmpty()) ? new int[]{2, 1, 2, 1} : (addedJobs == null || addedJobs.isEmpty() ? new int[]{1, 2, 1} : (deselectedJobs == null || deselectedJobs.isEmpty() ? new int[]{2, 1, 2, 1} : new int[]{1, 2, 1, 2, 1}));
                        SplitProgressMonitor sm = new SplitProgressMonitor(monitor, com.ibm.cic.agent.core.sharedUI.Messages.InstalledOfferingPage_validatePkgProgress, taskTicks);
                        if (deselectedJobs != null && !deselectedJobs.isEmpty()) {
                            ArrayList<IOfferingOrFix> unloadOfferingOrFixes = new ArrayList<IOfferingOrFix>();
                            int i = 0;
                            while (i < deselectedJobs.size()) {
                                IOfferingOrFix offeringOrFix = ((AgentJob)deselectedJobs.get(i)).getOfferingOrFix();
                                if (offeringOrFix != null) {
                                    unloadOfferingOrFixes.add(offeringOrFix);
                                }
                                ++i;
                            }
                            CicMultiStatus unloadStatus = Statuses.ST.createMultiStatus();
                            SplitProgressMonitor unloadMonitor = new SplitProgressMonitor(sm.next(), unloadOfferingOrFixes.size());
                            int i2 = 0;
                            while (i2 < unloadOfferingOrFixes.size()) {
                                IOfferingOrFix offeringOrFix = (IOfferingOrFix)unloadOfferingOrFixes.get(i2);
                                unloadStatus.add(Agent.getInstance().unloadAgentBundles(offeringOrFix, unloadMonitor.next()));
                                ++i2;
                            }
                            if (!unloadStatus.isOK()) {
                                AgentUI.reportStatus((IStatus)unloadStatus, false);
                            }
                        }
                        CicMultiStatus warningStatus = Statuses.ST.createMultiStatus(com.ibm.cic.common.core.utils.Messages.MultipleWarnings, new Object[0]);
                        List jobsToPrepare = null;
                        if (addedJobs != null && !addedJobs.isEmpty()) {
                            jobsToPrepare = addedJobs;
                        } else if (addedJobs == null && deselectedJobs == null) {
                            jobsToPrepare = selectedJobs;
                        }
                        if (jobsToPrepare != null) {
                            status[0] = AvailableRollbackPage.this.prepareAndResolveJobs(jobsToPrepare, sm.next());
                            if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                                warningStatus.add(status[0]);
                                status[0] = AgentUIUtils.runPrecheckBundlesWithMonitor(jobsToPrepare, false, sm.next());
                            }
                        }
                        if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                            warningStatus.add(status[0]);
                            status[0] = AgentUtil.getOfferingsApplicability((List)selectedJobs, (AgentJob[])selectedJobsArray);
                        }
                        if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                            warningStatus.add(status[0]);
                            jobs = selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
                            status[0] = AgentUI.getDefault().getAgent().checkInstall((AgentJob[])jobs, sm.next());
                        }
                        if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                            warningStatus.add(status[0]);
                            try {
                                jobs = selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
                                status[0] = AgentUIDependenciesCheckUtils.checkDependenciesProfilePrepareUnprepareFinal((AgentJob[])jobs, sm.next());
                            }
                            catch (CoreException e) {
                                status[0] = new Status(4, "com.ibm.cic.agent.ui", Messages.AvailableOfferingPage_dependencyException, (Throwable)e);
                            }
                        }
                        if (!StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                            warningStatus.add(status[0]);
                            IStatus[] children = warningStatus.getChildren();
                            status[0] = children != null && children.length == 1 ? children[0] : warningStatus;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            if (StatusUtil.isErrorOrCancel((IStatus)status[0])) {
                this.validationSuccess = false;
                this.setWarningState(this.rollbackWarning, null);
                String errorMsg = status[0].getMessage().trim();
                if (errorMsg.length() > 0) {
                    this.setErrorStateWithStatus(this.rollbackError, status[0]);
                } else if (status[0].isMultiStatus()) {
                    CicMultiStatus errorMultiStatus = Statuses.ST.createMultiStatus(status[0].getSeverity(), status[0].getCode(), status[0].getChildren(), status[0].getException(), Messages.AvailableRollbackPage_cannotRollbackPkg, new Object[0]);
                    this.setErrorStateWithStatus(this.rollbackError, (IStatus)errorMultiStatus);
                } else {
                    this.setErrorState(this.rollbackError, Messages.AvailableRollbackPage_cannotRollbackPkg);
                }
                if (status[0].isMultiStatus() && status[0].getChildren() != null && status[0].getChildren().length > 0) {
                    String message = null;
                    if (status[0].getMessage().trim().length() == 0) {
                        message = Messages.AvailableRollbackPage_cannotRollbackPkg;
                    }
                    WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(AgentUI.getActiveWorkbenchShell(), com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, message, status[0], 15);
                    errorDialog.open();
                }
            } else if (status[0].matches(2)) {
                this.validationSuccess = true;
                this.setWarningStateWithStatus(this.rollbackWarning, status[0]);
                this.setErrorState(this.rollbackError, null);
            } else {
                this.validationSuccess = true;
                this.setWarningState(this.rollbackWarning, null);
                this.setErrorState(this.rollbackError, null);
            }
            List<Object> currentSelections = null;
            Object[] selectionArray = this.getSelections();
            currentSelections = selectionArray == null ? new ArrayList<Object>() : Arrays.asList(selectionArray);
            if (!AgentUIUtils.sameJobs(selectedJobs, currentSelections)) {
                Object[] jobs = selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
                this.setSelection(jobs);
                this.primaryRollbackWizard.setConstructedWizard(this.getConstructedWizard());
            }
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    protected Profile[] getProfiles() {
        return this.primaryRollbackWizard.getSelectedProfiles();
    }

    protected PrimaryRollbackWizard getPrimaryRollbackWizard() {
        return this.primaryRollbackWizard;
    }

    @Override
    protected int[] getWeights() {
        return new int[]{60, 40};
    }
}

