/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.OnlyFixesNode;
import com.ibm.cic.agent.internal.ui.utils.PackageNode;
import com.ibm.cic.agent.internal.ui.utils.VersionNode;
import com.ibm.cic.agent.internal.ui.wizards.IAvailableOfferingPage;
import com.ibm.cic.agent.internal.ui.wizards.OfferingOrFixInRepDetailPage;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.repository.UnavailableUtils;
import com.ibm.cic.common.ui.internal.FormTextUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class AvailableOfferingDetailPage
extends OfferingOrFixInRepDetailPage {
    private final IAvailableOfferingPage wizardPage;

    public AvailableOfferingDetailPage(IAvailableOfferingPage wizardPage) {
        this.wizardPage = wizardPage;
    }

    @Override
    protected String getObjectDescription(Object object) {
        String desc = super.getObjectDescription(object);
        if (object instanceof FixNode) {
            FixNode fixNode = (FixNode)object;
            AbstractJob job = fixNode.getJob();
            desc = this.addToleranceStatus(desc, fixNode.getToleranceStatus());
            desc = this.addAdminUserCheckStatus(desc, job.getOffering());
            desc = this.addBetaCheckStatus(desc, job.getOfferingOrFix());
            desc = this.addSupportedOSCheckStatus(desc, job.getOffering());
            desc = this.addSupportedPlatformsCheckStatus(desc, fixNode);
            desc = this.addGroupModeCheckStatus(desc, job.getOffering());
            desc = this.addAvailabilityStatus(desc, job.getOfferingOrFix(), null);
            desc = this.addSupportedUICheckStatus(desc, job.getOfferingOrFix());
            return desc;
        }
        if (object instanceof VersionNode) {
            VersionNode versionNode = (VersionNode)object;
            AbstractJob job = versionNode.getJob();
            desc = this.addToleranceStatus(desc, versionNode.getToleranceStatus());
            desc = this.addAdminUserCheckStatus(desc, job.getOffering());
            desc = this.addBetaCheckStatus(desc, job.getOfferingOrFix());
            desc = this.addSupportedOSCheckStatus(desc, job.getOffering());
            desc = this.addSupportedPlatformsCheckStatus(desc, job);
            desc = this.addGroupModeCheckStatus(desc, job.getOffering());
            desc = this.addAvailabilityStatus(desc, (IOfferingOrFix)job.getOffering(), versionNode);
            desc = this.addSupportedUICheckStatus(desc, (IOfferingOrFix)job.getOffering());
            return desc;
        }
        if (object instanceof PackageNode) {
            PackageNode packageNode = (PackageNode)object;
            IOffering offering = packageNode.getOffering();
            VersionNode versionNode = packageNode.getRecommendedVersion();
            if (versionNode != null) {
                desc = this.addToleranceStatus(desc, versionNode.getToleranceStatus());
            }
            desc = this.addAdminUserCheckStatus(desc, offering);
            desc = this.addBetaCheckStatus(desc, (IOfferingOrFix)offering);
            desc = this.addSupportedOSCheckStatus(desc, offering);
            desc = this.addSupportedPlatformsCheckStatus(desc, offering);
            desc = this.addGroupModeCheckStatus(desc, offering);
            desc = this.addSupportedUICheckStatus(desc, (IOfferingOrFix)offering);
            desc = this.addAvailabilityStatus(desc, (IOfferingOrFix)offering, packageNode);
            return desc;
        }
        if (object instanceof OnlyFixesNode) {
            IOffering offering = ((OnlyFixesNode)object).getOffering();
            desc = this.addAdminUserCheckStatus(desc, offering);
            desc = this.addBetaCheckStatus(desc, (IOfferingOrFix)offering);
            desc = this.addSupportedOSCheckStatus(desc, offering);
            desc = this.addSupportedPlatformsCheckStatus(desc, offering);
            desc = this.addGroupModeCheckStatus(desc, offering);
            desc = this.addSupportedUICheckStatus(desc, (IOfferingOrFix)offering);
            return desc;
        }
        return desc;
    }

    private String addBetaCheckStatus(String desc, IOfferingOrFix offeringOrFix) {
        IStatus status = Agent.getInstance().checkBetaRequirement(offeringOrFix);
        if (!status.isOK()) {
            String formText = FormTextUtil.toFormTextError((String)status.getMessage());
            return FormTextUtil.prependFormText((String)desc, (String)formText);
        }
        return desc;
    }

    private String addAdminUserCheckStatus(String desc, IOffering offering) {
        if (offering != null && FormTextUtil.isFormText((String)desc) && OfferingProperty.hasUnacceptableRequirementForUserRights((IOffering)offering)) {
            String msg = AgentUIUtils.escapeSpecialChars(Messages.AvailableOfferingDetailPage_offeringRequiresAdminRights);
            String error = FormTextUtil.toFormTextError((String)msg);
            return FormTextUtil.prependFormText((String)desc, (String)error);
        }
        return desc;
    }

    private String addSupportedOSCheckStatus(String desc, IOffering offering) {
        if (offering != null && FormTextUtil.isFormText((String)desc) && !OfferingProperty.isSupportedOS((IOffering)offering)) {
            String supportedOSList = OfferingProperty.getSupportedOS((IOffering)offering);
            String msg = AgentUIUtils.escapeSpecialChars(NLS.bind((String)Messages.AvailableOfferingDetailPage_supportOSMsg, (Object)Platform.getOS(), (Object)supportedOSList));
            String error = FormTextUtil.toFormTextError((String)msg);
            return FormTextUtil.prependFormText((String)desc, (String)error);
        }
        return desc;
    }

    private String addSupportedUICheckStatus(String desc, IOfferingOrFix offering) {
        IStatus status;
        if (offering != null && FormTextUtil.isFormText((String)desc) && !(status = Agent.getInstance().checkWebUISupported(offering)).isOK()) {
            String msg = AgentUIUtils.escapeSpecialChars(status.getMessage());
            return FormTextUtil.prependFormText((String)desc, (String)FormTextUtil.toFormTextError((String)msg));
        }
        return desc;
    }

    private String addSupportedPlatformsCheckStatus(String desc, FixNode fixNode) {
        IFix fix = fixNode.getFix();
        Object parent = fixNode.getParent();
        if (parent instanceof VersionNode) {
            VersionNode vNode = (VersionNode)parent;
            IOffering offering = vNode.getOffering();
            if (offering != null && FormTextUtil.isFormText((String)desc)) {
                IStatus status = BitModeUtils.checkSupportedPlatformsInOfferingOrFix((IOfferingOrFix)offering);
                if (!status.isOK()) {
                    String error = FormTextUtil.toFormTextError((String)status.getMessage());
                    return FormTextUtil.prependFormText((String)desc, (String)error);
                }
                AbstractJob parentJob = vNode.getJob();
                if (parentJob.isUpdate()) {
                    Profile profile = parentJob.getProfile();
                    status = SliceUtils.checkPlatform((IOfferingOrFix)fix, (String)profile.getOS(), (String)profile.getArch());
                    if (status.isOK()) {
                        return desc;
                    }
                    String error = FormTextUtil.toFormTextError((String)status.getMessage());
                    return FormTextUtil.prependFormText((String)desc, (String)error);
                }
                status = BitModeUtils.checkSupportedPlatformsInOfferingOrFix((IOfferingOrFix)fix);
                if (!status.isOK()) {
                    String error = FormTextUtil.toFormTextError((String)status.getMessage());
                    return FormTextUtil.prependFormText((String)desc, (String)error);
                }
                status = SliceUtils.checkPlatform((IOfferingOrFix)fix, (String)Platform.getOS(), (String)BitModeUtils.get32bitArch());
                if (status.isOK()) {
                    return desc;
                }
                status = SliceUtils.checkPlatform((IOfferingOrFix)fix, (String)Platform.getOS(), (String)BitModeUtils.get64bitArch());
                if (status.isOK()) {
                    return desc;
                }
                String error = FormTextUtil.toFormTextError((String)status.getMessage());
                return FormTextUtil.prependFormText((String)desc, (String)error);
            }
        } else if (parent instanceof PackageNode) {
            PackageNode pkgNode = (PackageNode)parent;
            IOffering offering = pkgNode.getOffering();
            Profile profile = fixNode.getJob().getProfile();
            if (offering != null && FormTextUtil.isFormText((String)desc)) {
                IStatus status = BitModeUtils.checkSupportedPlatformsInOfferingOrFix((IOfferingOrFix)offering);
                if (!status.isOK()) {
                    String error = FormTextUtil.toFormTextError((String)status.getMessage());
                    return FormTextUtil.prependFormText((String)desc, (String)error);
                }
                status = SliceUtils.checkPlatform((IOfferingOrFix)fix, (String)profile.getOS(), (String)profile.getArch());
                if (status.isOK()) {
                    return desc;
                }
                String error = FormTextUtil.toFormTextError((String)status.getMessage());
                return FormTextUtil.prependFormText((String)desc, (String)error);
            }
        }
        return desc;
    }

    private String addSupportedPlatformsCheckStatus(String desc, AbstractJob job) {
        IOffering offering = job.getOffering();
        if (offering != null && FormTextUtil.isFormText((String)desc)) {
            if (job.isUpdate()) {
                IStatus status = BitModeUtils.checkSupportedPlatformsInOfferingOrFix((IOfferingOrFix)offering);
                if (!status.isOK()) {
                    String error = FormTextUtil.toFormTextError((String)status.getMessage());
                    return FormTextUtil.prependFormText((String)desc, (String)error);
                }
                Profile profile = job.getProfile();
                status = SliceUtils.checkPlatform((IOfferingOrFix)offering, (String)profile.getOS(), (String)profile.getArch());
                if (!status.isOK()) {
                    String error = FormTextUtil.toFormTextError((String)status.getMessage());
                    return FormTextUtil.prependFormText((String)desc, (String)error);
                }
            } else {
                return this.addSupportedPlatformsCheckStatus(desc, offering);
            }
        }
        return desc;
    }

    private String addSupportedPlatformsCheckStatus(String desc, IOffering offering) {
        IStatus status;
        if (offering != null && FormTextUtil.isFormText((String)desc) && !(status = BitModeUtils.checkSupportedPlatforms((IOfferingOrFix)offering)).isOK()) {
            String error = FormTextUtil.toFormTextError((String)status.getMessage());
            return FormTextUtil.prependFormText((String)desc, (String)error);
        }
        return desc;
    }

    private String addGroupModeCheckStatus(String desc, IOffering offering) {
        if (offering != null && FormTextUtil.isFormText((String)desc) && OfferingProperty.hasUnacceptableRequirementForGroupMode((IOfferingOrFix)offering)) {
            String msg = AgentUIUtils.escapeSpecialChars(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.OfferingsDoNotSupportGroupMode, (Object)OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering)));
            String error = FormTextUtil.toFormTextError((String)msg);
            return FormTextUtil.prependFormText((String)desc, (String)error);
        }
        return desc;
    }

    private String addToleranceStatus(String desc, IStatus status) {
        if (status.isOK()) {
            return desc;
        }
        if (!FormTextUtil.isFormText((String)desc)) {
            return desc;
        }
        String error = FormTextUtil.toFormTextError((String)status.getMessage());
        return FormTextUtil.prependFormText((String)desc, (String)error);
    }

    private String getEntitlementHelpURLHtml(IOfferingOrFix offeringOrFix) {
        return "<a href=\"" + UnavailableUtils.getEntitlementHelpURL((IContent)offeringOrFix) + "\">" + Messages.EntitlementHelpLabel + "</a>";
    }

    private String addAvailabilityStatus(String desc, IOfferingOrFix offeringOrFix, Object node) {
        if (offeringOrFix != null && FormTextUtil.isFormText((String)desc)) {
            PackageNode packageNode = node instanceof PackageNode ? (PackageNode)node : null;
            VersionNode verNode = node instanceof VersionNode ? (VersionNode)node : null;
            boolean isShowAllChecked = this.wizardPage.isShowAllChecked();
            if (!isShowAllChecked && verNode != null && verNode.containsUnavailableFixes()) {
                return this.prependNotAvailableFixesWarning(desc, offeringOrFix);
            }
            if (UnavailableUtils.isUnavailable((IContent)offeringOrFix)) {
                if (packageNode == null) {
                    String entitlementHelpUrl = this.getEntitlementHelpURLHtml(offeringOrFix);
                    String msg = AgentUIUtils.escapeSpecialChars(NLS.bind((String)(offeringOrFix instanceof IOffering ? com.ibm.cic.agent.internal.core.Messages.OfferingIsNotAvailable : com.ibm.cic.agent.internal.core.Messages.FixIsNotAvailable), (Object)OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix)));
                    String error = FormTextUtil.toFormTextError((String)msg, (boolean)false, (String)entitlementHelpUrl);
                    return FormTextUtil.prependFormText((String)desc, (String)error);
                }
                String msg = AgentUIUtils.escapeSpecialChars(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.PackageOnlyForEntitled, (Object)OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix)));
                String error = FormTextUtil.toFormTextError((String)msg);
                return FormTextUtil.prependFormText((String)desc, (String)error);
            }
            if (!isShowAllChecked && packageNode != null) {
                VersionNode recommendedVersionNode = packageNode.getRecommendedVersion();
                if (recommendedVersionNode != null) {
                    Version recommendedVersion = recommendedVersionNode.getOffering().getVersion();
                    for (VersionNode versionNode : packageNode.getVersionNodes()) {
                        Version currentVersion = versionNode.getOffering().getVersion();
                        if (!versionNode.isUnavailable() || currentVersion.compareTo(recommendedVersion) <= 0) continue;
                        String msg = AgentUIUtils.escapeSpecialChars(NLS.bind((String)this.wizardPage.messageHigherNotEntitledVersionsAreAvailable(), (Object)OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix)));
                        String error = FormTextUtil.toFormTextWarning((String)msg);
                        return FormTextUtil.prependFormText((String)desc, (String)error);
                    }
                } else if (packageNode.containsUnavailableFixes()) {
                    return this.prependNotAvailableFixesWarning(desc, offeringOrFix);
                }
            }
        }
        return desc;
    }

    private String prependNotAvailableFixesWarning(String desc, IOfferingOrFix offeringOrFix) {
        String msg = AgentUIUtils.escapeSpecialChars(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.NotAvailableFixesForPackageWarning, (Object)OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix)));
        String error = FormTextUtil.toFormTextWarning((String)msg);
        return FormTextUtil.prependFormText((String)desc, (String)error);
    }
}

