/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.SharedUIDependenciesCheckUtils;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIDependenciesCheckUtils;
import com.ibm.cic.agent.internal.ui.utils.AgentUIRegressingUpdateWarningUtil;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.BitModeUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUISecondaryPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.AvailableFixSection;
import com.ibm.cic.agent.internal.ui.wizards.AvailableOfferingDetailPage;
import com.ibm.cic.agent.internal.ui.wizards.IAvailableOfferingPage;
import com.ibm.cic.agent.internal.ui.wizards.IFixesInRepPage;
import com.ibm.cic.agent.internal.ui.wizards.InstallWizard;
import com.ibm.cic.agent.internal.ui.wizards.OfferingOrFixInRepDetailPage;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryBaseWizard;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryInstallWizard;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryUpdateWizard;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;

public class AvailableFixPage
extends AbstractAgentUISecondaryPage
implements IAvailableOfferingPage,
IFixesInRepPage {
    private List fixJobList;
    private List selectedOfferingJobs;
    private List previousSelectedOfferingFixJobs = new ArrayList();
    private List previousSelectedFixJobs = new ArrayList();
    private boolean rebuildTreeViewer;
    private boolean firstTimeVisible = true;
    private boolean shouldSkip = false;
    protected AvailableFixSection fixSection;
    protected AvailableOfferingDetailPage fixDetailPage;
    private PrimaryBaseWizard wizard = null;
    private boolean validFixes = true;
    private boolean multipleProfileInstall = false;

    public AvailableFixPage(PrimaryBaseWizard wizard) {
        this(wizard, com.ibm.cic.agent.internal.ui.licenses.Messages.AvailableOfferingPage_title, "com.ibm.cic.agent.ui.AvailableFixPage");
    }

    public AvailableFixPage(PrimaryBaseWizard wizard, String pageTitle, String helpId) {
        super(pageTitle, Messages.AvailableFixPage_description, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.AvailableFixPage");
        this.wizard = wizard;
    }

    @Override
    public boolean canFlipToNextPage() {
        if (!super.canFlipToNextPage()) {
            this.setErrorMessage(null);
            this.setMessage(null, 2);
            return false;
        }
        List currentSelectedFixJobs = AgentUIUtils.getSelectedJobs(this.fixJobList);
        ArrayList<AgentJob> currentSelectedOfferingFixJobs = new ArrayList<AgentJob>(this.selectedOfferingJobs);
        currentSelectedOfferingFixJobs.addAll(currentSelectedFixJobs);
        if (this.previousSelectedOfferingFixJobs != null && currentSelectedOfferingFixJobs.equals(this.previousSelectedOfferingFixJobs)) {
            return this.validFixes;
        }
        ArrayList addedOfferingFixJobs = new ArrayList(currentSelectedOfferingFixJobs);
        ArrayList<AgentJob> deselectedOfferingFixJobs = new ArrayList<AgentJob>();
        if (this.previousSelectedOfferingFixJobs != null) {
            deselectedOfferingFixJobs.addAll(this.previousSelectedOfferingFixJobs);
        }
        addedOfferingFixJobs.removeAll(this.previousSelectedOfferingFixJobs);
        deselectedOfferingFixJobs.removeAll(currentSelectedOfferingFixJobs);
        this.previousSelectedOfferingFixJobs = currentSelectedOfferingFixJobs;
        FixValidation validateFixes = new FixValidation(currentSelectedOfferingFixJobs, deselectedOfferingFixJobs);
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, (IRunnableWithProgress)validateFixes);
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
        if (StatusUtil.isErrorOrCancel((IStatus)validateFixes.getValidationStatus())) {
            this.setErrorMessageWithStatus(validateFixes.getValidationStatus());
            if (validateFixes.showErrorDisplayDialog()) {
                final IStatus[] validationStatus = new IStatus[]{validateFixes.getValidationStatus()};
                DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(AgentUI.getActiveWorkbenchShell(), com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, null, validationStatus[0], 15);
                        errorDialog.open();
                    }
                });
            }
            this.validFixes = false;
        } else if (validateFixes.getValidationStatus().getSeverity() == 2) {
            this.setErrorMessageWithStatus(null);
            this.setMessageWithStatus(validateFixes.getValidationStatus());
            this.validFixes = true;
        } else {
            this.setErrorMessageWithStatus(null);
            this.setMessageWithStatus(null);
            this.validFixes = true;
        }
        return this.validFixes;
    }

    private static CicMultiStatus getSupportedPlatformsStatusForFixJobs(AgentJob[] agentJobs) {
        CicMultiStatus returnStatus = Statuses.ST.createMultiStatus(com.ibm.cic.agent.internal.core.Messages.Agent_unsatisfiedDependencies, new Object[0]);
        AgentJob[] agentJobArray = agentJobs;
        int n = agentJobs.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus fixStatus;
            AgentJob job = agentJobArray[n2];
            IFix fix = job.getFix();
            if (fix != null && StatusUtil.isErrorOrCancel((IStatus)(fixStatus = BitModeUtils.checkSupportedPlatformsInOfferingOrFix((IOfferingOrFix)fix)))) {
                returnStatus.add(fixStatus);
            }
            ++n2;
        }
        return returnStatus;
    }

    private List getDeselectedFixes(List deselectedFixJobs) {
        ArrayList<IFix> return_result = new ArrayList<IFix>();
        if (deselectedFixJobs != null) {
            int i = 0;
            while (i < deselectedFixJobs.size()) {
                IFix fix = ((AgentJob)deselectedFixJobs.get(i)).getFix();
                if (fix != null) {
                    return_result.add(fix);
                }
                ++i;
            }
        }
        return return_result;
    }

    @Override
    public IWizardPage getNextPage() {
        if (!this.shouldSkip) {
            final List currentSelectedFixJobs = AgentUIUtils.getSelectedJobs(this.fixJobList);
            ArrayList deselectedFixJobs = new ArrayList(this.previousSelectedFixJobs);
            deselectedFixJobs.removeAll(currentSelectedFixJobs);
            final List deselectedFixes = this.getDeselectedFixes(deselectedFixJobs);
            this.previousSelectedFixJobs = currentSelectedFixJobs;
            final IStatus[] prepareStatus = new IStatus[]{Status.OK_STATUS};
            try {
                CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        IProgressMonitor prepareResolveMonitor = monitor;
                        if (!deselectedFixes.isEmpty()) {
                            SplitProgressMonitor sm = new SplitProgressMonitor(monitor, new int[]{1, 2});
                            CicMultiStatus unloadStatus = Statuses.ST.createMultiStatus();
                            SplitProgressMonitor unloadMonitor = new SplitProgressMonitor(sm.next(), deselectedFixes.size());
                            int i = 0;
                            while (i < deselectedFixes.size()) {
                                IOfferingOrFix offeringOrFix = (IOfferingOrFix)deselectedFixes.get(i);
                                unloadStatus.add(Agent.getInstance().unloadAgentBundles(offeringOrFix, unloadMonitor.next()));
                                ++i;
                            }
                            if (!unloadStatus.isOK()) {
                                AgentUI.reportStatus((IStatus)unloadStatus, false);
                            }
                            prepareResolveMonitor = sm.next();
                        }
                        prepareStatus[0] = SharedUIUtils.prepareAndResolveSelectedJobs((List)currentSelectedFixJobs, (IProgressMonitor)prepareResolveMonitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                AgentUI.reportException(e);
            }
            catch (InterruptedException e) {
                AgentUI.reportException(e);
            }
            if (StatusUtil.isErrorOrCancel((IStatus)prepareStatus[0])) {
                this.setErrorMessageWithStatus(prepareStatus[0]);
                return this;
            }
        }
        return super.getNextPage();
    }

    @Override
    protected IDetailsPage createDetailsSection() {
        this.fixDetailPage = new AvailableOfferingDetailPage(this);
        return this.fixDetailPage;
    }

    @Override
    public void refreshDetailPage() {
        if (this.fixDetailPage != null) {
            this.fixDetailPage.refreshDetails();
        }
    }

    @Override
    protected AgentUIWizard createInnerWizard() {
        InstallWizard installWizard = new InstallWizard();
        installWizard.setMultipleProfileInstall(this.multipleProfileInstall);
        return installWizard;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.fixSection = new AvailableFixSection(context, parent, this);
        return this.fixSection;
    }

    @Override
    public List getFixJobs() {
        return this.fixJobList;
    }

    public void setFixJobs(List inputJobs) {
        this.fixJobList = inputJobs;
        if (this.previousSelectedOfferingFixJobs != null) {
            this.previousSelectedOfferingFixJobs.clear();
        }
        if (this.previousSelectedFixJobs != null) {
            this.previousSelectedFixJobs.clear();
        }
    }

    public void setSelectedOfferingJobs(List selectedJobs) {
        this.selectedOfferingJobs = selectedJobs;
        Object[] jobArray = selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
        this.setPrimarySelections(jobArray);
    }

    @Override
    public List getSelectedOfferingJobs() {
        return this.selectedOfferingJobs;
    }

    @Override
    public boolean isPageComplete() {
        if (this.shouldSkip) {
            return true;
        }
        return this.canFlipToNextPage();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && (this.firstTimeVisible || this.rebuildTreeViewer)) {
            if (this.firstTimeVisible && !this.rebuildTreeViewer && AgentInput.getInstance().getMode() == 1) {
                this.fixSection.resetTreeViewer(true);
            } else {
                this.fixSection.resetTreeViewer(false);
            }
            this.firstTimeVisible = false;
            this.rebuildTreeViewer = false;
            this.checkJobsToleranceForAgent();
        }
    }

    protected void checkJobsToleranceForAgent() {
        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AvailableFixPage.this.fixSection.checkJobsToleranceForAgent();
            }
        });
    }

    @Override
    public void setSelection() {
        AbstractJob[] jobArray = null;
        if (this.fixJobList != null) {
            List selectedJobs = AgentUIUtils.getSelectedJobs(this.fixJobList);
            jobArray = selectedJobs.toArray(new AbstractJob[selectedJobs.size()]);
        }
        super.setSelection(jobArray);
    }

    public void setRebuildFixTree(boolean refresh) {
        this.rebuildTreeViewer = refresh;
    }

    @Override
    public PrimaryBaseWizard getPrimaryWizard() {
        return this.wizard;
    }

    @Override
    public AbstractJob createJob(IFix fix, Profile profile) {
        if (this.wizard instanceof PrimaryInstallWizard) {
            AbstractJob fixJob = ((PrimaryInstallWizard)this.wizard).createJob((IOfferingOrFix)fix);
            if (profile != null) {
                fixJob.setProfile(profile);
            }
            return fixJob;
        }
        return null;
    }

    public boolean shouldSkip() {
        return this.shouldSkip;
    }

    public void setShouldSkip(boolean shouldSkip) {
        this.shouldSkip = shouldSkip;
    }

    void setIsMultipleProfileInstall(boolean isMultipleProfileInstall) {
        this.multipleProfileInstall = isMultipleProfileInstall;
    }

    @Override
    public boolean isMultipleProfileInstall() {
        return this.multipleProfileInstall;
    }

    @Override
    public boolean isShowAllChecked() {
        return this.fixSection.isShowAllChecked();
    }

    @Override
    public String messageHigherNotEntitledVersionsAreAvailable() {
        return com.ibm.cic.agent.internal.core.Messages.HigherVersionsNotAvailable_Update;
    }

    @Override
    public OfferingOrFixInRepDetailPage getDetailPage() {
        return this.fixDetailPage;
    }

    private class FixValidation
    implements IRunnableWithProgress {
        private IStatus validationStatus;
        private boolean onErrorDisplayDialog;
        private final AgentJob[] deselectedFixJobArray;
        private final AgentJob[] selectedFixJobArray;

        public FixValidation(List<AgentJob> currentSelectedOfferingFixJobs, List<AgentJob> deselectedOfferingFixJobs) {
            this.selectedFixJobArray = currentSelectedOfferingFixJobs.toArray(new AgentJob[currentSelectedOfferingFixJobs.size()]);
            this.deselectedFixJobArray = deselectedOfferingFixJobs.toArray(new AgentJob[deselectedOfferingFixJobs.size()]);
            this.validationStatus = Status.OK_STATUS;
            this.onErrorDisplayDialog = true;
        }

        public void run(IProgressMonitor monitor) {
            SplitProgressMonitor sm = new SplitProgressMonitor(monitor, new int[]{3, 1});
            boolean installFlow = !(AvailableFixPage.this.getWizard() instanceof PrimaryUpdateWizard);
            this.validationStatus = this.checkFixDependencyBundles(installFlow, sm.next());
            if (!StatusUtil.isErrorOrCancel((IStatus)this.validationStatus)) {
                this.validationStatus = this.checkFixSupportedPlaforms(installFlow, sm.next());
            }
            if (!installFlow && this.validationStatus.isOK()) {
                this.validationStatus = AgentUIRegressingUpdateWarningUtil.checkRegressingUpdateWarning(this.selectedFixJobArray);
            }
            monitor.done();
        }

        private void prepareFixDependencyBundles(boolean installFlow, IProgressMonitor monitor) {
            IStatus unloadStatus;
            SplitProgressMonitor sm = new SplitProgressMonitor(monitor, 2);
            if (!AvailableFixPage.this.multipleProfileInstall && StatusUtil.isErrorOrCancel((IStatus)(unloadStatus = AgentUIUtils.unloadAgentDependencyBundles(this.deselectedFixJobArray, sm.next())))) {
                AgentUI.reportStatus(unloadStatus, false);
            }
            if (!AvailableFixPage.this.multipleProfileInstall) {
                this.validationStatus = AgentUIUtils.loadAgentDependencyBundles(this.selectedFixJobArray, installFlow, sm.next());
            }
            sm.done();
        }

        private IStatus checkFixDependencyBundles(boolean installFlow, IProgressMonitor monitor) {
            SplitProgressMonitor sm = new SplitProgressMonitor(monitor, 2);
            IStatus dependencyStatus = Status.OK_STATUS;
            this.prepareFixDependencyBundles(installFlow, sm.next());
            dependencyStatus = installFlow ? (AvailableFixPage.this.multipleProfileInstall ? SharedUIDependenciesCheckUtils.checkDependenciesMultiFinalProfilesPrepareUnprepare((AgentJob[])this.selectedFixJobArray, (IProgressMonitor)sm.next()) : AgentUIDependenciesCheckUtils.checkDependenciesPreliminaryProfile(this.selectedFixJobArray, sm.next())) : AgentUIDependenciesCheckUtils.checkDependenciesFinalProfile(this.selectedFixJobArray, sm.next());
            if (!dependencyStatus.isOK()) {
                this.onErrorDisplayDialog = true;
                dependencyStatus = AgentUIDependenciesCheckUtils.processDependencyStatus(dependencyStatus, false);
            }
            sm.done();
            return dependencyStatus;
        }

        private IStatus checkFixSupportedPlaforms(Boolean installFlow, IProgressMonitor monitor) {
            IStatus returnStatus;
            IStatus supportedPlatformsStatus = Status.OK_STATUS;
            supportedPlatformsStatus = installFlow != false ? BitModeUtils.checkBitnessConflict(Arrays.asList(this.selectedFixJobArray)) : BitModeUIUtils.checkFixesSupportedPlatformsAgainstProfile(this.selectedFixJobArray);
            CicMultiStatus supportedPlatformsStatusForWizard = Statuses.ST.createMultiStatus();
            if (AgentInput.getInstance().getMode() == 1) {
                supportedPlatformsStatusForWizard = AvailableFixPage.getSupportedPlatformsStatusForFixJobs(this.selectedFixJobArray);
            }
            if (!(returnStatus = this.consolidateStatusesForSupportedPlatforms(supportedPlatformsStatus, supportedPlatformsStatusForWizard)).isOK()) {
                this.onErrorDisplayDialog = false;
                returnStatus = AgentUIDependenciesCheckUtils.processDependencyStatus(returnStatus, false);
            }
            monitor.done();
            return returnStatus;
        }

        private IStatus consolidateStatusesForSupportedPlatforms(IStatus supportedPlatformsStatus, CicMultiStatus jobsStatus) {
            if (!StatusUtil.isErrorOrCancel((IStatus)jobsStatus)) {
                return supportedPlatformsStatus;
            }
            if (!StatusUtil.isErrorOrCancel((IStatus)supportedPlatformsStatus)) {
                return jobsStatus;
            }
            if (supportedPlatformsStatus.isMultiStatus()) {
                IStatus[] iStatusArray = jobsStatus.getLeaves();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus leafStatus = iStatusArray[n2];
                    ((CicMultiStatus)supportedPlatformsStatus).add(leafStatus);
                    ++n2;
                }
            }
            return supportedPlatformsStatus;
        }

        public IStatus getValidationStatus() {
            return this.validationStatus;
        }

        public boolean showErrorDisplayDialog() {
            return this.validationStatus.isMultiStatus() && this.onErrorDisplayDialog;
        }
    }
}

