/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.InstallAgentUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractCicTreeDetailsWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractAgentUIWizardPage
extends AbstractCicTreeDetailsWizardPage {
    private final AgentUIWizard agentWizard;

    public AbstractAgentUIWizardPage(FormToolkit toolkit, String title, String description, AgentUIWizard wizard) {
        super(title, toolkit, title, description);
        this.agentWizard = wizard;
    }

    public AbstractAgentUIWizardPage(String id, FormToolkit toolkit, String title, String description, AgentUIWizard wizard) {
        super(id, toolkit, title, description);
        this.agentWizard = wizard;
    }

    protected AgentUIWizard getAgentWizard() {
        return this.agentWizard;
    }

    protected List getJobs() {
        return this.agentWizard.getJobs();
    }

    protected List getSelectedJobs() {
        return this.agentWizard.getSelectedJobs();
    }

    public List getSelectedJobsWithoutAgentJob() {
        return InstallAgentUtils.getSelectedJobsWithoutAgentJob(this.getSelectedJobs());
    }

    public List getSelectedProductJobs() {
        return AgentUtil.getSelectedProductAgentJobs((Collection)this.getSelectedJobs());
    }

    public IOffering[] getSelectedProductOfferings() {
        return AgentUIUtils.getSelectedProductOfferingArray(this.getSelectedJobs());
    }

    public IOffering[] getSelectedPekOfferings() {
        ArrayList<IOffering> return_value = new ArrayList<IOffering>();
        List selectedJobs = this.getSelectedJobs();
        int i = 0;
        while (i < selectedJobs.size()) {
            AbstractJob job = (AbstractJob)selectedJobs.get(i);
            IOffering offering = job.getOffering();
            if (offering != null && LicenseUtils.isPEKOffering((IOffering)offering)) {
                return_value.add(offering);
            }
            ++i;
        }
        return return_value.toArray(new IOffering[return_value.size()]);
    }

    protected List getProfiles() {
        return this.agentWizard.getProfiles();
    }

    protected List getProductProfileList() {
        return this.agentWizard.getProductProfileList();
    }

    protected List getAgentProfileList() {
        return this.agentWizard.getAgentProfileList();
    }

    protected Map getProfileLocalLanguagesMap() {
        return this.agentWizard.getProfileLocaleLanguagesMap();
    }

    protected boolean hasSelectedJob() {
        for (AbstractJob job : this.getJobs()) {
            if (!job.isSelected()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSelectedProfile() {
        return this.getProfiles().size() > 0;
    }
}

