/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.views;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.ProfileOffering;
import com.ibm.cic.agent.core.sharedUI.ProfileOfferingFix;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.factories.MoreInfoFactory;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.views.IPreviewTask;
import com.ibm.cic.agent.internal.ui.views.IPreviewTaskProvider;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.DiskUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IProblemResolved;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.msdrepo.MasterSetupDiskRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.FormTextUtil;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PreviewTaskDetailsPage
extends AbstractFormPart
implements IDetailsPage {
    private FormText fDesc;
    private FormText taskList;
    private Label titleLabel;
    private Section pListSection;
    private FormText pListContent;
    private IPreviewTask[] tasks;
    private IPreviewTaskProvider currentProvider;
    protected Composite container;
    private Composite sectionParent;
    private final List alreadyPreparedOfferings = new ArrayList();
    protected Object lastSelectedObject = null;
    private IOfferingOrFix currentSelectedOfferingOrFix = null;

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 5;
        layout.topMargin = 3;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 3;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new TableWrapData(256, 256));
        this.sectionParent = parent;
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(parent, 512);
        section.setLayoutData((Object)new TableWrapData(256, 256));
        section.marginHeight = 0;
        section.marginWidth = 0;
        section.setText(com.ibm.cic.agent.core.sharedUI.Messages.DetailsPage_title);
        this.container = toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)this.container);
        layout = new TableWrapLayout();
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new TableWrapData(256, 256));
        this.titleLabel = toolkit.createLabel(this.container, null, 64);
        final Font customHeaderFont = CommonUIUtils.createBoldFont((Display)DisplayKeeper.INSTANCE.getDisplay(), (Font)this.container.getFont());
        this.titleLabel.setFont(customHeaderFont);
        this.titleLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (customHeaderFont != null && !customHeaderFont.isDisposed()) {
                    customHeaderFont.dispose();
                }
            }
        });
        HyperlinkAdapter urlAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (e.getLabel().equals(Messages.DetailsPage_moreInfo)) {
                    if (PreviewTaskDetailsPage.this.currentSelectedOfferingOrFix != null) {
                        IStatus status = PreviewTaskDetailsPage.this.prepareOfferingOrFix(PreviewTaskDetailsPage.this.currentSelectedOfferingOrFix);
                        if (status.isOK()) {
                            URL infoURL = null;
                            MoreInfoFactory.MoreInfo[] info = MoreInfoFactory.getInstance().findMoreInfoFor(PreviewTaskDetailsPage.this.currentSelectedOfferingOrFix);
                            if (info != null) {
                                MoreInfoFactory.MoreInfo[] moreInfoArray = info;
                                int n = info.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    MoreInfoFactory.MoreInfo element = moreInfoArray[n2];
                                    if (infoURL == null) {
                                        infoURL = element.getURL(Locale.getDefault());
                                    } else {
                                        element.getURL(Locale.getDefault());
                                    }
                                    ++n2;
                                }
                            }
                            if (infoURL != null) {
                                PreviewTaskDetailsPage.this.currentProvider.showURL(infoURL.toExternalForm());
                            } else {
                                MessageDialog.openInformation((Shell)PreviewTaskDetailsPage.this.fDesc.getShell(), (String)Messages.NoMoreInfoDlg_title, (String)Messages.NoMoreInfoDlg_message);
                            }
                        } else if (status.matches(4)) {
                            CicMultiStatus multiStatus = Statuses.ST.createMultiStatus(Messages.MoreInfoDlg_errorMsg, new Object[0]);
                            multiStatus.add(status);
                            WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(PreviewTaskDetailsPage.this.fDesc.getShell(), com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, null, (IStatus)multiStatus, 15);
                            errorDialog.open();
                        }
                    }
                } else if (e.getLabel().equals(Messages.EntitlementHelpLabel)) {
                    String url = (String)e.getHref();
                    if (Util.isValidUrl((String)url)) {
                        PreviewTaskDetailsPage.this.currentProvider.showURL(url);
                    } else {
                        MessageDialog.openError((Shell)PreviewTaskDetailsPage.this.fDesc.getShell(), (String)com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, (String)Messages.EntitlementHelpDlg_errorMsg);
                    }
                }
            }
        };
        HyperlinkAdapter taskAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String indexArg = (String)e.getHref();
                try {
                    int index = Integer.parseInt(indexArg);
                    if (PreviewTaskDetailsPage.this.tasks != null) {
                        PreviewTaskDetailsPage.this.tasks[index].run();
                    }
                }
                catch (NumberFormatException ex) {
                    AgentUI.reportException(ex);
                }
            }
        };
        this.fDesc = toolkit.createFormText(this.container, true);
        this.fDesc.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
        this.fDesc.addHyperlinkListener((IHyperlinkListener)urlAction);
        this.fDesc.setText("", false, false);
        TableWrapData td = new TableWrapData(256, 256);
        this.fDesc.setLayoutData((Object)td);
        FormTextUtil.connect((FormText)this.fDesc);
        this.taskList = toolkit.createFormText(this.container, false);
        this.taskList.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
        this.taskList.addHyperlinkListener((IHyperlinkListener)taskAction);
        this.taskList.setText("", false, false);
        td = new TableWrapData(256, 16);
        this.taskList.setLayoutData((Object)td);
        this.pListSection = toolkit.createSection(parent, 530);
        this.pListSection.clientVerticalSpacing = 0;
        this.pListSection.setText(Messages.DetailsSection_ResolvedProblemLabel);
        Composite pListComposite = toolkit.createComposite((Composite)this.pListSection);
        this.pListSection.setClient((Control)pListComposite);
        pListComposite.setLayout((Layout)new TableWrapLayout());
        this.pListSection.setLayoutData((Object)new TableWrapData(256, 256));
        this.pListContent = toolkit.createFormText(pListComposite, true);
        this.pListContent.setText("", false, false);
        this.pListSection.setVisible(false);
    }

    public void setSelection(IStructuredSelection selection) {
    }

    protected String getObjectLabel(Object object) {
        IBaseLabelProvider baseLabelProvider;
        if (object == null) {
            return "";
        }
        if (object instanceof Profile) {
            return ((Profile)object).getProfileId();
        }
        if (object instanceof IOffering) {
            return this.getOfferingOrFixLabel((IOfferingOrFix)((IOffering)object));
        }
        if (object instanceof IFix) {
            return this.getOfferingOrFixLabel((IOfferingOrFix)((IFix)object));
        }
        if (object instanceof IAdaptable) {
            IOffering offering = (IOffering)((IAdaptable)object).getAdapter(IOffering.class);
            if (offering != null) {
                return this.getOfferingOrFixLabel((IOfferingOrFix)offering);
            }
            IFix fix = (IFix)((IAdaptable)object).getAdapter(IFix.class);
            if (fix != null) {
                return this.getOfferingOrFixLabel((IOfferingOrFix)fix);
            }
            Profile profile = (Profile)((IAdaptable)object).getAdapter(Profile.class);
            if (profile != null) {
                return profile.getProfileId();
            }
        }
        if ((baseLabelProvider = this.currentProvider.getLabelProvider()) instanceof LabelProvider) {
            return ((LabelProvider)baseLabelProvider).getText(object);
        }
        return "";
    }

    private String getOfferingOrFixLabel(IOfferingOrFix offeringOrFix) {
        return AgentUIUtils.getOfferingOrFixLabel(offeringOrFix);
    }

    private IStatus prepareOfferingOrFix(final IOfferingOrFix offeringOrFix) {
        final IStatus[] status = new IStatus[1];
        try {
            if (this.alreadyPreparedOfferings.contains(offeringOrFix)) {
                return Status.OK_STATUS;
            }
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    status[0] = Agent.getInstance().prepare(offeringOrFix, new String[]{"OfferingBranding"}, monitor);
                    if (status[0].isOK()) {
                        PreviewTaskDetailsPage.this.alreadyPreparedOfferings.add(offeringOrFix);
                    }
                }
            }, 30);
        }
        catch (InvocationTargetException e) {
            status[0] = AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            status[0] = AgentUI.reportException(e);
        }
        return status[0];
    }

    protected String getObjectDescription(Object object) {
        if (object instanceof IOfferingOrFix) {
            this.currentSelectedOfferingOrFix = (IOfferingOrFix)object;
            if (object instanceof IOffering) {
                String return_value = "<form>";
                return_value = String.valueOf(return_value) + "<p>" + this.getOfferingDescription((IOffering)object, Status.OK_STATUS) + "</p>";
                String repLocation = this.getRepositoryDescription(null, (IOfferingOrFix)((IOffering)object));
                if (repLocation != null && repLocation.length() > 0) {
                    return_value = String.valueOf(return_value) + repLocation;
                }
                return_value = String.valueOf(return_value) + "</form>";
                return return_value;
            }
            if (object instanceof IFix) {
                String return_value = "<form>";
                return_value = String.valueOf(return_value) + "<p>" + this.getFixDescription((IFix)object, Status.OK_STATUS) + "</p>";
                String repLocation = this.getRepositoryDescription(null, (IOfferingOrFix)((IFix)object));
                if (repLocation != null && repLocation.length() > 0) {
                    return_value = String.valueOf(return_value) + repLocation;
                }
                return_value = String.valueOf(return_value) + "</form>";
                return return_value;
            }
        }
        if (object instanceof IRepositoryGroup) {
            String location = ((IRepositoryGroup)object).getLocationStr();
            return TextProcessor.process((String)location);
        }
        if (object instanceof Profile) {
            String des = FormTextUtil.toFormText((String)this.getProfileDescription((Profile)object));
            return des;
        }
        if (object instanceof ProfileOffering) {
            String repLocation;
            IOffering offering = ((ProfileOffering)object).getOffering();
            Profile profile = ((ProfileOffering)object).getProfile();
            this.currentSelectedOfferingOrFix = offering;
            String offeringDes = this.getOfferingDescription(offering, Status.OK_STATUS);
            String des = "<form>";
            if (offeringDes.length() > 0) {
                des = String.valueOf(des) + "<p>" + offeringDes + "</p>";
            }
            if ((repLocation = this.getRepositoryDescription(profile, (IOfferingOrFix)offering)) != null && repLocation.length() > 0) {
                des = String.valueOf(des) + repLocation;
            }
            des = String.valueOf(des) + this.getProfileDescription(profile);
            des = String.valueOf(des) + "</form>";
            return des;
        }
        if (object instanceof ProfileOfferingFix) {
            String repLocation;
            IFix fix = ((ProfileOfferingFix)object).getFix();
            ProfileOffering po = ((ProfileOfferingFix)object).getProfileOffering();
            Profile profile = po.getProfile();
            this.currentSelectedOfferingOrFix = fix;
            String fixDes = this.getFixDescription(fix, Status.OK_STATUS);
            String des = "<form>";
            if (fixDes.length() > 0) {
                des = String.valueOf(des) + "<p>" + fixDes + "</p>";
            }
            if ((repLocation = this.getRepositoryDescription(profile, (IOfferingOrFix)fix)) != null && repLocation.length() > 0) {
                des = String.valueOf(des) + repLocation;
            }
            des = String.valueOf(des) + "</form>";
            return des;
        }
        if (object instanceof IFeatureGroup) {
            return this.getFeatureGroupDescription((IFeatureGroup)object);
        }
        if (object instanceof IFeature) {
            return this.getFeatureDescription((IFeature)object);
        }
        if (object instanceof IAdaptable) {
            Object adapter = ((IAdaptable)object).getAdapter(AbstractJob.class);
            if (adapter != null) {
                IOffering offering = ((AbstractJob)adapter).getOffering();
                if (offering != null) {
                    this.currentSelectedOfferingOrFix = offering;
                    Profile profile = ((AbstractJob)adapter).getProfile();
                    String return_value = "<form>";
                    return_value = String.valueOf(return_value) + "<p>" + this.getOfferingDescription(offering, Status.OK_STATUS) + "</p>";
                    String repLocation = this.getRepositoryDescription(profile, (IOfferingOrFix)offering);
                    if (repLocation != null && repLocation.length() > 0) {
                        return_value = String.valueOf(return_value) + repLocation;
                    }
                    return_value = String.valueOf(return_value) + "</form>";
                    return return_value;
                }
                IFix fix = ((AbstractJob)adapter).getFix();
                if (fix != null) {
                    this.currentSelectedOfferingOrFix = fix;
                    Profile profile = ((AbstractJob)adapter).getProfile();
                    String return_value = "<form>";
                    return_value = String.valueOf(return_value) + "<p>" + this.getFixDescription(fix, Status.OK_STATUS) + "</p>";
                    String repLocation = this.getRepositoryDescription(profile, (IOfferingOrFix)fix);
                    if (repLocation != null && repLocation.length() > 0) {
                        return_value = String.valueOf(return_value) + repLocation;
                    }
                    return_value = String.valueOf(return_value) + "</form>";
                    return return_value;
                }
            }
            if ((adapter = ((IAdaptable)object).getAdapter(IOffering.class)) != null) {
                IOffering installedOffering = (IOffering)adapter;
                this.currentSelectedOfferingOrFix = installedOffering;
                String return_value = "<form>";
                return_value = String.valueOf(return_value) + "<p>" + this.getOfferingDescription(installedOffering, Status.OK_STATUS) + "</p>";
                Profile profile = (Profile)((IAdaptable)object).getAdapter(Profile.class);
                String repLocation = this.getRepositoryDescription(profile, (IOfferingOrFix)installedOffering);
                if (repLocation != null && repLocation.length() > 0) {
                    return_value = String.valueOf(return_value) + repLocation;
                }
                return_value = String.valueOf(return_value) + "</form>";
                return return_value;
            }
            adapter = ((IAdaptable)object).getAdapter(IFix.class);
            if (adapter != null) {
                this.currentSelectedOfferingOrFix = (IFix)adapter;
                String return_value = "<form>";
                return_value = String.valueOf(return_value) + "<p>" + this.getFixDescription((IFix)adapter, Status.OK_STATUS) + "</p>";
                String repLocation = this.getRepositoryDescription(null, (IOfferingOrFix)((IFix)adapter));
                if (repLocation != null && repLocation.length() > 0) {
                    return_value = String.valueOf(return_value) + repLocation;
                }
                return_value = String.valueOf(return_value) + "</form>";
                return return_value;
            }
            adapter = ((IAdaptable)object).getAdapter(Profile.class);
            if (adapter != null) {
                String des = "<form>";
                des = String.valueOf(des) + this.getProfileDescription((Profile)adapter);
                des = String.valueOf(des) + "</form>";
                return des;
            }
        }
        return "";
    }

    private String getProfileDescription(Profile profile) {
        String installLocation = profile.getInstallLocation();
        String processedCacheLocation = TextProcessor.process((String)AgentUIUtils.escapeSpecialChars(Agent.getInstance().isPortable() ? AgentUtil.genPortableSharedLocation((String)installLocation) : profile.getCacheLocation()));
        String profileDes = "<li>" + Messages.DetailSection_commonComponentLocation + " " + processedCacheLocation + "</li>";
        String processedInstallLocation = TextProcessor.process((String)AgentUIUtils.escapeSpecialChars(installLocation));
        profileDes = String.valueOf(profileDes) + "<li>" + Messages.DetailSection_installLocationDirectory + " " + processedInstallLocation + "</li>";
        String eclipseLocation = AgentUIUtils.escapeSpecialChars(profile.getEclipseLocation());
        if (eclipseLocation != null && eclipseLocation.length() > 0 && profile.isExistingEclipseProfile()) {
            String processedEclipseLocation = TextProcessor.process((String)eclipseLocation);
            profileDes = String.valueOf(profileDes) + "<li>" + Messages.SummaryPage_eclipseIDELabel + " " + processedEclipseLocation + "</li>";
        }
        String localeLanguages = TextProcessor.process((String)ProfileLanguageUtils.getLabelString((String)profile.getData("cic.selector.nl"), (boolean)false));
        profileDes = String.valueOf(profileDes) + "<li>" + Messages.DetailSection_translations + " " + localeLanguages + "</li>";
        if (BitModeUtils.isBitModeApplicable((Profile)profile)) {
            String bitModeText = TextProcessor.process((String)BitModeUtils.getBitModeText((Profile)profile));
            profileDes = String.valueOf(profileDes) + "<li>" + Messages.DetailSection_architecture + " " + bitModeText + "</li>";
        }
        profileDes = String.valueOf(profileDes) + this.getInstalledOfferingDescription(profile);
        return profileDes;
    }

    protected String getInstalledOfferingDescription(Profile profile) {
        return "";
    }

    private IFix toIFix(Object anObject) {
        if (anObject == null) {
            return null;
        }
        if (anObject instanceof IFix) {
            return (IFix)anObject;
        }
        if (anObject instanceof ProfileOfferingFix) {
            return ((ProfileOfferingFix)anObject).getFix();
        }
        if (anObject instanceof IAdaptable) {
            IFix fix;
            Object adapter = ((IAdaptable)anObject).getAdapter(AbstractJob.class);
            if (adapter != null && (fix = ((AbstractJob)adapter).getFix()) != null) {
                return fix;
            }
            adapter = ((IAdaptable)anObject).getAdapter(IFix.class);
            if (adapter != null) {
                return (IFix)adapter;
            }
        }
        return null;
    }

    private void hideResolvedProblemList() {
        this.pListContent.setText("", false, false);
        this.pListSection.setVisible(false);
        this.pListSection.getParent().layout();
    }

    private void setResolvedProblemList(Object anObject) {
        IFix offeringOrFix = this.toIFix(anObject);
        if (offeringOrFix == null) {
            this.hideResolvedProblemList();
            return;
        }
        List resolvedList = offeringOrFix.getProblemsResolvedList();
        if (resolvedList.size() == 0) {
            this.hideResolvedProblemList();
            return;
        }
        IProblemsResolved problems = (IProblemsResolved)resolvedList.get(0);
        List problemsList = problems.getProblems();
        if (!problems.showList() || problemsList.size() == 0) {
            this.hideResolvedProblemList();
            return;
        }
        StringBuffer problemsListStr = new StringBuffer();
        int visibleProblem = 0;
        int j = 0;
        while (j < problemsList.size()) {
            IProblemResolved p = (IProblemResolved)problemsList.get(j);
            if (!p.isHidden()) {
                String pDesc = p.getDescription();
                if (pDesc == null || pDesc.length() == 0) {
                    pDesc = p.getDisplayId();
                }
                problemsListStr.append("- ");
                problemsListStr.append(pDesc);
                problemsListStr.append("<br/>");
                ++visibleProblem;
            }
            ++j;
        }
        if (visibleProblem == 0) {
            this.hideResolvedProblemList();
            return;
        }
        StringBuffer msg = new StringBuffer("<form><p>");
        msg.append(problemsListStr.toString());
        msg.append("</p></form>");
        this.pListContent.setText(msg.toString(), true, false);
        String problemsDesc = problems.getDescription();
        if (problemsDesc == null || problemsDesc.length() == 0) {
            problemsDesc = Messages.DetailsSection_ResolvedProblemLabel;
        }
        this.pListSection.setText(problemsDesc);
        this.pListSection.setExpanded(visibleProblem < 11);
        this.pListSection.setVisible(true);
        this.pListSection.getParent().layout();
    }

    private String getRepositoryDescription(Profile profile, IOfferingOrFix offeringOrFix) {
        StringBuffer return_value = new StringBuffer();
        if (offeringOrFix == null) {
            return return_value.toString();
        }
        IRepository rep = offeringOrFix.getRepository();
        if (rep != null && rep.getLocationStr() != null) {
            return_value.append("<li>");
            return_value.append(Messages.DetailsSection_RepositoryLabel);
            return_value.append(" ");
            String repLocation = rep.getLocationStr();
            if (profile != null) {
                Agent agent = AgentUI.getDefault().getAgent();
                IRepository installRegistryRep = profile.getInstallRegistry().getRepository();
                if (installRegistryRep != null && installRegistryRep.equals(rep)) {
                    String serializedRepInfo = agent.getInstalledOfferingRepInfo(profile, offeringOrFix);
                    RepositoryInfo repInfo = RepositoryInfo.deserialize((String)serializedRepInfo);
                    repLocation = repInfo.getLocationStr();
                }
            }
            String processedLocation = TextProcessor.process((String)repLocation);
            return_value.append(processedLocation);
            return_value.append("</li>");
            if (profile == null) {
                ArrayList<IOfferingOrFix> selectedOfferingOrFix = new ArrayList<IOfferingOrFix>();
                selectedOfferingOrFix.add(offeringOrFix);
                if (!DiskUtil.canFindAvailableDisks(selectedOfferingOrFix)) {
                    return return_value.toString();
                }
                IVolumeAccessByDisk diskRep = RepoAs.IVolumeAccessByDisk((IReadArtifactRepo)rep);
                if (diskRep != null) {
                    StringBuffer diskSetInfo;
                    block16: {
                        diskSetInfo = new StringBuffer();
                        IArtifactSession session = IArtifactSessionFactory.INSTANCE.createArtifactSession();
                        try {
                            try {
                                IVolumeAccessByDisk.IDiskSet[] diskSets;
                                IVolumeAccessByDisk.IDiskSet[] iDiskSetArray = diskSets = diskRep.getDiskSets(session, (IProgressMonitor)new NullProgressMonitor());
                                int n = diskSets.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String missingDisks;
                                    IVolumeAccessByDisk.IDiskSetDisks allDisks;
                                    List diskInfo;
                                    IVolumeAccessByDisk.IDiskSet diskSet2 = iDiskSetArray[n2];
                                    IVolumeAccessByDisk.IDiskSet diskSet = diskSet2;
                                    if (!diskSet.equals(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET) && (diskInfo = AgentUIUtils.getDiskInfoFromDiskSet(session, diskRep, diskSet, allDisks = diskSet.useAllDisks())).size() == 2 && (missingDisks = (String)diskInfo.get(1)) != null && missingDisks.length() > 0) {
                                        if (diskSetInfo.length() > 0) {
                                            diskSetInfo.append("; ");
                                        }
                                        diskSetInfo.append(NLS.bind((String)Messages.DetailsPage_disksInDiskSet, (Object)missingDisks, (Object)diskSet.getLabel()));
                                    }
                                    ++n2;
                                }
                            }
                            catch (Exception e) {
                                AgentUI.reportException(e, false);
                                session.close();
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            session.close();
                            throw throwable;
                        }
                        session.close();
                    }
                    if (diskSetInfo.length() > 0) {
                        String warningMsg = NLS.bind((String)Messages.DetailsPage_diskNotFound, (Object)diskSetInfo.toString());
                        return_value.append(FormTextUtil.toFormTextWarning((String)warningMsg));
                    }
                }
            }
        }
        return return_value.toString();
    }

    private String getOfferingDescription(IOffering offering, IStatus prepareResolveStatus) {
        Information information = offering.getInformation();
        String description = information == null ? "" : information.getDescription();
        String loadMoreInfoDesc = "";
        return this.getOfferingDescription(description, loadMoreInfoDesc, "");
    }

    private String getFixDescription(IFix fix, IStatus prepareResolveStatus) {
        Information information = fix.getInformation();
        String description = information == null ? "" : information.getDescription();
        String loadMoreInfoDesc = "";
        return this.getFixDescription(description, loadMoreInfoDesc, "");
    }

    private String getFixDescription(String desc, String moreInfoDes, String url) {
        if (desc != null) {
            desc = AgentUIUtils.convertSpecialCharsForDescription(desc);
            if (moreInfoDes != null && moreInfoDes.length() > 0) {
                desc = String.valueOf(desc) + " " + moreInfoDes;
            }
            if (url == null) {
                return desc;
            }
            String link = " <a href=\"" + url + "\">" + Messages.DetailsPage_moreInfo + "</a>";
            String fullText = String.valueOf(desc) + link;
            return fullText;
        }
        return "";
    }

    private String getOfferingDescription(String desc, String moreInfoDesc, String url) {
        if (desc != null) {
            desc = AgentUIUtils.convertSpecialCharsForDescription(desc);
            if (moreInfoDesc != null && moreInfoDesc.length() > 0) {
                desc = String.valueOf(desc) + " " + moreInfoDesc;
            }
            if (url == null) {
                return desc;
            }
            String link = " <a href=\"" + url + "\">" + Messages.DetailsPage_moreInfo + "</a>";
            String fullText = String.valueOf(desc) + link;
            return fullText;
        }
        return "";
    }

    private String getFeatureGroupDescription(IFeatureGroup featureGroup) {
        Information information = featureGroup.getInformation();
        return this.getFeatureDescription(information == null ? null : information.getDescription(), null);
    }

    private String getFeatureDescription(IFeature feature) {
        Information information = feature.getInformation();
        return this.getFeatureDescription(information == null ? null : information.getDescription(), null);
    }

    private String getFeatureDescription(String desc, String url) {
        if (desc != null) {
            desc = AgentUIUtils.convertSpecialCharsForDescription(desc);
            if (url == null) {
                return "<form><p>" + desc + "</p></form>";
            }
            String link = " <a href=\"" + url + "\">" + Messages.DetailsPage_moreInfo + "</a>";
            String fullText = "<form><p>" + desc + link + "</p></form>";
            return fullText;
        }
        return "";
    }

    private String getTasksText() {
        if (this.tasks == null || this.tasks.length == 0) {
            return "";
        }
        boolean hasEnabledTasks = false;
        IPreviewTask[] iPreviewTaskArray = this.tasks;
        int n = this.tasks.length;
        int n2 = 0;
        while (n2 < n) {
            IPreviewTask task = iPreviewTaskArray[n2];
            if (task.isEnabled()) {
                hasEnabledTasks = true;
                break;
            }
            ++n2;
        }
        if (!hasEnabledTasks) {
            return "<form/>";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<form><p><b>");
        buf.append(Messages.DetailsPage_availableTasks);
        buf.append("</b></p>");
        int i = 0;
        while (i < this.tasks.length) {
            IPreviewTask task = this.tasks[i];
            if (task.isEnabled()) {
                buf.append("<li style=\"text\" indent=\"0\"><a href=\"" + i + "\">" + task.getName() + "</a></li>");
                buf.append("<li style=\"text\" indent=\"10\" vspace=\"false\">" + task.getDescription() + "</li>");
            }
            ++i;
        }
        buf.append("</form>");
        return buf.toString();
    }

    protected void setLicenseDetails(Object object) {
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        try {
            Object object = ((StructuredSelection)selection).getFirstElement();
            if (object == this.lastSelectedObject) {
                return;
            }
            this.lastSelectedObject = object;
            this.currentProvider = (IPreviewTaskProvider)part;
            this.tasks = this.currentProvider.getPreviewTasksFor(selection);
            this.currentSelectedOfferingOrFix = null;
            String title = this.getObjectLabel(object);
            this.setLicenseDetails(object);
            String description = this.getObjectDescription(object);
            String taskText = this.getTasksText();
            this.titleLabel.setText(title);
            boolean tags = FormTextUtil.isFormText((String)description);
            this.fDesc.setText(description, tags, tags);
            this.setResolvedProblemList(object);
            if (taskText != null && taskText.length() > 0) {
                this.taskList.setText(taskText, true, false);
            } else {
                this.taskList.setText("", false, false);
            }
            if (this.sectionParent != null) {
                this.sectionParent.layout();
            }
        }
        catch (RuntimeStatusException e) {
            AgentUI.reportException(e);
        }
    }

    public void refreshDetails() {
        if (this.lastSelectedObject == null || this.currentProvider == null || this.tasks == null || this.currentSelectedOfferingOrFix == null) {
            return;
        }
        String title = this.getObjectLabel(this.lastSelectedObject);
        this.setLicenseDetails(this.lastSelectedObject);
        String description = this.getObjectDescription(this.lastSelectedObject);
        String taskText = this.getTasksText();
        this.titleLabel.setText(title);
        boolean tags = description.startsWith("<form>");
        this.fDesc.setText(description, tags, !tags);
        this.setResolvedProblemList(this.lastSelectedObject);
        if (taskText != null && taskText.length() > 0) {
            this.taskList.setText(taskText, true, false);
        } else {
            this.taskList.setText("", false, false);
        }
        if (this.sectionParent != null) {
            this.sectionParent.layout();
        }
    }
}

