/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.views;

import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.dialogs.LogFilterDialog;
import com.ibm.cic.agent.internal.ui.dialogs.OpenLogDialog;
import com.ibm.cic.agent.internal.ui.dialogs.ViewLogDialog;
import com.ibm.cic.agent.internal.ui.parts.TreeMasterPart;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.logging.CicLogRelocalizer;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.ILogListener;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.parser.CicLogParser;
import com.ibm.cic.common.logging.parser.EntryRecord;
import com.ibm.cic.common.logging.parser.LogRecord;
import com.ibm.cic.common.logging.parser.MessageRecord;
import com.ibm.cic.common.logging.parser.StackRecord;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class LogSection
extends TreeMasterPart {
    private ViewerFilter logFilter;
    private LogRecord input;
    private IFormContext context;
    private IDialogSettings logDialogSettings;
    private File logFile;
    private boolean isCurrentSessionLog;
    private TreeColumn severityCol;
    private TreeColumn descriptionCol;
    private TreeColumn messageIdCol;
    private TreeColumn dateCol;
    private static int severityColInitWidth = 40;
    private static int descriptionColInitWidth = 500;
    private static int messageIdColInitWidth = 80;
    private static int dateColInitWidth = 80;
    public static final String P_LOG_ERROR = "error";
    public static final String P_LOG_WARNING = "warning";
    public static final String P_LOG_INFO = "info";
    public static final String P_LOG_DEBUG = "debug";
    public static final String P_LOG_NOTE = "note";
    public static final String P_LOG_MESSAGE_ID = "messageID";
    public static final String P_ORDER_TYPE = "orderType";
    public static final String P_ORDER_VALUE = "orderValue";
    public static final String P_SEVERITY_COL = "severityCol";
    public static final String P_DESCRIPTION_COL = "desCol";
    public static final String P_MESSAGE_ID_COL = "messageIdCol";
    public static final String P_DATE_COL = "dateCol";
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private int SEVERITY_ORDER = -1;
    private int DESCRIPTION_ORDER = 1;
    private int MESSAGE_ID_ORDER = 1;
    private int DATE_ORDER = -1;
    private static final int SORT_SEVERITY = 0;
    private static final int SORT_DESCRIPTION = 1;
    private static final int SORT_MESSAGE_ID = 2;
    private static final int SORT_DATE = 3;
    private CicLogRelocalizer relocalizer = null;

    public LogSection(IFormContext context, Composite parent, File agentLogFile) {
        super(context, parent, 640, null, 256);
        this.context = context;
        this.logFile = agentLogFile;
        File currentSessionLog = LogManager.getDefaultLogFile();
        this.isCurrentSessionLog = this.logFile != null && this.logFile.equals(currentSessionLog);
        this.configureViewer(this.getTreePart().getTreeViewer());
        AgentUILabelProvider labelProvider = AgentUI.getDefault().getLabelProvider();
        labelProvider.connect(this);
        if (this.isCurrentSessionLog) {
            this.getSection().setDescription(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_des_currentSession);
        } else {
            this.getSection().setDescription(NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_des_logFile, (Object)this.logFile.getAbsolutePath()));
        }
        this.getSection().layout();
        final Composite finalParent = parent;
        Composite imageComp = new Composite((Composite)this.getSection(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        imageComp.setLayout((Layout)layout);
        Image exportLogImage = labelProvider.get(CICImages.LOG_EXPORT_FILE);
        ImageHyperlink exportLogLink = new ImageHyperlink(imageComp, 0);
        this.getToolkit().adapt((Composite)exportLogLink);
        exportLogLink.setImage(exportLogImage);
        exportLogLink.setToolTipText(Messages.AgentLogView_export_tooltip);
        exportLogLink.setBackground(this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        exportLogLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String currentLogPath = LogSection.this.logFile.getParent();
                String fullPathName = UiServices.getInstance().getFileDialog(finalParent.getShell()).filterExtensions(new String[]{"*.xml"}).title(Messages.AgentLogView_exportDlgTitle).filterPath(currentLogPath).run();
                if (fullPathName != null) {
                    if (LogSection.this.logFile != null && LogSection.this.logFile.exists()) {
                        if (fullPathName.indexOf(46) == -1 && !fullPathName.endsWith(".xml")) {
                            fullPathName = String.valueOf(fullPathName) + ".xml";
                        }
                        if (!fullPathName.equals(LogSection.this.logFile.getAbsolutePath())) {
                            File outputFile = new Path(fullPathName).toFile();
                            if (outputFile.exists()) {
                                String message = NLS.bind((String)Messages.AgentLogView_exportLogConfirmMsg, (Object)outputFile.toString());
                                if (!MessageDialog.openQuestion((Shell)finalParent.getShell(), (String)Messages.AgentLogView_exportLogDlgTitle, (String)message)) {
                                    return;
                                }
                            }
                            if (LogSection.this.getCicLogRelocalizer() != null) {
                                LogSection.this.getCicLogRelocalizer().export(LogSection.this.logFile, outputFile);
                            } else {
                                LogSection.this.copy(LogSection.this.logFile, outputFile);
                            }
                        } else {
                            MessageDialog.openError((Shell)finalParent.getShell(), (String)Messages.AgentLogView_exportLogErrorTitle, (String)Messages.AgentLogView_exportLogErrorSameFile);
                        }
                    } else {
                        MessageDialog.openError((Shell)finalParent.getShell(), (String)Messages.AgentLogView_exportLogErrorTitle, (String)Messages.AgentLogView_exportLogErrorMsg);
                    }
                }
            }
        });
        Image filterImage = labelProvider.get(CICImages.LOG_FILTER);
        ImageHyperlink filterLink = new ImageHyperlink(imageComp, 0);
        this.getToolkit().adapt((Composite)filterLink);
        filterLink.setImage(filterImage);
        filterLink.setToolTipText(Messages.AgentLogView_filters);
        filterLink.setBackground(this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        filterLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                List filterSelection = LogSection.this.constructFilterSelection();
                String containedSource = LogSection.this.logDialogSettings.get(LogSection.P_LOG_MESSAGE_ID);
                LogFilterDialog filterDialog = new LogFilterDialog(finalParent.getShell(), filterSelection, containedSource);
                if (filterDialog.open() == 0) {
                    List checkedList = filterDialog.getSelections();
                    CicPreferenceManager.getInstance().setBoolean(ICicPreferenceConstants.ShowInformationLog, ((Boolean)checkedList.get(1)).booleanValue());
                    CicPreferenceManager.getInstance().setBoolean(ICicPreferenceConstants.ShowNoteLog, ((Boolean)checkedList.get(2)).booleanValue());
                    CicPreferenceManager.getInstance().setBoolean(ICicPreferenceConstants.ShowWarningLog, ((Boolean)checkedList.get(3)).booleanValue());
                    CicPreferenceManager.getInstance().setBoolean(ICicPreferenceConstants.ShowErrorLog, ((Boolean)checkedList.get(4)).booleanValue());
                    String source = filterDialog.getSourceString();
                    LogSection.this.logDialogSettings.put(LogSection.P_LOG_MESSAGE_ID, source);
                    LogSection.this.updateViewerFilter();
                    LogSection.this.primeSelection();
                }
            }
        });
        Image openLogImage = labelProvider.get(CICImages.LOG_OPEN_FILE);
        final ImageHyperlink openLogLink = new ImageHyperlink(imageComp, 0);
        this.getToolkit().adapt((Composite)openLogLink);
        openLogLink.setImage(openLogImage);
        openLogLink.setToolTipText(Messages.AgentLogView_openLogFile);
        openLogLink.setBackground(this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        openLogLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenLogDialog.openSystemEditor(openLogLink.getShell(), LogSection.this.logFile);
            }
        });
        this.getSection().setTextClient((Control)imageComp);
        try {
            if (this.logFile != null && this.logFile.exists()) {
                this.input = new CicLogParser().parse(this.logFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getTreePart().getTreeViewer().setInput((Object)this.input);
        this.initializeViewerSorter();
        this.updateViewerFilter();
        this.makePreviewTasks();
    }

    protected void createButtons(Composite parent, FormToolkit toolkit) {
    }

    protected CicLogRelocalizer getCicLogRelocalizer() {
        boolean isEnglish = Platform.getNL().startsWith(Locale.ENGLISH.getLanguage());
        if (this.relocalizer == null && !isEnglish) {
            this.relocalizer = new CicLogRelocalizer(Locale.ENGLISH);
        }
        return this.relocalizer;
    }

    private void copy(File inputFile, File outputFile) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8"));
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (line == null) continue;
                    writer.write(line);
                    writer.write(System.getProperty("line.separator"));
                }
            }
            catch (IOException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e1) {
                    ExceptionUtil.debugLogToReview((Throwable)e1);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                ExceptionUtil.debugLogToReview((Throwable)e1);
            }
        }
    }

    public void setInput(File agentLogFile) {
        this.logFile = agentLogFile;
        try {
            if (this.logFile != null && this.logFile.exists()) {
                this.input = new CicLogParser().parse(this.logFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getTreePart().getTreeViewer().setInput((Object)this.input);
        this.isCurrentSessionLog = this.logFile != null && this.logFile.equals(LogManager.getDefaultLogFile());
        this.getTreePart().setButtonEnabled(0, !this.isCurrentSessionLog);
        if (this.isCurrentSessionLog) {
            this.getSection().setDescription(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_des_currentSession);
        } else {
            this.getSection().setDescription(NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_des_logFile, (Object)this.logFile.getAbsolutePath()));
        }
        this.getSection().layout();
        this.primeSelection();
    }

    public File getInput() {
        return this.logFile;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        int fullStyle = style;
        if (fullStyle == 0) {
            fullStyle = this.getToolkit().getBorderStyle() | 0x10000;
        }
        TreeViewer viewer = new TreeViewer(parent, fullStyle);
        this.getContext().getForm().getToolkit().adapt(viewer.getControl(), true, true);
        return viewer;
    }

    @Override
    public void primeSelection() {
        TreeViewer viewer;
        Tree logTree;
        if (this.input != null && (logTree = (viewer = this.getTreePart().getTreeViewer()).getTree()).getItemCount() > 0) {
            Object firstElement = logTree.getItem(0).getData();
            viewer.setSelection((ISelection)new StructuredSelection(firstElement));
        }
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 65538, 2, toolkit);
        UiServices.getInstance().paintBordersFor(toolkit, container);
        section.setClient((Control)container);
    }

    @Override
    protected FormToolkit getToolkit() {
        return this.getContext().getForm().getToolkit();
    }

    public void dispose() {
        this.saveState();
        AgentUI.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        if (this.context instanceof ViewLogDialog) {
            this.logDialogSettings = ((ViewLogDialog)this.context).getLogSettings();
        } else {
            IDialogSettings settings = AgentUI.getDefault().getDialogSettings();
            this.logDialogSettings = settings.getSection(this.getClass().getName());
            if (this.logDialogSettings == null) {
                this.logDialogSettings = settings.addNewSection(this.getClass().getName());
            }
        }
        this.initLogSection();
        viewer.setContentProvider((IContentProvider)new LogContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LogLabelProvider());
        this.createColumns(viewer);
        viewer.getTree().setHeaderVisible(true);
        viewer.getTree().setLinesVisible(true);
        this.getTreePart().setButtonEnabled(0, !this.isCurrentSessionLog);
        this.getTreePart().setButtonTooltip(0, Messages.AgentLogView_viewCurrentLog_tooltip);
    }

    private void createColumns(final TreeViewer viewer) {
        this.severityCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.severityCol.setText(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_severityCol);
        this.severityCol.setWidth(this.logDialogSettings.getInt(P_SEVERITY_COL));
        this.severityCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LogSection.this.logDialogSettings.put(LogSection.P_SEVERITY_COL, LogSection.this.severityCol.getWidth());
            }
        });
        this.severityCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogSection logSection = LogSection.this;
                logSection.SEVERITY_ORDER = logSection.SEVERITY_ORDER * -1;
                ViewerSorter sorter = LogSection.this.getViewerSorter(0);
                viewer.setSorter(sorter);
                LogSection.this.logDialogSettings.put(LogSection.P_ORDER_VALUE, LogSection.this.SEVERITY_ORDER);
                LogSection.this.logDialogSettings.put(LogSection.P_ORDER_TYPE, 0);
                LogSection.this.setColumnSorting(LogSection.this.severityCol, LogSection.this.SEVERITY_ORDER);
            }
        });
        this.descriptionCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.descriptionCol.setText(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_desCol);
        this.descriptionCol.setWidth(this.logDialogSettings.getInt(P_DESCRIPTION_COL));
        this.descriptionCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LogSection.this.logDialogSettings.put(LogSection.P_DESCRIPTION_COL, LogSection.this.descriptionCol.getWidth());
            }
        });
        this.descriptionCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogSection logSection = LogSection.this;
                logSection.DESCRIPTION_ORDER = logSection.DESCRIPTION_ORDER * -1;
                ViewerSorter sorter = LogSection.this.getViewerSorter(1);
                viewer.setSorter(sorter);
                LogSection.this.logDialogSettings.put(LogSection.P_ORDER_VALUE, LogSection.this.DESCRIPTION_ORDER);
                LogSection.this.logDialogSettings.put(LogSection.P_ORDER_TYPE, 1);
                LogSection.this.setColumnSorting(LogSection.this.descriptionCol, LogSection.this.DESCRIPTION_ORDER);
            }
        });
        this.messageIdCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.messageIdCol.setText(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_messageIDCol);
        this.messageIdCol.setWidth(this.logDialogSettings.getInt(P_MESSAGE_ID_COL));
        this.messageIdCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LogSection.this.logDialogSettings.put(LogSection.P_MESSAGE_ID_COL, LogSection.this.messageIdCol.getWidth());
            }
        });
        this.messageIdCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogSection logSection = LogSection.this;
                logSection.MESSAGE_ID_ORDER = logSection.MESSAGE_ID_ORDER * -1;
                ViewerSorter sorter = LogSection.this.getViewerSorter(2);
                viewer.setSorter(sorter);
                LogSection.this.logDialogSettings.put(LogSection.P_ORDER_VALUE, LogSection.this.MESSAGE_ID_ORDER);
                LogSection.this.logDialogSettings.put(LogSection.P_ORDER_TYPE, 2);
                LogSection.this.setColumnSorting(LogSection.this.messageIdCol, LogSection.this.MESSAGE_ID_ORDER);
            }
        });
        this.dateCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.dateCol.setText(Messages.AgentLogView_dateCol);
        this.dateCol.setWidth(this.logDialogSettings.getInt(P_DATE_COL));
        this.dateCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LogSection.this.logDialogSettings.put(LogSection.P_DATE_COL, LogSection.this.dateCol.getWidth());
            }
        });
        this.dateCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogSection logSection = LogSection.this;
                logSection.DATE_ORDER = logSection.DATE_ORDER * -1;
                ViewerSorter sorter = LogSection.this.getViewerSorter(3);
                viewer.setSorter(sorter);
                LogSection.this.logDialogSettings.put(LogSection.P_ORDER_VALUE, LogSection.this.DATE_ORDER);
                LogSection.this.logDialogSettings.put(LogSection.P_ORDER_TYPE, 3);
                LogSection.this.setColumnSorting(LogSection.this.dateCol, LogSection.this.DATE_ORDER);
            }
        });
    }

    private void initializeViewerSorter() {
        int orderType = this.logDialogSettings.getInt(P_ORDER_TYPE);
        ViewerSorter sorter = this.getViewerSorter(orderType);
        this.getTreePart().getTreeViewer().setSorter(sorter);
        if (orderType == 0) {
            this.setColumnSorting(this.severityCol, this.SEVERITY_ORDER);
        } else if (orderType == 1) {
            this.setColumnSorting(this.descriptionCol, this.DESCRIPTION_ORDER);
        } else if (orderType == 2) {
            this.setColumnSorting(this.messageIdCol, this.MESSAGE_ID_ORDER);
        } else if (orderType == 3) {
            this.setColumnSorting(this.dateCol, this.DATE_ORDER);
        }
    }

    private List constructFilterSelection() {
        ArrayList<Boolean> logControl = new ArrayList<Boolean>();
        logControl.add(Boolean.FALSE);
        logControl.add(CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.ShowInformationLog.key()));
        logControl.add(CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.ShowNoteLog.key()));
        logControl.add(CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.ShowWarningLog.key()));
        logControl.add(CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.ShowErrorLog.key()));
        return logControl;
    }

    private void updateViewerFilter() {
        List filterSelection = this.constructFilterSelection();
        String containedSource = this.logDialogSettings.get(P_LOG_MESSAGE_ID);
        ViewerFilter oldLogFilter = this.logFilter;
        this.logFilter = new LogFilter(filterSelection, containedSource);
        if (oldLogFilter != null) {
            this.getTreePart().getTreeViewer().removeFilter(oldLogFilter);
        }
        this.getTreePart().getTreeViewer().addFilter(this.logFilter);
    }

    private void setColumnSorting(TreeColumn column, int order) {
        this.getTreePart().getTreeViewer().getTree().setSortColumn(column);
        this.getTreePart().getTreeViewer().getTree().setSortDirection(order == 1 ? 128 : 1024);
    }

    private ViewerSorter getViewerSorter(int sortType) {
        if (sortType == 0) {
            return new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    EntryRecord entry1 = (EntryRecord)e1;
                    EntryRecord entry2 = (EntryRecord)e2;
                    int result = (entry1.getLevel() - entry2.getLevel()) * LogSection.this.SEVERITY_ORDER;
                    if (result == 0) {
                        result = (entry1.getNum() - entry2.getNum()) * LogSection.this.SEVERITY_ORDER;
                    }
                    return result;
                }
            };
        }
        if (sortType == 1) {
            return new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    EntryRecord entry1 = (EntryRecord)e1;
                    EntryRecord entry2 = (EntryRecord)e2;
                    int result = super.compare(viewer, (Object)SharedUIUtils.constructLogDescription((EntryRecord)entry1), (Object)SharedUIUtils.constructLogDescription((EntryRecord)entry2)) * LogSection.this.DESCRIPTION_ORDER;
                    if (result == 0) {
                        result = (entry1.getNum() - entry2.getNum()) * LogSection.this.DESCRIPTION_ORDER;
                    }
                    return result;
                }
            };
        }
        if (sortType == 2) {
            return new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    EntryRecord entry1 = (EntryRecord)e1;
                    EntryRecord entry2 = (EntryRecord)e2;
                    int result = super.compare(viewer, (Object)LogSection.this.constructMessageId(entry1), (Object)LogSection.this.constructMessageId(entry2)) * LogSection.this.MESSAGE_ID_ORDER;
                    if (result == 0) {
                        result = (entry1.getNum() - entry2.getNum()) * LogSection.this.MESSAGE_ID_ORDER;
                    }
                    return result;
                }
            };
        }
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                EntryRecord entry1 = (EntryRecord)e1;
                EntryRecord entry2 = (EntryRecord)e2;
                long result = (entry1.getTime() - entry2.getTime()) * (long)LogSection.this.DATE_ORDER;
                if (result == 0L) {
                    result = (entry1.getNum() - entry2.getNum()) * LogSection.this.DATE_ORDER;
                }
                return (int)result;
            }
        };
    }

    private String constructMessageId(EntryRecord entryRecord) {
        String messageId = entryRecord.getUid();
        if (messageId == null) {
            return "";
        }
        return messageId;
    }

    void initLogSection() {
        this.readSettings();
        int type = this.logDialogSettings.getInt(P_ORDER_TYPE);
        switch (type) {
            case 3: {
                this.DATE_ORDER = this.logDialogSettings.getInt(P_ORDER_VALUE);
                this.SEVERITY_ORDER = -1;
                this.DESCRIPTION_ORDER = -1;
                this.MESSAGE_ID_ORDER = -1;
                break;
            }
            case 0: {
                this.SEVERITY_ORDER = this.logDialogSettings.getInt(P_ORDER_VALUE);
                this.DATE_ORDER = -1;
                this.DESCRIPTION_ORDER = -1;
                this.MESSAGE_ID_ORDER = -1;
                break;
            }
            case 2: {
                this.MESSAGE_ID_ORDER = this.logDialogSettings.getInt(P_ORDER_VALUE);
                this.DATE_ORDER = -1;
                this.DESCRIPTION_ORDER = -1;
                this.SEVERITY_ORDER = -1;
                break;
            }
            case 1: {
                this.DESCRIPTION_ORDER = this.logDialogSettings.getInt(P_ORDER_VALUE);
                this.DATE_ORDER = -1;
                this.SEVERITY_ORDER = -1;
                this.MESSAGE_ID_ORDER = -1;
                break;
            }
            default: {
                this.SEVERITY_ORDER = -1;
                this.DATE_ORDER = -1;
                this.DESCRIPTION_ORDER = -1;
                this.MESSAGE_ID_ORDER = -1;
            }
        }
    }

    private IDialogSettings getFilterSettings() {
        IDialogSettings settings = AgentUI.getDefault().getDialogSettings();
        return settings.getSection(this.getClass().getName());
    }

    private void readSettings() {
        IDialogSettings s = this.getFilterSettings();
        if (s == null) {
            this.initializeLogDialogSettings();
        } else {
            this.logDialogSettings.put(P_LOG_INFO, s.getBoolean(P_LOG_INFO) ? "true" : "false");
            this.logDialogSettings.put(P_LOG_WARNING, s.getBoolean(P_LOG_WARNING) ? "true" : "false");
            this.logDialogSettings.put(P_LOG_ERROR, s.getBoolean(P_LOG_ERROR) ? "true" : "false");
            this.logDialogSettings.put(P_LOG_DEBUG, s.getBoolean(P_LOG_DEBUG) ? "true" : "false");
            this.logDialogSettings.put(P_LOG_NOTE, s.getBoolean(P_LOG_NOTE) ? "true" : "false");
            this.logDialogSettings.put(P_LOG_MESSAGE_ID, s.get(P_LOG_MESSAGE_ID));
        }
        try {
            this.logDialogSettings.getInt(P_SEVERITY_COL);
            this.logDialogSettings.getInt(P_DESCRIPTION_COL);
            this.logDialogSettings.getInt(P_MESSAGE_ID_COL);
            this.logDialogSettings.getInt(P_DATE_COL);
            this.logDialogSettings.getInt(P_ORDER_VALUE);
            this.logDialogSettings.getInt(P_ORDER_TYPE);
        }
        catch (NumberFormatException numberFormatException) {
            this.logDialogSettings.put(P_SEVERITY_COL, severityColInitWidth);
            this.logDialogSettings.put(P_DESCRIPTION_COL, descriptionColInitWidth);
            this.logDialogSettings.put(P_MESSAGE_ID_COL, messageIdColInitWidth);
            this.logDialogSettings.put(P_DATE_COL, dateColInitWidth);
            this.logDialogSettings.put(P_ORDER_TYPE, 3);
            this.logDialogSettings.put(P_ORDER_VALUE, -1);
        }
    }

    private void initializeLogDialogSettings() {
        if (this.logDialogSettings.get(P_LOG_INFO) == null) {
            this.logDialogSettings.put(P_LOG_INFO, "false");
        }
        if (this.logDialogSettings.get(P_LOG_WARNING) == null) {
            this.logDialogSettings.put(P_LOG_WARNING, "true");
        }
        if (this.logDialogSettings.get(P_LOG_ERROR) == null) {
            this.logDialogSettings.put(P_LOG_ERROR, "true");
        }
        if (this.logDialogSettings.get(P_LOG_DEBUG) == null) {
            this.logDialogSettings.put(P_LOG_DEBUG, "false");
        }
        if (this.logDialogSettings.get(P_LOG_NOTE) == null) {
            this.logDialogSettings.put(P_LOG_NOTE, "true");
        }
        if (this.logDialogSettings.get(P_LOG_MESSAGE_ID) == null) {
            this.logDialogSettings.put(P_LOG_MESSAGE_ID, "");
        }
    }

    public void saveState() {
        this.writeSettings();
    }

    private void writeSettings() {
        this.writeFilterSettings();
    }

    private void writeFilterSettings() {
        IDialogSettings settings = this.getFilterSettings();
        if (settings == null) {
            settings = AgentUI.getDefault().getDialogSettings().addNewSection(this.getClass().getName());
        }
        settings.put(P_LOG_INFO, this.logDialogSettings.get(P_LOG_INFO).equals("true"));
        settings.put(P_LOG_WARNING, this.logDialogSettings.get(P_LOG_WARNING).equals("true"));
        settings.put(P_LOG_ERROR, this.logDialogSettings.get(P_LOG_ERROR).equals("true"));
        settings.put(P_LOG_DEBUG, this.logDialogSettings.get(P_LOG_DEBUG).equals("true"));
        settings.put(P_LOG_NOTE, this.logDialogSettings.get(P_LOG_NOTE).equals("true"));
        settings.put(P_LOG_MESSAGE_ID, this.logDialogSettings.get(P_LOG_MESSAGE_ID));
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.getTreePart().getTreeViewer().getLabelProvider();
    }

    @Override
    public void showURL(String url) {
        AgentUI.getDefault().showURL(url);
    }

    private class LogContentProvider
    implements ITreeContentProvider,
    ILogListener {
        private TreeViewer viewer;
        Object contentInput;

        private LogContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof LogRecord) {
                List records = ((LogRecord)inputElement).getRecords();
                ArrayList newList = new ArrayList();
                int i = 0;
                while (i < records.size()) {
                    Object entry = records.get(i);
                    if (entry != null) {
                        newList.add(entry);
                    }
                    ++i;
                }
                return newList.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            EntryRecord entry;
            List children;
            if (parentElement instanceof EntryRecord && (children = (entry = (EntryRecord)parentElement).getChildren()) != null) {
                return children.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof EntryRecord) {
                return ((EntryRecord)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof EntryRecord) {
                List children = ((EntryRecord)element).getChildren();
                return children != null && children.size() > 0;
            }
            return false;
        }

        public void dispose() {
            LogManager.removeListener((ILogListener)this);
        }

        public void inputChanged(Viewer theViewer, Object oldInput, Object newInput) {
            this.viewer = (TreeViewer)theViewer;
            if (oldInput != null && oldInput instanceof LogRecord && ((LogRecord)oldInput).getLogFile() == LogManager.getDefaultLogFile()) {
                LogManager.removeListener((ILogListener)this);
            }
            if (newInput != null && newInput instanceof LogRecord && ((LogRecord)newInput).getLogFile() == LogManager.getDefaultLogFile()) {
                LogManager.addListener((ILogListener)this, (int)Level.INFO);
            }
            this.contentInput = newInput;
        }

        public void logEntry(LogEntry entry) {
            if (this.contentInput == null || !(this.contentInput instanceof LogRecord)) {
                return;
            }
            LogRecord logInput = (LogRecord)this.contentInput;
            if (entry.getLevel() == Level.DEBUG) {
                return;
            }
            EntryRecord entryRecord = new EntryRecord(entry);
            String message = this.formatObject(entry.getMessage());
            StringTokenizer tokenizer = new StringTokenizer(message, LogUtil.NEWLINE);
            if (tokenizer.countTokens() > 1) {
                boolean firstToken = true;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken().trim();
                    if (token.length() <= 0) continue;
                    if (firstToken) {
                        MessageRecord msgRecord = entryRecord.getMessageRecord();
                        if (token.startsWith("ERROR:")) {
                            entryRecord.setLevel(Level.ERROR);
                            msgRecord.setMessage(token.substring("ERROR:".length()));
                        } else if (token.startsWith("WARNING:")) {
                            entryRecord.setLevel(Level.WARNING);
                            msgRecord.setMessage(token.substring("WARNING:".length()));
                        } else if (token.startsWith("INFO:")) {
                            entryRecord.setLevel(Level.INFO);
                            msgRecord.setMessage(token.substring("INFO:".length()));
                        } else {
                            msgRecord.setMessage(token);
                        }
                        firstToken = false;
                        continue;
                    }
                    EntryRecord child = new EntryRecord(entryRecord);
                    MessageRecord msgRecord = child.getMessageRecord();
                    if (token.startsWith("ERROR:")) {
                        child.setLevel(Level.ERROR);
                        msgRecord.setMessage(token.substring("ERROR:".length()));
                    } else if (token.startsWith("WARNING:")) {
                        child.setLevel(Level.WARNING);
                        msgRecord.setMessage(token.substring("WARNING:".length()));
                    } else if (token.startsWith("INFO:")) {
                        child.setLevel(Level.INFO);
                        msgRecord.setMessage(token.substring("INFO:".length()));
                    } else {
                        msgRecord.setMessage(token);
                    }
                    entryRecord.addChild(child);
                }
            } else {
                MessageRecord msgRecord = entryRecord.getMessageRecord();
                msgRecord.setMessage(message);
            }
            int i = 0;
            while (i < entry.getArgCount()) {
                entryRecord.getMessageRecord().addArg(this.formatObject(entry.getArg(i)));
                ++i;
            }
            if (entry.getException() != null) {
                StackTraceElement[] elements;
                entryRecord.getThrownRecord().setThrown(entry.getException().toString());
                StackTraceElement[] stackTraceElementArray = elements = entry.getException().getStackTrace();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    StackRecord stackRecord = new StackRecord(this.formatObject(element));
                    entryRecord.getThrownRecord().addStack(stackRecord);
                    ++n2;
                }
            }
            logInput.addRecord(entryRecord);
            final EntryRecord finalEntry = entryRecord;
            Control ctrl = this.viewer.getControl();
            if (ctrl != null && !ctrl.isDisposed()) {
                DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (LogContentProvider.this.viewer != null) {
                            LogContentProvider.this.viewer.add((Object)LogSection.this.input, (Object)finalEntry);
                        }
                    }
                });
            }
        }

        private String formatObject(Object obj) {
            return LogUtil.escape((String)LogUtil.toString((Object)obj));
        }

        public void close() {
        }
    }

    private static class LogFilter
    extends ViewerFilter {
        private final List filters;
        private final String containedSource;

        LogFilter(List selectControl, String containedSource) {
            this.filters = selectControl;
            this.containedSource = containedSource;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof EntryRecord) {
                boolean select = false;
                EntryRecord entry = (EntryRecord)element;
                int level = entry.getLevel();
                if (level > Level.MIN && level < Level.MAX) {
                    select = (Boolean)this.filters.get(level - 1);
                }
                if (select && this.containedSource != null) {
                    String callingClass = entry.getCallingClass();
                    if (callingClass == null) {
                        callingClass = entry.getLogger();
                    }
                    return callingClass.indexOf(this.containedSource) != -1 || entry.getCallingMethod().indexOf(this.containedSource) != -1;
                }
                return select;
            }
            return false;
        }
    }

    private class LogLabelProvider
    implements ITableLabelProvider {
        AgentUILabelProvider agentUILabelProvider = AgentUI.getDefault().getLabelProvider();

        LogLabelProvider() {
            this.agentUILabelProvider.connect(this);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof EntryRecord) {
                EntryRecord entry = (EntryRecord)element;
                if (columnIndex == 0) {
                    int levelNum = entry.getLevel();
                    if (levelNum == Level.ERROR) {
                        return this.agentUILabelProvider.get(CommonImages.LOG_ERROR);
                    }
                    if (levelNum == Level.WARNING) {
                        return this.agentUILabelProvider.get(CommonImages.LOG_WARNING);
                    }
                    if (levelNum == Level.DEBUG) {
                        return this.agentUILabelProvider.get(CommonImages.LOG_DEBUG);
                    }
                    if (levelNum == Level.INFO) {
                        return this.agentUILabelProvider.get(CommonImages.LOG_INFO);
                    }
                    if (levelNum == Level.NOTE) {
                        return this.agentUILabelProvider.get(CommonImages.LOG_NOTE);
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof EntryRecord) {
                EntryRecord entry = (EntryRecord)element;
                if (columnIndex != 0) {
                    if (columnIndex == 1) {
                        String message = SharedUIUtils.constructLogDescription((EntryRecord)entry);
                        message = StatusUtil.stripAnchors((String)message);
                        return message;
                    }
                    if (columnIndex == 2) {
                        return LogSection.this.constructMessageId(entry);
                    }
                    if (columnIndex == 3) {
                        return LogUtil.toISO8601((long)entry.getTime());
                    }
                    if (columnIndex == 4) {
                        return SharedUIUtils.getLogSeverity((int)entry.getLevel());
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.agentUILabelProvider.disconnect(this);
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

