/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.views;

import com.ibm.cic.agent.internal.core.history.IActivity;
import com.ibm.cic.agent.internal.core.history.IFeatureInfo;
import com.ibm.cic.agent.internal.core.history.IOfferingInfo;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.views.IPreviewTaskProvider;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.framework.Version;

public class InstallHistoryDetailsPage
extends AbstractFormPart
implements IDetailsPage {
    private Label startTimeLabel;
    private Label endTimeLabel;
    private Text startTimeText;
    private Text endTimeText;
    private Label activityLabel;
    private Text activityText;
    private Label profileIdLabel;
    private Text profileIdText;
    private Label statusLabel;
    private Text statusText;
    private Label offeringsLabel;
    private FormText offeringsText;
    private IPreviewTaskProvider currentProvider;

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        layout.bottomMargin = 0;
        layout.leftMargin = 10;
        layout.rightMargin = 5;
        layout.topMargin = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 20;
        parent.setLayout((Layout)layout);
        toolkit.setBorderStyle(0);
        Section section = toolkit.createSection(parent, 512);
        section.setLayoutData((Object)new TableWrapData(256));
        section.marginHeight = 5;
        section.marginWidth = 5;
        section.setText(com.ibm.cic.agent.core.sharedUI.Messages.DetailsPage_title);
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        layout = new TableWrapLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Color titleColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.startTimeLabel = toolkit.createLabel(container, Messages.InstallationHistoryDetailsView_startTime, 0);
        this.startTimeLabel.setForeground(titleColor);
        this.startTimeText = toolkit.createText(container, null, 8);
        this.endTimeLabel = toolkit.createLabel(container, Messages.InstallationHistoryDetailsView_endTime, 0);
        this.endTimeLabel.setForeground(titleColor);
        this.endTimeText = toolkit.createText(container, null, 8);
        this.activityLabel = toolkit.createLabel(container, Messages.InstallationHistoryDetailsView_activity, 0);
        this.activityLabel.setForeground(titleColor);
        this.activityText = toolkit.createText(container, null, 8);
        this.profileIdLabel = toolkit.createLabel(container, Messages.InstallLocationDetailsPage_installLocationNameLabel, 0);
        this.profileIdLabel.setForeground(titleColor);
        this.profileIdText = toolkit.createText(container, null, 8);
        this.statusLabel = toolkit.createLabel(container, Messages.InstallationHistoryDetailsView_status, 0);
        this.statusLabel.setForeground(titleColor);
        this.statusText = toolkit.createText(container, null, 8);
        this.offeringsLabel = toolkit.createLabel(container, Messages.InstallationHistoryDetailsView_offerings, 0);
        this.offeringsLabel.setForeground(titleColor);
        this.offeringsText = toolkit.createFormText(container, false);
    }

    public void setSelection(IStructuredSelection selection) {
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = ((StructuredSelection)selection).getFirstElement();
        this.currentProvider = (IPreviewTaskProvider)part;
        ITableLabelProvider tableLabelProvider = null;
        IBaseLabelProvider baseLabelProvider = this.currentProvider.getLabelProvider();
        if (baseLabelProvider instanceof ITableLabelProvider) {
            tableLabelProvider = (ITableLabelProvider)baseLabelProvider;
        }
        if (tableLabelProvider == null) {
            return;
        }
        IActivity activity = null;
        if (object instanceof IActivity) {
            activity = (IActivity)object;
        }
        if (activity == null) {
            return;
        }
        this.startTimeText.setText(tableLabelProvider.getColumnText((Object)activity, 0));
        this.endTimeText.setText(activity.getEndTime());
        this.activityText.setText(tableLabelProvider.getColumnText((Object)activity, 1));
        this.profileIdText.setText(tableLabelProvider.getColumnText((Object)activity, 2));
        this.statusText.setText(tableLabelProvider.getColumnText((Object)activity, 3));
        String offeringsList = this.constructOfferingList(activity);
        this.offeringsText.setText(offeringsList, true, false);
    }

    private String constructOfferingList(IActivity activity) {
        StringBuffer return_value = new StringBuffer();
        return_value.append("<form>");
        Iterator it = activity.getAllOfferings();
        while (it.hasNext()) {
            IOfferingInfo offeringInfo = (IOfferingInfo)it.next();
            return_value.append("<li>");
            return_value.append(offeringInfo.getOfferingName());
            return_value.append("  ");
            return_value.append(offeringInfo.getLocalizedVersion());
            return_value.append("  ");
            Version offeringVersion = offeringInfo.getOfferingVersion();
            if (offeringVersion != null) {
                String offeringVersionStr = offeringVersion.toString();
                boolean showInternalVersion = AgentUI.getDefault().getAgentPreferenceStore().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key());
                if (!offeringVersionStr.equals(offeringInfo.getLocalizedVersion()) && showInternalVersion) {
                    return_value.append(NLS.bind((String)Messages.InstallHistoryDetailsPage_internalVersion, (Object)offeringInfo.getOfferingVersion()));
                }
            }
            return_value.append("</li>");
            Iterator featureIt = offeringInfo.getFeatures();
            while (featureIt.hasNext()) {
                IFeatureInfo featureInfo = (IFeatureInfo)featureIt.next();
                if (!featureInfo.isVisible()) continue;
                return_value.append("<li bindent=\"20\">");
                return_value.append(AgentUIUtils.escapeSpecialChars(featureInfo.getFeatureName()));
                return_value.append("</li>");
            }
        }
        return_value.append("</form>");
        return return_value.toString();
    }

    protected IPreviewTaskProvider getProvider() {
        return this.currentProvider;
    }
}

