/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.OfferingTreeNode;
import com.ibm.cic.agent.internal.ui.utils.ProfileTreeNode;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IOffering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class UpdateResultContentProvider
extends ArrayContentProvider
implements ITreeContentProvider {
    private final Map jobToChildrenMap = new HashMap();
    private boolean showFeature = true;
    private boolean hasFix = false;
    private ITreeContentProvider featureTreeContentProvider;
    private Map jobToRootFeatureGroupMap;

    public UpdateResultContentProvider() {
    }

    public UpdateResultContentProvider(boolean showFeature) {
        this.showFeature = showFeature;
    }

    public UpdateResultContentProvider(ITreeContentProvider provider, Map map) {
        this.featureTreeContentProvider = provider;
        this.jobToRootFeatureGroupMap = map;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ProfileTreeNode) {
            return ((ProfileTreeNode)parentElement).getChildren().toArray();
        }
        if (parentElement instanceof OfferingTreeNode) {
            AbstractJob job = ((OfferingTreeNode)parentElement).getOfferingJob();
            ArrayList allChildren = new ArrayList(((OfferingTreeNode)parentElement).getChildren());
            if (job != null) {
                ArrayList<Object> featureChildren = (ArrayList<Object>)this.jobToChildrenMap.get(job);
                if (featureChildren == null) {
                    featureChildren = new ArrayList<Object>();
                    IOffering offering = job.getOffering();
                    if (offering != null && this.showFeature) {
                        if (this.jobToRootFeatureGroupMap != null && this.featureTreeContentProvider != null) {
                            if (this.hasFix) {
                                Object[] valueArray = (Object[])this.jobToRootFeatureGroupMap.get(job);
                                if (valueArray != null) {
                                    featureChildren.addAll(Arrays.asList(valueArray));
                                }
                            } else {
                                featureChildren.addAll(Arrays.asList(this.featureTreeContentProvider.getChildren((Object)job)));
                            }
                        } else {
                            List selectedFeatures = job.getFeatures();
                            ArrayList<IFeature> visibleSelectedFeatures = new ArrayList<IFeature>();
                            int i = 0;
                            while (i < selectedFeatures.size()) {
                                IFeature feature = (IFeature)selectedFeatures.get(i);
                                if (feature.isVisible()) {
                                    visibleSelectedFeatures.add(feature);
                                }
                                ++i;
                            }
                            featureChildren.addAll(visibleSelectedFeatures);
                        }
                    }
                    this.jobToChildrenMap.put(job, featureChildren);
                }
                allChildren.addAll(featureChildren);
            }
            return allChildren.toArray();
        }
        if (this.featureTreeContentProvider != null) {
            return this.featureTreeContentProvider.getChildren(parentElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof FixNode) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public void setShowFeature(boolean showFeature) {
        this.showFeature = showFeature;
    }

    public void setHasFix(boolean hasFix) {
        this.hasFix = hasFix;
    }

    public void resetFeatures() {
        this.jobToChildrenMap.clear();
    }
}

