/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.sharedUI.FeatureBaseNode;
import com.ibm.cic.agent.core.sharedUI.FeatureGroupNode;
import com.ibm.cic.agent.internal.ui.utils.SimpleFeatureNode;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IOffering;
import java.util.List;

public class InstalledFeatureTreeUtil {
    public static FeatureGroupNode generateFeatureTree(IOffering offering, List installedVisibleFeatures, List installedFeatures) {
        IFeatureGroup rootGroup = offering.getFeatureGroup();
        if (!rootGroup.isVisible() || installedFeatures == null || installedFeatures.isEmpty()) {
            return null;
        }
        FeatureGroupNode rootGroupNode = new FeatureGroupNode(rootGroup, null);
        InstalledFeatureTreeUtil.generateChildren(rootGroupNode, installedVisibleFeatures, installedFeatures);
        return rootGroupNode;
    }

    private static void generateChildren(FeatureGroupNode featureGroupNode, List visibleInstalledFeatures, List installedFeatures) {
        IFeatureGroup featureGroup = featureGroupNode.getFeatureGroup();
        List children = featureGroup.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFeatureBase featureBase = (IFeatureBase)children.get(i);
            if (featureBase.isVisible()) {
                IFeatureGroup group;
                if (featureBase instanceof IFeature) {
                    IFeature feature = (IFeature)featureBase;
                    if (visibleInstalledFeatures.contains(feature)) {
                        SimpleFeatureNode featureNode = new SimpleFeatureNode(feature, featureGroupNode);
                        featureGroupNode.addChild((FeatureBaseNode)featureNode);
                    }
                } else if (featureBase instanceof IFeatureGroup && InstalledFeatureTreeUtil.containInstalledFeature(group = (IFeatureGroup)featureBase, installedFeatures)) {
                    FeatureGroupNode childGroupNode = new FeatureGroupNode(group, featureGroupNode);
                    featureGroupNode.addChild((FeatureBaseNode)childGroupNode);
                    InstalledFeatureTreeUtil.generateChildren(childGroupNode, visibleInstalledFeatures, installedFeatures);
                }
            }
            ++i;
        }
    }

    private static boolean containInstalledFeature(IFeatureGroup group, List installedFeatures) {
        List features = group.getFeatures();
        features.retainAll(installedFeatures);
        if (!features.isEmpty()) {
            return true;
        }
        List groups = group.getGroups();
        int i = 0;
        while (i < groups.size()) {
            IFeatureGroup childGroup = (IFeatureGroup)groups.get(i);
            if (group.isVisible() && InstalledFeatureTreeUtil.containInstalledFeature(childGroup, installedFeatures)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

