/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.IContainsFix;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.utils.PackageNode;
import com.ibm.cic.agent.internal.ui.utils.VersionNode;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.FixProperty;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.repository.UnavailableUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class FixNode
implements IContainsFix,
IAdaptable {
    private final AbstractJob job;
    private final Object parent;
    private IStatus toleranceStatus = null;
    private boolean isRecommended = true;
    private IStatus checkBetaStatus = null;
    private Boolean hasWrongPrivilege = null;
    private Boolean supportCurrentOS = null;
    private Boolean supportCurrentPlatform = null;
    private Boolean supportCurrentArchitecture = null;
    private Boolean supportCurrentUI = null;
    private boolean checkStatus = true;

    public FixNode(AbstractJob job, Object parent) {
        this.job = job;
        this.parent = parent;
        this.isRecommended = FixProperty.isRecommended((IFix)this.job.getFix());
    }

    public FixNode(AbstractJob job, Object parent, boolean checkStatus) {
        this(job, parent);
        this.checkStatus = checkStatus;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFix.class) {
            return this.job.getFix();
        }
        if (adapter == AbstractJob.class) {
            return this.job;
        }
        return null;
    }

    public AbstractJob getJob() {
        return this.job;
    }

    public IFix getFix() {
        return this.job.getFix();
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean isSelected() {
        return this.job.isSelected();
    }

    public void setSelected(boolean selected) {
        this.job.setSelected(selected);
        if (selected) {
            this.setFixJobProfileToParentProfile();
        }
    }

    public void setFixJobProfileToParentProfile() {
        if (this.parent != null && this.parent instanceof VersionNode) {
            this.job.setProfile(((VersionNode)this.parent).getProfile());
        }
    }

    public IStatus getToleranceStatus() {
        if (this.toleranceStatus == null) {
            this.toleranceStatus = Status.OK_STATUS;
            if (this.checkStatus) {
                this.toleranceStatus = AgentUI.getDefault().getAgent().checkAgentRequirement((IOfferingOrFix)this.job.getFix(), AgentUI.getDefault().getAgentPreferenceStore().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key()));
            }
        }
        return this.toleranceStatus;
    }

    public IStatus getCheckBetaStatus() {
        if (this.checkBetaStatus == null) {
            this.checkBetaStatus = Status.OK_STATUS;
            if (this.checkStatus) {
                Agent agent = AgentUI.getDefault().getAgent();
                this.checkBetaStatus = agent.checkBetaRequirement((IOfferingOrFix)this.job.getFix());
                if (this.checkBetaStatus.isOK() && this.parent != null && this.parent instanceof VersionNode) {
                    IOffering parentOffering = ((VersionNode)this.parent).getOffering();
                    this.checkBetaStatus = agent.checkBetaRequirement((IOfferingOrFix)parentOffering);
                }
            }
        }
        return this.checkBetaStatus;
    }

    public boolean hasUnacceptablePrivilege() {
        if (this.hasWrongPrivilege == null) {
            this.hasWrongPrivilege = Boolean.FALSE;
            if (this.checkStatus) {
                if (this.parent != null && this.parent instanceof VersionNode) {
                    IOffering parentOffering = ((VersionNode)this.parent).getOffering();
                    boolean violatePrivilege = OfferingProperty.hasUnacceptableRequirementForUserRights((IOffering)parentOffering);
                    this.hasWrongPrivilege = violatePrivilege;
                } else if (this.parent != null && this.parent instanceof PackageNode) {
                    IOffering parentOffering = ((PackageNode)this.parent).getOffering();
                    boolean violatePrivilege = OfferingProperty.hasUnacceptableRequirementForUserRights((IOffering)parentOffering);
                    this.hasWrongPrivilege = violatePrivilege;
                }
            }
        }
        return this.hasWrongPrivilege;
    }

    public boolean supportCurrentOS() {
        if (this.supportCurrentOS == null) {
            if (!this.checkStatus) {
                this.supportCurrentOS = Boolean.TRUE;
            } else if (this.parent != null && this.parent instanceof VersionNode) {
                IOffering parentOffering = ((VersionNode)this.parent).getOffering();
                boolean isSupportedOS = OfferingProperty.isSupportedOS((IOffering)parentOffering);
                this.supportCurrentOS = isSupportedOS;
            } else if (this.parent != null && this.parent instanceof PackageNode) {
                IOffering parentOffering = ((PackageNode)this.parent).getOffering();
                boolean isSupportedOS = OfferingProperty.isSupportedOS((IOffering)parentOffering);
                this.supportCurrentOS = isSupportedOS;
            } else {
                this.supportCurrentOS = Boolean.FALSE;
            }
        }
        return this.supportCurrentOS;
    }

    public boolean supportCurrentPlatform() {
        if (this.supportCurrentPlatform == null) {
            if (!this.checkStatus) {
                this.supportCurrentPlatform = Boolean.TRUE;
            } else if (this.parent != null && this.parent instanceof VersionNode) {
                VersionNode parentNode = (VersionNode)this.parent;
                IOffering parentOffering = parentNode.getOffering();
                boolean isSupportedPlatformInOffering = BitModeUtils.checkSupportedPlatformsInOfferingOrFix((IOfferingOrFix)parentOffering).isOK();
                if (isSupportedPlatformInOffering) {
                    AbstractJob parentJob = parentNode.getJob();
                    if (parentJob.isUpdate()) {
                        Profile profile = this.job.getProfile();
                        IStatus status = SliceUtils.checkPlatform((IOfferingOrFix)this.getFix(), (String)profile.getOS(), (String)profile.getArch());
                        this.supportCurrentPlatform = status.isOK();
                    } else {
                        IStatus status = SliceUtils.checkPlatform((IOfferingOrFix)this.getFix(), (String)Platform.getOS(), (String)BitModeUtils.get32bitArch());
                        if (status.isOK()) {
                            this.supportCurrentPlatform = Boolean.TRUE;
                        } else {
                            status = SliceUtils.checkPlatform((IOfferingOrFix)this.getFix(), (String)Platform.getOS(), (String)BitModeUtils.get64bitArch());
                            this.supportCurrentPlatform = status.isOK();
                        }
                    }
                } else {
                    this.supportCurrentPlatform = Boolean.FALSE;
                }
            } else if (this.parent != null && this.parent instanceof PackageNode) {
                IOffering parentOffering = ((PackageNode)this.parent).getOffering();
                boolean isSupportedPlatform = BitModeUtils.checkSupportedPlatformsInOfferingOrFix((IOfferingOrFix)parentOffering).isOK();
                if (isSupportedPlatform) {
                    Profile profile = this.getJob().getProfile();
                    IStatus status = SliceUtils.checkPlatform((IOfferingOrFix)this.getFix(), (String)profile.getOS(), (String)profile.getArch());
                    this.supportCurrentPlatform = status.isOK();
                } else {
                    this.supportCurrentPlatform = Boolean.FALSE;
                }
            } else {
                this.supportCurrentPlatform = Boolean.FALSE;
            }
        }
        return this.supportCurrentPlatform;
    }

    public boolean supportCurrentUI() {
        if (this.supportCurrentUI == null) {
            if (!this.checkStatus) {
                this.supportCurrentUI = Boolean.TRUE;
            } else {
                this.supportCurrentUI = Boolean.FALSE;
                if (this.parent instanceof VersionNode) {
                    if (((VersionNode)this.parent).supportCurrentUI()) {
                        IStatus status = Agent.getInstance().checkWebUISupported((IOfferingOrFix)this.getFix());
                        this.supportCurrentUI = status.isOK();
                    }
                } else if (this.parent instanceof PackageNode) {
                    IStatus status = Agent.getInstance().checkWebUISupported((IOfferingOrFix)this.getFix());
                    this.supportCurrentUI = status.isOK();
                }
            }
        }
        return this.supportCurrentUI;
    }

    public void resetSupportCurrentPlatform() {
        this.supportCurrentPlatform = null;
    }

    public boolean supportCurrentArchitecture() {
        if (this.supportCurrentArchitecture == null) {
            IFix fix;
            this.supportCurrentArchitecture = Boolean.TRUE;
            if (this.checkStatus && this.parent != null && (this.parent instanceof PackageNode || this.parent instanceof VersionNode && ((VersionNode)this.parent).getJob().isUpdate()) && (fix = this.getFix()) != null) {
                Profile profile = this.job.getProfile();
                IStatus status = SliceUtils.checkPlatform((IOfferingOrFix)fix, (String)profile.getOS(), (String)profile.getArch());
                this.supportCurrentArchitecture = status.isOK();
            }
        }
        return this.supportCurrentArchitecture;
    }

    public boolean isUnavailable() {
        if (this.checkStatus) {
            if (this.parent instanceof VersionNode) {
                if (((VersionNode)this.parent).isUnavailable()) {
                    return true;
                }
                return UnavailableUtils.isUnavailable((IContent)this.getFix());
            }
            if (this.parent instanceof PackageNode) {
                return UnavailableUtils.isUnavailable((IContent)this.getFix());
            }
        }
        return false;
    }

    public boolean canBeInstalled() {
        return !this.hasUnacceptablePrivilege() && this.getCheckBetaStatus().isOK() && this.supportCurrentOS() && this.supportCurrentPlatform() && this.supportCurrentArchitecture() && !this.isUnavailable() && this.supportCurrentUI();
    }

    public boolean isRecommended() {
        return this.isRecommended;
    }

    public void setRecommended(boolean isRecommended) {
        this.isRecommended = isRecommended;
    }
}

