/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.OnlyFixesNode;
import com.ibm.cic.agent.internal.ui.utils.PackageNode;
import com.ibm.cic.agent.internal.ui.utils.ProfileNode;
import com.ibm.cic.agent.internal.ui.utils.VersionNode;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class BaseJobNodeLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    protected AgentUILabelProvider agentLabelProvider = AgentUI.getDefault().getLabelProvider();
    protected Color disabledColor;
    private Font boldFont;

    public BaseJobNodeLabelProvider(Display display) {
        this.agentLabelProvider.connect((Object)this);
        this.disabledColor = CommonUIUtils.createDisabledColor((Display)display);
    }

    public void dispose() {
        this.agentLabelProvider.disconnect((Object)this);
        this.disabledColor.dispose();
        super.dispose();
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        FixNode node;
        VersionNode versionNode;
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        if (columnIndex == 1 && (element instanceof VersionNode ? (versionNode = (VersionNode)element).isRecommended() : (element instanceof FixNode ? (node = (FixNode)element).isRecommended() : element instanceof OnlyFixesNode && (node = (OnlyFixesNode)element).isRecommended()))) {
            return this.agentLabelProvider.get(CICImages.UPDATE_RECOMMENDED);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        if (columnIndex == 2) {
            if (element instanceof VersionNode) {
                IOffering offering = ((VersionNode)element).getJob().getOffering();
                return offering.getProperties().getProperty("vendor.name", "");
            }
            if (element instanceof FixNode) {
                IFix fix = ((FixNode)element).getJob().getFix();
                return fix.getProperties().getProperty("vendor.name", "");
            }
        }
        return "";
    }

    public Font getFont(Object element, int columnIndex) {
        if (element instanceof VersionNode || element instanceof FixNode || element instanceof OnlyFixesNode) {
            Object node;
            boolean isRecommended = false;
            if (element instanceof VersionNode) {
                node = (VersionNode)element;
                isRecommended = ((VersionNode)node).isRecommended();
            } else if (element instanceof FixNode) {
                node = (FixNode)element;
                isRecommended = ((FixNode)node).isRecommended();
            } else if (element instanceof OnlyFixesNode) {
                node = (OnlyFixesNode)element;
                isRecommended = ((OnlyFixesNode)node).isRecommended();
            }
            if (isRecommended) {
                if (this.boldFont == null) {
                    FontData[] data = JFaceResources.getDefaultFont().getFontData();
                    this.boldFont = JFaceResources.getFontRegistry().getBold(data[0].getName());
                }
                return this.boldFont;
            }
        }
        return JFaceResources.getDefaultFont();
    }

    public Color getForeground(Object element, int columnIndex) {
        if (columnIndex == 0) {
            FixNode fixNode;
            VersionNode versionNode;
            if (element instanceof ProfileNode || element instanceof PackageNode) {
                return this.disabledColor;
            }
            if (element instanceof VersionNode ? !(versionNode = (VersionNode)element).canBeInstalled() : element instanceof FixNode && !(fixNode = (FixNode)element).canBeInstalled()) {
                return this.disabledColor;
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof VersionNode) {
            return this.agentLabelProvider.get(CommonImages.DESC_UPDATE_OBJ);
        }
        if (element instanceof PackageNode) {
            IOffering offering = ((PackageNode)element).getOffering();
            return this.agentLabelProvider.getOfferingImage(offering);
        }
        if (element instanceof ProfileNode) {
            return this.agentLabelProvider.get(CommonImages.DESC_PROFILE_OBJ);
        }
        if (element instanceof FixNode) {
            return this.agentLabelProvider.get(CommonImages.DESC_FIX_OBJ);
        }
        if (element instanceof OnlyFixesNode) {
            return this.agentLabelProvider.get(CommonImages.DESC_FIX_OBJ);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof FixNode) {
            FixNode fixNode = (FixNode)element;
            IFix fix = fixNode.getJob().getFix();
            String name = fix.getName();
            String version = AgentUIUtils.getDisplayableVersion((IOfferingOrFix)fix);
            return String.valueOf(name) + " " + version;
        }
        if (element instanceof VersionNode) {
            VersionNode vNode = (VersionNode)element;
            String version = AgentUIUtils.getDisplayableVersion((IOfferingOrFix)vNode.getJob().getOffering());
            return NLS.bind((String)Messages.AvailableUpdateSection_version, (Object)version);
        }
        if (element instanceof PackageNode) {
            IOffering installedOffering = ((PackageNode)element).getOffering();
            String label = String.valueOf(installedOffering.getName()) + " " + AgentUIUtils.getDisplayableVersion((IOfferingOrFix)installedOffering) + " " + Messages.AvailableUpdateSection_installed;
            return label;
        }
        if (element instanceof ProfileNode) {
            return ((ProfileNode)element).getProfile().getProfileId();
        }
        if (element instanceof OnlyFixesNode) {
            String version = AgentUIUtils.getDisplayableVersion((IOfferingOrFix)((OnlyFixesNode)element).getOffering());
            return NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableUpdateSection_onlyFixesVersion, (Object)version);
        }
        return super.getText(element);
    }
}

